/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import javajs.util.BS;
import org.jmol.modelset.Atom;
import org.jmol.quantum.MepCalculation;
import org.jmol.util.Logger;

public class MlpCalculation
extends MepCalculation {
    public MlpCalculation() {
        this.distanceMode = 3;
    }

    @Override
    public void assignPotentials(Atom[] atomArray, float[] fArray, BS bS, BS bS2, BS bS3, String string) {
        this.getAtomicPotentials(string, "atomicLipophilicity.txt");
        int n = 0;
        while (n < atomArray.length) {
            float f = Math.abs(atomArray[n].getFormalCharge());
            if (f == 0.0f) {
                if (bS3 != null && bS3.get(n)) {
                    f = Float.NaN;
                } else {
                    f = this.getTabulatedPotential(atomArray[n]);
                    if (Float.isNaN(f)) {
                        switch (atomArray[n].getElementNumber()) {
                            case 6: {
                                f = bS.get(n) ? 0.31f : (bS2.get(n) ? -0.54f : 0.45f);
                                break;
                            }
                            case 7: {
                                f = bS.get(n) ? -0.6f : (bS2.get(n) ? -0.44f : -1.0f);
                                break;
                            }
                            case 8: {
                                f = bS2.get(n) ? -0.9f : -0.17f;
                                break;
                            }
                            default: {
                                f = Float.NaN;
                            }
                        }
                    }
                }
            }
            if (Logger.debugging) {
                Logger.debug(String.valueOf(atomArray[n].getInfo()) + " " + f);
            }
            fArray[n] = f;
            ++n;
        }
    }
}

