/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import java.util.IdentityHashMap;

public class GLRendererQuirks {
    public static final int NoDoubleBufferedPBuffer = 0;
    public static final int NoDoubleBufferedBitmap = 1;
    public static final int NoSetSwapInterval = 2;
    public static final int NoOffscreenBitmap = 3;
    public static final int NoSetSwapIntervalPostRetarget = 4;
    public static final int GLSLBuggyDiscard = 5;
    public static final int GLNonCompliant = 6;
    public static final int GLFlushBeforeRelease = 7;
    public static final int DontCloseX11Display = 8;
    public static final int NeedCurrCtx4ARBPixFmtQueries = 9;
    public static final int NeedCurrCtx4ARBCreateContext = 10;
    public static final int NoFullFBOSupport = 11;
    public static final int GLSLNonCompliant = 12;
    public static final int GL4NeedsGL3Request = 13;
    public static final int GLSharedContextBuggy = 14;
    public static final int GLES3ViaEGLES2Config = 15;
    public static final int SingletonEGLDisplayOnly = 16;
    public static final int NoMultiSamplingBuffers = 17;
    public static final int BuggyColorRenderbuffer = 18;
    public static final int NoPBufferWithAccum = 19;
    public static final int NeedSharedObjectSync = 20;
    public static final int NoARBCreateContext = 21;
    public static final int NoSurfacelessCtx = 22;
    private static final String[] _names = new String[]{"NoDoubleBufferedPBuffer", "NoDoubleBufferedBitmap", "NoSetSwapInterval", "NoOffscreenBitmap", "NoSetSwapIntervalPostRetarget", "GLSLBuggyDiscard", "GLNonCompliant", "GLFlushBeforeRelease", "DontCloseX11Display", "NeedCurrCtx4ARBPixFmtQueries", "NeedCurrCtx4ARBCreateContext", "NoFullFBOSupport", "GLSLNonCompliant", "GL4NeedsGL3Request", "GLSharedContextBuggy", "GLES3ViaEGLES2Config", "SingletonEGLDisplayOnly", "NoMultiSamplingBuffers", "BuggyColorRenderbuffer", "NoPBufferWithAccum", "NeedSharedObjectSync", "NoARBCreateContext", "NoSurfacelessCtx"};
    private static final IdentityHashMap<String, GLRendererQuirks> stickyDeviceQuirks = new IdentityHashMap();
    private int _bitmask = 0;

    public static final int getCount() {
        return 23;
    }

    public static GLRendererQuirks getStickyDeviceQuirks(AbstractGraphicsDevice abstractGraphicsDevice) {
        GLRendererQuirks gLRendererQuirks;
        String string = abstractGraphicsDevice.getUniqueID();
        GLRendererQuirks gLRendererQuirks2 = stickyDeviceQuirks.get(string);
        if (null == gLRendererQuirks2) {
            gLRendererQuirks = new GLRendererQuirks();
            stickyDeviceQuirks.put(string, gLRendererQuirks);
        } else {
            gLRendererQuirks = gLRendererQuirks2;
        }
        return gLRendererQuirks;
    }

    public static boolean areSameStickyDevice(AbstractGraphicsDevice abstractGraphicsDevice, AbstractGraphicsDevice abstractGraphicsDevice2) {
        return abstractGraphicsDevice.getUniqueID() == abstractGraphicsDevice2.getUniqueID();
    }

    public static void addStickyDeviceQuirk(AbstractGraphicsDevice abstractGraphicsDevice, int n) throws IllegalArgumentException {
        GLRendererQuirks gLRendererQuirks = GLRendererQuirks.getStickyDeviceQuirks(abstractGraphicsDevice);
        gLRendererQuirks.addQuirk(n);
    }

    public static void addStickyDeviceQuirks(AbstractGraphicsDevice abstractGraphicsDevice, int[] nArray, int n, int n2) throws IllegalArgumentException {
        GLRendererQuirks gLRendererQuirks = GLRendererQuirks.getStickyDeviceQuirks(abstractGraphicsDevice);
        gLRendererQuirks.addQuirks(nArray, n, n2);
    }

    public static void addStickyDeviceQuirks(AbstractGraphicsDevice abstractGraphicsDevice, GLRendererQuirks gLRendererQuirks) throws IllegalArgumentException {
        GLRendererQuirks gLRendererQuirks2 = GLRendererQuirks.getStickyDeviceQuirks(abstractGraphicsDevice);
        gLRendererQuirks2.addQuirks(gLRendererQuirks);
    }

    public static boolean existStickyDeviceQuirk(AbstractGraphicsDevice abstractGraphicsDevice, int n) {
        return GLRendererQuirks.getStickyDeviceQuirks(abstractGraphicsDevice).exist(n);
    }

    public static void pushStickyDeviceQuirks(AbstractGraphicsDevice abstractGraphicsDevice, GLRendererQuirks gLRendererQuirks) {
        gLRendererQuirks.addQuirks(GLRendererQuirks.getStickyDeviceQuirks(abstractGraphicsDevice));
    }

    public GLRendererQuirks() {
    }

    public GLRendererQuirks(int[] nArray, int n, int n2) throws IllegalArgumentException {
        this();
        this.addQuirks(nArray, n, n2);
    }

    public final void addQuirk(int n) throws IllegalArgumentException {
        GLRendererQuirks.validateQuirk(n);
        this._bitmask |= 1 << n;
    }

    public final void addQuirks(int[] nArray, int n, int n2) throws IllegalArgumentException {
        int n3 = 0;
        if (0 > n + n2 || n + n2 > nArray.length) {
            throw new IllegalArgumentException("offset and len out of bounds: offset " + n + ", len " + n2 + ", array-len " + nArray.length);
        }
        for (int i = n; i < n + n2; ++i) {
            int n4 = nArray[i];
            GLRendererQuirks.validateQuirk(n4);
            n3 |= 1 << n4;
        }
        this._bitmask |= n3;
    }

    public final void addQuirks(GLRendererQuirks gLRendererQuirks) {
        this._bitmask |= gLRendererQuirks._bitmask;
    }

    public final boolean exist(int n) throws IllegalArgumentException {
        GLRendererQuirks.validateQuirk(n);
        return 0 != (1 << n & this._bitmask);
    }

    public final StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("[");
        boolean bl = true;
        for (int i = 0; i < GLRendererQuirks.getCount(); ++i) {
            int n = 1 << i;
            if (0 == (this._bitmask & n)) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(GLRendererQuirks.toString(i));
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    public final String toString() {
        return this.toString(null).toString();
    }

    public static void validateQuirk(int n) throws IllegalArgumentException {
        if (0 > n || n >= GLRendererQuirks.getCount()) {
            throw new IllegalArgumentException("Quirks must be in range [0.." + GLRendererQuirks.getCount() + "[, but quirk: " + n);
        }
    }

    public static final String toString(int n) throws IllegalArgumentException {
        GLRendererQuirks.validateQuirk(n);
        return _names[n];
    }
}

