/*
 * Decompiled with CFR 0.152.
 */
package javax.media.rtp;

import com.sun.media.Log;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.Controls;
import javax.media.Format;
import javax.media.PackageManager;
import javax.media.format.UnsupportedFormatException;
import javax.media.protocol.DataSource;
import javax.media.rtp.EncryptionInfo;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.InvalidSessionAddressException;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SendStream;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionListener;
import javax.media.rtp.rtcp.SourceDescription;

public abstract class RTPManager
implements Controls {
    private static boolean jdkInit = false;
    private static Method forName3ArgsM;
    private static Method getSystemClassLoaderM;
    private static ClassLoader systemClassLoader;
    private static Method getContextClassLoaderM;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Thread;

    public abstract void addFormat(Format var1, int var2);

    public abstract void addReceiveStreamListener(ReceiveStreamListener var1);

    public abstract void addRemoteListener(RemoteListener var1);

    public abstract void addSendStreamListener(SendStreamListener var1);

    public abstract void addSessionListener(SessionListener var1);

    public abstract void removeTarget(SessionAddress var1, String var2) throws InvalidSessionAddressException;

    public abstract void removeTargets(String var1);

    public abstract SendStream createSendStream(DataSource var1, int var2) throws UnsupportedFormatException, IOException;

    public abstract void dispose();

    public abstract Vector getActiveParticipants();

    public abstract Vector getAllParticipants();

    public abstract GlobalReceptionStats getGlobalReceptionStats();

    public abstract GlobalTransmissionStats getGlobalTransmissionStats();

    public abstract LocalParticipant getLocalParticipant();

    public abstract Vector getPassiveParticipants();

    public abstract Vector getReceiveStreams();

    public abstract Vector getRemoteParticipants();

    public abstract Vector getSendStreams();

    public abstract void initialize(SessionAddress var1) throws InvalidSessionAddressException, IOException;

    public abstract void initialize(SessionAddress[] var1, SourceDescription[] var2, double var3, double var5, EncryptionInfo var7) throws InvalidSessionAddressException, IOException;

    public abstract void initialize(RTPConnector var1);

    public abstract void addTarget(SessionAddress var1) throws InvalidSessionAddressException, IOException;

    public abstract void removeReceiveStreamListener(ReceiveStreamListener var1);

    public abstract void removeRemoteListener(RemoteListener var1);

    public abstract void removeSendStreamListener(SendStreamListener var1);

    public abstract void removeSessionListener(SessionListener var1);

    public static RTPManager newInstance() {
        RTPManager rtpManager = null;
        Enumeration SessionList = RTPManager.getRTPManagerList().elements();
        while (SessionList.hasMoreElements()) {
            String protoClassName = (String)SessionList.nextElement();
            try {
                Class protoClass = RTPManager.getClassForName(protoClassName);
                rtpManager = (RTPManager)protoClass.newInstance();
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
                String err = "Error instantiating class: " + protoClassName + " : " + e;
                Log.error(e);
            }
            catch (IllegalAccessException e) {
                System.out.println("illegal access.");
            }
            catch (Exception e) {
                String err = "Error instantiating class: " + protoClassName + " : " + e;
                Log.error(e);
            }
            catch (Error e) {
                String err = "Error instantiating class: " + protoClassName + " : " + e;
                Log.error(e);
            }
            if (rtpManager != null) break;
        }
        return rtpManager;
    }

    public static Vector getRTPManagerList() {
        String sourceName = "media.rtp.RTPSessionMgr";
        return RTPManager.buildClassList(RTPManager.getProtocolPrefixList(), sourceName);
    }

    static Class getClassForName(String className) throws ClassNotFoundException {
        block9: {
            try {
                return Class.forName(className);
            }
            catch (Exception e) {
                if (!RTPManager.checkIfJDK12()) {
                    throw new ClassNotFoundException(e.getMessage());
                }
            }
            catch (Error e) {
                if (RTPManager.checkIfJDK12()) break block9;
                throw e;
            }
        }
        try {
            return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class == null ? (class$java$lang$Class = RTPManager.class$("java.lang.Class")) : class$java$lang$Class), className, new Boolean(true), systemClassLoader);
        }
        catch (Throwable e) {
            try {
                ClassLoader contextClassLoader = (ClassLoader)getContextClassLoaderM.invoke((Object)Thread.currentThread(), null);
                return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class == null ? (class$java$lang$Class = RTPManager.class$("java.lang.Class")) : class$java$lang$Class), className, new Boolean(true), contextClassLoader);
            }
            catch (Exception e2) {
                throw new ClassNotFoundException(e2.getMessage());
            }
            catch (Error e3) {
                throw e3;
            }
        }
    }

    static Vector buildClassList(Vector prefixList, String name) {
        Vector<String> classList = new Vector<String>();
        classList.addElement(name);
        Enumeration prefix = prefixList.elements();
        while (prefix.hasMoreElements()) {
            String prefixName = (String)prefix.nextElement();
            classList.addElement(prefixName + "." + name);
        }
        return classList;
    }

    static Vector getProtocolPrefixList() {
        return (Vector)PackageManager.getProtocolPrefixList().clone();
    }

    private static boolean checkIfJDK12() {
        if (jdkInit) {
            return forName3ArgsM != null;
        }
        jdkInit = true;
        try {
            forName3ArgsM = (class$java$lang$Class == null ? (class$java$lang$Class = RTPManager.class$("java.lang.Class")) : class$java$lang$Class).getMethod("forName", class$java$lang$String == null ? (class$java$lang$String = RTPManager.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = RTPManager.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            getSystemClassLoaderM = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = RTPManager.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getMethod("getSystemClassLoader", null);
            systemClassLoader = (ClassLoader)getSystemClassLoaderM.invoke((Object)(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = RTPManager.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader), null);
            getContextClassLoaderM = (class$java$lang$Thread == null ? (class$java$lang$Thread = RTPManager.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
            return true;
        }
        catch (Throwable t) {
            forName3ArgsM = null;
            return false;
        }
    }

    public abstract Object getControl(String var1);

    public abstract Object[] getControls();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

