/*
 * Decompiled with CFR 0.152.
 */
package IceBT;

import Ice.ConnectFailedException;
import Ice.LocalException;
import Ice.SocketException;
import IceBT.ConnectionInfo;
import IceBT.Instance;
import IceInternal.Buffer;
import IceInternal.EndpointI;
import IceInternal.ReadyCallback;
import IceInternal.Transceiver;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.util.UUID;

final class TransceiverI
implements Transceiver {
    private Instance _instance;
    private String _remoteAddr;
    private String _uuid;
    private String _connectionId;
    private String _adapterName;
    private BluetoothSocket _socket;
    private static final int StateConnecting = 0;
    private static final int StateConnected = 1;
    private static final int StateClosed = 2;
    private int _state;
    private Thread _connectThread;
    private Thread _readThread;
    private Thread _writeThread;
    private LocalException _exception;
    private int _rcvSize;
    private int _sndSize;
    private Buffer _readBuffer;
    private Buffer _writeBuffer;
    private String _desc;
    private ReadyCallback _readyCallback;

    @Override
    public SelectableChannel fd() {
        return null;
    }

    @Override
    public void setReadyCallback(ReadyCallback callback) {
        this._readyCallback = callback;
    }

    @Override
    public synchronized int initialize(Buffer readBuffer, Buffer writeBuffer) {
        if (this._exception != null) {
            throw this._exception;
        }
        if (this._state == 0) {
            return 1;
        }
        if (this._state == 1) {
            this._readyCallback.ready(1, this._readBuffer.b.position() > 0);
        }
        return 0;
    }

    @Override
    public int closing(boolean initiator, LocalException ex) {
        return initiator ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Thread connectThread = null;
        Thread readThread = null;
        Thread writeThread = null;
        TransceiverI transceiverI = this;
        synchronized (transceiverI) {
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this._socket = null;
            }
            connectThread = this._connectThread;
            this._connectThread = null;
            readThread = this._readThread;
            this._readThread = null;
            writeThread = this._writeThread;
            this._writeThread = null;
            this._state = 2;
            if (writeThread != null) {
                this.notifyAll();
            }
        }
        if (connectThread != null) {
            try {
                connectThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (readThread != null) {
            try {
                readThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (writeThread != null) {
            try {
                writeThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public EndpointI bind() {
        assert (false);
        return null;
    }

    @Override
    public synchronized int write(Buffer buf) {
        if (this._exception != null) {
            throw this._exception;
        }
        int capacity = this._sndSize - this._writeBuffer.b.position();
        if (capacity > 0) {
            int num = Math.min(capacity, buf.b.remaining());
            this._writeBuffer.expand(num);
            int lim = buf.b.limit();
            buf.limit(buf.b.position() + num);
            this._writeBuffer.b.put(buf.b);
            buf.limit(lim);
            this.notifyAll();
        }
        return buf.b.hasRemaining() ? 4 : 0;
    }

    @Override
    public synchronized int read(Buffer buf) {
        if (this._exception != null) {
            throw this._exception;
        }
        this._readBuffer.b.flip();
        if (this._readBuffer.b.hasRemaining()) {
            int bytesNeeded;
            int bytesAvailable = this._readBuffer.b.remaining();
            if (bytesAvailable > (bytesNeeded = buf.b.remaining())) {
                bytesAvailable = bytesNeeded;
            }
            if (buf.b.hasArray()) {
                byte[] arr = buf.b.array();
                this._readBuffer.b.get(arr, buf.b.arrayOffset() + buf.b.position(), bytesAvailable);
                buf.position(buf.b.position() + bytesAvailable);
            } else if (this._readBuffer.b.hasArray()) {
                byte[] arr = this._readBuffer.b.array();
                buf.b.put(arr, this._readBuffer.b.arrayOffset() + this._readBuffer.b.position(), bytesAvailable);
                this._readBuffer.b.position(this._readBuffer.b.position() + bytesAvailable);
            } else {
                byte[] arr = new byte[bytesAvailable];
                this._readBuffer.b.get(arr);
                buf.b.put(arr);
            }
        }
        this._readBuffer.b.compact();
        if (this._readBuffer.b.position() < this._rcvSize) {
            this.notifyAll();
        }
        this._readyCallback.ready(1, this._readBuffer.b.position() > 0);
        return buf.b.hasRemaining() ? 1 : 0;
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public String toString() {
        return this._desc;
    }

    @Override
    public String toDetailedString() {
        return this.toString();
    }

    @Override
    public Ice.ConnectionInfo getInfo() {
        ConnectionInfo info = new ConnectionInfo();
        info.incoming = this._adapterName != null;
        info.adapterName = this._adapterName != null ? this._adapterName : "";
        info.connectionId = this._connectionId;
        info.rcvSize = this._rcvSize;
        info.sndSize = this._sndSize;
        info.localAddress = BluetoothAdapter.getDefaultAdapter().getAddress();
        info.remoteAddress = this._remoteAddr;
        info.uuid = this._uuid;
        return info;
    }

    @Override
    public synchronized void setBufferSize(int rcvSize, int sndSize) {
        this._rcvSize = Math.max(1024, rcvSize);
        this._sndSize = Math.max(1024, sndSize);
    }

    @Override
    public void checkSendSize(Buffer buf) {
    }

    TransceiverI(Instance instance, String remoteAddr, String uuid, String connectionId) {
        this._instance = instance;
        this._remoteAddr = remoteAddr;
        this._uuid = uuid;
        this._connectionId = connectionId;
        this._state = 0;
        this.init();
        BluetoothAdapter adapter = this._instance.bluetoothAdapter();
        assert (adapter != null);
        BluetoothDevice device = null;
        try {
            device = adapter.getRemoteDevice(this._remoteAddr);
        }
        catch (IllegalArgumentException ex) {
            throw new SocketException(ex);
        }
        UUID uuidObj = null;
        try {
            uuidObj = UUID.fromString(this._uuid);
        }
        catch (IllegalArgumentException ex) {
            throw new SocketException(ex);
        }
        try {
            this._socket = device.createRfcommSocketToServiceRecord(uuidObj);
        }
        catch (IOException ex) {
            throw new SocketException(ex);
        }
        this._connectThread = new Thread(){

            @Override
            public void run() {
                String name = "IceBT.ConnectThread";
                if (TransceiverI.this._remoteAddr != null && !TransceiverI.this._remoteAddr.isEmpty()) {
                    name = name + "-" + TransceiverI.this._remoteAddr;
                }
                if (!TransceiverI.this._uuid.isEmpty()) {
                    name = name + "-" + TransceiverI.this._uuid;
                }
                this.setName(name);
                TransceiverI.this.runConnectThread();
            }
        };
        this._connectThread.start();
    }

    TransceiverI(Instance instance, BluetoothSocket socket, String uuid, String adapterName) {
        this._instance = instance;
        this._remoteAddr = socket.getRemoteDevice().getAddress();
        this._uuid = uuid;
        this._connectionId = "";
        this._adapterName = adapterName;
        this._socket = socket;
        this._state = 1;
        this.init();
        this.startReadWriteThreads();
    }

    private void init() {
        this._desc = "local address = " + this._instance.bluetoothAdapter().getAddress();
        if (this._remoteAddr != null && !this._remoteAddr.isEmpty()) {
            this._desc = this._desc + "\nremote address = " + this._remoteAddr;
        }
        if (!this._uuid.isEmpty()) {
            this._desc = this._desc + "\nservice uuid = " + this._uuid;
        }
        int defaultBufSize = 131072;
        this._rcvSize = this._instance.properties().getPropertyAsIntWithDefault("IceBT.RcvSize", 131072);
        this._sndSize = this._instance.properties().getPropertyAsIntWithDefault("IceBT.SndSize", 131072);
        this._readBuffer = new Buffer(false);
        this._writeBuffer = new Buffer(false);
    }

    private synchronized void exception(LocalException ex) {
        if (this._exception == null) {
            this._exception = ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runConnectThread() {
        this._instance.bluetoothAdapter().cancelDiscovery();
        try {
            this._socket.connect();
        }
        catch (IOException ex) {
            this.exception(new ConnectFailedException(ex));
        }
        TransceiverI transceiverI = this;
        synchronized (transceiverI) {
            this._connectThread = null;
            if (this._exception == null) {
                this._state = 1;
                this.startReadWriteThreads();
            }
        }
        this._readyCallback.ready(1, true);
    }

    private void startReadWriteThreads() {
        String s = "";
        if (this._remoteAddr != null && !this._remoteAddr.isEmpty()) {
            s = s + "-" + this._remoteAddr;
        }
        if (!this._uuid.isEmpty()) {
            s = s + "-" + this._uuid;
        }
        final String suffix = s;
        this._readThread = new Thread(){

            @Override
            public void run() {
                this.setName("IceBT.ReadThread" + suffix);
                TransceiverI.this.runReadThread();
            }
        };
        this._readThread.start();
        this._writeThread = new Thread(){

            @Override
            public void run() {
                this.setName("IceBT.WriteThread" + suffix);
                TransceiverI.this.runWriteThread();
            }
        };
        this._writeThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runReadThread() {
        InputStream in = null;
        try {
            byte[] buf = null;
            TransceiverI transceiverI = this;
            synchronized (transceiverI) {
                if (this._socket == null) {
                    return;
                }
                in = this._socket.getInputStream();
                buf = new byte[this._rcvSize];
            }
            while (true) {
                TransceiverI transceiverI2 = this;
                synchronized (transceiverI2) {
                    while (this._state == 1 && this._exception == null && this._readBuffer.b.position() > this._rcvSize) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                            break;
                        }
                    }
                    if (this._state != 1) return;
                    if (this._exception != null) {
                        return;
                    }
                }
                int num = in.read(buf);
                if (num <= 0) continue;
                TransceiverI transceiverI3 = this;
                synchronized (transceiverI3) {
                    this._readBuffer.expand(num);
                    this._readBuffer.b.put(buf, 0, num);
                    this._readyCallback.ready(1, true);
                    if (buf.length != this._rcvSize) {
                        buf = new byte[this._rcvSize];
                    }
                }
            }
        }
        catch (IOException ex) {
            this.exception(new SocketException(ex));
            this._readyCallback.ready(1, true);
            return;
        }
        catch (LocalException ex) {
            this.exception(ex);
            this._readyCallback.ready(1, true);
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWriteThread() {
        OutputStream out = null;
        try {
            TransceiverI transceiverI = this;
            synchronized (transceiverI) {
                block32: {
                    if (this._socket != null) break block32;
                    return;
                }
                out = this._socket.getOutputStream();
            }
            boolean done = false;
            while (!done) {
                ByteBuffer b = null;
                TransceiverI transceiverI2 = this;
                synchronized (transceiverI2) {
                    while (this._state == 1 && this._exception == null && this._writeBuffer.b.position() == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                            break;
                        }
                    }
                    if (this._state != 1 || this._exception != null) {
                        done = true;
                    }
                    b = this._writeBuffer.b;
                    this._writeBuffer.clear();
                }
                assert (b != null && b.hasArray());
                b.flip();
                if (b.hasRemaining() && !done) {
                    out.write(b.array(), b.arrayOffset(), b.remaining());
                }
                transceiverI2 = this;
                synchronized (transceiverI2) {
                    this._readyCallback.ready(4, this._writeBuffer.b.position() < this._sndSize);
                }
            }
        }
        catch (IOException ex) {
            this.exception(new SocketException(ex));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

