/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.EffectSystem;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.LocalVariableResolver;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionInformation;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiOperation;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ConditionalDataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.IdentifierInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.checkers.PrimitiveNumericComparisonCallChecker;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.TypeReconstructionUtil;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001BB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J.\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001eH\u0002J(\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0002J8\u0010$\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J \u0010+\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J8\u0010.\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*H\u0002J8\u00100\u001a\u0004\u0018\u00010\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u00101\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000703H\u0002J4\u00104\u001a\u0002052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u00106\u001a\u0004\u0018\u00010\u00192\u0006\u00107\u001a\u00020\u00142\b\u00108\u001a\u0004\u0018\u00010*H\u0002J\u0010\u00109\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0018\u0010:\u001a\u00020\r2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0018\u0010=\u001a\u0002052\u0006\u0010\b\u001a\u00020>2\u0006\u00101\u001a\u00020\u000bH\u0016J\u0018\u0010?\u001a\u0002052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u001e\u0010?\u001a\u0002052\u0006\u0010\b\u001a\u00020\t2\u0006\u00101\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020\u0014J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u0017032\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingVisitor;", "facade", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;)V", "analyzeConditionsInWhenEntries", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "contextAfterSubject", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "subject", "Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$Subject;", "analyzeWhenEntryConditions", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/ConditionalDataFlowInfo;", "whenEntry", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "context", "checkSmartCastToExpectedTypeInSubject", "", "contextBeforeSubject", "subjectExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "subjectType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expectedType", "checkSmartCastsInSubjectIfRequired", "", "possibleTypesForSubject", "", "checkTypeCompatibility", "type", "reportErrorOn", "Lorg/jetbrains/kotlin/psi/KtElement;", "checkTypeForExpressionCondition", "checkTypeForIs", "isCheck", "negated", "typeReferenceAfterIs", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "subjectDataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "checkWhenCondition", "condition", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "detectRedundantIs", "targetType", "inferTypeForWhenExpression", "contextWithExpectedType", "dataFlowInfoForEntries", "", "joinWhenExpressionBranches", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "resultType", "jumpOutPossibleInSubject", "whenResultValue", "noChange", "processVariableSubject", "subjectVariable", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "visitWhenExpression", "isStatement", "wrapWhenEntryExpressionsAsSpecialCallArguments", "Subject", "frontend"})
public final class PatternMatchingTypingVisitor
extends ExpressionTypingVisitor {
    @Override
    @NotNull
    public KotlinTypeInfo visitIsExpression(@NotNull KtIsExpression expression2, @NotNull ExpressionTypingContext contextWithExpectedType) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(contextWithExpectedType, "contextWithExpectedType");
        Object Context2 = ((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkExpressionValueIsNotNull(Context2, "contextWithExpectedType.\u2026xtDependency(INDEPENDENT)");
        ExpressionTypingContext context = (ExpressionTypingContext)Context2;
        KtExpression ktExpression = expression2.getLeftHandSide();
        Intrinsics.checkExpressionValueIsNotNull(ktExpression, "expression.leftHandSide");
        KtExpression leftHandSide = ktExpression;
        KotlinTypeInfo kotlinTypeInfo = this.facade.safeGetTypeInfo(leftHandSide, context);
        Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "facade.safeGetTypeInfo(leftHandSide, context)");
        KotlinTypeInfo typeInfo = kotlinTypeInfo;
        KotlinType knownType = typeInfo.getType();
        KtTypeReference typeReference = expression2.getTypeReference();
        if (typeReference != null && knownType != null) {
            DataFlowValue dataFlowValue2 = this.components.dataFlowValueFactory.createDataFlowValue(leftHandSide, knownType, context);
            DataFlowInfo conditionInfo = this.checkTypeForIs(context, expression2, expression2.isNegated(), knownType, typeReference, dataFlowValue2).getThenInfo();
            DataFlowInfo newDataFlowInfo = conditionInfo.and(typeInfo.getDataFlowInfo());
            context.trace.record(BindingContext.DATAFLOW_INFO_AFTER_CONDITION, expression2, newDataFlowInfo);
        }
        DataFlowAnalyzer dataFlowAnalyzer = this.components.dataFlowAnalyzer;
        KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
        Intrinsics.checkExpressionValueIsNotNull(kotlinBuiltIns, "components.builtIns");
        KotlinTypeInfo kotlinTypeInfo2 = dataFlowAnalyzer.checkType(typeInfo.replaceType(kotlinBuiltIns.getBooleanType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType);
        Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo2, "components.dataFlowAnaly\u2026ithExpectedType\n        )");
        KotlinTypeInfo resultTypeInfo = kotlinTypeInfo2;
        if (typeReference != null) {
            KotlinType rhsType = (KotlinType)context.trace.get(BindingContext.TYPE, typeReference);
            RttiExpressionInformation rttiInformation = new RttiExpressionInformation(leftHandSide, knownType, rhsType, expression2.isNegated() ? RttiOperation.NOT_IS : RttiOperation.IS);
            Iterable<RttiExpressionChecker> iterable = this.components.rttiExpressionCheckers;
            Intrinsics.checkExpressionValueIsNotNull(iterable, "components.rttiExpressionCheckers");
            Iterable<RttiExpressionChecker> $receiver$iv = iterable;
            Iterator<RttiExpressionChecker> iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                RttiExpressionChecker element$iv;
                RttiExpressionChecker it = element$iv = iterator2.next();
                PsiElement psiElement = expression2;
                BindingTrace bindingTrace = context.trace;
                Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
                it.check(rttiInformation, psiElement, bindingTrace);
            }
        }
        return resultTypeInfo;
    }

    @Override
    @NotNull
    public KotlinTypeInfo visitWhenExpression(@NotNull KtWhenExpression expression2, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return this.visitWhenExpression(expression2, context, false);
    }

    @NotNull
    public final KotlinTypeInfo visitWhenExpression(@NotNull KtWhenExpression expression2, @NotNull ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        DataFlowInfo resultDataFlowInfo;
        DataFlowInfo dataFlowInfo;
        DataFlowValue dataFlowValue2;
        KotlinType whenReturnType;
        Object object;
        Object contextWithExpectedTypeAndSubjectVariable;
        ExpressionTypingContext contextAfterSubject;
        Subject subject;
        ExpressionTypingContext contextBeforeSubject;
        BindingTrace trace;
        block18: {
            block17: {
                Object it;
                Object it2;
                Object object2;
                Subject subject2;
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(contextWithExpectedType, "contextWithExpectedType");
                BindingTrace bindingTrace = contextWithExpectedType.trace;
                Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "contextWithExpectedType.trace");
                trace = bindingTrace;
                WhenChecker.INSTANCE.checkDeprecatedWhenSyntax(trace, expression2);
                WhenChecker.INSTANCE.checkReservedPrefix(trace, expression2);
                this.components.dataFlowAnalyzer.recordExpectedType(trace, expression2, contextWithExpectedType.expectedType);
                Object Context2 = ((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
                Intrinsics.checkExpressionValueIsNotNull(Context2, "contextWithExpectedType.\u2026xtDependency(INDEPENDENT)");
                contextBeforeSubject = (ExpressionTypingContext)Context2;
                KtExpression subjectExpression = expression2.getSubjectExpression();
                KtProperty subjectVariable = expression2.getSubjectVariable();
                if (subjectVariable != null) {
                    subject2 = this.processVariableSubject(subjectVariable, contextBeforeSubject);
                } else if (subjectExpression != null) {
                    KotlinTypeInfo kotlinTypeInfo = this.facade.getTypeInfo(subjectExpression, contextBeforeSubject);
                    Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "facade.getTypeInfo(subje\u2026on, contextBeforeSubject)");
                    DataFlowValueFactory dataFlowValueFactory = this.components.dataFlowValueFactory;
                    Intrinsics.checkExpressionValueIsNotNull(dataFlowValueFactory, "components.dataFlowValueFactory");
                    subject2 = new Subject.Expression(subjectExpression, kotlinTypeInfo, dataFlowValueFactory);
                } else {
                    subject2 = new Subject.None();
                }
                subject = subject2;
                PatternMatchingTypingVisitor patternMatchingTypingVisitor = this;
                Object $receiver = patternMatchingTypingVisitor;
                ExpressionTypingContext result2 = contextBeforeSubject;
                LexicalScope lexicalScope = subject.getScopeWithSubject();
                if (lexicalScope != null) {
                    it2 = object2 = lexicalScope;
                    Object Context3 = result2.replaceScope((LexicalScope)it2);
                    Intrinsics.checkExpressionValueIsNotNull(Context3, "result.replaceScope(it)");
                    result2 = (ExpressionTypingContext)Context3;
                }
                DataFlowInfo dataFlowInfo2 = subject.getDataFlowInfo();
                if (dataFlowInfo2 != null) {
                    it2 = object2 = dataFlowInfo2;
                    Object Context4 = result2.replaceDataFlowInfo((DataFlowInfo)it2);
                    Intrinsics.checkExpressionValueIsNotNull(Context4, "result.replaceDataFlowInfo(it)");
                    result2 = (ExpressionTypingContext)Context4;
                }
                contextAfterSubject = result2;
                Object object3 = subject.getScopeWithSubject();
                if (object3 == null || (object3 = (ExpressionTypingContext)contextWithExpectedType.replaceScope((LexicalScope)(it = ($receiver = object3)))) == null) {
                    object3 = contextWithExpectedType;
                }
                Intrinsics.checkExpressionValueIsNotNull(object3, "subject.scopeWithSubject\u2026: contextWithExpectedType");
                contextWithExpectedTypeAndSubjectVariable = object3;
                KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
                Intrinsics.checkExpressionValueIsNotNull(kotlinBuiltIns, "components.builtIns");
                subject.initDataFlowValue(contextAfterSubject, kotlinBuiltIns);
                object = subject.getTypeInfo();
                if (object == null || (object = ((KotlinTypeInfo)object).getDataFlowInfo()) == null) break block17;
                DataFlowValue dataFlowValue3 = subject.getDataFlowValue();
                LanguageVersionSettings languageVersionSettings = this.components.languageVersionSettings;
                Intrinsics.checkExpressionValueIsNotNull(languageVersionSettings, "components.languageVersionSettings");
                if ((object = object.getStableTypes(dataFlowValue3, languageVersionSettings)) != null) break block18;
            }
            object = SetsKt.emptySet();
        }
        Set possibleTypesForSubject = object;
        this.checkSmartCastsInSubjectIfRequired(expression2, contextBeforeSubject, subject.getType(), possibleTypesForSubject);
        ArrayList<DataFlowInfo> dataFlowInfoForEntries = this.analyzeConditionsInWhenEntries(expression2, contextAfterSubject, subject);
        KotlinType kotlinType = whenReturnType = this.inferTypeForWhenExpression(expression2, subject, (ExpressionTypingContext)contextWithExpectedTypeAndSubjectVariable, contextAfterSubject, (List<? extends DataFlowInfo>)dataFlowInfoForEntries);
        if (kotlinType != null) {
            KotlinType $i$a$2$let;
            KotlinType it = $i$a$2$let = kotlinType;
            ExpressionTypingInternals expressionTypingInternals = this.facade;
            Intrinsics.checkExpressionValueIsNotNull(expressionTypingInternals, "facade");
            dataFlowValue2 = expressionTypingInternals.getComponents().dataFlowValueFactory.createDataFlowValue(expression2, it, contextAfterSubject);
        } else {
            dataFlowValue2 = null;
        }
        DataFlowValue whenResultValue = dataFlowValue2;
        KotlinTypeInfo branchesTypeInfo = this.joinWhenExpressionBranches(expression2, contextAfterSubject, whenReturnType, subject.getJumpOutPossible(), whenResultValue);
        boolean isExhaustive = WhenChecker.isWhenExhaustive(expression2, trace);
        DataFlowInfo branchesDataFlowInfo = branchesTypeInfo.getDataFlowInfo();
        if (expression2.getElseExpression() == null && !isExhaustive) {
            DataFlowInfo dataFlowInfo3 = contextAfterSubject.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo3, "contextAfterSubject.dataFlowInfo");
            dataFlowInfo = branchesDataFlowInfo.or(dataFlowInfo3);
        } else {
            dataFlowInfo = resultDataFlowInfo = branchesDataFlowInfo;
        }
        if (whenReturnType != null && isExhaustive && expression2.getElseExpression() == null && KotlinBuiltIns.isNothing(whenReturnType)) {
            trace.record(BindingContext.IMPLICIT_EXHAUSTIVE_WHEN, expression2);
        }
        KotlinType kotlinType2 = branchesTypeInfo.getType();
        if (kotlinType2 == null) {
            return TypeInfoFactoryKt.noTypeInfo(resultDataFlowInfo);
        }
        KotlinType branchesType = kotlinType2;
        KotlinType resultType = this.components.dataFlowAnalyzer.checkType(branchesType, (KtExpression)expression2, (ResolutionContext)contextWithExpectedType);
        boolean bl = branchesTypeInfo.getJumpOutPossible();
        DataFlowInfo dataFlowInfo4 = contextWithExpectedType.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo4, "contextWithExpectedType.dataFlowInfo");
        return TypeInfoFactoryKt.createTypeInfo(resultType, resultDataFlowInfo, bl, dataFlowInfo4);
    }

    /*
     * WARNING - void declaration
     */
    private final Subject processVariableSubject(KtProperty subjectVariable, ExpressionTypingContext contextBeforeSubject) {
        void typeInfo;
        BindingTrace bindingTrace = contextBeforeSubject.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "contextBeforeSubject.trace");
        BindingTrace trace = bindingTrace;
        if (!this.components.languageVersionSettings.supportsFeature(LanguageFeature.VariableDeclarationInWhenSubject)) {
            trace.report(Errors.UNSUPPORTED_FEATURE.on(subjectVariable, new Pair<LanguageFeature, LanguageVersionSettings>(LanguageFeature.VariableDeclarationInWhenSubject, this.components.languageVersionSettings)));
        } else {
            String illegalDeclarationString;
            String string = subjectVariable instanceof KtDestructuringDeclaration ? "destructuring declaration" : (subjectVariable.isVar() ? "var" : (subjectVariable.getInitializer() == null ? "variable without initializer" : (subjectVariable.hasDelegateExpression() ? "delegated property" : (illegalDeclarationString = subjectVariable.getGetter() != null || subjectVariable.getSetter() != null ? "property with accessors" : null))));
            if (illegalDeclarationString != null) {
                trace.report(Errors.ILLEGAL_DECLARATION_IN_WHEN_SUBJECT.on(subjectVariable, illegalDeclarationString));
            }
        }
        LexicalWritableScope lexicalWritableScope = ExpressionTypingUtils.newWritableScopeImpl(contextBeforeSubject, LexicalScopeKind.WHEN, this.components.overloadChecker);
        Intrinsics.checkExpressionValueIsNotNull(lexicalWritableScope, "ExpressionTypingUtils.ne\u2026mponents.overloadChecker)");
        LexicalWritableScope scopeWithSubjectVariable = lexicalWritableScope;
        LocalVariableResolver localVariableResolver = this.components.localVariableResolver;
        LexicalScope lexicalScope = contextBeforeSubject.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "contextBeforeSubject.scope");
        ExpressionTypingInternals expressionTypingInternals = this.facade;
        Intrinsics.checkExpressionValueIsNotNull(expressionTypingInternals, "facade");
        Pair<KotlinTypeInfo, VariableDescriptor> pair = localVariableResolver.process(subjectVariable, contextBeforeSubject, lexicalScope, expressionTypingInternals);
        KotlinTypeInfo kotlinTypeInfo = pair.component1();
        VariableDescriptor descriptor2 = pair.component2();
        scopeWithSubjectVariable.addVariableDescriptor(descriptor2);
        KotlinTypeInfo subjectTypeInfo = typeInfo.replaceType(descriptor2.getType());
        return new Subject.Variable(subjectVariable, descriptor2, subjectTypeInfo, scopeWithSubjectVariable);
    }

    private final KotlinType inferTypeForWhenExpression(KtWhenExpression expression2, Subject subject, ExpressionTypingContext contextWithExpectedType, ExpressionTypingContext contextAfterSubject, List<? extends DataFlowInfo> dataFlowInfoForEntries) {
        ResolvedCall<FunctionDescriptor> resolvedCall2;
        boolean bl;
        block5: {
            List<KtWhenEntry> list2 = expression2.getEntries();
            Intrinsics.checkExpressionValueIsNotNull(list2, "expression.entries");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    KtWhenEntry it;
                    KtWhenEntry ktWhenEntry = it = (KtWhenEntry)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull(ktWhenEntry, "it");
                    if (ktWhenEntry.getExpression() == null) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
            Intrinsics.checkExpressionValueIsNotNull(kotlinBuiltIns, "components.builtIns");
            return kotlinBuiltIns.getUnitType();
        }
        List<KtExpression> wrappedArgumentExpressions = this.wrapWhenEntryExpressionsAsSpecialCallArguments(expression2);
        KtExpression ktExpression = expression2;
        KtExpression ktExpression2 = subject.getCalleeExpressionForSpecialCall();
        if (ktExpression2 == null) {
            ktExpression2 = expression2;
        }
        Call callForWhen = ControlStructureTypingUtils.createCallForSpecialConstruction(ktExpression, ktExpression2, wrappedArgumentExpressions);
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = ControlStructureTypingUtils.createDataFlowInfoForArgumentsOfWhenCall(callForWhen, contextAfterSubject.dataFlowInfo, dataFlowInfoForEntries);
        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(callForWhen, ControlStructureTypingUtils.ResolveConstruct.WHEN, (List<String>)new AbstractList<String>(wrappedArgumentExpressions){
            final /* synthetic */ List $wrappedArgumentExpressions;

            @NotNull
            public String get(int index2) {
                return "entry" + index2;
            }

            public int getSize() {
                return this.$wrappedArgumentExpressions.size();
            }
            {
                this.$wrappedArgumentExpressions = $captured_local_variable$0;
            }
        }, Collections.nCopies(wrappedArgumentExpressions.size(), false), contextWithExpectedType, dataFlowInfoForArguments);
        Intrinsics.checkExpressionValueIsNotNull(resolvedCall3, "resolvedCall");
        return resolvedCall3.getResultingDescriptor().getReturnType();
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtExpression> wrapWhenEntryExpressionsAsSpecialCallArguments(KtWhenExpression expression2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default(expression2, false, 2, null);
        List<KtWhenEntry> list2 = expression2.getEntries();
        Intrinsics.checkExpressionValueIsNotNull(list2, "expression.entries");
        Iterable iterable = $receiver$iv = (Iterable)list2;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtBlockExpression ktBlockExpression;
            KtBlockExpression ktBlockExpression2;
            KtWhenEntry whenEntry;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            KtWhenEntry ktWhenEntry = whenEntry = (KtWhenEntry)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull(ktWhenEntry, "whenEntry");
            if (ktWhenEntry.getExpression() != null) {
                KtExpression ktExpression;
                KtExpression it;
                KtExpression ktExpression2 = it = ktExpression;
                Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "it");
                ktBlockExpression2 = psiFactory.wrapInABlockWrapper(ktExpression2);
            } else {
                ktBlockExpression2 = null;
            }
            if (ktBlockExpression2 == null) continue;
            KtBlockExpression it$iv$iv = ktBlockExpression = ktBlockExpression2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ArrayList<DataFlowInfo> analyzeConditionsInWhenEntries(KtWhenExpression expression2, ExpressionTypingContext contextAfterSubject, Subject subject) {
        ArrayList<DataFlowInfo> argumentDataFlowInfos = new ArrayList<DataFlowInfo>();
        DataFlowInfo dataFlowInfo = contextAfterSubject.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "contextAfterSubject.dataFlowInfo");
        DataFlowInfo inputDataFlowInfo = dataFlowInfo;
        Iterator<KtWhenEntry> iterator2 = expression2.getEntries().iterator();
        while (iterator2.hasNext()) {
            KtWhenEntry whenEntry;
            KtWhenEntry ktWhenEntry = whenEntry = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(ktWhenEntry, "whenEntry");
            Object Context2 = contextAfterSubject.replaceDataFlowInfo(inputDataFlowInfo);
            Intrinsics.checkExpressionValueIsNotNull(Context2, "contextAfterSubject.repl\u2026owInfo(inputDataFlowInfo)");
            ConditionalDataFlowInfo conditionsInfo = this.analyzeWhenEntryConditions(ktWhenEntry, (ExpressionTypingContext)Context2, subject);
            inputDataFlowInfo = inputDataFlowInfo.and(conditionsInfo.getElseInfo());
            if (whenEntry.getExpression() == null) continue;
            argumentDataFlowInfos.add(conditionsInfo.getThenInfo());
        }
        return argumentDataFlowInfos;
    }

    private final KotlinTypeInfo joinWhenExpressionBranches(KtWhenExpression expression2, ExpressionTypingContext contextAfterSubject, KotlinType resultType, boolean jumpOutPossibleInSubject, DataFlowValue whenResultValue) {
        BindingTrace bindingTrace = contextAfterSubject.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "contextAfterSubject.trace");
        BindingContext bindingContext = bindingTrace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "contextAfterSubject.trace.bindingContext");
        BindingContext bindingContext2 = bindingContext;
        DataFlowInfo currentDataFlowInfo = null;
        boolean jumpOutPossible = jumpOutPossibleInSubject;
        boolean errorTypeExistInBranch = false;
        Iterator<KtWhenEntry> iterator2 = expression2.getEntries().iterator();
        while (iterator2.hasNext()) {
            DataFlowInfo entryDataFlowInfo;
            DataFlowInfo dataFlowInfo;
            KotlinTypeInfo entryTypeInfo;
            KtExpression entryExpression;
            KtWhenEntry whenEntry;
            KtWhenEntry ktWhenEntry = whenEntry = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(ktWhenEntry, "whenEntry");
            if (ktWhenEntry.getExpression() == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull(entryExpression, "whenEntry.expression ?: continue");
            if (BindingContextUtils.getRecordedTypeInfo(entryExpression, bindingContext2) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull(entryTypeInfo, "BindingContextUtils.getR\u2026ndingContext) ?: continue");
            KotlinType entryType = entryTypeInfo.getType();
            if (entryType == null) {
                errorTypeExistInBranch = true;
            }
            if (whenResultValue != null && entryType != null) {
                ExpressionTypingInternals expressionTypingInternals = this.facade;
                Intrinsics.checkExpressionValueIsNotNull(expressionTypingInternals, "facade");
                DataFlowValue entryValue = expressionTypingInternals.getComponents().dataFlowValueFactory.createDataFlowValue(entryExpression, entryType, contextAfterSubject);
                DataFlowInfo dataFlowInfo2 = entryTypeInfo.getDataFlowInfo();
                LanguageVersionSettings languageVersionSettings = this.components.languageVersionSettings;
                Intrinsics.checkExpressionValueIsNotNull(languageVersionSettings, "components.languageVersionSettings");
                dataFlowInfo = dataFlowInfo2.assign(whenResultValue, entryValue, languageVersionSettings);
            } else {
                dataFlowInfo = entryDataFlowInfo = entryTypeInfo.getDataFlowInfo();
            }
            currentDataFlowInfo = entryType != null && KotlinBuiltIns.isNothing(entryType) ? currentDataFlowInfo : (currentDataFlowInfo != null ? currentDataFlowInfo.or(entryDataFlowInfo) : entryDataFlowInfo);
            jumpOutPossible |= entryTypeInfo.getJumpOutPossible();
        }
        DataFlowInfo dataFlowInfo = currentDataFlowInfo;
        if (dataFlowInfo == null) {
            DataFlowInfo dataFlowInfo3 = contextAfterSubject.dataFlowInfo;
            dataFlowInfo = dataFlowInfo3;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo3, "contextAfterSubject.dataFlowInfo");
        }
        DataFlowInfo resultDataFlowInfo = dataFlowInfo;
        return resultType == null || errorTypeExistInBranch && KotlinBuiltIns.isNothing(resultType) ? TypeInfoFactoryKt.noTypeInfo(resultDataFlowInfo) : TypeInfoFactoryKt.createTypeInfo(resultType, resultDataFlowInfo, jumpOutPossible, resultDataFlowInfo);
    }

    private final void checkSmartCastsInSubjectIfRequired(KtWhenExpression expression2, ExpressionTypingContext contextBeforeSubject, KotlinType subjectType, Set<? extends KotlinType> possibleTypesForSubject) {
        KtExpression ktExpression = expression2.getSubjectExpression();
        if (ktExpression == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull(ktExpression, "expression.subjectExpression ?: return");
        KtExpression subjectExpression = ktExpression;
        for (KotlinType possibleCastType : CollectionsKt.reversed((Iterable)possibleTypesForSubject)) {
            ClassDescriptor possibleCastClass;
            ClassifierDescriptor classifierDescriptor = possibleCastType.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            if ((ClassDescriptor)classifierDescriptor == null) {
                continue;
            }
            if (possibleCastClass.getKind() != ClassKind.ENUM_CLASS && possibleCastClass.getModality() != Modality.SEALED || !this.checkSmartCastToExpectedTypeInSubject(contextBeforeSubject, subjectExpression, subjectType, possibleCastType)) continue;
            return;
        }
        boolean isNullableType = TypeUtils.isNullableType(subjectType);
        BindingTrace bindingTrace = contextBeforeSubject.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "contextBeforeSubject.trace");
        BindingContext bindingContext = bindingTrace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "contextBeforeSubject.trace.bindingContext");
        BindingContext bindingContext2 = bindingContext;
        if (isNullableType && !WhenChecker.INSTANCE.containsNullCase(expression2, bindingContext2)) {
            KotlinType kotlinType = TypeUtils.makeNotNullable(subjectType);
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeUtils.makeNotNullable(subjectType)");
            KotlinType notNullableType = kotlinType;
            if (this.checkSmartCastToExpectedTypeInSubject(contextBeforeSubject, subjectExpression, subjectType, notNullableType)) {
                return;
            }
        }
    }

    private final boolean checkSmartCastToExpectedTypeInSubject(ExpressionTypingContext contextBeforeSubject, KtExpression subjectExpression, KotlinType subjectType, KotlinType expectedType) {
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(contextBeforeSubject.trace, "Temporary trace for when subject nullability");
        Intrinsics.checkExpressionValueIsNotNull(temporaryBindingTrace, "TemporaryBindingTrace.cr\u2026hen subject nullability\")");
        TemporaryBindingTrace trace = temporaryBindingTrace;
        Object Context2 = ((ExpressionTypingContext)contextBeforeSubject.replaceExpectedType(expectedType)).replaceBindingTrace(trace);
        Intrinsics.checkExpressionValueIsNotNull(Context2, "contextBeforeSubject.rep\u2026eplaceBindingTrace(trace)");
        ExpressionTypingContext subjectContext = (ExpressionTypingContext)Context2;
        ExpressionTypingInternals expressionTypingInternals = this.facade;
        Intrinsics.checkExpressionValueIsNotNull(expressionTypingInternals, "facade");
        SmartCastResult castResult = expressionTypingInternals.getComponents().dataFlowAnalyzer.checkPossibleCast(subjectType, KtPsiUtil.safeDeparenthesize(subjectExpression), subjectContext);
        if (castResult != null && castResult.isCorrect()) {
            trace.commit();
            return true;
        }
        return false;
    }

    private final ConditionalDataFlowInfo analyzeWhenEntryConditions(KtWhenEntry whenEntry, ExpressionTypingContext context, Subject subject) {
        if (whenEntry.isElse()) {
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
            return new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
        }
        ConditionalDataFlowInfo entryInfo = null;
        ExpressionTypingContext contextForCondition = context;
        KtWhenCondition[] ktWhenConditionArray = whenEntry.getConditions();
        int n = ktWhenConditionArray.length;
        for (int i = 0; i < n; ++i) {
            ConditionalDataFlowInfo conditionalDataFlowInfo;
            KtWhenCondition condition;
            KtWhenCondition ktWhenCondition = condition = ktWhenConditionArray[i];
            Intrinsics.checkExpressionValueIsNotNull(ktWhenCondition, "condition");
            ConditionalDataFlowInfo conditionInfo = this.checkWhenCondition(subject, ktWhenCondition, contextForCondition);
            if (entryInfo != null) {
                ConditionalDataFlowInfo conditionalDataFlowInfo2;
                ConditionalDataFlowInfo it = conditionalDataFlowInfo2;
                conditionalDataFlowInfo = new ConditionalDataFlowInfo(it.getThenInfo().or(conditionInfo.getThenInfo()), it.getElseInfo().and(conditionInfo.getElseInfo()));
            } else {
                conditionalDataFlowInfo = conditionInfo;
            }
            entryInfo = conditionalDataFlowInfo;
            Object Context2 = contextForCondition.replaceDataFlowInfo(conditionInfo.getElseInfo());
            Intrinsics.checkExpressionValueIsNotNull(Context2, "contextForCondition.repl\u2026o(conditionInfo.elseInfo)");
            contextForCondition = (ExpressionTypingContext)Context2;
        }
        ConditionalDataFlowInfo conditionalDataFlowInfo = entryInfo;
        if (conditionalDataFlowInfo == null) {
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
            conditionalDataFlowInfo = new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
        }
        return conditionalDataFlowInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final ConditionalDataFlowInfo checkWhenCondition(Subject subject, KtWhenCondition condition, ExpressionTypingContext context) {
        void newDataFlowInfo;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.noChange(context);
        condition.accept(new KtVisitorVoid(this, subject, context, (Ref.ObjectRef)newDataFlowInfo){
            final /* synthetic */ PatternMatchingTypingVisitor this$0;
            final /* synthetic */ Subject $subject;
            final /* synthetic */ ExpressionTypingContext $context;
            final /* synthetic */ Ref.ObjectRef $newDataFlowInfo;

            public void visitWhenConditionInRange(@NotNull KtWhenConditionInRange condition) {
                Intrinsics.checkParameterIsNotNull(condition, "condition");
                KtExpression ktExpression = condition.getRangeExpression();
                if (ktExpression == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull(ktExpression, "condition.rangeExpression ?: return");
                KtExpression rangeExpression = ktExpression;
                if (this.$subject instanceof Subject.None) {
                    this.$context.trace.report(Errors.EXPECTED_CONDITION.on((KtWhenCondition)((PsiElement)condition)));
                    DataFlowInfo dataFlowInfo = this.this$0.facade.getTypeInfo(rangeExpression, this.$context).getDataFlowInfo();
                    this.$newDataFlowInfo.element = new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
                    return;
                }
                ValueArgument valueArgument = this.$subject.makeValueArgument();
                if (valueArgument == null) {
                    return;
                }
                ValueArgument argumentForSubject = valueArgument;
                KotlinTypeInfo kotlinTypeInfo = this.this$0.facade.checkInExpression(condition, condition.getOperationReference(), argumentForSubject, rangeExpression, this.$context);
                Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "facade.checkInExpression\u2026context\n                )");
                KotlinTypeInfo typeInfo = kotlinTypeInfo;
                DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
                this.$newDataFlowInfo.element = new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
                KotlinType type2 = typeInfo.getType();
                if (type2 == null || !KotlinBuiltIns.isBoolean(type2)) {
                    this.$context.trace.report(Errors.TYPE_MISMATCH_IN_RANGE.on((KtWhenConditionInRange)((PsiElement)condition)));
                }
            }

            public void visitWhenConditionIsPattern(@NotNull KtWhenConditionIsPattern condition) {
                Intrinsics.checkParameterIsNotNull(condition, "condition");
                if (this.$subject instanceof Subject.None) {
                    this.$context.trace.report(Errors.EXPECTED_CONDITION.on((KtWhenCondition)((PsiElement)condition)));
                }
                KtTypeReference ktTypeReference = condition.getTypeReference();
                if (ktTypeReference == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull(ktTypeReference, "condition.typeReference ?: return");
                KtTypeReference typeReference = ktTypeReference;
                ConditionalDataFlowInfo result2 = PatternMatchingTypingVisitor.access$checkTypeForIs(this.this$0, this.$context, condition, condition.isNegated(), this.$subject.getType(), typeReference, this.$subject.getDataFlowValue());
                this.$newDataFlowInfo.element = condition.isNegated() ? new ConditionalDataFlowInfo(result2.getElseInfo(), result2.getThenInfo()) : result2;
                KotlinType rhsType = (KotlinType)this.$context.trace.get(BindingContext.TYPE, typeReference);
                if (!(this.$subject instanceof Subject.None)) {
                    KtElement ktElement = this.$subject.getElement();
                    if (ktElement == null) {
                        Intrinsics.throwNpe();
                    }
                    RttiExpressionInformation rttiInformation = new RttiExpressionInformation(ktElement, this.$subject.getType(), rhsType, condition.isNegated() ? RttiOperation.NOT_IS : RttiOperation.IS);
                    Iterable<RttiExpressionChecker> iterable = this.this$0.components.rttiExpressionCheckers;
                    Intrinsics.checkExpressionValueIsNotNull(iterable, "components.rttiExpressionCheckers");
                    Iterable<RttiExpressionChecker> $receiver$iv = iterable;
                    Iterator<RttiExpressionChecker> iterator2 = $receiver$iv.iterator();
                    while (iterator2.hasNext()) {
                        RttiExpressionChecker element$iv;
                        RttiExpressionChecker it = element$iv = iterator2.next();
                        PsiElement psiElement = condition;
                        BindingTrace bindingTrace = this.$context.trace;
                        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
                        it.check(rttiInformation, psiElement, bindingTrace);
                    }
                }
            }

            public void visitWhenConditionWithExpression(@NotNull KtWhenConditionWithExpression condition) {
                Intrinsics.checkParameterIsNotNull(condition, "condition");
                KtExpression ktExpression = condition.getExpression();
                if (ktExpression == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull(ktExpression, "condition.expression ?: return");
                KtExpression expression2 = ktExpression;
                ConditionalDataFlowInfo basicDataFlowInfo = PatternMatchingTypingVisitor.access$checkTypeForExpressionCondition(this.this$0, this.$context, expression2, this.$subject);
                ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule(this.$context.scope.getOwnerDescriptor());
                Intrinsics.checkExpressionValueIsNotNull(moduleDescriptor, "DescriptorUtils.getConta\u2026xt.scope.ownerDescriptor)");
                ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
                EffectSystem effectSystem = this.this$0.components.effectSystem;
                KtExpression ktExpression2 = this.$subject.getValueExpression();
                BindingTrace bindingTrace = this.$context.trace;
                Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
                ConditionalDataFlowInfo dataFlowInfoFromES = effectSystem.getDataFlowInfoWhenEquals(ktExpression2, expression2, bindingTrace, moduleDescriptor2);
                this.$newDataFlowInfo.element = basicDataFlowInfo.and(dataFlowInfoFromES);
            }

            public void visitKtElement(@NotNull KtElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                this.$context.trace.report(Errors.UNSUPPORTED.on(element, this.getClass().getCanonicalName()));
            }
            {
                this.this$0 = $outer;
                this.$subject = $captured_local_variable$1;
                this.$context = $captured_local_variable$2;
                this.$newDataFlowInfo = $captured_local_variable$3;
            }
        });
        return (ConditionalDataFlowInfo)newDataFlowInfo.element;
    }

    private final ConditionalDataFlowInfo checkTypeForExpressionCondition(ExpressionTypingContext context, KtExpression expression2, Subject subject) {
        ExpressionTypingContext newContext = context;
        KotlinTypeInfo kotlinTypeInfo = this.facade.getTypeInfo(expression2, newContext);
        Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "facade.getTypeInfo(expression, newContext)");
        KotlinTypeInfo typeInfo = kotlinTypeInfo;
        KotlinType kotlinType = typeInfo.getType();
        if (kotlinType == null) {
            return this.noChange(newContext);
        }
        KotlinType type2 = kotlinType;
        Object Context2 = newContext.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        Intrinsics.checkExpressionValueIsNotNull(Context2, "newContext.replaceDataFl\u2026fo(typeInfo.dataFlowInfo)");
        newContext = (ExpressionTypingContext)Context2;
        if (subject instanceof Subject.None) {
            KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
            Intrinsics.checkExpressionValueIsNotNull(kotlinBuiltIns, "components.builtIns");
            SimpleType simpleType2 = kotlinBuiltIns.getBooleanType();
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "components.builtIns.booleanType");
            SimpleType booleanType = simpleType2;
            KotlinTypeInfo kotlinTypeInfo2 = this.components.dataFlowAnalyzer.checkType(typeInfo, expression2, (ResolutionContext)newContext.replaceExpectedType(booleanType));
            Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo2, "components.dataFlowAnaly\u2026xpectedType(booleanType))");
            KotlinTypeInfo checkedTypeInfo = kotlinTypeInfo2;
            KotlinType kotlinType2 = booleanType;
            KotlinType kotlinType3 = checkedTypeInfo.getType();
            if (kotlinType3 == null) {
                kotlinType3 = type2;
            }
            if (KotlinTypeChecker.DEFAULT.equalTypes(kotlinType2, kotlinType3)) {
                DataFlowInfo dataFlowInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(expression2, true, newContext);
                Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "components.dataFlowAnaly\u2026ession, true, newContext)");
                DataFlowInfo ifInfo = dataFlowInfo;
                DataFlowInfo dataFlowInfo2 = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(expression2, false, newContext);
                Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo2, "components.dataFlowAnaly\u2026ssion, false, newContext)");
                DataFlowInfo elseInfo = dataFlowInfo2;
                return new ConditionalDataFlowInfo(ifInfo, elseInfo);
            }
            return this.noChange(newContext);
        }
        this.checkTypeCompatibility(newContext, type2, subject.getType(), expression2);
        ExpressionTypingInternals expressionTypingInternals = this.facade;
        Intrinsics.checkExpressionValueIsNotNull(expressionTypingInternals, "facade");
        DataFlowValue expressionDataFlowValue = expressionTypingInternals.getComponents().dataFlowValueFactory.createDataFlowValue(expression2, type2, newContext);
        Collection collection = CollectionsKt.listOf(subject.getType());
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        DataFlowValue dataFlowValue2 = subject.getDataFlowValue();
        LanguageVersionSettings languageVersionSettings = this.components.languageVersionSettings;
        Intrinsics.checkExpressionValueIsNotNull(languageVersionSettings, "components.languageVersionSettings");
        List subjectStableTypes = CollectionsKt.plus(collection, (Iterable)dataFlowInfo.getStableTypes(dataFlowValue2, languageVersionSettings));
        Collection collection2 = CollectionsKt.listOf(type2);
        DataFlowInfo dataFlowInfo3 = newContext.dataFlowInfo;
        LanguageVersionSettings languageVersionSettings2 = this.components.languageVersionSettings;
        Intrinsics.checkExpressionValueIsNotNull(languageVersionSettings2, "components.languageVersionSettings");
        List expressionStableTypes = CollectionsKt.plus(collection2, (Iterable)dataFlowInfo3.getStableTypes(expressionDataFlowValue, languageVersionSettings2));
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        PrimitiveNumericComparisonCallChecker.INSTANCE.inferPrimitiveNumericComparisonType(bindingTrace, subjectStableTypes, expressionStableTypes, expression2);
        ConditionalDataFlowInfo result2 = this.noChange(newContext);
        DataFlowInfo dataFlowInfo4 = result2.getThenInfo();
        DataFlowValue dataFlowValue3 = subject.getDataFlowValue();
        ExpressionTypingInternals expressionTypingInternals2 = this.facade;
        Intrinsics.checkExpressionValueIsNotNull(expressionTypingInternals2, "facade");
        boolean bl = expressionTypingInternals2.getComponents().dataFlowAnalyzer.typeHasEqualsFromAny(subject.getType(), expression2);
        LanguageVersionSettings languageVersionSettings3 = this.components.languageVersionSettings;
        Intrinsics.checkExpressionValueIsNotNull(languageVersionSettings3, "components.languageVersionSettings");
        DataFlowInfo dataFlowInfo5 = dataFlowInfo4.equate(dataFlowValue3, expressionDataFlowValue, bl, languageVersionSettings3);
        DataFlowInfo dataFlowInfo6 = result2.getElseInfo();
        DataFlowValue dataFlowValue4 = subject.getDataFlowValue();
        LanguageVersionSettings languageVersionSettings4 = this.components.languageVersionSettings;
        Intrinsics.checkExpressionValueIsNotNull(languageVersionSettings4, "components.languageVersionSettings");
        return new ConditionalDataFlowInfo(dataFlowInfo5, dataFlowInfo6.disequate(dataFlowValue4, expressionDataFlowValue, languageVersionSettings4));
    }

    private final ConditionalDataFlowInfo checkTypeForIs(ExpressionTypingContext context, KtElement isCheck, boolean negated, KotlinType subjectType, KtTypeReference typeReferenceAfterIs, DataFlowValue subjectDataFlowValue) {
        DataFlowInfo dataFlowInfo;
        ClassDescriptor targetDescriptor;
        TypeResolutionContext typeResolutionContext = new TypeResolutionContext(context.scope, context.trace, true, true, context.isDebuggerContext);
        PossiblyBareType possiblyBareTarget = this.components.typeResolver.resolvePossiblyBareType(typeResolutionContext, typeReferenceAfterIs);
        KotlinType kotlinType = TypeReconstructionUtil.reconstructBareType(typeReferenceAfterIs, possiblyBareTarget, subjectType, context.trace, this.components.builtIns);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeReconstructionUtil.r\u2026onents.builtIns\n        )");
        KotlinType targetType = kotlinType;
        if (DynamicTypesKt.isDynamic(targetType)) {
            context.trace.report(Errors.DYNAMIC_NOT_ALLOWED.on((KtTypeReference)((PsiElement)typeReferenceAfterIs)));
        }
        if ((targetDescriptor = TypeUtils.getClassDescriptor(targetType)) != null && DescriptorUtils.isEnumEntry(targetDescriptor)) {
            context.trace.report(Errors.IS_ENUM_ENTRY.on((KtTypeReference)((PsiElement)typeReferenceAfterIs)));
        }
        if (!TypeUtilsKt.containsError(subjectType) && !TypeUtils.isNullableType(subjectType) && targetType.isMarkedNullable()) {
            KtTypeElement element = typeReferenceAfterIs.getTypeElement();
            boolean bl = element instanceof KtNullableType;
            if (_Assertions.ENABLED && !bl) {
                String string = "element must be instance of " + KtNullableType.class.getName();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            KtTypeElement ktTypeElement = element;
            if (ktTypeElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNullableType");
            }
            context.trace.report(Errors.USELESS_NULLABLE_CHECK.on((KtNullableType)((PsiElement)((KtNullableType)ktTypeElement))));
        }
        this.checkTypeCompatibility(context, targetType, subjectType, typeReferenceAfterIs);
        this.detectRedundantIs(context, subjectType, targetType, isCheck, negated, subjectDataFlowValue);
        KotlinTypeChecker kotlinTypeChecker = KotlinTypeChecker.DEFAULT;
        Intrinsics.checkExpressionValueIsNotNull(kotlinTypeChecker, "KotlinTypeChecker.DEFAULT");
        if (CastDiagnosticsUtil.isCastErased(subjectType, targetType, kotlinTypeChecker)) {
            context.trace.report(Errors.CANNOT_CHECK_FOR_ERASED.on((KtElement)((PsiElement)typeReferenceAfterIs), targetType));
        }
        DataFlowInfo it = dataFlowInfo = context.dataFlowInfo;
        LanguageVersionSettings languageVersionSettings = this.components.languageVersionSettings;
        Intrinsics.checkExpressionValueIsNotNull(languageVersionSettings, "components.languageVersionSettings");
        DataFlowInfo dataFlowInfo2 = it.establishSubtyping(subjectDataFlowValue, targetType, languageVersionSettings);
        DataFlowInfo dataFlowInfo3 = it;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo3, "it");
        return new ConditionalDataFlowInfo(dataFlowInfo2, dataFlowInfo3);
    }

    private final void detectRedundantIs(ExpressionTypingContext context, KotlinType subjectType, KotlinType targetType, KtElement isCheck, boolean negated, DataFlowValue subjectDataFlowValue) {
        if (TypeUtilsKt.containsError(subjectType) || TypeUtilsKt.containsError(targetType)) {
            return;
        }
        Collection<KotlinType> collection = DataFlowAnalyzer.getAllPossibleTypes(subjectType, context, subjectDataFlowValue, context.languageVersionSettings);
        Intrinsics.checkExpressionValueIsNotNull(collection, "DataFlowAnalyzer.getAllP\u2026.languageVersionSettings)");
        Collection<KotlinType> possibleTypes = collection;
        if (CastDiagnosticsUtil.INSTANCE.isRefinementUseless(possibleTypes, targetType, false)) {
            context.trace.report(Errors.USELESS_IS_CHECK.on((KtElement)((PsiElement)isCheck), !negated));
        }
    }

    private final ConditionalDataFlowInfo noChange(ExpressionTypingContext context) {
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
        return new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
    }

    private final void checkTypeCompatibility(ExpressionTypingContext context, KotlinType type2, KotlinType subjectType, KtElement reportErrorOn) {
        if (TypeIntersector.isIntersectionEmpty(type2, subjectType)) {
            context.trace.report(Errors.INCOMPATIBLE_TYPES.on((KtElement)((PsiElement)reportErrorOn), type2, subjectType));
            return;
        }
        if (KotlinBuiltIns.isNullableNothing(type2) && !TypeUtils.isNullableType(subjectType)) {
            context.trace.report(Errors.SENSELESS_NULL_IN_WHEN.on((KtElement)((PsiElement)reportErrorOn)));
        }
    }

    public PatternMatchingTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        Intrinsics.checkParameterIsNotNull(facade, "facade");
        super(facade);
    }

    @NotNull
    public static final /* synthetic */ ConditionalDataFlowInfo access$checkTypeForIs(PatternMatchingTypingVisitor $this, @NotNull ExpressionTypingContext context, @NotNull KtElement isCheck, boolean negated, @NotNull KotlinType subjectType, @NotNull KtTypeReference typeReferenceAfterIs, @NotNull DataFlowValue subjectDataFlowValue) {
        return $this.checkTypeForIs(context, isCheck, negated, subjectType, typeReferenceAfterIs, subjectDataFlowValue);
    }

    @NotNull
    public static final /* synthetic */ ConditionalDataFlowInfo access$checkTypeForExpressionCondition(PatternMatchingTypingVisitor $this, @NotNull ExpressionTypingContext context, @NotNull KtExpression expression2, @NotNull Subject subject) {
        return $this.checkTypeForExpressionCondition(context, expression2, subject);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\"\u0018\u00002\u00020\u0001:\u0003012B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H$J\n\u0010+\u001a\u0004\u0018\u00010#H\u0016J\u0016\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\n\u0010.\u001a\u0004\u0018\u00010/H&R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u0004\u0018\u00010#X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$Subject;", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "typeInfo", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "scopeWithSubject", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/types/KotlinType;)V", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getDataFlowInfo", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "<set-?>", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "dataFlowValue", "getDataFlowValue", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "setDataFlowValue", "(Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;)V", "getElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "jumpOutPossible", "", "getJumpOutPossible", "()Z", "getScopeWithSubject", "()Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getTypeInfo", "()Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "valueExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getValueExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "createDataFlowValue", "contextAfterSubject", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getCalleeExpressionForSpecialCall", "initDataFlowValue", "", "makeValueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "Expression", "None", "Variable", "frontend"})
    private static abstract class Subject {
        @NotNull
        private DataFlowValue dataFlowValue;
        @Nullable
        private final KtElement element;
        @Nullable
        private final KotlinTypeInfo typeInfo;
        @Nullable
        private final LexicalScope scopeWithSubject;
        @NotNull
        private final KotlinType type;

        @NotNull
        protected abstract DataFlowValue createDataFlowValue(@NotNull ExpressionTypingContext var1, @NotNull KotlinBuiltIns var2);

        @Nullable
        public abstract ValueArgument makeValueArgument();

        @Nullable
        public abstract KtExpression getValueExpression();

        @Nullable
        public KtExpression getCalleeExpressionForSpecialCall() {
            return null;
        }

        @NotNull
        public final DataFlowValue getDataFlowValue() {
            DataFlowValue dataFlowValue2 = this.dataFlowValue;
            if (dataFlowValue2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("dataFlowValue");
            }
            return dataFlowValue2;
        }

        public final void initDataFlowValue(@NotNull ExpressionTypingContext contextAfterSubject, @NotNull KotlinBuiltIns builtIns) {
            Intrinsics.checkParameterIsNotNull(contextAfterSubject, "contextAfterSubject");
            Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
            this.dataFlowValue = this.createDataFlowValue(contextAfterSubject, builtIns);
        }

        @Nullable
        public final DataFlowInfo getDataFlowInfo() {
            KotlinTypeInfo kotlinTypeInfo = this.typeInfo;
            return kotlinTypeInfo != null ? kotlinTypeInfo.getDataFlowInfo() : null;
        }

        public final boolean getJumpOutPossible() {
            KotlinTypeInfo kotlinTypeInfo = this.typeInfo;
            return kotlinTypeInfo != null ? kotlinTypeInfo.getJumpOutPossible() : false;
        }

        @Nullable
        public final KtElement getElement() {
            return this.element;
        }

        @Nullable
        public final KotlinTypeInfo getTypeInfo() {
            return this.typeInfo;
        }

        @Nullable
        public final LexicalScope getScopeWithSubject() {
            return this.scopeWithSubject;
        }

        @NotNull
        public final KotlinType getType() {
            return this.type;
        }

        public Subject(@Nullable KtElement element, @Nullable KotlinTypeInfo typeInfo, @Nullable LexicalScope scopeWithSubject, @NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull(type2, "type");
            this.element = element;
            this.typeInfo = typeInfo;
            this.scopeWithSubject = scopeWithSubject;
            this.type = type2;
        }

        public /* synthetic */ Subject(KtElement ktElement, KotlinTypeInfo kotlinTypeInfo, LexicalScope lexicalScope, KotlinType object, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                Object object2 = kotlinTypeInfo;
                if (object2 == null || (object2 = ((KotlinTypeInfo)object2).getType()) == null) {
                    SimpleType simpleType2 = ErrorUtils.createErrorType("Unknown type");
                    Intrinsics.checkExpressionValueIsNotNull(simpleType2, "ErrorUtils.createErrorType(\"Unknown type\")");
                    object2 = simpleType2;
                }
                object = object2;
            }
            this(ktElement, kotlinTypeInfo, lexicalScope, (KotlinType)object);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$Subject$Expression;", "Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$Subject;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "typeInfo", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "valueExpression", "getValueExpression", "createDataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "contextAfterSubject", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "makeValueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "frontend"})
        public static final class Expression
        extends Subject {
            @NotNull
            private final KtExpression expression;
            private final DataFlowValueFactory dataFlowValueFactory;

            @Override
            @NotNull
            protected DataFlowValue createDataFlowValue(@NotNull ExpressionTypingContext contextAfterSubject, @NotNull KotlinBuiltIns builtIns) {
                Intrinsics.checkParameterIsNotNull(contextAfterSubject, "contextAfterSubject");
                Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
                return this.dataFlowValueFactory.createDataFlowValue(this.expression, this.getType(), contextAfterSubject);
            }

            @Override
            @NotNull
            public ValueArgument makeValueArgument() {
                ValueArgument valueArgument = CallMaker.makeExternalValueArgument(this.expression);
                Intrinsics.checkExpressionValueIsNotNull(valueArgument, "CallMaker.makeExternalValueArgument(expression)");
                return valueArgument;
            }

            @Override
            @NotNull
            public KtExpression getValueExpression() {
                return this.expression;
            }

            @NotNull
            public final KtExpression getExpression() {
                return this.expression;
            }

            public Expression(@NotNull KtExpression expression2, @NotNull KotlinTypeInfo typeInfo, @NotNull DataFlowValueFactory dataFlowValueFactory) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(typeInfo, "typeInfo");
                Intrinsics.checkParameterIsNotNull(dataFlowValueFactory, "dataFlowValueFactory");
                super(expression2, typeInfo, null, null, 8, null);
                this.expression = expression2;
                this.dataFlowValueFactory = dataFlowValueFactory;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\n\u0010\u0019\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$Subject$Variable;", "Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$Subject;", "variable", "Lorg/jetbrains/kotlin/psi/KtProperty;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "typeInfo", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "scopeWithSubject", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;)V", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "valueExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getValueExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getVariable", "()Lorg/jetbrains/kotlin/psi/KtProperty;", "createDataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "contextAfterSubject", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getCalleeExpressionForSpecialCall", "makeValueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "frontend"})
        public static final class Variable
        extends Subject {
            @NotNull
            private final KtProperty variable;
            @NotNull
            private final VariableDescriptor descriptor;

            @Override
            @NotNull
            protected DataFlowValue createDataFlowValue(@NotNull ExpressionTypingContext contextAfterSubject, @NotNull KotlinBuiltIns builtIns) {
                Intrinsics.checkParameterIsNotNull(contextAfterSubject, "contextAfterSubject");
                Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
                BindingTrace bindingTrace = contextAfterSubject.trace;
                Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "contextAfterSubject.trace");
                IdentifierInfo identifierInfo = new IdentifierInfo.Variable(this.descriptor, DataFlowValue.Kind.STABLE_VALUE, (DataFlowValue)bindingTrace.getBindingContext().get(BindingContext.BOUND_INITIALIZER_VALUE, this.descriptor));
                KotlinType kotlinType = this.descriptor.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "descriptor.type");
                return new DataFlowValue(identifierInfo, kotlinType, null, 4, null);
            }

            @Override
            @Nullable
            public ValueArgument makeValueArgument() {
                ValueArgument valueArgument;
                KtExpression ktExpression = this.variable.getInitializer();
                if (ktExpression != null) {
                    KtExpression ktExpression2;
                    KtExpression it = ktExpression2 = ktExpression;
                    Project project = this.variable.getProject();
                    Intrinsics.checkExpressionValueIsNotNull(project, "variable.project");
                    KtPsiFactory ktPsiFactory = new KtPsiFactory(project, true);
                    String string = this.variable.getName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    valueArgument = CallMaker.makeExternalValueArgument(ktPsiFactory.createExpression(string), it);
                } else {
                    valueArgument = null;
                }
                return valueArgument;
            }

            @Override
            @Nullable
            public KtExpression getCalleeExpressionForSpecialCall() {
                return this.variable;
            }

            @Override
            @Nullable
            public KtExpression getValueExpression() {
                return this.variable.getInitializer();
            }

            @NotNull
            public final KtProperty getVariable() {
                return this.variable;
            }

            @NotNull
            public final VariableDescriptor getDescriptor() {
                return this.descriptor;
            }

            public Variable(@NotNull KtProperty variable2, @NotNull VariableDescriptor descriptor2, @NotNull KotlinTypeInfo typeInfo, @NotNull LexicalScope scopeWithSubject) {
                Intrinsics.checkParameterIsNotNull(variable2, "variable");
                Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
                Intrinsics.checkParameterIsNotNull(typeInfo, "typeInfo");
                Intrinsics.checkParameterIsNotNull(scopeWithSubject, "scopeWithSubject");
                super(variable2, typeInfo, scopeWithSubject, null, 8, null);
                this.variable = variable2;
                this.descriptor = descriptor2;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$Subject$None;", "Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$Subject;", "()V", "valueExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getValueExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "createDataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "contextAfterSubject", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "makeValueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "frontend"})
        public static final class None
        extends Subject {
            @Override
            @NotNull
            protected DataFlowValue createDataFlowValue(@NotNull ExpressionTypingContext contextAfterSubject, @NotNull KotlinBuiltIns builtIns) {
                Intrinsics.checkParameterIsNotNull(contextAfterSubject, "contextAfterSubject");
                Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
                return DataFlowValue.Companion.nullValue(builtIns);
            }

            @Override
            @Nullable
            public ValueArgument makeValueArgument() {
                return null;
            }

            @Override
            @Nullable
            public KtExpression getValueExpression() {
                return null;
            }

            public None() {
                super(null, null, null, null, 8, null);
            }
        }
    }
}

