/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.PT;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class XcrysdenReader
extends AtomSetCollectionReader {
    private int nAtoms;
    private boolean animation = false;
    private float[] unitCellData = new float[9];
    private int animationStep;

    @Override
    protected void initializeReader() throws Exception {
        this.doApplySymmetry = true;
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.contains("ANIMSTEP")) {
            this.readNostep();
        } else if (this.line.contains("CRYSTAL")) {
            this.setFractionalCoordinates(false);
        } else if (this.line.contains("PRIMVEC")) {
            this.readUnitCell();
        } else if (this.line.contains("PRIMCOORD")) {
            this.readCoordinates();
        }
        return true;
    }

    private void readNostep() throws Exception {
        this.animation = true;
    }

    private void readUnitCell() throws Exception {
        this.setSymmetry();
        this.fillFloatArray(null, 0, this.unitCellData);
        this.setUnitCell();
    }

    private void setUnitCell() {
        this.addExplicitLatticeVector(0, this.unitCellData, 0);
        this.addExplicitLatticeVector(1, this.unitCellData, 3);
        this.addExplicitLatticeVector(2, this.unitCellData, 6);
    }

    private void setSymmetry() throws Exception {
        this.applySymmetryAndSetTrajectory();
        this.asc.newAtomSet();
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(false);
    }

    private void readCoordinates() throws Exception {
        String[] stringArray = PT.getTokens(this.rd());
        this.nAtoms = Integer.parseInt(stringArray[0]);
        this.setFractionalCoordinates(false);
        int n = 0;
        while (n < this.nAtoms && this.rd() != null) {
            String[] stringArray2 = this.getTokens();
            this.addAtomXYZSymName(stringArray2, 1, null, XcrysdenReader.getElementSymbol(Integer.parseInt(stringArray2[0])));
            ++n;
        }
        this.asc.setAtomSetName(this.animation ? "Structure " + this.animationStep++ : "Initial coordinates");
    }
}

