/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesSearch;
import org.jmol.util.Edge;
import org.jmol.util.SimpleNode;

public class SmilesBond
extends Edge {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_AROMATIC = 17;
    public static final int TYPE_RING = 65;
    public static final int TYPE_ANY = 81;
    public static final int TYPE_BIO_SEQUENCE = 96;
    public static final int TYPE_BIO_CROSSLINK = 112;
    private static final String ALL_BONDS = "-=#$:/\\.~^`+!,&;@";
    private static final String SMILES_BONDS = "-=#$:/\\.~^`";
    SmilesAtom atom1;
    SmilesAtom atom2;
    boolean isNot;
    Edge matchingBond;
    private SmilesBond[] primitives;
    int nPrimitives;
    SmilesBond[] bondsOr;
    int nBondsOr;
    boolean isConnection;
    int[] atropType;
    public boolean isChain;

    static String getBondOrderString(int n) {
        switch (n) {
            case 2: {
                return "=";
            }
            case 3: {
                return "#";
            }
            case 4: {
                return "$";
            }
        }
        return "";
    }

    static int getBondTypeFromCode(char c) {
        switch (c) {
            case '.': {
                return 0;
            }
            case '-': {
                return 1;
            }
            case '=': {
                return 2;
            }
            case '#': {
                return 3;
            }
            case '$': {
                return 4;
            }
            case ':': {
                return 17;
            }
            case '/': {
                return 1025;
            }
            case '\\': {
                return 1041;
            }
            case '^': {
                return 65537;
            }
            case '`': {
                return 65538;
            }
            case '@': {
                return 65;
            }
            case '~': {
                return 81;
            }
            case '+': {
                return 96;
            }
        }
        return -1;
    }

    public SmilesAtom getAtom1() {
        return this.atom1;
    }

    void set(SmilesBond smilesBond) {
        this.order = smilesBond.order;
        this.isNot = smilesBond.isNot;
        this.primitives = smilesBond.primitives;
        this.nPrimitives = smilesBond.nPrimitives;
        this.bondsOr = smilesBond.bondsOr;
        this.nBondsOr = smilesBond.nBondsOr;
    }

    void setAtropType(int n) {
        this.atropType = new int[]{n / 10 - 1, n % 10 - 1};
    }

    public SmilesBond setPrimitive(int n) {
        SmilesBond smilesBond = this.primitives[n];
        this.order = smilesBond.order;
        this.isNot = smilesBond.isNot;
        this.atropType = smilesBond.atropType;
        return smilesBond;
    }

    SmilesBond addBondOr() {
        Object object;
        if (this.bondsOr == null) {
            this.bondsOr = new SmilesBond[2];
        }
        if (this.nBondsOr >= this.bondsOr.length) {
            object = new SmilesBond[this.bondsOr.length * 2];
            System.arraycopy(this.bondsOr, 0, object, 0, this.bondsOr.length);
            this.bondsOr = object;
        }
        this.bondsOr[this.nBondsOr] = object = new SmilesBond(null, null, -1, false);
        ++this.nBondsOr;
        return object;
    }

    SmilesBond addPrimitive() {
        Object object;
        if (this.primitives == null) {
            this.primitives = new SmilesBond[2];
        }
        if (this.nPrimitives >= this.primitives.length) {
            object = new SmilesBond[this.primitives.length * 2];
            System.arraycopy(this.primitives, 0, object, 0, this.primitives.length);
            this.primitives = object;
        }
        this.primitives[this.nPrimitives] = object = new SmilesBond(null, null, -1, false);
        ++this.nPrimitives;
        return object;
    }

    public String toString() {
        return this.atom1 + " -" + (this.isNot ? "!" : "") + this.order + "- " + this.atom2;
    }

    SmilesBond(SmilesAtom smilesAtom, SmilesAtom smilesAtom2, int n, boolean bl) {
        this.set2(n, bl);
        this.set2a(smilesAtom, smilesAtom2);
    }

    void set2(int n, boolean bl) {
        this.order = n;
        this.isNot = bl;
    }

    void set2a(SmilesAtom smilesAtom, SmilesAtom smilesAtom2) {
        if (smilesAtom != null) {
            this.atom1 = smilesAtom;
            smilesAtom.addBond(this);
        }
        if (smilesAtom2 != null) {
            this.atom2 = smilesAtom2;
            if (smilesAtom2.isBioAtomWild && this.atom1.isBioAtomWild) {
                this.order = 96;
            }
            smilesAtom2.isFirst = false;
            smilesAtom2.addBond(this);
        }
    }

    void setAtom2(SmilesAtom smilesAtom, SmilesSearch smilesSearch) {
        this.atom2 = smilesAtom;
        if (this.atom2 != null) {
            smilesAtom.addBond(this);
            this.isConnection = true;
        }
    }

    boolean isFromPreviousTo(SmilesAtom smilesAtom) {
        return !this.isConnection && this.atom2 == smilesAtom;
    }

    static int isBondType(char c, boolean bl, boolean bl2) throws InvalidSmilesException {
        if (c == '>') {
            return 1;
        }
        if (ALL_BONDS.indexOf(c) < 0) {
            return 0;
        }
        if (!bl && SMILES_BONDS.indexOf(c) < 0) {
            throw new InvalidSmilesException("SMARTS bond type " + c + " not allowed in SMILES");
        }
        switch (c) {
            case '~': {
                return bl2 ? 0 : 1;
            }
            case '^': 
            case '`': {
                return -1;
            }
        }
        return 1;
    }

    int getBondType() {
        return this.order;
    }

    int getValence() {
        return this.order & 7;
    }

    SmilesAtom getOtherAtom(SmilesAtom smilesAtom) {
        return this.atom1 == smilesAtom ? this.atom2 : this.atom1;
    }

    @Override
    public int getAtomIndex1() {
        return this.atom1.index;
    }

    @Override
    public int getAtomIndex2() {
        return this.atom2.index;
    }

    @Override
    public int getCovalentOrder() {
        return this.order;
    }

    @Override
    public SimpleNode getOtherNode(SimpleNode simpleNode) {
        return simpleNode == this.atom1 ? this.atom2 : (simpleNode == this.atom2 || simpleNode == null ? this.atom1 : null);
    }

    @Override
    public boolean isCovalent() {
        return this.order != 112;
    }

    @Override
    public boolean isHydrogen() {
        return this.order == 112;
    }

    void switchAtoms() {
        SmilesAtom smilesAtom = this.atom1;
        this.atom1 = this.atom2;
        this.atom2 = smilesAtom;
        switch (this.order) {
            case 65537: {
                this.order = 65538;
                break;
            }
            case 65538: {
                this.order = 65537;
                break;
            }
            case 1025: {
                this.order = 1041;
                break;
            }
            case 1041: {
                this.order = 1025;
            }
        }
    }

    public int getRealCovalentOrder() {
        switch (this.order) {
            case 1025: 
            case 1041: 
            case 65537: 
            case 65538: {
                return 1;
            }
        }
        return this.order;
    }

    public Edge getMatchingBond() {
        return this.matchingBond == null ? this : this.matchingBond;
    }
}

