/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import javajs.util.A4;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.thread.JmolThread;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class MoveToThread
extends JmolThread {
    private boolean isMove;
    private final V3 aaStepCenter = new V3();
    private final V3 aaStepNavCenter = new V3();
    private final A4 aaStep = new A4();
    private final A4 aaTotal = new A4();
    private final M3 matrixStart = new M3();
    private final M3 matrixStartInv = new M3();
    private M3 matrixStep = new M3();
    private final M3 matrixEnd = new M3();
    private P3 center;
    private P3 navCenter;
    private P3 ptMoveToCenter;
    private Slider zoom;
    private Slider xTrans;
    private Slider yTrans;
    private Slider xNav;
    private Slider yNav;
    private Slider navDepth;
    private Slider cameraDepth;
    private Slider cameraX;
    private Slider cameraY;
    private Slider rotationRadius;
    private Slider pixelScale;
    private int fps;
    private long frameTimeMillis;
    private boolean doEndMove;
    private float fStep;
    private TransformManager transformManager;
    private float floatSecondsTotal;
    private int totalSteps;
    private int iStep;
    private int timePerStep;
    private float radiansXStep;
    private float radiansYStep;
    private float radiansZStep;
    private V3 dRot;
    private V3 dTrans;
    private float dZoom;
    private float dSlab;
    private float zoomPercent0;
    private int slab;
    private float transX;
    private float transY;

    @Override
    public int setManager(Object object, Viewer viewer, Object object2) {
        Object[] objectArray = (Object[])object2;
        this.isMove = objectArray[0] instanceof V3;
        this.setViewer(viewer, this.isMove ? "moveThread" : "MoveToThread");
        this.transformManager = (TransformManager)object;
        return this.isMove ? this.setManagerMove(objectArray) : this.setManagerMoveTo(objectArray);
    }

    @Override
    protected void run1(int n) throws InterruptedException {
        if (this.isMove) {
            this.run1Move(n);
        } else {
            this.run1MoveTo(n);
        }
    }

    @Override
    public void interrupt() {
        this.doEndMove = false;
        super.interrupt();
    }

    private int setManagerMove(Object[] objectArray) {
        this.dRot = (V3)objectArray[0];
        this.dTrans = (V3)objectArray[1];
        float[] fArray = (float[])objectArray[2];
        this.dZoom = fArray[0];
        this.dSlab = fArray[1];
        this.floatSecondsTotal = fArray[2];
        int n = (int)fArray[3];
        this.slab = this.transformManager.getSlabPercentSetting();
        this.transX = this.transformManager.getTranslationXPercent();
        this.transY = this.transformManager.getTranslationYPercent();
        this.timePerStep = 1000 / n;
        this.totalSteps = (int)((float)n * this.floatSecondsTotal);
        if (this.totalSteps <= 0) {
            this.totalSteps = 1;
        }
        float f = (float)(Math.PI / 180 / (double)this.totalSteps);
        this.radiansXStep = f * this.dRot.x;
        this.radiansYStep = f * this.dRot.y;
        this.radiansZStep = f * this.dRot.z;
        this.zoomPercent0 = this.transformManager.zmPct;
        this.iStep = 0;
        return this.totalSteps;
    }

    private int setManagerMoveTo(Object[] objectArray) {
        this.center = (P3)objectArray[0];
        this.matrixEnd.setM3((M3)objectArray[1]);
        float[] fArray = (float[])objectArray[3];
        this.ptMoveToCenter = this.center == null ? this.transformManager.fixedRotationCenter : this.center;
        this.floatSecondsTotal = fArray[0];
        this.zoom = this.newSlider(this.transformManager.zmPct, fArray[1]);
        this.xTrans = this.newSlider(this.transformManager.getTranslationXPercent(), fArray[2]);
        this.yTrans = this.newSlider(this.transformManager.getTranslationYPercent(), fArray[3]);
        this.rotationRadius = this.newSlider(this.transformManager.modelRadius, this.center == null || Float.isNaN(fArray[4]) ? this.transformManager.modelRadius : (fArray[4] <= 0.0f ? this.vwr.ms.calcRotationRadius(this.vwr.am.cmi, this.center, false) : fArray[4]));
        this.pixelScale = this.newSlider(this.transformManager.scaleDefaultPixelsPerAngstrom, fArray[5]);
        if (fArray[6] != 0.0f) {
            this.navCenter = (P3)objectArray[2];
            this.navDepth = this.newSlider(this.transformManager.navigationDepthPercent, fArray[6]);
            this.xNav = this.newSlider(this.transformManager.getNavigationOffsetPercent('X'), fArray[7]);
            this.yNav = this.newSlider(this.transformManager.getNavigationOffsetPercent('Y'), fArray[8]);
        }
        this.cameraDepth = this.newSlider(this.transformManager.getCameraDepth(), fArray[9]);
        this.cameraX = this.newSlider(this.transformManager.camera.x, fArray[10]);
        this.cameraY = this.newSlider(this.transformManager.camera.y, fArray[11]);
        this.transformManager.getRotation(this.matrixStart);
        this.matrixStartInv.invertM(this.matrixStart);
        this.matrixStep.mul2(this.matrixEnd, this.matrixStartInv);
        this.aaTotal.setM(this.matrixStep);
        this.fps = 30;
        this.totalSteps = (int)(this.floatSecondsTotal * (float)this.fps);
        this.frameTimeMillis = 1000 / this.fps;
        this.targetTime = System.currentTimeMillis();
        this.aaStepCenter.sub2(this.ptMoveToCenter, this.transformManager.fixedRotationCenter);
        this.aaStepCenter.scale(1.0f / (float)this.totalSteps);
        if (this.navCenter != null && this.transformManager.mode == 1) {
            this.aaStepNavCenter.sub2(this.navCenter, this.transformManager.navigationCenter);
            this.aaStepNavCenter.scale(1.0f / (float)this.totalSteps);
        }
        this.iStep = 0;
        return this.totalSteps;
    }

    private Slider newSlider(float f, float f2) {
        return Float.isNaN(f2) || f2 == Float.MAX_VALUE ? null : new Slider(f, f2);
    }

    private void run1Move(int n) throws InterruptedException {
        block5: while (true) {
            switch (n) {
                case -1: {
                    if (this.floatSecondsTotal > 0.0f) {
                        this.vwr.setInMotion(true);
                    }
                    n = 0;
                    continue block5;
                }
                case 0: {
                    int n2;
                    if (this.stopped || this.iStep >= this.totalSteps) {
                        n = -2;
                        continue block5;
                    }
                    ++this.iStep;
                    if (this.dRot.x != 0.0f) {
                        this.transformManager.rotateXRadians(this.radiansXStep, null);
                    }
                    if (this.dRot.y != 0.0f) {
                        this.transformManager.rotateYRadians(this.radiansYStep, null);
                    }
                    if (this.dRot.z != 0.0f) {
                        this.transformManager.rotateZRadians(this.radiansZStep);
                    }
                    if (this.dZoom != 0.0f) {
                        this.transformManager.zoomToPercent(this.zoomPercent0 + this.dZoom * (float)this.iStep / (float)this.totalSteps);
                    }
                    if (this.dTrans.x != 0.0f) {
                        this.transformManager.translateToPercent('x', this.transX + this.dTrans.x * (float)this.iStep / (float)this.totalSteps);
                    }
                    if (this.dTrans.y != 0.0f) {
                        this.transformManager.translateToPercent('y', this.transY + this.dTrans.y * (float)this.iStep / (float)this.totalSteps);
                    }
                    if (this.dTrans.z != 0.0f) {
                        this.transformManager.translateToPercent('z', this.dTrans.z * (float)this.iStep / (float)this.totalSteps);
                    }
                    if (this.dSlab != 0.0f) {
                        this.transformManager.slabToPercent((int)Math.floor((float)this.slab + this.dSlab * (float)this.iStep / (float)this.totalSteps));
                    }
                    if (this.iStep == this.totalSteps) {
                        n = -2;
                        continue block5;
                    }
                    int n3 = (int)(System.currentTimeMillis() - this.startTime);
                    if (n3 >= (n2 = this.iStep * this.timePerStep)) continue block5;
                    this.vwr.requestRepaintAndWait("moveThread");
                    if (!this.isJS && !this.vwr.isScriptExecuting()) {
                        n = -2;
                        continue block5;
                    }
                    n3 = (int)(System.currentTimeMillis() - this.startTime);
                    this.sleepTime = n2 - n3;
                    if (this.runSleep(this.sleepTime, 0)) continue block5;
                    return;
                }
                case -2: {
                    if (this.floatSecondsTotal > 0.0f) {
                        this.vwr.setInMotion(false);
                    }
                    this.resumeEval();
                    return;
                }
            }
        }
    }

    private void run1MoveTo(int n) throws InterruptedException {
        block5: while (true) {
            switch (n) {
                case -1: {
                    if (this.totalSteps > 0) {
                        this.vwr.setInMotion(true);
                    }
                    n = 0;
                    continue block5;
                }
                case 0: {
                    boolean bl;
                    if (this.stopped || ++this.iStep >= this.totalSteps) {
                        n = -2;
                        continue block5;
                    }
                    this.doStepTransform();
                    this.doEndMove = true;
                    this.targetTime += this.frameTimeMillis;
                    this.currentTime = System.currentTimeMillis();
                    boolean bl2 = bl = this.currentTime < this.targetTime;
                    if (!bl && this.isJS) {
                        this.targetTime = this.currentTime;
                        bl = true;
                    }
                    if (bl) {
                        this.vwr.requestRepaintAndWait("movetoThread");
                    }
                    if (this.transformManager.movetoThread == null || !this.transformManager.movetoThread.name.equals(this.name) || !this.isJS && this.eval != null && !this.vwr.isScriptExecuting()) {
                        this.stopped = true;
                        continue block5;
                    }
                    this.currentTime = System.currentTimeMillis();
                    int n2 = (int)(this.targetTime - this.currentTime);
                    if (!this.runSleep(n2, 0)) {
                        return;
                    }
                    n = 0;
                    continue block5;
                }
                case -2: {
                    if (this.totalSteps <= 0 || this.doEndMove && !this.stopped) {
                        this.doFinalTransform();
                    }
                    if (this.totalSteps > 0) {
                        this.vwr.setInMotion(false);
                    }
                    this.vwr.moveUpdate(this.floatSecondsTotal);
                    if (this.transformManager.movetoThread != null && !this.stopped) {
                        this.transformManager.movetoThread = null;
                        this.vwr.finalizeTransformParameters();
                    }
                    this.resumeEval();
                    return;
                }
            }
        }
    }

    private void doStepTransform() {
        if (!Float.isNaN(this.matrixEnd.m00)) {
            this.transformManager.getRotation(this.matrixStart);
            this.matrixStartInv.invertM(this.matrixStart);
            this.matrixStep.mul2(this.matrixEnd, this.matrixStartInv);
            this.aaTotal.setM(this.matrixStep);
            this.aaStep.setAA(this.aaTotal);
            this.aaStep.angle /= (float)(this.totalSteps - this.iStep);
            if (this.aaStep.angle == 0.0f) {
                this.matrixStep.setScale(1.0f);
            } else {
                this.matrixStep.setAA(this.aaStep);
            }
            this.matrixStep.mul(this.matrixStart);
        }
        this.fStep = (float)this.iStep / ((float)this.totalSteps - 1.0f);
        if (this.center != null) {
            this.transformManager.fixedRotationCenter.add(this.aaStepCenter);
        }
        if (this.navCenter != null && this.transformManager.mode == 1) {
            P3 p3 = P3.newP(this.transformManager.navigationCenter);
            p3.add(this.aaStepNavCenter);
            this.transformManager.setNavigatePt(p3);
        }
        this.setValues(this.matrixStep, null, null);
    }

    private void doFinalTransform() {
        this.fStep = -1.0f;
        this.setValues(this.matrixEnd, this.center, this.navCenter);
    }

    private void setValues(M3 m3, P3 p3, P3 p32) {
        this.transformManager.setAll(p3, m3, p32, this.getVal(this.zoom), this.getVal(this.xTrans), this.getVal(this.yTrans), this.getVal(this.rotationRadius), this.getVal(this.pixelScale), this.getVal(this.navDepth), this.getVal(this.xNav), this.getVal(this.yNav), this.getVal(this.cameraDepth), this.getVal(this.cameraX), this.getVal(this.cameraY));
    }

    private float getVal(Slider slider) {
        return slider == null ? Float.NaN : slider.getVal(this.fStep);
    }

    private class Slider {
        float start;
        float delta;
        float value;

        Slider(float f, float f2) {
            this.start = f;
            this.value = f2;
            this.delta = f2 - f;
        }

        float getVal(float f) {
            return f < 0.0f ? this.value : this.start + f * this.delta;
        }
    }
}

