/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.clean.ReferenceTracker;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00142\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u0010J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u001c\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u001c\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u001f2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u0012\u0010 \u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/UnusedLocalFunctionsCollector;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "functions", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "(Ljava/util/Map;)V", "processed", "", "removableFunctions", "", "getRemovableFunctions", "()Ljava/util/List;", "tracker", "Lorg/jetbrains/kotlin/js/inline/clean/ReferenceTracker;", "endVisit", "", "x", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "isFunctionReference", "", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/HasName;", "process", "processLocalFunction", "name", "function", "processNonLocalFunction", "visit", "Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer;", "wasProcessed", "js.translator"})
final class UnusedLocalFunctionsCollector
extends JsVisitorWithContextImpl {
    private final ReferenceTracker<JsName, JsFunction> tracker;
    private final Set<JsFunction> processed;
    private final Map<JsName, JsFunction> functions;

    @NotNull
    public final List<JsFunction> getRemovableFunctions() {
        return this.tracker.getRemovable();
    }

    /*
     * WARNING - void declaration
     */
    public final void process() {
        void $receiver$iv$iv;
        Map entry = this.functions;
        Object object = entry;
        Map<JsName, JsFunction> destination$iv$iv = new LinkedHashMap();
        void var4_7 = $receiver$iv$iv;
        for (Map.Entry element$iv$iv : var4_7.entrySet()) {
            Map.Entry it = element$iv$iv;
            if (!MetadataProperties.isLocal((JsFunction)it.getValue())) continue;
            destination$iv$iv.put((JsName)element$iv$iv.getKey(), (JsFunction)element$iv$iv.getValue());
        }
        Map map2 = destination$iv$iv;
        object = map2;
        destination$iv$iv = object.entrySet().iterator();
        while (destination$iv$iv.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = (Map.Entry)destination$iv$iv.next();
            this.tracker.addCandidateForRemoval((JsName)it.getKey(), (JsFunction)((JsNode)it.getValue()));
        }
        destination$iv$iv = this.functions;
        for (Map.Entry entry2 : destination$iv$iv.entrySet()) {
            Object object2 = entry2;
            JsName name = (JsName)object2.getKey();
            object2 = entry2;
            JsFunction function2 = (JsFunction)object2.getValue();
            if (MetadataProperties.isLocal(function2)) {
                this.processLocalFunction(name, function2);
            } else {
                this.processNonLocalFunction(function2);
            }
            this.processed.add(function2);
        }
    }

    public boolean visit(@NotNull JsPropertyInitializer x, @NotNull JsContext<?> ctx) {
        JsExpression value;
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        JsExpression jsExpression = x.getValueExpr();
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "x.valueExpr");
        JsExpression jsExpression2 = value = jsExpression;
        return jsExpression2 instanceof JsFunction ? !this.wasProcessed((JsFunction)value) : super.visit(x, ctx);
    }

    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        return !this.wasProcessed(x);
    }

    public void endVisit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        this.processed.add(x);
    }

    public void endVisit(@NotNull JsNameRef x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        JsName name = x.getName();
        if (this.isFunctionReference(x) && name != null) {
            this.tracker.markReachable(name);
        }
    }

    private final void processLocalFunction(JsName name, JsFunction function2) {
        for (JsName referenced : CollectUtilsKt.collectReferencedNames(function2)) {
            this.tracker.addRemovableReference(name, referenced);
        }
    }

    private final void processNonLocalFunction(JsFunction function2) {
        for (JsName referenced : CollectUtilsKt.collectReferencedNames(function2)) {
            this.tracker.markReachable(referenced);
        }
    }

    private final boolean isFunctionReference(HasName nameRef) {
        Object object = nameRef;
        return (object != null && (object = object.getName()) != null ? MetadataProperties.getStaticRef((JsName)object) : null) instanceof JsFunction;
    }

    private final boolean wasProcessed(JsFunction function2) {
        return function2 != null && this.processed.contains(function2);
    }

    public UnusedLocalFunctionsCollector(@NotNull Map<JsName, JsFunction> functions2) {
        Intrinsics.checkParameterIsNotNull(functions2, "functions");
        this.functions = functions2;
        this.tracker = new ReferenceTracker();
        this.processed = CollectionUtilsKt.IdentitySet();
    }
}

