# Visualization Toolkit (VTK) Tcl package configuration.

package ifneeded vtkinit {8.1} {
  namespace eval ::vtk::init {
    proc load_library_package {libName libPath {libPrefix {lib}}} {
      #first try to load a static package, then try the shared package.
      if {[catch "load {} $libName"]} {
        set libExt [info sharedlibextension]
        set currentDirectory [pwd]
        set libFile [file join $libPath "$libPrefix$libName-8.1$libExt"]
        if {[catch "cd {$libPath}; load {$libFile}" errorMessage]} {
          puts $errorMessage
        }
        cd $currentDirectory
      }
    }
    proc require_package {name {version {8.1}}} {
      if {[catch "package require -exact $name $version" errorMessage]} {
        puts $errorMessage
        return 0
      } else {
        return 1
      }
    }
    set version {8.1}
    set kits {}
    foreach kit { base  CommonCore CommonMath CommonMisc CommonSystem CommonTransforms CommonDataModel CommonColor CommonExecutionModel CommonComputationalGeometry FiltersCore FiltersGeneral ImagingCore ImagingFourier FiltersStatistics FiltersExtraction InfovisCore FiltersGeometry FiltersSources RenderingCore RenderingFreeType RenderingContextIID ChartsCore IOCore IOLegacy IOXMLParser IOXML IOInfovis RenderingOpenGLII RenderingContextOpenGLII IOImage TestingRendering ImagingSources FiltersHybrid FiltersModeling ImagingColor ImagingGeneral ImagingHybrid InteractionStyle RenderingAnnotation RenderingVolume InteractionWidgets ViewsCore ViewsContextIID FiltersGeneric IOGeometry DomainsChemistry RenderingChemistryOpenGLII ParallelCore FiltersAMR IOAMR IOExodus ImagingMath RenderingVolumeOpenGLII FiltersFlowPaths FiltersImaging RenderingLabel FiltersHyperTree ImagingStencil FiltersParallel FiltersParallelImaging ParallelMPI FiltersParallelMPI RenderingParallel FiltersParallelDIYII FiltersParallelFlowPaths IONetCDF IOParallel FiltersParallelGeometry IOParallelXML FiltersParallelStatistics FiltersVerdict FiltersParallelVerdict FiltersPoints FiltersProgrammable FiltersReebGraph FiltersSMP FiltersSelection FiltersTexture FiltersTopology IOSQL InfovisLayout GeovisCore ViewsInfovis ViewsGeovis IOEnSight RenderingGLtoPSOpenGLII IOExport IOExportOpenGLII InteractionImage IOMovie IOFFMPEG IOGDAL IOGeoJSON IOImport IOLSDyna IOMINC IOMPIImage IOMPIParallel IOMySQL IOODBC IOPLY IOParallelExodus IOParallelLSDyna IOParallelNetCDF IOXdmfIII IOParallelXdmfIII IOPostgreSQL IOSegY IOTRUCHAS IOTecplotTable IOVPIC IOVideo IOXdmfII ImagingStatistics RenderingImage ImagingMorphological InfovisBoostGraphAlgorithms RenderingLOD PythonInterpreter RenderingLICOpenGLII RenderingMatplotlib RenderingParallelLIC RenderingQt RenderingSceneGraph RenderingTk RenderingVolumeAMR } {
      lappend kits [string tolower "${kit}"]
    }
  }
  package provide vtkinit {8.1}
}

foreach kit {  CommonCore CommonMath CommonMisc CommonSystem CommonTransforms CommonDataModel CommonColor CommonExecutionModel CommonComputationalGeometry FiltersCore FiltersGeneral ImagingCore ImagingFourier FiltersStatistics FiltersExtraction InfovisCore FiltersGeometry FiltersSources RenderingCore RenderingFreeType RenderingContextIID ChartsCore IOCore IOLegacy IOXMLParser IOXML IOInfovis RenderingOpenGLII RenderingContextOpenGLII IOImage TestingRendering ImagingSources FiltersHybrid FiltersModeling ImagingColor ImagingGeneral ImagingHybrid InteractionStyle RenderingAnnotation RenderingVolume InteractionWidgets ViewsCore ViewsContextIID FiltersGeneric IOGeometry DomainsChemistry RenderingChemistryOpenGLII ParallelCore FiltersAMR IOAMR IOExodus ImagingMath RenderingVolumeOpenGLII FiltersFlowPaths FiltersImaging RenderingLabel FiltersHyperTree ImagingStencil FiltersParallel FiltersParallelImaging ParallelMPI FiltersParallelMPI RenderingParallel FiltersParallelDIYII FiltersParallelFlowPaths IONetCDF IOParallel FiltersParallelGeometry IOParallelXML FiltersParallelStatistics FiltersVerdict FiltersParallelVerdict FiltersPoints FiltersProgrammable FiltersReebGraph FiltersSMP FiltersSelection FiltersTexture FiltersTopology IOSQL InfovisLayout GeovisCore ViewsInfovis ViewsGeovis IOEnSight RenderingGLtoPSOpenGLII IOExport IOExportOpenGLII InteractionImage IOMovie IOFFMPEG IOGDAL IOGeoJSON IOImport IOLSDyna IOMINC IOMPIImage IOMPIParallel IOMySQL IOODBC IOPLY IOParallelExodus IOParallelLSDyna IOParallelNetCDF IOXdmfIII IOParallelXdmfIII IOPostgreSQL IOSegY IOTRUCHAS IOTecplotTable IOVPIC IOVideo IOXdmfII ImagingStatistics RenderingImage ImagingMorphological InfovisBoostGraphAlgorithms RenderingLOD PythonInterpreter RenderingLICOpenGLII RenderingMatplotlib RenderingParallelLIC RenderingQt RenderingSceneGraph RenderingTk RenderingVolumeAMR } {
  package ifneeded "vtk${kit}TCL" {8.1} "
    package require -exact vtkinit {8.1}
    ::vtk::init::load_library_package {vtk${kit}TCL} {[file dirname [file dirname [file dirname [info script]]]]}
  "
  package ifneeded "vtk[string tolower ${kit}]" {8.1} "
    package require -exact vtkinit {8.1}
    if {\[catch {source \[file join {[file dirname [info script]]} {vtk[string tolower ${kit}]} {vtk[string tolower ${kit}].tcl}\]} errorMessage\]} {
      puts \$errorMessage
    }
  "
}

foreach src {vtk vtkbase vtkinteraction vtktesting} {
  package ifneeded ${src} {8.1} "
    package require -exact vtkinit {8.1}
    if {\[catch {source \[file join {[file dirname [info script]]} {$src} {$src.tcl}\]} errorMessage\]} {
      puts \$errorMessage
    }
  "
}
