/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.lib.profiler.ui.UIUtils;

public class HTMLLabel
extends JEditorPane
implements HyperlinkListener {
    private int halign = 10;
    private String txt;

    public HTMLLabel() {
        this((String)null);
    }

    public HTMLLabel(String string) {
        this.setEditorKit(new HTMLEditorKit());
        this.setEditable(false);
        this.setOpaque(false);
        this.setNavigationFilter(new NavigationFilter(){

            @Override
            public void moveDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
                super.moveDot(filterBypass, 0, bias);
            }

            @Override
            public void setDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
                super.setDot(filterBypass, 0, bias);
            }

            @Override
            public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
                return 0;
            }
        });
        this.setFont(UIManager.getFont("Label.font"));
        this.addHyperlinkListener(this);
        if (string != null) {
            this.setText(string);
        }
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (UIUtils.isNimbusLookAndFeel() && !bl) {
            this.setBackground(new Color(0, 0, 0, 0));
        }
        if (this.txt != null) {
            this.setText(this.txt);
        }
    }

    @Override
    public void setText(String string) {
        this.txt = string;
        Font font = this.getFont();
        Color color = this.getForeground();
        Color color2 = this.getBackground();
        string = string.replaceAll("\\n\\r|\\r\\n|\\n|\\r", "<br>");
        string = string.replace("<code>", "<code style=\"font-size: " + font.getSize() + "pt;\">");
        String string2 = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        String string3 = this.isOpaque() ? "rgb(" + color2.getRed() + "," + color2.getGreen() + "," + color2.getBlue() + ")" : null;
        String string4 = null;
        switch (this.halign) {
            case 0: {
                string4 = "center";
                break;
            }
            case 4: 
            case 11: {
                string4 = "right";
            }
        }
        String string5 = "text=\"" + string2 + "\"";
        if (string3 != null) {
            string5 = string5 + " bgcolor=\"" + string3 + "\"";
        }
        if (string4 != null) {
            string5 = string5 + " align=\"" + string4 + "\"";
        }
        super.setText("<html><body " + string5 + " style=\"font-size: " + font.getSize() + "pt; font-family: " + font.getName() + ";\">" + string + "</body></html>");
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.txt != null) {
            this.setText(this.txt);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.txt != null) {
            this.setText(this.txt);
        }
    }

    public void setHorizontalAlignment(int n) {
        if (n == this.halign) {
            return;
        }
        this.halign = n;
        if (this.txt != null) {
            this.setText(this.txt);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.showURL(hyperlinkEvent.getURL());
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void showURL(URL uRL) {
    }
}

