/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.utils;

import com.github.cereda.arara.Arara;
import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.FileType;
import com.github.cereda.arara.model.FileTypeResource;
import com.github.cereda.arara.model.Messages;
import com.github.cereda.arara.model.Resource;
import com.github.cereda.arara.utils.CommonUtils;
import java.io.File;
import java.io.FileReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang.SystemUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationUtils {
    private static final LanguageController messages = LanguageController.getInstance();

    public static List<FileType> getDefaultFileTypes() throws AraraException {
        return Arrays.asList(new FileType("tex"), new FileType("dtx"), new FileType("ltx"), new FileType("drv"), new FileType("ins"));
    }

    public static File getConfigFile() {
        File file;
        String path;
        List<String> names = Arrays.asList(".araraconfig.yaml", "araraconfig.yaml", ".arararc.yaml", "arararc.yaml");
        for (String name : names) {
            path = CommonUtils.buildPath(SystemUtils.USER_DIR, name);
            file = new File(path);
            if (!file.exists()) continue;
            return file;
        }
        for (String name : names) {
            path = CommonUtils.buildPath(SystemUtils.USER_HOME, name);
            file = new File(path);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public static Resource validateConfiguration(File file) throws AraraException {
        Representer representer = new Representer();
        representer.addClassTag(Resource.class, new Tag("!config"));
        Yaml yaml = new Yaml(new Constructor(Resource.class), representer);
        try {
            List<FileTypeResource> filetypes;
            Resource resource = yaml.loadAs(new FileReader(file), Resource.class);
            if (resource.getFiletypes() != null && CollectionUtils.exists(filetypes = resource.getFiletypes(), new Predicate<FileTypeResource>(){

                @Override
                public boolean evaluate(FileTypeResource filetype) {
                    return filetype.getExtension() == null;
                }
            })) {
                throw new AraraException(messages.getMessage(Messages.ERROR_CONFIGURATION_FILETYPE_MISSING_EXTENSION));
            }
            return resource;
        }
        catch (MarkedYAMLException yamlException) {
            throw new AraraException(messages.getMessage(Messages.ERROR_CONFIGURATION_INVALID_YAML), yamlException);
        }
        catch (Exception exception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_CONFIGURATION_GENERIC_ERROR));
        }
    }

    public static List<String> normalizePaths(List<String> paths) throws AraraException {
        paths.add(CommonUtils.buildPath(ConfigurationUtils.getApplicationPath(), "rules"));
        LinkedHashSet<String> set = new LinkedHashSet<String>(paths);
        ArrayList<String> result = new ArrayList<String>(set);
        return result;
    }

    public static List<FileType> normalizeFileTypes(List<FileType> types) throws AraraException {
        types.addAll(ConfigurationUtils.getDefaultFileTypes());
        LinkedHashSet<FileType> set = new LinkedHashSet<FileType>(types);
        ArrayList<FileType> result = new ArrayList<FileType>(set);
        return result;
    }

    public static String getApplicationPath() throws AraraException {
        try {
            String path = Arara.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            path = URLDecoder.decode(path, "UTF-8");
            path = new File(path).getParentFile().getPath();
            return path;
        }
        catch (UnsupportedEncodingException exception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_GETAPPLICATIONPATH_ENCODING_EXCEPTION), exception);
        }
    }

    public static String cleanFileName(String name) {
        String result = new File(name).getName().trim();
        if (CommonUtils.checkEmptyString(result)) {
            return "arara";
        }
        return result.trim();
    }
}

