/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.gnome;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.network.proxy.NetworkProxyResolver;
import org.netbeans.core.network.proxy.NetworkProxySettings;
import org.netbeans.core.network.proxy.gnome.GconfNetworkProxy;
import org.netbeans.core.network.proxy.gnome.GsettingsNetworkProxy;

public class GnomeNetworkProxy
implements NetworkProxyResolver {
    private static final Logger LOGGER = Logger.getLogger(GnomeNetworkProxy.class.getName());

    @Override
    public NetworkProxySettings getNetworkProxySettings() {
        if (new File("/usr/bin/gsettings").exists() && GsettingsNetworkProxy.isGsettingsValid()) {
            return GsettingsNetworkProxy.getNetworkProxySettings();
        }
        if (new File("/usr/bin/gconftool-2").exists() && GconfNetworkProxy.isGconfValid()) {
            return GconfNetworkProxy.getNetworkProxySettings();
        }
        return new NetworkProxySettings(false);
    }

    protected static BufferedReader executeCommand(String string) {
        BufferedReader bufferedReader = null;
        try {
            Process process = Runtime.getRuntime().exec(string);
            process.waitFor();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Cannot execute command: " + string, iOException);
        }
        catch (InterruptedException interruptedException) {
            LOGGER.log(Level.SEVERE, "Cannot execute command: " + string, interruptedException);
        }
        return bufferedReader;
    }
}

