#ifndef _EFL_UI_RANGE_EO_H_
#define _EFL_UI_RANGE_EO_H_

#ifndef _EFL_UI_RANGE_EO_CLASS_TYPE
#define _EFL_UI_RANGE_EO_CLASS_TYPE

typedef Eo Efl_Ui_Range;

#endif

#ifndef _EFL_UI_RANGE_EO_TYPES
#define _EFL_UI_RANGE_EO_TYPES


#endif
/** Efl UI progress interface
 *
 * @ingroup Efl_Ui_Range
 */
#define EFL_UI_RANGE_INTERFACE efl_ui_range_interface_get()

EWAPI const Efl_Class *efl_ui_range_interface_get(void);

/**
 * @brief Control the range value (in percentage) on a given range widget
 *
 * Use this call to set range levels.
 *
 * @note If you pass a value out of the specified interval for @c val, it will
 * be interpreted as the closest of the boundary values in the interval.
 *
 * @param[in] obj The object.
 * @param[in] val The range value (must be between $0.0 and 1.0)
 *
 * @ingroup Efl_Ui_Range
 */
EOAPI void efl_ui_range_value_set(Eo *obj, double val);

/**
 * @brief Control the range value (in percentage) on a given range widget
 *
 * Use this call to set range levels.
 *
 * @note If you pass a value out of the specified interval for @c val, it will
 * be interpreted as the closest of the boundary values in the interval.
 *
 * @param[in] obj The object.
 *
 * @return The range value (must be between $0.0 and 1.0)
 *
 * @ingroup Efl_Ui_Range
 */
EOAPI double efl_ui_range_value_get(const Eo *obj);

/**
 * @brief Set the minimum and maximum values for given range widget.
 *
 * Define the allowed range of values to be selected by the user.
 *
 * If actual value is less than @c min, it will be updated to @c min. If it is
 * bigger then @c max, will be updated to @c max. The actual value can be
 * obtained with @ref efl_ui_range_value_get
 *
 * The minimum and maximum values may be different for each class.
 *
 * @warning maximum must be greater than minimum, otherwise behavior is
 * undefined.
 *
 * @param[in] obj The object.
 * @param[in] min The minimum value.
 * @param[in] max The maximum value.
 *
 * @ingroup Efl_Ui_Range
 */
EOAPI void efl_ui_range_min_max_set(Eo *obj, double min, double max);

/**
 * @brief Get the minimum and maximum values of the given range widget.
 *
 * @note If only one value is needed, the other pointer can be passed as
 * @c null.
 *
 * @param[in] obj The object.
 * @param[out] min The minimum value.
 * @param[out] max The maximum value.
 *
 * @ingroup Efl_Ui_Range
 */
EOAPI void efl_ui_range_min_max_get(const Eo *obj, double *min, double *max);

/**
 * @brief Control the step used to increment or decrement values for given
 * widget.
 *
 * This value will be incremented or decremented to the displayed value.
 *
 * By default step value is equal to 1.
 *
 * @warning The step value should be bigger than 0.
 *
 * @param[in] obj The object.
 * @param[in] step The step value.
 *
 * @ingroup Efl_Ui_Range
 */
EOAPI void efl_ui_range_step_set(Eo *obj, double step);

/**
 * @brief Control the step used to increment or decrement values for given
 * widget.
 *
 * This value will be incremented or decremented to the displayed value.
 *
 * By default step value is equal to 1.
 *
 * @warning The step value should be bigger than 0.
 *
 * @param[in] obj The object.
 *
 * @return The step value.
 *
 * @ingroup Efl_Ui_Range
 */
EOAPI double efl_ui_range_step_get(const Eo *obj);

#endif
