/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.controller.Controller;
import freemind.controller.LastStateStorageManagement;
import freemind.controller.MapModuleManager;
import freemind.controller.MindMapNodesSelection;
import freemind.controller.StructuredMenuHolder;
import freemind.controller.actions.generated.instance.MindmapLastStateStorage;
import freemind.controller.actions.generated.instance.NodeListMember;
import freemind.extensions.PermanentNodeHook;
import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.main.XMLParseException;
import freemind.modes.FreeMindAwtFileDialog;
import freemind.modes.FreeMindFileDialog;
import freemind.modes.FreeMindJFileDialog;
import freemind.modes.MapAdapter;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.XMLElementAdapter;
import freemind.modes.attributes.AttributeController;
import freemind.modes.common.listeners.MindMapMouseWheelEventHandler;
import freemind.view.MapModule;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import freemind.view.mindmapview.attributeview.AttributeTable;
import freemind.view.mindmapview.attributeview.AttributeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeNode;

public abstract class ControllerAdapter
implements ModeController,
FreeMindFileDialog.DirectoryResultListener {
    private static Logger logger;
    private Mode mode;
    private Color selectionColor = new Color(200, 220, 200);
    private MapAdapter mModel;
    private HashSet mNodeSelectionListeners = new HashSet();
    private HashSet mNodeLifetimeListeners = new HashSet();
    private File lastCurrentDir = null;
    protected final ControllerPopupMenuListener popupListenerSingleton = new ControllerPopupMenuListener();
    private boolean isBlocked = false;
    private MapView mView;

    public ControllerAdapter(Mode mode) {
        this.setMode(mode);
        if (logger == null) {
            logger = this.getFrame().getLogger(this.getClass().getName());
        }
    }

    @Override
    public void setModel(MapAdapter model) {
        this.mModel = model;
    }

    public abstract MindMapNode newNode(Object var1, MindMap var2);

    public abstract XMLElement createXMLElement();

    public MapAdapter newModel(ModeController modeController) {
        throw new UnsupportedOperationException();
    }

    protected FileFilter getFileFilter() {
        return null;
    }

    @Override
    public void nodeChanged(MindMapNode node) {
        this.getMap().setSaved(false);
        this.nodeRefresh(node, true);
    }

    @Override
    public void nodeRefresh(MindMapNode node) {
        this.nodeRefresh(node, false);
    }

    private void nodeRefresh(MindMapNode node, boolean isUpdate) {
        logger.finest("nodeChanged called for node " + node + " parent=" + node.getParentNode());
        if (isUpdate) {
            if (node.getHistoryInformation() != null) {
                node.getHistoryInformation().setLastModifiedAt(new Date());
            }
            this.updateNode(node);
        }
        ((MapAdapter)this.getMap()).nodeChangedInternal(node);
    }

    @Override
    public void refreshMap() {
        MindMapNode root = this.getMap().getRootNode();
        this.refreshMapFrom(root);
    }

    public void refreshMapFrom(MindMapNode node) {
        for (MindMapNode child : node.getChildren()) {
            this.refreshMapFrom(child);
        }
        ((MapAdapter)this.getMap()).nodeChangedInternal(node);
    }

    public void nodeStructureChanged(MindMapNode node) {
        this.getMap().nodeStructureChanged(node);
    }

    protected void updateNode(MindMapNode node) {
        for (ModeController.NodeSelectionListener listener : this.mNodeSelectionListeners) {
            listener.onUpdateNodeHook(node);
        }
    }

    @Override
    public void onLostFocusNode(NodeView node) {
        try {
            HashSet copy = new HashSet(this.mNodeSelectionListeners);
            for (ModeController.NodeSelectionListener listener : copy) {
                listener.onLostFocusNode(node);
            }
            for (PermanentNodeHook hook : node.getModel().getActivatedHooks()) {
                hook.onLostFocusNode(node);
            }
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "Error in node selection listeners", e);
        }
    }

    @Override
    public void onFocusNode(NodeView node) {
        try {
            HashSet copy = new HashSet(this.mNodeSelectionListeners);
            for (ModeController.NodeSelectionListener listener : copy) {
                listener.onFocusNode(node);
            }
            for (PermanentNodeHook hook : node.getModel().getActivatedHooks()) {
                hook.onFocusNode(node);
            }
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "Error in node selection listeners", e);
        }
    }

    @Override
    public void changeSelection(NodeView pNode, boolean pIsSelected) {
        try {
            HashSet copy = new HashSet(this.mNodeSelectionListeners);
            for (ModeController.NodeSelectionListener listener : copy) {
                listener.onSelectionChange(pNode, pIsSelected);
            }
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "Error in node selection listeners", e);
        }
    }

    @Override
    public void onViewCreatedHook(NodeView node) {
        for (PermanentNodeHook hook : node.getModel().getActivatedHooks()) {
            hook.onViewCreatedHook(node);
        }
    }

    @Override
    public void onViewRemovedHook(NodeView node) {
        for (PermanentNodeHook hook : node.getModel().getActivatedHooks()) {
            hook.onViewRemovedHook(node);
        }
    }

    @Override
    public void registerNodeSelectionListener(ModeController.NodeSelectionListener listener, boolean pCallWithCurrentSelection) {
        this.mNodeSelectionListeners.add(listener);
        if (pCallWithCurrentSelection) {
            try {
                listener.onFocusNode(this.getSelectedView());
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
            }
            for (NodeView view : this.getView().getSelecteds()) {
                try {
                    listener.onSelectionChange(view, true);
                }
                catch (Exception e) {
                    Resources.getInstance().logException(e);
                }
            }
        }
    }

    @Override
    public void deregisterNodeSelectionListener(ModeController.NodeSelectionListener listener) {
        this.mNodeSelectionListeners.remove(listener);
    }

    @Override
    public void registerNodeLifetimeListener(ModeController.NodeLifetimeListener listener, boolean pFireCreateEvent) {
        this.mNodeLifetimeListeners.add(listener);
        if (pFireCreateEvent) {
            this.fireRecursiveNodeCreateEvent(this.getRootNode());
        }
    }

    @Override
    public void deregisterNodeLifetimeListener(ModeController.NodeLifetimeListener listener) {
        this.mNodeLifetimeListeners.remove(listener);
    }

    public HashSet getNodeLifetimeListeners() {
        return this.mNodeLifetimeListeners;
    }

    @Override
    public void fireNodePreDeleteEvent(MindMapNode node) {
        for (ModeController.NodeLifetimeListener listener : this.mNodeLifetimeListeners) {
            listener.onPreDeleteNode(node);
        }
    }

    public void fireNodePostDeleteEvent(MindMapNode node, MindMapNode parent) {
        for (ModeController.NodeLifetimeListener listener : this.mNodeLifetimeListeners) {
            listener.onPostDeleteNode(node, parent);
        }
    }

    public void fireRecursiveNodeCreateEvent(MindMapNode node) {
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            NodeAdapter child = (NodeAdapter)i.next();
            this.fireRecursiveNodeCreateEvent(child);
        }
        for (ModeController.NodeLifetimeListener listener : this.mNodeLifetimeListeners) {
            listener.onCreateNodeHook(node);
        }
    }

    @Override
    public void firePreSaveEvent(MindMapNode node) {
        HashSet listenerCopy = new HashSet(this.mNodeSelectionListeners);
        for (ModeController.NodeSelectionListener listener : listenerCopy) {
            listener.onSaveNode(node);
        }
    }

    @Override
    public String getText(String textId) {
        return this.getController().getResourceString(textId);
    }

    @Override
    public MindMap newMap() {
        ModeController newModeController = this.getMode().createModeController();
        MapAdapter newModel = this.newModel(newModeController);
        this.newMap(newModel);
        newModeController.getView().moveToRoot();
        return newModel;
    }

    public void newMap(MindMap mapModel) {
        this.getController().getMapModuleManager().newMapModule(mapModel, mapModel.getModeController());
        mapModel.setSaved(false);
    }

    @Override
    public ModeController load(URL file) throws FileNotFoundException, IOException, XMLParseException, URISyntaxException {
        String mapDisplayName = this.getController().getMapModuleManager().checkIfFileIsAlreadyOpened(file);
        if (null != mapDisplayName) {
            this.getController().getMapModuleManager().changeToMapModule(mapDisplayName);
            return this.getController().getModeController();
        }
        ModeController newModeController = this.getMode().createModeController();
        MapAdapter model = this.newModel(newModeController);
        model.load(file);
        this.newMap(model);
        model.setSaved(true);
        this.restoreMapsLastState(newModeController, model);
        return newModeController;
    }

    @Override
    public ModeController load(File file) throws FileNotFoundException, IOException {
        try {
            return this.load(Tools.fileToUrl(file));
        }
        catch (XMLParseException e) {
            Resources.getInstance().logException(e);
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            Resources.getInstance().logException(e);
            throw new RuntimeException(e);
        }
    }

    protected void restoreMapsLastState(ModeController newModeController, MapAdapter model) {
        String lastStateMapXml = this.getFrame().getProperty("mindmap_last_state_map_storage");
        LastStateStorageManagement management = new LastStateStorageManagement(lastStateMapXml);
        MindmapLastStateStorage store = management.getStorage(model.getRestorable());
        if (store != null) {
            ModeController modeController = newModeController;
            this.getController().setZoom(store.getLastZoom());
            NodeAdapter sel = null;
            try {
                sel = modeController.getNodeFromID(store.getLastSelected());
                modeController.centerNode(sel);
                Vector<NodeAdapter> selected = new Vector<NodeAdapter>();
                for (NodeListMember member : store.getListNodeListMemberList()) {
                    NodeAdapter selNode = modeController.getNodeFromID(member.getNode());
                    selected.add(selNode);
                }
                modeController.select(sel, selected);
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
                newModeController.getView().moveToRoot();
            }
        } else {
            newModeController.getView().moveToRoot();
        }
    }

    @Override
    public boolean save() {
        if (this.getModel().isSaved()) {
            return true;
        }
        if (this.getModel().getFile() == null || this.getModel().isReadOnly()) {
            return this.saveAs();
        }
        return this.save(this.getModel().getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadURL(String relative) {
        block20: {
            try {
                String extension;
                logger.info("Trying to open " + relative);
                URL absolute = null;
                if (Tools.isAbsolutePath(relative)) {
                    absolute = Tools.fileToUrl(new File(relative));
                } else {
                    if (relative.startsWith("#")) {
                        logger.finest("found relative link to " + relative);
                        String target = relative.substring(1);
                        try {
                            this.centerNode(this.getNodeFromID(target));
                        }
                        catch (Exception e) {
                            Resources.getInstance().logException(e);
                            this.getFrame().out(Tools.expandPlaceholders(this.getText("link_not_found"), target));
                        }
                        return;
                    }
                    absolute = new URL(this.getMap().getURL(), relative);
                }
                URL originalURL = absolute;
                String ref = absolute.getRef();
                if (ref != null) {
                    absolute = Tools.getURLWithoutReference(absolute);
                }
                if ((extension = Tools.getExtension(absolute.toString())) != null && extension.equals("mm")) {
                    logger.info("Trying to open mind map " + absolute);
                    MapModuleManager mapModuleManager = this.getController().getMapModuleManager();
                    String mapExtensionKey = mapModuleManager.checkIfFileIsAlreadyOpened(absolute);
                    if (mapExtensionKey == null) {
                        this.getFrame().setWaitingCursor(true);
                        this.load(absolute);
                    } else {
                        mapModuleManager.tryToChangeToMapModule(mapExtensionKey);
                    }
                    if (ref == null) break block20;
                    try {
                        ModeController newModeController = this.getController().getModeController();
                        newModeController.centerNode(newModeController.getNodeFromID(ref));
                        break block20;
                    }
                    catch (Exception e) {
                        Resources.getInstance().logException(e);
                        this.getFrame().out(Tools.expandPlaceholders(this.getText("link_not_found"), ref));
                        this.getFrame().setWaitingCursor(false);
                        return;
                    }
                }
                this.getFrame().openDocument(originalURL);
            }
            catch (MalformedURLException ex) {
                Resources.getInstance().logException(ex);
                this.getController().errorMessage(this.getText("url_error") + "\n" + ex);
                return;
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
            }
            finally {
                this.getFrame().setWaitingCursor(false);
            }
        }
    }

    @Override
    public MindMapNode createNodeTreeFromXml(Reader pReader, HashMap pIDToTarget) throws XMLParseException, IOException {
        XMLElementAdapter element = (XMLElementAdapter)this.createXMLElement();
        element.setIDToTarget(pIDToTarget);
        element.parseFromReader(pReader);
        element.processUnfinishedLinks(this.getModel().getLinkRegistry());
        NodeAdapter node = element.getMapChild();
        return node;
    }

    public void invokeHooksRecursively(NodeAdapter node, MindMap map) {
        Iterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            NodeAdapter child = (NodeAdapter)i.next();
            this.invokeHooksRecursively(child, map);
        }
        for (PermanentNodeHook hook : node.getHooks()) {
            hook.setController(this);
            hook.setMap(map);
            node.invokeHook(hook);
        }
    }

    public void processUnfinishedLinksInHooks(NodeAdapter node) {
        Iterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            NodeAdapter child = (NodeAdapter)i.next();
            this.processUnfinishedLinksInHooks(child);
        }
        for (PermanentNodeHook hook : node.getHooks()) {
            hook.processUnfinishedLinks();
        }
    }

    @Override
    public List getSelecteds() {
        LinkedList<MindMapNode> selecteds = new LinkedList<MindMapNode>();
        ListIterator it = this.getView().getSelecteds().listIterator();
        if (it != null) {
            while (it.hasNext()) {
                NodeView selected = (NodeView)it.next();
                selecteds.add(selected.getModel());
            }
        }
        return selecteds;
    }

    @Override
    public void select(NodeView node) {
        if (node == null) {
            logger.warning("Select with null NodeView called!");
            return;
        }
        this.getView().scrollNodeToVisible(node);
        this.getView().selectAsTheOnlyOneSelected(node);
        this.getView().setSiblingMaxLevel(node.getModel().getNodeLevel());
    }

    @Override
    public void select(MindMapNode primarySelected, List selecteds) {
        for (MindMapNode node : selecteds) {
            this.displayNode(node);
        }
        NodeView focussedNodeView = this.getNodeView(primarySelected);
        if (focussedNodeView != null) {
            this.getView().selectAsTheOnlyOneSelected(focussedNodeView);
            this.getView().scrollNodeToVisible(focussedNodeView);
            for (MindMapNode node : selecteds) {
                NodeView nodeView = this.getNodeView(node);
                if (nodeView == null) continue;
                this.getView().makeTheSelected(nodeView);
            }
        }
        this.getController().obtainFocusForSelected();
    }

    @Override
    public void selectBranch(NodeView selected, boolean extend) {
        this.displayNode(selected.getModel());
        this.getView().selectBranch(selected, extend);
    }

    @Override
    public List getSelectedsByDepth() {
        List result = this.getSelecteds();
        this.sortNodesByDepth(result);
        return result;
    }

    @Override
    public void sortNodesByDepth(List inPlaceList) {
        Collections.sort(inPlaceList, new nodesDepthComparator());
        logger.finest("Sort result: " + inPlaceList);
    }

    @Override
    public boolean save(File file) {
        return this.getModel().save(file);
    }

    protected JMenuItem add(JMenu menu, Action action, String keystroke) {
        JMenuItem item = menu.add(action);
        item.setAccelerator(KeyStroke.getKeyStroke(this.getFrame().getAdjustableProperty(keystroke)));
        return item;
    }

    protected JMenuItem add(StructuredMenuHolder holder, String category, Action action, String keystroke) {
        JMenuItem item = holder.addAction(action, category);
        if (keystroke != null) {
            String keyProperty = this.getFrame().getAdjustableProperty(keystroke);
            logger.finest("Found key stroke: " + keyProperty);
            item.setAccelerator(KeyStroke.getKeyStroke(keyProperty));
        }
        return item;
    }

    protected JMenuItem addCheckBox(StructuredMenuHolder holder, String category, Action action, String keystroke) {
        JCheckBoxMenuItem item = (JCheckBoxMenuItem)holder.addMenuItem(new JCheckBoxMenuItem(action), category);
        if (keystroke != null) {
            item.setAccelerator(KeyStroke.getKeyStroke(this.getFrame().getAdjustableProperty(keystroke)));
        }
        return item;
    }

    protected JMenuItem addRadioItem(StructuredMenuHolder holder, String category, Action action, String keystroke, boolean isSelected) {
        JRadioButtonMenuItem item = (JRadioButtonMenuItem)holder.addMenuItem(new JRadioButtonMenuItem(action), category);
        if (keystroke != null) {
            item.setAccelerator(KeyStroke.getKeyStroke(this.getFrame().getAdjustableProperty(keystroke)));
        }
        item.setSelected(isSelected);
        return item;
    }

    protected void add(JMenu menu, Action action) {
        menu.add(action);
    }

    @Override
    public void open() {
        FreeMindFileDialog chooser = this.getFileChooser();
        int returnVal = chooser.showOpenDialog(this.getView());
        if (returnVal == 0) {
            File[] selectedFiles = chooser.isMultiSelectionEnabled() ? chooser.getSelectedFiles() : new File[]{chooser.getSelectedFile()};
            for (int i = 0; i < selectedFiles.length; ++i) {
                File theFile = selectedFiles[i];
                try {
                    this.lastCurrentDir = theFile.getParentFile();
                    ModeController newMC = this.load(theFile);
                    continue;
                }
                catch (Exception ex) {
                    this.handleLoadingException(ex);
                    break;
                }
            }
        }
        this.getController().setTitle();
    }

    @Override
    public void setChosenDirectory(File pDir) {
        this.lastCurrentDir = pDir;
    }

    @Override
    public FreeMindFileDialog getFileChooser(FileFilter filter) {
        Container chooser = !Tools.isMacOsX() ? new FreeMindJFileDialog() : new FreeMindAwtFileDialog();
        chooser.registerDirectoryResultListener(this);
        File parentFile = this.getMapsParentFile();
        if (parentFile != null && this.lastCurrentDir == null) {
            this.lastCurrentDir = parentFile;
        }
        if (this.lastCurrentDir != null) {
            chooser.setCurrentDirectory(this.lastCurrentDir);
        }
        if (filter != null) {
            chooser.addChoosableFileFilterAsDefault(filter);
        }
        return chooser;
    }

    public FreeMindFileDialog getFileChooser() {
        return this.getFileChooser(this.getFileFilter());
    }

    private File getMapsParentFile() {
        if (this.getMap() != null && this.getMap().getFile() != null && this.getMap().getFile().getParentFile() != null) {
            return this.getMap().getFile().getParentFile();
        }
        return null;
    }

    public void handleLoadingException(Exception ex) {
        String exceptionType = ex.getClass().getName();
        if (exceptionType.equals("freemind.main.XMLParseException")) {
            int showDetail = JOptionPane.showConfirmDialog(this.getView(), this.getText("map_corrupted"), "FreeMind", 0, 0);
            if (showDetail == 0) {
                this.getController().errorMessage(ex);
            }
        } else if (exceptionType.equals("java.io.FileNotFoundException")) {
            this.getController().errorMessage(ex.getMessage());
        } else {
            Resources.getInstance().logException(ex);
            this.getController().errorMessage(ex);
        }
    }

    @Override
    public boolean saveAs() {
        File f;
        boolean repeatSaveAsQuestion;
        FreeMindFileDialog chooser = this.getFileChooser();
        if (this.getMapsParentFile() == null) {
            chooser.setSelectedFile(new File(this.getFileNameProposal() + ".mm"));
        }
        chooser.setDialogTitle(this.getText("save_as"));
        do {
            int overwriteMap;
            repeatSaveAsQuestion = false;
            int returnVal = chooser.showSaveDialog(this.getView());
            if (returnVal != 0) {
                return false;
            }
            f = chooser.getSelectedFile();
            this.lastCurrentDir = f.getParentFile();
            String ext = Tools.getExtension(f.getName());
            if (!ext.equals("mm")) {
                f = new File(f.getParent(), f.getName() + ".mm");
            }
            if (!f.exists() || (overwriteMap = JOptionPane.showConfirmDialog(this.getView(), this.getText("map_already_exists"), "FreeMind", 0)) == 0) continue;
            repeatSaveAsQuestion = true;
        } while (repeatSaveAsQuestion);
        try {
            String lockingUser = this.getModel().tryToLock(f);
            if (lockingUser != null) {
                this.getFrame().getController().informationMessage(Tools.expandPlaceholders(this.getText("map_locked_by_save_as"), f.getName(), lockingUser));
                return false;
            }
        }
        catch (Exception e) {
            this.getFrame().getController().informationMessage(Tools.expandPlaceholders(this.getText("locking_failed_by_save_as"), f.getName()));
            return false;
        }
        this.save(f);
        this.getController().getMapModuleManager().updateMapModuleName();
        return true;
    }

    private String getFileNameProposal() {
        return Tools.getFileNameProposal(this.getMap().getRootNode());
    }

    @Override
    public boolean close(boolean force, MapModuleManager mapModuleManager) {
        this.getFrame().out("");
        if (!force && !this.getModel().isSaved()) {
            boolean savingNotCancelled;
            String text = this.getText("save_unsaved") + "\n" + mapModuleManager.getMapModule().toString();
            String title = Tools.removeMnemonic(this.getText("save"));
            int returnVal = JOptionPane.showOptionDialog(this.getFrame().getContentPane(), text, title, 1, 3, null, null, null);
            if (returnVal == 0 ? !(savingNotCancelled = this.save()) : returnVal == 2 || returnVal == -1) {
                return false;
            }
        }
        LastStateStorageManagement management = new LastStateStorageManagement(this.getFrame().getProperty("mindmap_last_state_map_storage"));
        String restorable = this.getModel().getRestorable();
        if (restorable != null) {
            MindmapLastStateStorage store = management.getStorage(restorable);
            if (store == null) {
                store = new MindmapLastStateStorage();
            }
            store.setRestorableName(restorable);
            store.setLastZoom(this.getView().getZoom());
            Point viewLocation = this.getView().getViewPosition();
            if (viewLocation != null) {
                store.setX(viewLocation.x);
                store.setY(viewLocation.y);
            }
            String lastSelected = this.getNodeID(this.getSelected());
            store.setLastSelected(lastSelected);
            store.clearNodeListMemberList();
            List selecteds = this.getSelecteds();
            for (MindMapNode node : selecteds) {
                NodeListMember member = new NodeListMember();
                member.setNode(this.getNodeID(node));
                store.addNodeListMember(member);
            }
            management.changeOrAdd(store);
            this.getFrame().setProperty("mindmap_last_state_map_storage", management.getXml());
        }
        this.getModel().destroy();
        return true;
    }

    @Override
    public void setVisible(boolean visible) {
        NodeView node = this.getSelectedView();
        if (visible) {
            this.onFocusNode(node);
        } else if (node != null) {
            this.onLostFocusNode(node);
        }
        this.changeSelection(node, !visible);
    }

    protected void setAllActions(boolean enabled) {
        this.getController().zoomIn.setEnabled(enabled);
        this.getController().zoomOut.setEnabled(enabled);
        this.getController().showFilterToolbarAction.setEnabled(enabled);
    }

    @Override
    public void showPopupMenu(MouseEvent e) {
        JPopupMenu popupmenu;
        if (e.isPopupTrigger() && (popupmenu = this.getPopupMenu()) != null) {
            popupmenu.addPopupMenuListener(this.popupListenerSingleton);
            popupmenu.show(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public JPopupMenu getPopupForModel(Object obj) {
        return null;
    }

    @Override
    public Component getLeftToolBar() {
        return null;
    }

    @Override
    public JToolBar getModeToolBar() {
        return null;
    }

    @Override
    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean isBlocked) {
        this.isBlocked = isBlocked;
    }

    @Override
    public Mode getMode() {
        return this.mode;
    }

    protected void setMode(Mode mode) {
        this.mode = mode;
    }

    @Override
    public MindMap getMap() {
        return this.mModel;
    }

    public MindMapNode getRootNode() {
        return (MindMapNode)this.getMap().getRoot();
    }

    @Override
    public URL getResource(String name) {
        return this.getFrame().getResource(name);
    }

    @Override
    public Controller getController() {
        return this.getMode().getController();
    }

    @Override
    public FreeMindMain getFrame() {
        return this.getController().getFrame();
    }

    public ControllerAdapter getModeController() {
        return this;
    }

    public MapAdapter getModel() {
        return this.mModel;
    }

    @Override
    public MapView getView() {
        return this.mView;
    }

    @Override
    public void setView(MapView pView) {
        this.mView = pView;
    }

    protected void updateMapModuleName() {
        this.getController().getMapModuleManager().updateMapModuleName();
    }

    @Override
    public NodeAdapter getNodeFromID(String nodeID) {
        NodeAdapter node = (NodeAdapter)this.getMap().getLinkRegistry().getTargetForId(nodeID);
        if (node == null) {
            throw new IllegalArgumentException("Node belonging to the node id " + nodeID + " not found in map " + this.getMap().getFile());
        }
        return node;
    }

    @Override
    public String getNodeID(MindMapNode selected) {
        return this.getMap().getLinkRegistry().registerLinkTarget(selected);
    }

    @Override
    public MindMapNode getSelected() {
        NodeView selectedView = this.getSelectedView();
        if (selectedView != null) {
            return selectedView.getModel();
        }
        return null;
    }

    @Override
    public NodeView getSelectedView() {
        if (this.getView() != null) {
            return this.getView().getSelected();
        }
        return null;
    }

    @Override
    public Transferable copy(MindMapNode node, boolean saveInvisible) {
        throw new IllegalArgumentException("No copy so far.");
    }

    @Override
    public Transferable copy() {
        return this.copy(this.getView().getSelectedNodesSortedByY(), false);
    }

    @Override
    public Transferable copySingle() {
        ArrayList selectedNodes = this.getView().getSingleSelectedNodes();
        return this.copy(selectedNodes, false);
    }

    @Override
    public Transferable copy(List selectedNodes, boolean copyInvisible) {
        try {
            String forNodesFlavor = this.createForNodesFlavor(selectedNodes, copyInvisible);
            List createForNodeIdsFlavor = this.createForNodeIdsFlavor(selectedNodes, copyInvisible);
            String plainText = this.getMap().getAsPlainText(selectedNodes);
            return new MindMapNodesSelection(forNodesFlavor, null, plainText, this.getMap().getAsRTF(selectedNodes), this.getMap().getAsHTML(selectedNodes), null, null, createForNodeIdsFlavor);
        }
        catch (UnsupportedFlavorException ex) {
            Resources.getInstance().logException(ex);
        }
        catch (IOException ex) {
            Resources.getInstance().logException(ex);
        }
        return null;
    }

    public String createForNodesFlavor(List selectedNodes, boolean copyInvisible) throws UnsupportedFlavorException, IOException {
        String forNodesFlavor = "";
        boolean firstLoop = true;
        for (MindMapNode tmpNode : selectedNodes) {
            if (firstLoop) {
                firstLoop = false;
            } else {
                forNodesFlavor = forNodesFlavor + "<nodeseparator>";
            }
            forNodesFlavor = forNodesFlavor + this.copy(tmpNode, copyInvisible).getTransferData(MindMapNodesSelection.mindMapNodesFlavor);
        }
        return forNodesFlavor;
    }

    public List createForNodeIdsFlavor(List selectedNodes, boolean copyInvisible) throws UnsupportedFlavorException, IOException {
        Vector<String> forNodesFlavor = new Vector<String>();
        boolean firstLoop = true;
        for (MindMapNode tmpNode : selectedNodes) {
            forNodesFlavor.add(this.getNodeID(tmpNode));
        }
        return forNodesFlavor;
    }

    @Override
    public Color getSelectionColor() {
        return this.selectionColor;
    }

    @Override
    public void updatePopupMenu(StructuredMenuHolder holder) {
    }

    @Override
    public void shutdownController() {
        this.setAllActions(false);
        this.getController().getMapMouseWheelListener().deregister();
    }

    @Override
    public void startupController() {
        this.setAllActions(true);
        if (this.getFrame().getView() != null) {
            FileOpener fileOpener = new FileOpener();
            DropTarget dropTarget = new DropTarget(this.getFrame().getView(), fileOpener);
        }
        this.getController().getMapMouseWheelListener().register(new MindMapMouseWheelEventHandler(this));
    }

    public void _setFolded(MindMapNode node, boolean folded) {
        if (node == null) {
            throw new IllegalArgumentException("setFolded was called with a null node.");
        }
        if (node.isRoot() && folded) {
            return;
        }
        if (node.isFolded() != folded) {
            node.setFolded(folded);
            this.nodeStructureChanged(node);
        }
    }

    @Override
    public String getLinkShortText(MindMapNode node) {
        String adaptedText = node.getLink();
        if (adaptedText == null) {
            return null;
        }
        if (adaptedText.startsWith("#")) {
            try {
                NodeAdapter dest = this.getNodeFromID(adaptedText.substring(1));
                return dest.getShortText(this);
            }
            catch (Exception e) {
                return this.getText("link_not_available_any_more");
            }
        }
        return adaptedText;
    }

    @Override
    public void displayNode(MindMapNode node) {
        this.displayNode(node, null);
    }

    public void displayNode(MindMapNode node, ArrayList nodesUnfoldedByDisplay) {
        TreeNode[] path = this.getMap().getPathToRoot(node);
        for (int i = 0; i < path.length - 1; ++i) {
            MindMapNode nodeOnPath = (MindMapNode)path[i];
            if (!nodeOnPath.isFolded()) continue;
            if (nodesUnfoldedByDisplay != null) {
                nodesUnfoldedByDisplay.add(nodeOnPath);
            }
            this.setFolded(nodeOnPath, false);
        }
    }

    private void centerNode(NodeView node) {
        this.getView().centerNode(node);
        this.getView().selectAsTheOnlyOneSelected(node);
    }

    @Override
    public void centerNode(MindMapNode node) {
        NodeView view = null;
        if (node == null) {
            return;
        }
        view = this.getController().getView().getNodeView(node);
        if (view == null) {
            this.displayNode(node);
            view = this.getController().getView().getNodeView(node);
        }
        this.centerNode(view);
    }

    @Override
    public AttributeController getAttributeController() {
        return null;
    }

    @Override
    public NodeView getNodeView(MindMapNode node) {
        return this.getView().getNodeView(node);
    }

    public void insertNodeInto(MindMapNode newNode, MindMapNode parent, int index) {
        this.getModel().insertNodeInto(newNode, parent, index);
        this.fireRecursiveNodeCreateEvent(newNode);
    }

    public void insertNodeInto(MindMapNode newChild, MindMapNode parent) {
        this.insertNodeInto(newChild, parent, parent.getChildCount());
    }

    public void loadURL() {
        String link = this.getSelected().getLink();
        if (link != null) {
            this.loadURL(link);
        }
    }

    public Set getRegisteredMouseWheelEventHandler() {
        return Collections.EMPTY_SET;
    }

    @Override
    public MapModule getMapModule() {
        return this.getController().getMapModuleManager().getModuleGivenModeController(this);
    }

    @Override
    public void setToolTip(MindMapNode node, String key, String value) {
        node.setToolTip(key, value);
        this.nodeRefresh(node);
    }

    protected class FileOpener
    implements DropTargetListener {
        protected FileOpener() {
        }

        private boolean isDragAcceptable(DropTargetDragEvent event) {
            DataFlavor[] flavors = event.getCurrentDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].isFlavorJavaFileListType()) continue;
                return true;
            }
            return false;
        }

        private boolean isDropAcceptable(DropTargetDropEvent event) {
            DataFlavor[] flavors = event.getCurrentDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].isFlavorJavaFileListType()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            if (!this.isDropAcceptable(dtde)) {
                dtde.rejectDrop();
                return;
            }
            dtde.acceptDrop(1);
            try {
                Object data = dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                if (data == null) {
                    dtde.dropComplete(false);
                    return;
                }
                for (File file : (List)data) {
                    ControllerAdapter.this.load(file);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(ControllerAdapter.this.getView(), "Couldn't open dropped file(s). Reason: " + e.getMessage());
                dtde.dropComplete(false);
                return;
            }
            dtde.dropComplete(true);
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (!this.isDragAcceptable(dtde)) {
                dtde.rejectDrag();
                return;
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        public void dragScroll(DropTargetDragEvent e) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }
    }

    protected class EditAttributesAction
    extends AbstractAction {
        public EditAttributesAction() {
            super(Resources.getInstance().getResourceString("attributes_edit_in_place"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean attributesClosed;
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            AttributeView attributeView = ControllerAdapter.this.getView().getSelected().getAttributeView();
            boolean bl = attributesClosed = null == SwingUtilities.getAncestorOfClass(AttributeTable.class, focusOwner);
            if (attributesClosed) {
                attributeView.startEditing();
            } else {
                attributeView.stopEditing();
            }
        }
    }

    public class SaveAsAction
    extends AbstractAction {
        ControllerAdapter mc;

        public SaveAsAction(ControllerAdapter modeController) {
            super(ControllerAdapter.this.getText("save_as"), new ImageIcon(ControllerAdapter.this.getResource("images/filesaveas.png")));
            this.mc = modeController;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.mc.saveAs();
            ControllerAdapter.this.getController().setTitle();
        }
    }

    public class SaveAction
    extends AbstractAction {
        ControllerAdapter mc;

        public SaveAction(ControllerAdapter modeController) {
            super(Tools.removeMnemonic(ControllerAdapter.this.getText("save")), new ImageIcon(ControllerAdapter.this.getResource("images/filesave.png")));
            this.mc = modeController;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean success = this.mc.save();
            if (success) {
                ControllerAdapter.this.getFrame().out(ControllerAdapter.this.getText("saved"));
            } else {
                String message = "Saving failed.";
                ControllerAdapter.this.getFrame().out(message);
                ControllerAdapter.this.getController().errorMessage(message);
            }
            ControllerAdapter.this.getController().setTitle();
        }
    }

    public class OpenAction
    extends AbstractAction {
        ControllerAdapter mc;

        public OpenAction(ControllerAdapter modeController) {
            super(ControllerAdapter.this.getText("open"), new ImageIcon(ControllerAdapter.this.getResource("images/fileopen.png")));
            this.mc = modeController;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.mc.open();
            ControllerAdapter.this.getController().setTitle();
        }
    }

    private class ControllerPopupMenuListener
    implements PopupMenuListener {
        private ControllerPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            ControllerAdapter.this.setBlocked(true);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            ControllerAdapter.this.setBlocked(false);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            ControllerAdapter.this.setBlocked(false);
        }
    }

    protected class nodesDepthComparator
    implements Comparator {
        public int compare(Object p1, Object p2) {
            TreeNode[] path2;
            MindMapNode n1 = (MindMapNode)p1;
            MindMapNode n2 = (MindMapNode)p2;
            TreeNode[] path1 = ControllerAdapter.this.getModel().getPathToRoot(n1);
            int depth = path1.length - (path2 = ControllerAdapter.this.getModel().getPathToRoot(n2)).length;
            if (depth > 0) {
                return -1;
            }
            if (depth < 0) {
                return 1;
            }
            if (n1.isRoot()) {
                return 0;
            }
            return n1.getParentNode().getChildPosition(n1) - n2.getParentNode().getChildPosition(n2);
        }
    }
}

