/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.component;

import com.connectina.swing.fontchooser.JFontChooser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.ui.components.JColorButton;
import org.gephi.visualization.VizController;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.component.LabelAttributesPanel;
import org.gephi.visualization.component.VizBarController;
import org.gephi.visualization.text.ColorMode;
import org.gephi.visualization.text.SizeMode;
import org.gephi.visualization.text.TextManager;
import org.gephi.visualization.text.TextModelImpl;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class LabelSettingsPanel
extends JPanel {
    private JComboBox colorModeCombo;
    private JButton configureLabelsButton;
    private JButton edgeColorButton;
    private JButton edgeFontButton;
    private JPanel edgePanel;
    private JSlider edgeSizeSlider;
    private JCheckBox hideNonSelectedCheckbox;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel labelColorMode;
    private JLabel labelEdgeColor;
    private JLabel labelEdgeFont;
    private JLabel labelEdgeSize;
    private JLabel labelNodeColor;
    private JLabel labelNodeFont;
    private JLabel labelNodeSize;
    private JLabel labelSizeMode;
    private JButton nodeColorButton;
    private JButton nodeFontButton;
    private JPanel nodePanel;
    private JSlider nodeSizeSlider;
    private JCheckBox showEdgeLabelsCheckbox;
    private JCheckBox showNodeLabelsCheckbox;
    private JComboBox sizeModeCombo;

    public LabelSettingsPanel() {
        this.initComponents();
        this.nodeFontButton.setFont(this.nodeFontButton.getFont().deriveFont(11));
    }

    public void setup() {
        VizModel vizModel = VizController.getInstance().getVizModel();
        TextModelImpl model = vizModel.getTextModel();
        vizModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("init")) {
                    LabelSettingsPanel.this.refreshSharedConfig();
                }
            }
        });
        this.showNodeLabelsCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TextModelImpl model;
                boolean value = LabelSettingsPanel.this.showNodeLabelsCheckbox.isSelected();
                if (value != (model = VizController.getInstance().getVizModel().getTextModel()).isShowNodeLabels()) {
                    model.setShowNodeLabels(value);
                    LabelSettingsPanel.this.setEnable(true);
                }
            }
        });
        this.nodeFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                Font font = JFontChooser.showDialog((Window)WindowManager.getDefault().getMainWindow(), (Font)model.getNodeFont());
                if (font != null && font != model.getNodeFont()) {
                    model.setNodeFont(font);
                }
            }
        });
        ((JColorButton)this.nodeColorButton).addPropertyChangeListener(JColorButton.EVENT_COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                if (!model.getNodeColor().equals(((JColorButton)LabelSettingsPanel.this.nodeColorButton).getColor())) {
                    model.setNodeColor(((JColorButton)LabelSettingsPanel.this.nodeColorButton).getColor());
                }
            }
        });
        this.nodeSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                if (model.getNodeSizeFactor() != (float)LabelSettingsPanel.this.nodeSizeSlider.getValue() / 100.0f) {
                    model.setNodeSizeFactor((float)LabelSettingsPanel.this.nodeSizeSlider.getValue() / 100.0f);
                }
            }
        });
        this.showEdgeLabelsCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TextModelImpl model;
                boolean value = LabelSettingsPanel.this.showEdgeLabelsCheckbox.isSelected();
                if (value != (model = VizController.getInstance().getVizModel().getTextModel()).isShowEdgeLabels()) {
                    model.setShowEdgeLabels(value);
                    LabelSettingsPanel.this.setEnable(true);
                }
            }
        });
        this.edgeFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                Font font = JFontChooser.showDialog((Window)WindowManager.getDefault().getMainWindow(), (Font)model.getEdgeFont());
                if (font != null && font != model.getEdgeFont()) {
                    model.setEdgeFont(font);
                }
            }
        });
        ((JColorButton)this.edgeColorButton).addPropertyChangeListener(JColorButton.EVENT_COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                if (!model.getEdgeColor().equals(((JColorButton)LabelSettingsPanel.this.edgeColorButton).getColor())) {
                    model.setEdgeColor(((JColorButton)LabelSettingsPanel.this.edgeColorButton).getColor());
                }
            }
        });
        this.edgeSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                model.setEdgeSizeFactor((float)LabelSettingsPanel.this.edgeSizeSlider.getValue() / 100.0f);
            }
        });
        TextManager textManager = VizController.getInstance().getTextManager();
        final DefaultComboBoxModel<SizeMode> sizeModeModel = new DefaultComboBoxModel<SizeMode>(textManager.getSizeModes());
        this.sizeModeCombo.setModel(sizeModeModel);
        final DefaultComboBoxModel<ColorMode> colorModeModel = new DefaultComboBoxModel<ColorMode>(textManager.getColorModes());
        this.colorModeCombo.setModel(colorModeModel);
        this.sizeModeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                if (model.getSizeMode() != sizeModeModel.getSelectedItem()) {
                    model.setSizeMode((SizeMode)sizeModeModel.getSelectedItem());
                }
            }
        });
        this.colorModeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                if (model.getColorMode() != colorModeModel.getSelectedItem()) {
                    model.setColorMode((ColorMode)colorModeModel.getSelectedItem());
                }
            }
        });
        this.hideNonSelectedCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                if (model.isSelectedOnly() != LabelSettingsPanel.this.hideNonSelectedCheckbox.isSelected()) {
                    model.setSelectedOnly(LabelSettingsPanel.this.hideNonSelectedCheckbox.isSelected());
                }
            }
        });
        this.configureLabelsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                LabelAttributesPanel panel = new LabelAttributesPanel();
                panel.setup(model);
                DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(VizBarController.class, (String)"LabelAttributesPanel.title"), true, 2, null, null);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd).equals(NotifyDescriptor.OK_OPTION)) {
                    panel.unsetup();
                    return;
                }
            }
        });
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LabelSettingsPanel.this.refreshSharedConfig();
            }
        });
        this.refreshSharedConfig();
    }

    private void refreshSharedConfig() {
        VizModel vizModel = VizController.getInstance().getVizModel();
        this.setEnable(!vizModel.isDefaultModel());
        if (vizModel.isDefaultModel()) {
            return;
        }
        TextModelImpl model = vizModel.getTextModel();
        this.nodeFontButton.setText(model.getNodeFont().getFontName() + ", " + model.getNodeFont().getSize());
        ((JColorButton)this.nodeColorButton).setColor(model.getNodeColor());
        if (this.showNodeLabelsCheckbox.isSelected() != model.isShowNodeLabels()) {
            this.showNodeLabelsCheckbox.setSelected(model.isShowNodeLabels());
        }
        if ((float)this.nodeSizeSlider.getValue() / 100.0f != model.getNodeSizeFactor()) {
            this.nodeSizeSlider.setValue((int)(model.getNodeSizeFactor() * 100.0f));
        }
        this.edgeFontButton.setText(model.getEdgeFont().getFontName() + ", " + model.getEdgeFont().getSize());
        ((JColorButton)this.edgeColorButton).setColor(model.getEdgeColor());
        if (this.showEdgeLabelsCheckbox.isSelected() != model.isShowEdgeLabels()) {
            this.showEdgeLabelsCheckbox.setSelected(model.isShowEdgeLabels());
        }
        if ((float)this.edgeSizeSlider.getValue() / 100.0f != model.getEdgeSizeFactor()) {
            this.edgeSizeSlider.setValue((int)(model.getEdgeSizeFactor() * 100.0f));
        }
        if (this.hideNonSelectedCheckbox.isSelected() != model.isSelectedOnly()) {
            this.hideNonSelectedCheckbox.setSelected(model.isSelectedOnly());
        }
        if (this.sizeModeCombo.getSelectedItem() != model.getSizeMode()) {
            this.sizeModeCombo.setSelectedItem(model.getSizeMode());
        }
        if (this.colorModeCombo.getSelectedItem() != model.getColorMode()) {
            this.colorModeCombo.setSelectedItem(model.getColorMode());
        }
    }

    public void setEnable(boolean enable) {
        this.showEdgeLabelsCheckbox.setEnabled(enable);
        this.showNodeLabelsCheckbox.setEnabled(enable);
        this.sizeModeCombo.setEnabled(enable);
        this.colorModeCombo.setEnabled(enable);
        this.hideNonSelectedCheckbox.setEnabled(enable);
        this.labelColorMode.setEnabled(enable);
        this.labelSizeMode.setEnabled(enable);
        this.configureLabelsButton.setEnabled(enable);
        TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
        boolean edgeValue = model.isShowEdgeLabels();
        this.edgeFontButton.setEnabled(enable && edgeValue);
        this.edgeColorButton.setEnabled(enable && edgeValue);
        this.edgeSizeSlider.setEnabled(enable && edgeValue);
        this.labelEdgeColor.setEnabled(enable && edgeValue);
        this.labelEdgeFont.setEnabled(enable && edgeValue);
        this.labelEdgeSize.setEnabled(enable && edgeValue);
        boolean nodeValue = model.isShowNodeLabels();
        this.nodeFontButton.setEnabled(enable && nodeValue);
        this.nodeColorButton.setEnabled(enable && nodeValue);
        this.nodeSizeSlider.setEnabled(enable && nodeValue);
        this.labelNodeColor.setEnabled(enable && nodeValue);
        this.labelNodeFont.setEnabled(enable && nodeValue);
        this.labelNodeSize.setEnabled(enable && nodeValue);
    }

    private void initComponents() {
        this.nodePanel = new JPanel();
        this.showNodeLabelsCheckbox = new JCheckBox();
        this.labelNodeFont = new JLabel();
        this.nodeSizeSlider = new JSlider();
        this.labelNodeColor = new JLabel();
        this.nodeColorButton = new JColorButton(Color.BLACK);
        this.labelNodeSize = new JLabel();
        this.nodeFontButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.edgePanel = new JPanel();
        this.showEdgeLabelsCheckbox = new JCheckBox();
        this.labelEdgeFont = new JLabel();
        this.edgeFontButton = new JButton();
        this.labelEdgeColor = new JLabel();
        this.edgeColorButton = new JColorButton(Color.BLACK);
        this.edgeSizeSlider = new JSlider();
        this.labelEdgeSize = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.labelSizeMode = new JLabel();
        this.sizeModeCombo = new JComboBox();
        this.labelColorMode = new JLabel();
        this.colorModeCombo = new JComboBox();
        this.hideNonSelectedCheckbox = new JCheckBox();
        this.configureLabelsButton = new JButton();
        this.nodePanel.setOpaque(false);
        this.showNodeLabelsCheckbox.setText(NbBundle.getMessage(LabelSettingsPanel.class, (String)"LabelSettingsPanel.showNodeLabelsCheckbox.text"));
        this.showNodeLabelsCheckbox.setBorder(null);
        this.showNodeLabelsCheckbox.setHorizontalAlignment(2);
        this.showNodeLabelsCheckbox.setHorizontalTextPosition(2);
        this.showNodeLabelsCheckbox.setMargin(new Insets(2, 0, 2, 2));
        this.labelNodeFont.setText(NbBundle.getMessage(LabelSettingsPanel.class, (String)"LabelSettingsPanel.labelNodeFont.text"));
        this.labelNodeFont.setMaximumSize(new Dimension(60, 15));
        this.labelNodeColor.setText(NbBundle.getMessage(LabelSettingsPanel.class, (String)"LabelSettingsPanel.labelNodeColor.text"));
        this.nodeColorButton.setText(NbBundle.getMessage(LabelSettingsPanel.class, (String)"LabelSettingsPanel.nodeColorButton.text"));
        this.nodeColorButton.setMargin(new Insets(1, 0, 1, 0));
        this.labelNodeSize.setText(NbBundle.getMessage(LabelSettingsPanel.class, (String)"LabelSettingsPanel.labelNodeSize.text"));
        this.nodeFontButton.setText(NbBundle.getMessage(LabelSettingsPanel.class, (String)"LabelSettingsPanel.nodeFontButton.text"));
        GroupLayout nodePanelLayout = new GroupLayout(this.nodePanel);
        this.nodePanel.setLayout(nodePanelLayout);
        nodePanelLayout.setHorizontalGroup(nodePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(nodePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.showNodeLabelsCheckbox, -2, 97, -2).addContainerGap(163, Short.MAX_VALUE)).addGroup(nodePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(nodePanelLayout.createSequentialGroup().addGap(27, 27, 27).addGroup(nodePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(nodePanelLayout.createSequentialGroup().addComponent(this.labelNodeSize).addGap(18, 18, 18).addComponent(this.nodeSizeSlider, 0, 0, Short.MAX_VALUE)).addGroup(nodePanelLayout.createSequentialGroup().addComponent(this.labelNodeFont, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nodeFontButton).addGap(23, 23, 23).addComponent(this.labelNodeColor).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.nodeColorButton, -2, 26, -2))).addContainerGap())));
        nodePanelLayout.setVerticalGroup(nodePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(nodePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.showNodeLabelsCheckbox).addContainerGap(112, Short.MAX_VALUE)).addGroup(nodePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(nodePanelLayout.createSequentialGroup().addGap(31, 31, 31).addGroup(nodePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelNodeFont, -2, -1, -2).addComponent(this.labelNodeColor).addComponent(this.nodeColorButton).addComponent(this.nodeFontButton)).addGroup(nodePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(nodePanelLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.labelNodeSize)).addGroup(nodePanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nodeSizeSlider, -2, 34, -2))).addContainerGap(50, Short.MAX_VALUE))));
        this.jSeparator1.setOrientation(1);
        this.edgePanel.setOpaque(false);
        this.showEdgeLabelsCheckbox.setText(NbBundle.getMessage(LabelSettingsPanel.class, (String)"LabelSettingsPanel.showEdgeLabelsCheckbox.text"));
        this.showEdgeLabelsCheckbox.setBorder(null);
        this.showEdgeLabelsCheckbox.setHorizontalAlignment(2);
        this.showEdgeLabelsCheckbox.setHorizontalTextPosition(2);
        this.showEdgeLabelsCheckbox.setMargin(new Insets(2, 0, 2, 2));
        this.labelEdgeFont.setText(NbBundle.getMessage(LabelSettingsPanel.class, (String)"LabelSettingsPanel.labelEdgeFont.text"));
        this.labelEdgeFont.setMaximumSize(new Dimension(60, 15));
        this.edgeFontButton.setText(NbBundle.getMessage(LabelSettingsPanel.class, (String)"LabelSettingsPanel.edgeFontButton.text"));
        this.labelEdgeColor.setText(NbBundle.getMessage(LabelSettingsPanel.class, (String)"LabelSettingsPanel.labelEdgeColor.text"));
        this.edgeColorButton.setText(NbBundle.getMessage(LabelSettingsPanel.class, (String)"LabelSettingsPanel.edgeColorButton.text"));
        this.edgeColorButton.setMargin(new Insets(1, 0, 1, 0));
        this.labelEdgeSize.setText(NbBundle.getMessage(LabelSettingsPanel.class, (String)"LabelSettingsPanel.labelEdgeSize.text"));
        GroupLayout edgePanelLayout = new GroupLayout(this.edgePanel);
        this.edgePanel.setLayout(edgePanelLayout);
        edgePanelLayout.setHorizontalGroup(edgePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(edgePanelLayout.createSequentialGroup().addContainerGap().addGroup(edgePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(edgePanelLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(edgePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(edgePanelLayout.createSequentialGroup().addComponent(this.labelEdgeSize).addGap(18, 18, 18).addComponent(this.edgeSizeSlider, 0, 0, Short.MAX_VALUE)).addGroup(edgePanelLayout.createSequentialGroup().addComponent(this.labelEdgeFont, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.edgeFontButton).addGap(23, 23, 23).addComponent(this.labelEdgeColor).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.edgeColorButton, -2, 26, -2)))).addComponent(this.showEdgeLabelsCheckbox, -2, 97, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        edgePanelLayout.setVerticalGroup(edgePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(edgePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.showEdgeLabelsCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(edgePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelEdgeFont, -2, -1, -2).addComponent(this.labelEdgeColor).addComponent(this.edgeColorButton).addComponent(this.edgeFontButton)).addGroup(edgePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(edgePanelLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.labelEdgeSize)).addGroup(edgePanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.edgeSizeSlider, -2, 34, -2))).addContainerGap(51, Short.MAX_VALUE)));
        this.jSeparator2.setOrientation(1);
        this.labelSizeMode.setText(NbBundle.getMessage(LabelSettingsPanel.class, (String)"LabelSettingsPanel.labelSizeMode.text"));
        this.sizeModeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.labelColorMode.setText(NbBundle.getMessage(LabelSettingsPanel.class, (String)"LabelSettingsPanel.labelColorMode.text"));
        this.colorModeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.hideNonSelectedCheckbox.setText(NbBundle.getMessage(LabelSettingsPanel.class, (String)"LabelSettingsPanel.hideNonSelectedCheckbox.text"));
        this.hideNonSelectedCheckbox.setBorder(null);
        this.hideNonSelectedCheckbox.setHorizontalTextPosition(2);
        this.hideNonSelectedCheckbox.setMargin(new Insets(2, 0, 2, 2));
        this.configureLabelsButton.setFont(new Font("Tahoma", 0, 10));
        this.configureLabelsButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/visualization/component/configureLabels.png")));
        this.configureLabelsButton.setText(NbBundle.getMessage(LabelSettingsPanel.class, (String)"LabelSettingsPanel.configureLabelsButton.text"));
        this.configureLabelsButton.setBorder(null);
        this.configureLabelsButton.setMargin(new Insets(2, 7, 2, 7));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.nodePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.edgePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hideNonSelectedCheckbox).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelColorMode).addComponent(this.labelSizeMode)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.colorModeCombo, 0, -1, Short.MAX_VALUE).addComponent(this.sizeModeCombo, 0, 91, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 31, Short.MAX_VALUE).addComponent(this.configureLabelsButton, -2, 93, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 136, Short.MAX_VALUE).addComponent(this.nodePanel, -1, -1, Short.MAX_VALUE).addComponent(this.edgePanel, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator2, -1, 136, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sizeModeCombo, -2, -1, -2).addComponent(this.labelSizeMode)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.colorModeCombo, -2, -1, -2).addComponent(this.labelColorMode)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.hideNonSelectedCheckbox).addContainerGap(44, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.configureLabelsButton, -2, 46, -2).addContainerGap(84, Short.MAX_VALUE)));
    }
}

