/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.plugins.ObjectConfigurationAction;
import org.gradle.api.plugins.PluginAware;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.TextResourceScriptSource;
import org.gradle.internal.resource.TextResource;
import org.gradle.internal.resource.TextResourceLoader;
import org.gradle.util.GUtil;

public class DefaultObjectConfigurationAction
implements ObjectConfigurationAction {
    private final FileResolver resolver;
    private final ScriptPluginFactory configurerFactory;
    private final ScriptHandlerFactory scriptHandlerFactory;
    private final Set<Object> targets = new LinkedHashSet<Object>();
    private final Set<Runnable> actions = new LinkedHashSet<Runnable>();
    private final ClassLoaderScope classLoaderScope;
    private final TextResourceLoader resourceLoader;
    private final Object defaultTarget;

    public DefaultObjectConfigurationAction(FileResolver resolver, ScriptPluginFactory configurerFactory, ScriptHandlerFactory scriptHandlerFactory, ClassLoaderScope classLoaderScope, TextResourceLoader resourceLoader, Object defaultTarget) {
        this.resolver = resolver;
        this.configurerFactory = configurerFactory;
        this.scriptHandlerFactory = scriptHandlerFactory;
        this.classLoaderScope = classLoaderScope;
        this.resourceLoader = resourceLoader;
        this.defaultTarget = defaultTarget;
    }

    public ObjectConfigurationAction to(Object ... targets) {
        GUtil.flatten((Object[])targets, this.targets);
        return this;
    }

    public ObjectConfigurationAction from(final Object script) {
        this.actions.add(new Runnable(){

            @Override
            public void run() {
                DefaultObjectConfigurationAction.this.applyScript(script);
            }
        });
        return this;
    }

    public ObjectConfigurationAction plugin(final Class<? extends Plugin> pluginClass) {
        this.actions.add(new Runnable(){

            @Override
            public void run() {
                DefaultObjectConfigurationAction.this.applyPlugin(pluginClass);
            }
        });
        return this;
    }

    public ObjectConfigurationAction plugin(final String pluginId) {
        this.actions.add(new Runnable(){

            @Override
            public void run() {
                DefaultObjectConfigurationAction.this.applyType(pluginId);
            }
        });
        return this;
    }

    public ObjectConfigurationAction type(final Class<?> pluginClass) {
        this.actions.add(new Runnable(){

            @Override
            public void run() {
                DefaultObjectConfigurationAction.this.applyType(pluginClass);
            }
        });
        return this;
    }

    private void applyScript(Object script) {
        URI scriptUri = this.resolver.resolveUri(script);
        TextResource resource = this.resourceLoader.loadUri("script", scriptUri);
        TextResourceScriptSource scriptSource = new TextResourceScriptSource(resource);
        ClassLoaderScope classLoaderScopeChild = this.classLoaderScope.createChild("script-" + scriptUri.toString());
        ScriptHandlerInternal scriptHandler = this.scriptHandlerFactory.create(scriptSource, classLoaderScopeChild);
        ScriptPlugin configurer = this.configurerFactory.create(scriptSource, scriptHandler, classLoaderScopeChild, this.classLoaderScope, false);
        for (Object target : this.targets) {
            configurer.apply(target);
        }
    }

    private void applyPlugin(Class<? extends Plugin> pluginClass) {
        this.applyType(pluginClass);
    }

    private void applyType(String pluginId) {
        for (Object target : this.targets) {
            if (target instanceof PluginAware) {
                ((PluginAware)target).getPluginManager().apply(pluginId);
                continue;
            }
            throw new UnsupportedOperationException(String.format("Cannot apply plugin with id '%s' to '%s' (class: %s) as it does not implement PluginAware", pluginId, target.toString(), target.getClass().getName()));
        }
    }

    private void applyType(Class<?> pluginClass) {
        for (Object target : this.targets) {
            if (target instanceof PluginAware) {
                ((PluginAware)target).getPluginManager().apply(pluginClass);
                continue;
            }
            throw new UnsupportedOperationException(String.format("Cannot apply plugin of class '%s' to '%s' (class: %s) as it does not implement PluginAware", pluginClass.getName(), target.toString(), target.getClass().getName()));
        }
    }

    public void execute() {
        if (this.targets.isEmpty()) {
            this.to(this.defaultTarget);
        }
        for (Runnable action : this.actions) {
            action.run();
        }
    }
}

