/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.DefaultNestedBuild;
import org.gradle.composite.internal.DefaultRootBuildState;
import org.gradle.composite.internal.IncludedBuildDependencySubstitutionsBuilder;
import org.gradle.composite.internal.IncludedBuildFactory;
import org.gradle.composite.internal.RootOfNestedBuildTree;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.NestedRootBuild;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.service.scopes.BuildTreeScopeServices;
import org.gradle.internal.text.TreeFormatter;
import org.gradle.util.Path;

public class DefaultIncludedBuildRegistry
implements BuildStateRegistry,
Stoppable {
    private final IncludedBuildFactory includedBuildFactory;
    private final ProjectStateRegistry projectRegistry;
    private final IncludedBuildDependencySubstitutionsBuilder dependencySubstitutionsBuilder;
    private final GradleLauncherFactory gradleLauncherFactory;
    private final ListenerManager listenerManager;
    private final BuildTreeScopeServices rootServices;
    private RootBuildState rootBuild;
    private final Map<BuildIdentifier, BuildState> builds = Maps.newHashMap();
    private final Map<File, IncludedBuildState> includedBuilds = Maps.newLinkedHashMap();
    private final List<IncludedBuildState> pendingIncludedBuilds = Lists.newArrayList();

    public DefaultIncludedBuildRegistry(IncludedBuildFactory includedBuildFactory, ProjectStateRegistry projectRegistry, IncludedBuildDependencySubstitutionsBuilder dependencySubstitutionsBuilder, GradleLauncherFactory gradleLauncherFactory, ListenerManager listenerManager, BuildTreeScopeServices rootServices) {
        this.includedBuildFactory = includedBuildFactory;
        this.projectRegistry = projectRegistry;
        this.dependencySubstitutionsBuilder = dependencySubstitutionsBuilder;
        this.gradleLauncherFactory = gradleLauncherFactory;
        this.listenerManager = listenerManager;
        this.rootServices = rootServices;
    }

    public RootBuildState getRootBuild() {
        if (this.rootBuild == null) {
            throw new IllegalStateException("Root build is not defined.");
        }
        return this.rootBuild;
    }

    public RootBuildState createRootBuild(BuildDefinition buildDefinition) {
        if (this.rootBuild != null) {
            throw new IllegalStateException("Root build already defined.");
        }
        this.rootBuild = new DefaultRootBuildState(buildDefinition, this.gradleLauncherFactory, this.listenerManager, this.rootServices);
        this.addBuild((BuildState)this.rootBuild);
        return this.rootBuild;
    }

    public void attachRootBuild(RootBuildState rootBuild) {
        if (this.rootBuild != null) {
            throw new IllegalStateException("Root build already defined.");
        }
        this.rootBuild = rootBuild;
        this.addBuild((BuildState)rootBuild);
    }

    private void addBuild(BuildState build) {
        BuildState before = this.builds.put(build.getBuildIdentifier(), build);
        if (before != null) {
            throw new IllegalArgumentException("Build is already registered: " + build.getBuildIdentifier());
        }
    }

    public boolean hasIncludedBuilds() {
        return !this.includedBuilds.isEmpty();
    }

    public Collection<IncludedBuildState> getIncludedBuilds() {
        return this.includedBuilds.values();
    }

    public IncludedBuildState addIncludedBuild(BuildDefinition buildDefinition) {
        return this.registerBuild(buildDefinition, false);
    }

    public IncludedBuildState getIncludedBuild(BuildIdentifier buildIdentifier) {
        BuildState includedBuildState = this.builds.get(buildIdentifier);
        if (!(includedBuildState instanceof IncludedBuildState)) {
            throw new IllegalArgumentException("Could not find " + buildIdentifier);
        }
        return (IncludedBuildState)includedBuildState;
    }

    public BuildState getBuild(BuildIdentifier buildIdentifier) {
        BuildState buildState = this.builds.get(buildIdentifier);
        if (buildState == null) {
            throw new IllegalArgumentException("Could not find " + buildIdentifier);
        }
        return buildState;
    }

    public void beforeConfigureRootBuild() {
        this.registerSubstitutions(this.includedBuilds.values());
    }

    public void finalizeIncludedBuilds() {
        SettingsInternal settings = this.getRootBuild().getLoadedSettings();
        LinkedHashMultimap names = LinkedHashMultimap.create();
        while (!this.pendingIncludedBuilds.isEmpty()) {
            IncludedBuildState build = this.pendingIncludedBuilds.remove(0);
            build.loadSettings();
            String buildName = build.getName();
            names.put((Object)buildName, (Object)build);
            if (settings.getRootProject().getName().equals(buildName)) {
                throw new GradleException("Included build in " + build.getRootDirectory() + " has the same root project name '" + buildName + "' as the main build.");
            }
            if (settings.findProject(":" + buildName) == null) continue;
            throw new GradleException("Included build in " + build.getRootDirectory() + " has a root project whose name '" + buildName + "' is the same as a project of the main build.");
        }
        for (String buildNAme : names.keySet()) {
            Set buildsWithName = names.get((Object)buildNAme);
            if (buildsWithName.size() <= 1) continue;
            TreeFormatter visitor = new TreeFormatter();
            visitor.node("Multiple included builds have the same root project name '" + buildNAme + "'");
            visitor.startChildren();
            for (IncludedBuildState build : buildsWithName) {
                visitor.node("Included build in " + build.getRootDirectory());
            }
            visitor.endChildren();
            throw new GradleException(visitor.toString());
        }
    }

    private void registerSubstitutions(Iterable<IncludedBuildState> includedBuilds) {
        for (IncludedBuildState includedBuild : includedBuilds) {
            this.dependencySubstitutionsBuilder.build(includedBuild);
        }
    }

    public synchronized IncludedBuildState addImplicitIncludedBuild(BuildDefinition buildDefinition) {
        IncludedBuildState includedBuild = this.includedBuilds.get(buildDefinition.getBuildRootDir());
        if (includedBuild == null) {
            includedBuild = this.registerBuild(buildDefinition, true);
        }
        return includedBuild;
    }

    public StandAloneNestedBuild addNestedBuild(BuildDefinition buildDefinition, BuildState owner) {
        if (buildDefinition.getName() == null) {
            throw new UnsupportedOperationException("Not yet implemented.");
        }
        BuildIdentifier buildIdentifier = this.idFor(buildDefinition.getName());
        Path identityPath = this.pathFor(owner, buildIdentifier.getName());
        DefaultNestedBuild build = new DefaultNestedBuild(buildIdentifier, identityPath, buildDefinition, owner);
        this.addBuild((BuildState)build);
        return build;
    }

    public NestedRootBuild addNestedBuildTree(BuildDefinition buildDefinition, BuildState owner) {
        if (buildDefinition.getName() != null || buildDefinition.getBuildRootDir() != null) {
            throw new UnsupportedOperationException("Not yet implemented.");
        }
        BuildIdentifier buildIdentifier = this.idFor(buildDefinition.getStartParameter().getCurrentDir().getName());
        Path identityPath = this.pathFor(owner, buildIdentifier.getName());
        return new RootOfNestedBuildTree(buildDefinition, buildIdentifier, identityPath, owner);
    }

    private IncludedBuildState registerBuild(BuildDefinition buildDefinition, boolean isImplicit) {
        if (buildDefinition.getBuildRootDir() == null) {
            throw new IllegalArgumentException("Included build must have a root directory defined");
        }
        if (this.rootBuild == null) {
            throw new IllegalStateException("No root build attached yet.");
        }
        IncludedBuildState includedBuild = this.includedBuilds.get(buildDefinition.getBuildRootDir());
        if (includedBuild == null) {
            String buildName = buildDefinition.getBuildRootDir().getName();
            BuildIdentifier buildIdentifier = this.idFor(buildName);
            Path idPath = this.pathFor((BuildState)this.rootBuild, buildIdentifier.getName());
            includedBuild = this.includedBuildFactory.createBuild(buildIdentifier, idPath, buildDefinition, isImplicit, (BuildState)this.rootBuild);
            this.includedBuilds.put(buildDefinition.getBuildRootDir(), includedBuild);
            this.pendingIncludedBuilds.add(includedBuild);
            this.addBuild((BuildState)includedBuild);
        } else if (includedBuild.isImplicitBuild() != isImplicit) {
            throw new IllegalStateException("Unexpected state for build.");
        }
        return includedBuild;
    }

    private BuildIdentifier idFor(String buildName) {
        DefaultBuildIdentifier buildIdentifier = new DefaultBuildIdentifier(buildName);
        int count = 1;
        while (this.builds.containsKey(buildIdentifier)) {
            buildIdentifier = new DefaultBuildIdentifier(buildName + ":" + count);
            ++count;
        }
        return buildIdentifier;
    }

    private Path pathFor(BuildState owner, String name) {
        return owner.getIdentityPath().append(Path.path((String)name));
    }

    public void stop() {
        CompositeStoppable.stoppable(this.builds.values()).stop();
    }
}

