/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;
import org.gradle.internal.resource.ExternalResourceName;

public class DefaultResourceAwareResolveResult
implements ResourceAwareResolveResult {
    private final Set<String> attempted = Sets.newLinkedHashSet();

    @Override
    public List<String> getAttempted() {
        return ImmutableList.copyOf(this.attempted);
    }

    @Override
    public void attempted(String locationDescription) {
        this.attempted.add(locationDescription);
    }

    @Override
    public void attempted(ExternalResourceName location) {
        this.attempted(location.getDisplayName());
    }

    @Override
    public void applyTo(ResourceAwareResolveResult target) {
        for (String location : this.attempted) {
            target.attempted(location);
        }
    }
}

