/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl.steps;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.file.FileCollection;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.impl.steps.Context;
import org.gradle.internal.execution.impl.steps.Step;
import org.gradle.internal.file.TreeType;
import org.gradle.util.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateOutputsStep<C extends Context, R extends Result>
implements Step<C, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateOutputsStep.class);
    private final Step<? super C, ? extends R> delegate;

    public CreateOutputsStep(Step<? super C, ? extends R> delegate) {
        this.delegate = delegate;
    }

    @Override
    public R execute(C context) {
        context.getWork().visitOutputs(new UnitOfWork.OutputVisitor(){

            @Override
            public void visitOutput(String name, TreeType type, FileCollection roots) {
                for (File root : roots) {
                    CreateOutputsStep.ensureOutput(name, root, type);
                }
            }
        });
        return this.delegate.execute(context);
    }

    private static void ensureOutput(String name, @Nullable File outputRoot, TreeType type) {
        if (outputRoot == null) {
            LOGGER.debug("Not ensuring directory exists for property {}, because value is null", (Object)name);
            return;
        }
        switch (type) {
            case DIRECTORY: {
                LOGGER.debug("Ensuring directory exists for property {} at {}", (Object)name, (Object)outputRoot);
                GFileUtils.mkdirs((File)outputRoot);
                break;
            }
            case FILE: {
                LOGGER.debug("Ensuring parent directory exists for property {} at {}", (Object)name, (Object)outputRoot);
                GFileUtils.mkdirs((File)outputRoot.getParentFile());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }
}

