/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.jvm.checkers.JavaNullabilityChecker;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypeWithEnhancement;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.SenselessComparisonChecker;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J,\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016Jf\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a26\u0010\u001b\u001a2\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00040\u001cH\u0002JI\u0010 \u001a\u0004\u0018\u0001H!\"\b\b\u0000\u0010!*\u00020\"2\u0006\u0010#\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00132\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H!0\u0017H\u0002\u00a2\u0006\u0002\u0010%J\f\u0010&\u001a\u00020'*\u00020(H\u0002J\f\u0010)\u001a\u00020'*\u00020\u0011H\u0002J\u000e\u0010*\u001a\u0004\u0018\u00010'*\u00020\u0011H\u0002J\u000e\u0010+\u001a\u0004\u0018\u00010'*\u00020\u0011H\u0002\u00a8\u0006-\u00b2\u0006\n\u0010\u0016\u001a\u00020\u0018X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaNullabilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkReceiver", "", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverArgument", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "safeAccess", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "checkType", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "doCheckType", "expectedType", "dataFlowValue", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "reportWarning", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "actualType", "doIfNotNull", "T", "", "type", "body", "(Lorg/jetbrains/kotlin/types/KotlinType;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "enhancementFromJava", "Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaNullabilityChecker$EnhancedNullabilityInfo;", "Lorg/jetbrains/kotlin/types/TypeWithEnhancement;", "enhancementFromKotlin", "mayBeNull", "mustNotBeNull", "EnhancedNullabilityInfo", "frontend.java"})
public final class JavaNullabilityChecker
implements AdditionalTypeChecker {
    static final /* synthetic */ KProperty[] $$delegatedProperties;

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property0(new PropertyReference0Impl(Reflection.getOrCreateKotlinClass(JavaNullabilityChecker.class), "dataFlowValue", "<v#0>"))};
    }

    @Override
    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        IElementType iElementType;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(expressionType, "expressionType");
        Intrinsics.checkParameterIsNotNull(expressionTypeWithSmartCast, "expressionTypeWithSmartCast");
        Intrinsics.checkParameterIsNotNull(c, "c");
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "c.expectedType");
        Function0 function0 = new Function0<DataFlowValue>(c, expression2, expressionType){
            final /* synthetic */ ResolutionContext $c;
            final /* synthetic */ KtExpression $expression;
            final /* synthetic */ KotlinType $expressionType;

            @NotNull
            public final DataFlowValue invoke() {
                return this.$c.dataFlowValueFactory.createDataFlowValue(this.$expression, this.$expressionType, this.$c);
            }
            {
                this.$c = resolutionContext;
                this.$expression = ktExpression;
                this.$expressionType = kotlinType;
                super(0);
            }
        };
        DataFlowInfo dataFlowInfo = c.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "c.dataFlowInfo");
        this.doCheckType(expressionType, kotlinType, function0, dataFlowInfo, (Function2<? super KotlinType, ? super KotlinType, Unit>)new Function2<KotlinType, KotlinType, Unit>(c, expression2){
            final /* synthetic */ ResolutionContext $c;
            final /* synthetic */ KtExpression $expression;

            public final void invoke(@NotNull KotlinType expectedType, @NotNull KotlinType actualType) {
                Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
                Intrinsics.checkParameterIsNotNull(actualType, "actualType");
                this.$c.trace.report(ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((KtElement)((PsiElement)this.$expression), expectedType, actualType));
            }
            {
                this.$c = resolutionContext;
                this.$expression = ktExpression;
                super(2);
            }
        });
        KtExpression ktExpression = expression2;
        if (ktExpression instanceof KtWhenExpression) {
            if (((KtWhenExpression)expression2).getElseExpression() == null) {
                KtExpression ktExpression2 = ((KtWhenExpression)expression2).getSubjectExpression();
                if (ktExpression2 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "expression.subjectExpression ?: return");
                KtExpression subjectExpression = ktExpression2;
                KotlinType kotlinType2 = c.trace.getType(subjectExpression);
                if (kotlinType2 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "c.trace.getType(subjectExpression) ?: return");
                KotlinType type2 = kotlinType2;
                if (FlexibleTypesKt.isFlexible(type2) && TypeUtils.isNullableType(FlexibleTypesKt.asFlexibleType(type2).getUpperBound())) {
                    ClassDescriptor classDescriptor2 = WhenChecker.getClassDescriptorOfTypeIfEnum(type2);
                    if (classDescriptor2 == null) {
                        return;
                    }
                    ClassDescriptor enumClassDescriptor = classDescriptor2;
                    BindingTrace bindingTrace = c.trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.trace");
                    BindingContext bindingContext = bindingTrace.getBindingContext();
                    Intrinsics.checkExpressionValueIsNotNull(bindingContext, "c.trace.bindingContext");
                    BindingContext context = bindingContext;
                    if (WhenChecker.getEnumMissingCases((KtWhenExpression)expression2, context, enumClassDescriptor).isEmpty() && !WhenChecker.INSTANCE.containsNullCase((KtWhenExpression)expression2, context)) {
                        DataFlowInfo dataFlowInfo2;
                        DataFlowValue subjectDataFlowValue = c.dataFlowValueFactory.createDataFlowValue(subjectExpression, type2, c);
                        KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)c.trace.get(BindingContext.EXPRESSION_TYPE_INFO, subjectExpression);
                        DataFlowInfo dataFlowInfo3 = dataFlowInfo2 = kotlinTypeInfo != null ? kotlinTypeInfo.getDataFlowInfo() : null;
                        if (dataFlowInfo2 != null && !dataFlowInfo2.getStableNullability(subjectDataFlowValue).canBeNull()) {
                            return;
                        }
                        BindingTrace bindingTrace2 = c.trace;
                        KtExpression ktExpression3 = ((KtWhenExpression)expression2).getSubjectExpression();
                        if (ktExpression3 == null) {
                            Intrinsics.throwNpe();
                        }
                        bindingTrace2.report(ErrorsJvm.WHEN_ENUM_CAN_BE_NULL_IN_JAVA.on((KtExpression)((PsiElement)ktExpression3)));
                    }
                }
            }
        } else if (ktExpression instanceof KtPostfixExpression) {
            if (Intrinsics.areEqual(((KtPostfixExpression)expression2).getOperationToken(), KtTokens.EXCLEXCL)) {
                KtExpression ktExpression4 = ((KtPostfixExpression)expression2).getBaseExpression();
                if (ktExpression4 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull(ktExpression4, "expression.baseExpression ?: return");
                KtExpression baseExpression = ktExpression4;
                KotlinType kotlinType3 = c.trace.getType(baseExpression);
                if (kotlinType3 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "c.trace.getType(baseExpression) ?: return");
                KotlinType baseExpressionType = kotlinType3;
                this.doIfNotNull(baseExpressionType, new Function0<DataFlowValue>(c, baseExpression, baseExpressionType){
                    final /* synthetic */ ResolutionContext $c;
                    final /* synthetic */ KtExpression $baseExpression;
                    final /* synthetic */ KotlinType $baseExpressionType;

                    @NotNull
                    public final DataFlowValue invoke() {
                        return this.$c.dataFlowValueFactory.createDataFlowValue(this.$baseExpression, this.$baseExpressionType, this.$c);
                    }
                    {
                        this.$c = resolutionContext;
                        this.$baseExpression = ktExpression;
                        this.$baseExpressionType = kotlinType;
                        super(0);
                    }
                }, c, (Function0)new Function0<Unit>(c, expression2, baseExpressionType){
                    final /* synthetic */ ResolutionContext $c;
                    final /* synthetic */ KtExpression $expression;
                    final /* synthetic */ KotlinType $baseExpressionType;

                    public final void invoke() {
                        this.$c.trace.report(Errors.UNNECESSARY_NOT_NULL_ASSERTION.on(((KtPostfixExpression)this.$expression).getOperationReference(), this.$baseExpressionType));
                    }
                    {
                        this.$c = resolutionContext;
                        this.$expression = ktExpression;
                        this.$baseExpressionType = kotlinType;
                        super(0);
                    }
                });
            }
        } else if (ktExpression instanceof KtBinaryExpression && (Intrinsics.areEqual(iElementType = ((KtBinaryExpression)expression2).getOperationToken(), KtTokens.EQEQ) || Intrinsics.areEqual(iElementType, KtTokens.EXCLEQ) || Intrinsics.areEqual(iElementType, KtTokens.EQEQEQ) || Intrinsics.areEqual(iElementType, KtTokens.EXCLEQEQEQ)) && ((KtBinaryExpression)expression2).getLeft() != null && ((KtBinaryExpression)expression2).getRight() != null) {
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)expression2;
            KtExpression ktExpression5 = ((KtBinaryExpression)expression2).getLeft();
            if (ktExpression5 == null) {
                Intrinsics.throwNpe();
            }
            KtExpression ktExpression6 = ((KtBinaryExpression)expression2).getRight();
            if (ktExpression6 == null) {
                Intrinsics.throwNpe();
            }
            SenselessComparisonChecker.checkSenselessComparisonWithNull(ktBinaryExpression, ktExpression5, ktExpression6, c, (Function1<? super KtExpression, ? extends KotlinType>)new Function1<KtExpression, KotlinType>(c){
                final /* synthetic */ ResolutionContext $c;

                @Nullable
                public final KotlinType invoke(@NotNull KtExpression it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    return this.$c.trace.getType(it);
                }
                {
                    this.$c = resolutionContext;
                    super(1);
                }
            }, (Function1<? super DataFlowValue, ? extends Nullability>)new Function1<DataFlowValue, Nullability>(this, c){
                final /* synthetic */ JavaNullabilityChecker this$0;
                final /* synthetic */ ResolutionContext $c;

                @NotNull
                public final Nullability invoke(@NotNull DataFlowValue value) {
                    Intrinsics.checkParameterIsNotNull(value, "value");
                    Nullability nullability = (Nullability)((Object)JavaNullabilityChecker.access$doIfNotNull(this.this$0, value.getType(), new Function0<DataFlowValue>(value){
                        final /* synthetic */ DataFlowValue $value;

                        @NotNull
                        public final DataFlowValue invoke() {
                            return this.$value;
                        }
                        {
                            this.$value = dataFlowValue2;
                            super(0);
                        }
                    }, this.$c, checkType.2.INSTANCE));
                    if (nullability == null) {
                        nullability = Nullability.UNKNOWN;
                    }
                    return nullability;
                }
                {
                    this.this$0 = javaNullabilityChecker;
                    this.$c = resolutionContext;
                    super(1);
                }
            });
        }
    }

    @Override
    public void checkReceiver(@NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, boolean safeAccess, @NotNull CallResolutionContext<?> c) {
        Intrinsics.checkParameterIsNotNull(receiverParameter, "receiverParameter");
        Intrinsics.checkParameterIsNotNull(receiverArgument, "receiverArgument");
        Intrinsics.checkParameterIsNotNull(c, "c");
        KProperty kProperty = $$delegatedProperties[0];
        Lazy dataFlowValue2 = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)new Function0<DataFlowValue>(c, receiverArgument){
            final /* synthetic */ CallResolutionContext $c;
            final /* synthetic */ ReceiverValue $receiverArgument;

            @NotNull
            public final DataFlowValue invoke() {
                return this.$c.dataFlowValueFactory.createDataFlowValue(this.$receiverArgument, this.$c);
            }
            {
                this.$c = callResolutionContext;
                this.$receiverArgument = receiverValue;
                super(0);
            }
        });
        if (safeAccess) {
            Call call2 = c.call;
            Intrinsics.checkExpressionValueIsNotNull(call2, "c.call");
            UserDataHolder userDataHolder = call2.getCallOperationNode();
            if (userDataHolder == null || (userDataHolder = userDataHolder.getPsi()) == null) {
                return;
            }
            UserDataHolder safeAccessElement = userDataHolder;
            KotlinType kotlinType = receiverArgument.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiverArgument.type");
            this.doIfNotNull(kotlinType, new Function0<DataFlowValue>(dataFlowValue2, kProperty){
                final /* synthetic */ Lazy $dataFlowValue;
                final /* synthetic */ KProperty $dataFlowValue$metadata;

                @NotNull
                public final DataFlowValue invoke() {
                    Lazy lazy = this.$dataFlowValue;
                    Object var2_2 = null;
                    KProperty kProperty = this.$dataFlowValue$metadata;
                    return (DataFlowValue)lazy.getValue();
                }
                {
                    this.$dataFlowValue = lazy;
                    this.$dataFlowValue$metadata = kProperty;
                    super(0);
                }
            }, (ResolutionContext)c, (Function0)new Function0<Unit>(c, (PsiElement)safeAccessElement, receiverArgument){
                final /* synthetic */ CallResolutionContext $c;
                final /* synthetic */ PsiElement $safeAccessElement;
                final /* synthetic */ ReceiverValue $receiverArgument;

                public final void invoke() {
                    this.$c.trace.report(Errors.UNNECESSARY_SAFE_CALL.on(this.$safeAccessElement, this.$receiverArgument.getType()));
                }
                {
                    this.$c = callResolutionContext;
                    this.$safeAccessElement = psiElement;
                    this.$receiverArgument = receiverValue;
                    super(0);
                }
            });
            return;
        }
        KotlinType kotlinType = receiverArgument.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiverArgument.type");
        KotlinType kotlinType2 = receiverParameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "receiverParameter.type");
        Function0 function0 = new Function0<DataFlowValue>(dataFlowValue2, kProperty){
            final /* synthetic */ Lazy $dataFlowValue;
            final /* synthetic */ KProperty $dataFlowValue$metadata;

            @NotNull
            public final DataFlowValue invoke() {
                Lazy lazy = this.$dataFlowValue;
                Object var2_2 = null;
                KProperty kProperty = this.$dataFlowValue$metadata;
                return (DataFlowValue)lazy.getValue();
            }
            {
                this.$dataFlowValue = lazy;
                this.$dataFlowValue$metadata = kProperty;
                super(0);
            }
        };
        DataFlowInfo dataFlowInfo = c.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "c.dataFlowInfo");
        this.doCheckType(kotlinType, kotlinType2, function0, dataFlowInfo, (Function2<? super KotlinType, ? super KotlinType, Unit>)new Function2<KotlinType, KotlinType, Unit>(receiverArgument, c){
            final /* synthetic */ ReceiverValue $receiverArgument;
            final /* synthetic */ CallResolutionContext $c;

            public final void invoke(@NotNull KotlinType expectedType, @NotNull KotlinType actualType) {
                KtExpression receiverExpression;
                Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
                Intrinsics.checkParameterIsNotNull(actualType, "actualType");
                ReceiverValue receiverValue = this.$receiverArgument;
                if (!(receiverValue instanceof ExpressionReceiver)) {
                    receiverValue = null;
                }
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
                KtExpression ktExpression = receiverExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
                if (receiverExpression != null) {
                    this.$c.trace.report(ErrorsJvm.RECEIVER_NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((KtElement)((PsiElement)receiverExpression), actualType));
                } else {
                    KtElement ktElement;
                    Call call2 = this.$c.call;
                    Intrinsics.checkExpressionValueIsNotNull(call2, "c.call");
                    KtExpression ktExpression2 = call2.getCalleeExpression();
                    if (ktExpression2 != null) {
                        ktElement = ktExpression2;
                    } else {
                        Call call3 = this.$c.call;
                        Intrinsics.checkExpressionValueIsNotNull(call3, "c.call");
                        ktElement = call3.getCallElement();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(ktElement, "c.call.calleeExpression ?: c.call.callElement");
                    KtElement reportOn = ktElement;
                    this.$c.trace.report(ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((KtElement)((PsiElement)reportOn), expectedType, actualType));
                }
            }
            {
                this.$receiverArgument = receiverValue;
                this.$c = callResolutionContext;
                super(2);
            }
        });
    }

    private final void doCheckType(KotlinType expressionType, KotlinType expectedType, Function0<DataFlowValue> dataFlowValue2, DataFlowInfo dataFlowInfo, Function2<? super KotlinType, ? super KotlinType, Unit> reportWarning) {
        if (TypeUtils.noExpectedType(expectedType)) {
            return;
        }
        EnhancedNullabilityInfo enhancedNullabilityInfo = this.mustNotBeNull(expectedType);
        if (enhancedNullabilityInfo == null) {
            return;
        }
        EnhancedNullabilityInfo expectedMustNotBeNull = enhancedNullabilityInfo;
        EnhancedNullabilityInfo enhancedNullabilityInfo2 = this.mayBeNull(expressionType);
        if (enhancedNullabilityInfo2 == null) {
            return;
        }
        EnhancedNullabilityInfo actualMayBeNull = enhancedNullabilityInfo2;
        if (expectedMustNotBeNull.isFromKotlin() && actualMayBeNull.isFromKotlin()) {
            return;
        }
        if (dataFlowInfo.getStableNullability(dataFlowValue2.invoke()) != Nullability.NOT_NULL) {
            reportWarning.invoke(expectedMustNotBeNull.getEnhancedType(), actualMayBeNull.getEnhancedType());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final <T> T doIfNotNull(KotlinType type2, Function0<DataFlowValue> dataFlowValue2, ResolutionContext<?> c, Function0<? extends T> body) {
        T t;
        EnhancedNullabilityInfo enhancedNullabilityInfo = this.mustNotBeNull(type2);
        if (enhancedNullabilityInfo != null && enhancedNullabilityInfo.isFromJava() && c.dataFlowInfo.getStableNullability(dataFlowValue2.invoke()).canBeNull()) {
            t = body.invoke();
            return t;
        }
        t = null;
        return t;
    }

    private final EnhancedNullabilityInfo enhancementFromKotlin(@NotNull KotlinType $receiver) {
        return new EnhancedNullabilityInfo($receiver, false);
    }

    private final EnhancedNullabilityInfo enhancementFromJava(@NotNull TypeWithEnhancement $receiver) {
        return new EnhancedNullabilityInfo($receiver.getEnhancement(), true);
    }

    private final EnhancedNullabilityInfo mustNotBeNull(@NotNull KotlinType $receiver) {
        return !KotlinTypeKt.isError($receiver) && !FlexibleTypesKt.isFlexible($receiver) && !TypeUtils.acceptsNullable($receiver) ? this.enhancementFromKotlin($receiver) : (FlexibleTypesKt.isFlexible($receiver) && !TypeUtils.acceptsNullable(FlexibleTypesKt.asFlexibleType($receiver).getUpperBound()) ? this.enhancementFromKotlin($receiver) : ($receiver instanceof TypeWithEnhancement && this.mustNotBeNull(((TypeWithEnhancement)((Object)$receiver)).getEnhancement()) != null ? this.enhancementFromJava((TypeWithEnhancement)((Object)$receiver)) : null));
    }

    private final EnhancedNullabilityInfo mayBeNull(@NotNull KotlinType $receiver) {
        return !KotlinTypeKt.isError($receiver) && !FlexibleTypesKt.isFlexible($receiver) && TypeUtils.acceptsNullable($receiver) ? this.enhancementFromKotlin($receiver) : (FlexibleTypesKt.isFlexible($receiver) && TypeUtils.acceptsNullable(FlexibleTypesKt.asFlexibleType($receiver).getLowerBound()) ? this.enhancementFromKotlin($receiver) : ($receiver instanceof TypeWithEnhancement && this.mayBeNull(((TypeWithEnhancement)((Object)$receiver)).getEnhancement()) != null ? this.enhancementFromJava((TypeWithEnhancement)((Object)$receiver)) : null));
    }

    @Nullable
    public static final /* synthetic */ Object access$doIfNotNull(JavaNullabilityChecker $this, @NotNull KotlinType type2, @NotNull Function0 dataFlowValue2, @NotNull ResolutionContext c, @NotNull Function0 body) {
        return $this.doIfNotNull(type2, dataFlowValue2, c, body);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\tR\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaNullabilityChecker$EnhancedNullabilityInfo;", "", "enhancedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isFromJava", "", "(Lorg/jetbrains/kotlin/types/KotlinType;Z)V", "getEnhancedType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "()Z", "isFromKotlin", "frontend.java"})
    private static final class EnhancedNullabilityInfo {
        @NotNull
        private final KotlinType enhancedType;
        private final boolean isFromJava;

        public final boolean isFromKotlin() {
            return !this.isFromJava;
        }

        @NotNull
        public final KotlinType getEnhancedType() {
            return this.enhancedType;
        }

        public final boolean isFromJava() {
            return this.isFromJava;
        }

        public EnhancedNullabilityInfo(@NotNull KotlinType enhancedType, boolean isFromJava) {
            Intrinsics.checkParameterIsNotNull(enhancedType, "enhancedType");
            this.enhancedType = enhancedType;
            this.isFromJava = isFromJava;
        }
    }
}

