/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.log4j;

import javax.swing.SwingUtilities;
import org.apache.log4j.Level;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.view.ScanStatus;

public class ZapOutputWriter
extends WriterAppender {
    private static final char NEWLINE = '\n';
    private ScanStatus scanStatus = null;

    public ZapOutputWriter(ScanStatus scanStatus) {
        if (!View.isInitialised()) {
            throw new IllegalStateException("View must be initialised.");
        }
        if (scanStatus == null) {
            throw new IllegalArgumentException("The parameter scanStatus must not be null.");
        }
        this.scanStatus = scanStatus;
    }

    public void append(final LoggingEvent event) {
        if (event.getLevel().equals((Object)Level.ERROR)) {
            String[] tsr;
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ZapOutputWriter.this.append(event);
                    }
                });
                return;
            }
            this.scanStatus.incScanCount();
            String renderedmessage = event.getRenderedMessage();
            if (renderedmessage != null) {
                View.getSingleton().getOutputPanel().append(renderedmessage + '\n');
            }
            if ((tsr = event.getThrowableStrRep()) != null) {
                StringBuilder eventThrowableStrRep = new StringBuilder(tsr.length * 75);
                for (String str : tsr) {
                    eventThrowableStrRep.append(str).append('\n');
                }
                View.getSingleton().getOutputPanel().append(eventThrowableStrRep.toString());
            }
        }
    }
}

