/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import IceInternal.Connector;
import IceInternal.HashUtil;
import IceInternal.Network;
import IceInternal.ProtocolInstance;
import IceInternal.Transceiver;
import IceInternal.UdpMulticastClientTransceiver;
import IceInternal.UdpTransceiver;
import IceInternal.Util;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;

final class UdpConnector
implements Connector {
    private ProtocolInstance _instance;
    private InetSocketAddress _addr;
    private InetSocketAddress _sourceAddr;
    private String _mcastInterface;
    private int _mcastTtl;
    private String _connectionId;
    private int _hashCode;

    @Override
    public Transceiver connect() {
        if (Util.isAndroid() && this._addr.getAddress().isMulticastAddress()) {
            return new UdpMulticastClientTransceiver(this._instance, this._addr, this._mcastInterface, this._mcastTtl);
        }
        return new UdpTransceiver(this._instance, this._addr, this._sourceAddr, this._mcastInterface, this._mcastTtl);
    }

    public SelectableChannel fd() {
        assert (false);
        return null;
    }

    @Override
    public short type() {
        return this._instance.type();
    }

    @Override
    public String toString() {
        return Network.addrToString(this._addr);
    }

    public int hashCode() {
        return this._hashCode;
    }

    UdpConnector(ProtocolInstance instance, InetSocketAddress addr, InetSocketAddress sourceAddr, String mcastInterface, int mcastTtl, String connectionId) {
        this._instance = instance;
        this._addr = addr;
        this._sourceAddr = sourceAddr;
        this._mcastInterface = mcastInterface;
        this._mcastTtl = mcastTtl;
        this._connectionId = connectionId;
        this._hashCode = 5381;
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._addr.getAddress().getHostAddress());
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._addr.getPort());
        if (this._sourceAddr != null) {
            this._hashCode = HashUtil.hashAdd(this._hashCode, this._sourceAddr.getAddress().getHostAddress());
        }
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._mcastInterface);
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._mcastTtl);
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._connectionId);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof UdpConnector)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        UdpConnector p = (UdpConnector)obj;
        if (!this._connectionId.equals(p._connectionId)) {
            return false;
        }
        if (this._mcastTtl != p._mcastTtl) {
            return false;
        }
        if (this._mcastInterface.compareTo(p._mcastInterface) != 0) {
            return false;
        }
        if (Network.compareAddress(this._sourceAddr, p._sourceAddr) != 0) {
            return false;
        }
        return Network.compareAddress(this._addr, p._addr) == 0;
    }
}

