#ifndef _EFL_PAGE_TRANSITION_SCROLL_EO_H_
#define _EFL_PAGE_TRANSITION_SCROLL_EO_H_

#ifndef _EFL_PAGE_TRANSITION_SCROLL_EO_CLASS_TYPE
#define _EFL_PAGE_TRANSITION_SCROLL_EO_CLASS_TYPE

typedef Eo Efl_Page_Transition_Scroll;

#endif

#ifndef _EFL_PAGE_TRANSITION_SCROLL_EO_TYPES
#define _EFL_PAGE_TRANSITION_SCROLL_EO_TYPES


#endif
/**
 * @brief Page transition for @ref Efl_Ui_Pager
 *
 * With this type of transition, pages are arranged linearly and move parallel
 * to the screen by scrolling. The current page is displayed at center, and
 * previous and next pages might be displayed optionally.
 *
 * @ingroup Efl_Page_Transition_Scroll
 */
#define EFL_PAGE_TRANSITION_SCROLL_CLASS efl_page_transition_scroll_class_get()

EWAPI const Efl_Class *efl_page_transition_scroll_class_get(void);

/**
 * @brief The number of pages displayed on each side of the current page
 *
 * @param[in] obj The object.
 * @param[in] side_page_num
 *
 * @ingroup Efl_Page_Transition_Scroll
 */
EOAPI void efl_page_transition_scroll_side_page_num_set(Eo *obj, int side_page_num);

/** The number of pages displayed on each side of the current page
 *
 * @ingroup Efl_Page_Transition_Scroll
 */
EOAPI int efl_page_transition_scroll_side_page_num_get(const Eo *obj);

#endif
