# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2018 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtDataVisualization, except for defaults which are replaced by "...".
"""

# Module PySide2.QtDataVisualization
import shiboken2 as Shiboken
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

Shiboken.Object = Object

import PySide2.QtDataVisualization


class QtDataVisualization(Shiboken.Object):

    @typing.overload
    @staticmethod
    def qDefaultSurfaceFormat(antialias: bool) -> PySide2.QtGui.QSurfaceFormat: ...
    @typing.overload
    @staticmethod
    def qDefaultSurfaceFormat(antialias: bool = ...) -> PySide2.QtGui.QSurfaceFormat: ...

    class Q3DBars(PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph):

        def __init__(self, format: PySide2.QtGui.QSurfaceFormat = ..., parent: PySide2.QtGui.QWindow = ...): ...
        def addAxis(self, axis: PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis): ...
        def addSeries(self, series: PySide2.QtDataVisualization.QtDataVisualization.QBar3DSeries): ...
        def axes(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis: ...
        def barSpacing(self) -> PySide2.QtCore.QSizeF: ...
        def barThickness(self) -> float: ...
        def columnAxis(self) -> PySide2.QtDataVisualization.QtDataVisualization.QCategory3DAxis: ...
        def floorLevel(self) -> float: ...
        def insertSeries(self, index: int, series: PySide2.QtDataVisualization.QtDataVisualization.QBar3DSeries): ...
        def isBarSpacingRelative(self) -> bool: ...
        def isMultiSeriesUniform(self) -> bool: ...
        def primarySeries(self) -> PySide2.QtDataVisualization.QtDataVisualization.QBar3DSeries: ...
        def releaseAxis(self, axis: PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis): ...
        def removeSeries(self, series: PySide2.QtDataVisualization.QtDataVisualization.QBar3DSeries): ...
        def rowAxis(self) -> PySide2.QtDataVisualization.QtDataVisualization.QCategory3DAxis: ...
        def selectedSeries(self) -> PySide2.QtDataVisualization.QtDataVisualization.QBar3DSeries: ...
        def seriesList(self) -> PySide2.QtDataVisualization.QtDataVisualization.QBar3DSeries: ...
        def setBarSpacing(self, spacing: PySide2.QtCore.QSizeF): ...
        def setBarSpacingRelative(self, relative: bool): ...
        def setBarThickness(self, thicknessRatio: float): ...
        def setColumnAxis(self, axis: PySide2.QtDataVisualization.QtDataVisualization.QCategory3DAxis): ...
        def setFloorLevel(self, level: float): ...
        def setMultiSeriesUniform(self, uniform: bool): ...
        def setPrimarySeries(self, series: PySide2.QtDataVisualization.QtDataVisualization.QBar3DSeries): ...
        def setRowAxis(self, axis: PySide2.QtDataVisualization.QtDataVisualization.QCategory3DAxis): ...
        def setValueAxis(self, axis: PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis): ...
        def valueAxis(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...

    class Q3DCamera(PySide2.QtDataVisualization.QtDataVisualization.Q3DObject):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def cameraPreset(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.CameraPreset: ...
        def copyValuesFrom(self, source: PySide2.QtDataVisualization.QtDataVisualization.Q3DObject): ...
        def maxZoomLevel(self) -> float: ...
        def minZoomLevel(self) -> float: ...
        def setCameraPosition(self, horizontal: float, vertical: float, zoom: float = ...): ...
        def setCameraPreset(self, preset: PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.CameraPreset): ...
        def setMaxZoomLevel(self, zoomLevel: float): ...
        def setMinZoomLevel(self, zoomLevel: float): ...
        def setTarget(self, target: PySide2.QtGui.QVector3D): ...
        def setWrapXRotation(self, isEnabled: bool): ...
        def setWrapYRotation(self, isEnabled: bool): ...
        def setXRotation(self, rotation: float): ...
        def setYRotation(self, rotation: float): ...
        def setZoomLevel(self, zoomLevel: float): ...
        def target(self) -> PySide2.QtGui.QVector3D: ...
        def wrapXRotation(self) -> bool: ...
        def wrapYRotation(self) -> bool: ...
        def xRotation(self) -> float: ...
        def yRotation(self) -> float: ...
        def zoomLevel(self) -> float: ...

    class Q3DInputHandler(PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def isRotationEnabled(self) -> bool: ...
        def isSelectionEnabled(self) -> bool: ...
        def isZoomAtTargetEnabled(self) -> bool: ...
        def isZoomEnabled(self) -> bool: ...
        def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent, mousePos: PySide2.QtCore.QPoint): ...
        def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent, mousePos: PySide2.QtCore.QPoint): ...
        def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent, mousePos: PySide2.QtCore.QPoint): ...
        def setRotationEnabled(self, enable: bool): ...
        def setSelectionEnabled(self, enable: bool): ...
        def setZoomAtTargetEnabled(self, enable: bool): ...
        def setZoomEnabled(self, enable: bool): ...
        def wheelEvent(self, event: PySide2.QtGui.QWheelEvent): ...

    class Q3DLight(PySide2.QtDataVisualization.QtDataVisualization.Q3DObject):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def isAutoPosition(self) -> bool: ...
        def setAutoPosition(self, enabled: bool): ...

    class Q3DObject(PySide2.QtCore.QObject):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def copyValuesFrom(self, source: PySide2.QtDataVisualization.QtDataVisualization.Q3DObject): ...
        def isDirty(self) -> bool: ...
        def parentScene(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DScene: ...
        def position(self) -> PySide2.QtGui.QVector3D: ...
        def setDirty(self, dirty: bool): ...
        def setPosition(self, position: PySide2.QtGui.QVector3D): ...

    class Q3DScatter(PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph):

        def __init__(self, format: PySide2.QtGui.QSurfaceFormat = ..., parent: PySide2.QtGui.QWindow = ...): ...
        def addAxis(self, axis: PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis): ...
        def addSeries(self, series: PySide2.QtDataVisualization.QtDataVisualization.QScatter3DSeries): ...
        def axes(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...
        def axisX(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...
        def axisY(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...
        def axisZ(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...
        def releaseAxis(self, axis: PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis): ...
        def removeSeries(self, series: PySide2.QtDataVisualization.QtDataVisualization.QScatter3DSeries): ...
        def selectedSeries(self) -> PySide2.QtDataVisualization.QtDataVisualization.QScatter3DSeries: ...
        def seriesList(self) -> PySide2.QtDataVisualization.QtDataVisualization.QScatter3DSeries: ...
        def setAxisX(self, axis: PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis): ...
        def setAxisY(self, axis: PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis): ...
        def setAxisZ(self, axis: PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis): ...

    class Q3DScene(PySide2.QtCore.QObject):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def activeCamera(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera: ...
        def activeLight(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DLight: ...
        def devicePixelRatio(self) -> float: ...
        def graphPositionQuery(self) -> PySide2.QtCore.QPoint: ...
        @staticmethod
        def invalidSelectionPoint() -> PySide2.QtCore.QPoint: ...
        def isPointInPrimarySubView(self, point: PySide2.QtCore.QPoint) -> bool: ...
        def isPointInSecondarySubView(self, point: PySide2.QtCore.QPoint) -> bool: ...
        def isSecondarySubviewOnTop(self) -> bool: ...
        def isSlicingActive(self) -> bool: ...
        def primarySubViewport(self) -> PySide2.QtCore.QRect: ...
        def secondarySubViewport(self) -> PySide2.QtCore.QRect: ...
        def selectionQueryPosition(self) -> PySide2.QtCore.QPoint: ...
        def setActiveCamera(self, camera: PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera): ...
        def setActiveLight(self, light: PySide2.QtDataVisualization.QtDataVisualization.Q3DLight): ...
        def setDevicePixelRatio(self, pixelRatio: float): ...
        def setGraphPositionQuery(self, point: PySide2.QtCore.QPoint): ...
        def setPrimarySubViewport(self, primarySubViewport: PySide2.QtCore.QRect): ...
        def setSecondarySubViewport(self, secondarySubViewport: PySide2.QtCore.QRect): ...
        def setSecondarySubviewOnTop(self, isSecondaryOnTop: bool): ...
        def setSelectionQueryPosition(self, point: PySide2.QtCore.QPoint): ...
        def setSlicingActive(self, isSlicing: bool): ...
        def viewport(self) -> PySide2.QtCore.QRect: ...

    class Q3DSurface(PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph):

        def __init__(self, format: PySide2.QtGui.QSurfaceFormat = ..., parent: PySide2.QtGui.QWindow = ...): ...
        def addAxis(self, axis: PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis): ...
        def addSeries(self, series: PySide2.QtDataVisualization.QtDataVisualization.QSurface3DSeries): ...
        def axes(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...
        def axisX(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...
        def axisY(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...
        def axisZ(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...
        def flipHorizontalGrid(self) -> bool: ...
        def releaseAxis(self, axis: PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis): ...
        def removeSeries(self, series: PySide2.QtDataVisualization.QtDataVisualization.QSurface3DSeries): ...
        def selectedSeries(self) -> PySide2.QtDataVisualization.QtDataVisualization.QSurface3DSeries: ...
        def seriesList(self) -> PySide2.QtDataVisualization.QtDataVisualization.QSurface3DSeries: ...
        def setAxisX(self, axis: PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis): ...
        def setAxisY(self, axis: PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis): ...
        def setAxisZ(self, axis: PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis): ...
        def setFlipHorizontalGrid(self, flip: bool): ...

    class Q3DTheme(PySide2.QtCore.QObject):

        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, themeType: PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.Theme, parent: PySide2.QtCore.QObject = ...): ...
        def ambientLightStrength(self) -> float: ...
        def backgroundColor(self) -> PySide2.QtGui.QColor: ...
        def baseColors(self) -> PySide2.QtGui.QColor: ...
        def baseGradients(self) -> PySide2.QtGui.QLinearGradient: ...
        def colorStyle(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.ColorStyle: ...
        def font(self) -> PySide2.QtGui.QFont: ...
        def gridLineColor(self) -> PySide2.QtGui.QColor: ...
        def highlightLightStrength(self) -> float: ...
        def isBackgroundEnabled(self) -> bool: ...
        def isGridEnabled(self) -> bool: ...
        def isLabelBackgroundEnabled(self) -> bool: ...
        def isLabelBorderEnabled(self) -> bool: ...
        def labelBackgroundColor(self) -> PySide2.QtGui.QColor: ...
        def labelTextColor(self) -> PySide2.QtGui.QColor: ...
        def lightColor(self) -> PySide2.QtGui.QColor: ...
        def lightStrength(self) -> float: ...
        def multiHighlightColor(self) -> PySide2.QtGui.QColor: ...
        def multiHighlightGradient(self) -> PySide2.QtGui.QLinearGradient: ...
        def setAmbientLightStrength(self, strength: float): ...
        def setBackgroundColor(self, color: PySide2.QtGui.QColor): ...
        def setBackgroundEnabled(self, enabled: bool): ...
        def setBaseColors(self, colors: list): ...
        def setBaseGradients(self, gradients: list): ...
        def setColorStyle(self, style: PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.ColorStyle): ...
        def setFont(self, font: PySide2.QtGui.QFont): ...
        def setGridEnabled(self, enabled: bool): ...
        def setGridLineColor(self, color: PySide2.QtGui.QColor): ...
        def setHighlightLightStrength(self, strength: float): ...
        def setLabelBackgroundColor(self, color: PySide2.QtGui.QColor): ...
        def setLabelBackgroundEnabled(self, enabled: bool): ...
        def setLabelBorderEnabled(self, enabled: bool): ...
        def setLabelTextColor(self, color: PySide2.QtGui.QColor): ...
        def setLightColor(self, color: PySide2.QtGui.QColor): ...
        def setLightStrength(self, strength: float): ...
        def setMultiHighlightColor(self, color: PySide2.QtGui.QColor): ...
        def setMultiHighlightGradient(self, gradient: PySide2.QtGui.QLinearGradient): ...
        def setSingleHighlightColor(self, color: PySide2.QtGui.QColor): ...
        def setSingleHighlightGradient(self, gradient: PySide2.QtGui.QLinearGradient): ...
        def setType(self, themeType: PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.Theme): ...
        def setWindowColor(self, color: PySide2.QtGui.QColor): ...
        def singleHighlightColor(self) -> PySide2.QtGui.QColor: ...
        def singleHighlightGradient(self) -> PySide2.QtGui.QLinearGradient: ...
        def type(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.Theme: ...
        def windowColor(self) -> PySide2.QtGui.QColor: ...

    class QAbstract3DAxis(PySide2.QtCore.QObject):

        def isAutoAdjustRange(self) -> bool: ...
        def isTitleFixed(self) -> bool: ...
        def isTitleVisible(self) -> bool: ...
        def labelAutoRotation(self) -> float: ...
        def labels(self) -> typing.List[str]: ...
        def max(self) -> float: ...
        def min(self) -> float: ...
        def orientation(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.AxisOrientation: ...
        def setAutoAdjustRange(self, autoAdjust: bool): ...
        def setLabelAutoRotation(self, angle: float): ...
        def setLabels(self, labels: typing.List[str]): ...
        def setMax(self, max: float): ...
        def setMin(self, min: float): ...
        def setRange(self, min: float, max: float): ...
        def setTitle(self, title: str): ...
        def setTitleFixed(self, fixed: bool): ...
        def setTitleVisible(self, visible: bool): ...
        def title(self) -> str: ...
        def type(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.AxisType: ...

    class QAbstract3DGraph(PySide2.QtGui.QWindow):

        def activeInputHandler(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler: ...
        def activeTheme(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme: ...
        def addCustomItem(self, item: PySide2.QtDataVisualization.QtDataVisualization.QCustom3DItem) -> int: ...
        def addInputHandler(self, inputHandler: PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler): ...
        def addTheme(self, theme: PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme): ...
        def aspectRatio(self) -> float: ...
        def clearSelection(self): ...
        def currentFps(self) -> float: ...
        def customItems(self) -> PySide2.QtDataVisualization.QtDataVisualization.QCustom3DItem: ...
        def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
        def exposeEvent(self, event: PySide2.QtGui.QExposeEvent): ...
        def hasContext(self) -> bool: ...
        def horizontalAspectRatio(self) -> float: ...
        def inputHandlers(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler: ...
        def isOrthoProjection(self) -> bool: ...
        def isPolar(self) -> bool: ...
        def isReflection(self) -> bool: ...
        def locale(self) -> PySide2.QtCore.QLocale: ...
        def margin(self) -> float: ...
        def measureFps(self) -> bool: ...
        def mouseDoubleClickEvent(self, event: PySide2.QtGui.QMouseEvent): ...
        def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent): ...
        def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent): ...
        def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent): ...
        def optimizationHints(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.OptimizationHints: ...
        def queriedGraphPosition(self) -> PySide2.QtGui.QVector3D: ...
        def radialLabelOffset(self) -> float: ...
        def reflectivity(self) -> float: ...
        def releaseCustomItem(self, item: PySide2.QtDataVisualization.QtDataVisualization.QCustom3DItem): ...
        def releaseInputHandler(self, inputHandler: PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler): ...
        def releaseTheme(self, theme: PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme): ...
        def removeCustomItem(self, item: PySide2.QtDataVisualization.QtDataVisualization.QCustom3DItem): ...
        def removeCustomItemAt(self, position: PySide2.QtGui.QVector3D): ...
        def removeCustomItems(self): ...
        def renderToImage(self, msaaSamples: int = ..., imageSize: PySide2.QtCore.QSize = ...) -> PySide2.QtGui.QImage: ...
        def resizeEvent(self, event: PySide2.QtGui.QResizeEvent): ...
        def scene(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DScene: ...
        def selectedAxis(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis: ...
        def selectedCustomItem(self) -> PySide2.QtDataVisualization.QtDataVisualization.QCustom3DItem: ...
        def selectedCustomItemIndex(self) -> int: ...
        def selectedElement(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.ElementType: ...
        def selectedLabelIndex(self) -> int: ...
        def selectionMode(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.SelectionFlags: ...
        def setActiveInputHandler(self, inputHandler: PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler): ...
        def setActiveTheme(self, theme: PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme): ...
        def setAspectRatio(self, ratio: float): ...
        def setHorizontalAspectRatio(self, ratio: float): ...
        def setLocale(self, locale: PySide2.QtCore.QLocale): ...
        def setMargin(self, margin: float): ...
        def setMeasureFps(self, enable: bool): ...
        def setOptimizationHints(self, hints: PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.OptimizationHints): ...
        def setOrthoProjection(self, enable: bool): ...
        def setPolar(self, enable: bool): ...
        def setRadialLabelOffset(self, offset: float): ...
        def setReflection(self, enable: bool): ...
        def setReflectivity(self, reflectivity: float): ...
        def setSelectionMode(self, mode: PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.SelectionFlags): ...
        def setShadowQuality(self, quality: PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.ShadowQuality): ...
        def shadowQuality(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.ShadowQuality: ...
        def shadowsSupported(self) -> bool: ...
        def themes(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme: ...
        def touchEvent(self, event: PySide2.QtGui.QTouchEvent): ...
        def wheelEvent(self, event: PySide2.QtGui.QWheelEvent): ...

    class QAbstract3DInputHandler(PySide2.QtCore.QObject):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def inputPosition(self) -> PySide2.QtCore.QPoint: ...
        def inputView(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler.InputView: ...
        def mouseDoubleClickEvent(self, event: PySide2.QtGui.QMouseEvent): ...
        def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent, mousePos: PySide2.QtCore.QPoint): ...
        def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent, mousePos: PySide2.QtCore.QPoint): ...
        def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent, mousePos: PySide2.QtCore.QPoint): ...
        def prevDistance(self) -> int: ...
        def previousInputPos(self) -> PySide2.QtCore.QPoint: ...
        def scene(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DScene: ...
        def setInputPosition(self, position: PySide2.QtCore.QPoint): ...
        def setInputView(self, inputView: PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler.InputView): ...
        def setPrevDistance(self, distance: int): ...
        def setPreviousInputPos(self, position: PySide2.QtCore.QPoint): ...
        def setScene(self, scene: PySide2.QtDataVisualization.QtDataVisualization.Q3DScene): ...
        def touchEvent(self, event: PySide2.QtGui.QTouchEvent): ...
        def wheelEvent(self, event: PySide2.QtGui.QWheelEvent): ...

    class QAbstract3DSeries(PySide2.QtCore.QObject):

        def baseColor(self) -> PySide2.QtGui.QColor: ...
        def baseGradient(self) -> PySide2.QtGui.QLinearGradient: ...
        def colorStyle(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.ColorStyle: ...
        def isItemLabelVisible(self) -> bool: ...
        def isMeshSmooth(self) -> bool: ...
        def isVisible(self) -> bool: ...
        def itemLabel(self) -> str: ...
        def itemLabelFormat(self) -> str: ...
        def mesh(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.Mesh: ...
        def meshRotation(self) -> PySide2.QtGui.QQuaternion: ...
        def multiHighlightColor(self) -> PySide2.QtGui.QColor: ...
        def multiHighlightGradient(self) -> PySide2.QtGui.QLinearGradient: ...
        def name(self) -> str: ...
        def setBaseColor(self, color: PySide2.QtGui.QColor): ...
        def setBaseGradient(self, gradient: PySide2.QtGui.QLinearGradient): ...
        def setColorStyle(self, style: PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.ColorStyle): ...
        def setItemLabelFormat(self, format: str): ...
        def setItemLabelVisible(self, visible: bool): ...
        def setMesh(self, mesh: PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.Mesh): ...
        def setMeshAxisAndAngle(self, axis: PySide2.QtGui.QVector3D, angle: float): ...
        def setMeshRotation(self, rotation: PySide2.QtGui.QQuaternion): ...
        def setMeshSmooth(self, enable: bool): ...
        def setMultiHighlightColor(self, color: PySide2.QtGui.QColor): ...
        def setMultiHighlightGradient(self, gradient: PySide2.QtGui.QLinearGradient): ...
        def setName(self, name: str): ...
        def setSingleHighlightColor(self, color: PySide2.QtGui.QColor): ...
        def setSingleHighlightGradient(self, gradient: PySide2.QtGui.QLinearGradient): ...
        def setUserDefinedMesh(self, fileName: str): ...
        def setVisible(self, visible: bool): ...
        def singleHighlightColor(self) -> PySide2.QtGui.QColor: ...
        def singleHighlightGradient(self) -> PySide2.QtGui.QLinearGradient: ...
        def type(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.SeriesType: ...
        def userDefinedMesh(self) -> str: ...

    class QAbstractDataProxy(PySide2.QtCore.QObject):

        def type(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstractDataProxy.DataType: ...

    class QBar3DSeries(PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries):

        @typing.overload
        def __init__(self, dataProxy: PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def dataProxy(self) -> PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy: ...
        @staticmethod
        def invalidSelectionPosition() -> PySide2.QtCore.QPoint: ...
        def meshAngle(self) -> float: ...
        def selectedBar(self) -> PySide2.QtCore.QPoint: ...
        def setDataProxy(self, proxy: PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy): ...
        def setMeshAngle(self, angle: float): ...
        def setSelectedBar(self, position: PySide2.QtCore.QPoint): ...

    class QBarDataItem(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, other: PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem): ...
        @typing.overload
        def __init__(self, value: float): ...
        @typing.overload
        def __init__(self, value: float, angle: float): ...
        def __copy__(self): ...
        def createExtraData(self): ...
        def rotation(self) -> float: ...
        def setRotation(self, angle: float): ...
        def setValue(self, val: float): ...
        def value(self) -> float: ...

    class QBarDataProxy(PySide2.QtDataVisualization.QtDataVisualization.QAbstractDataProxy):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def addRow(self, row: list) -> int: ...
        @typing.overload
        def addRow(self, row: list, label: str) -> int: ...
        @typing.overload
        def addRows(self, rows: typing.List[typing.List[PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem]]) -> int: ...
        @typing.overload
        def addRows(self, rows: typing.List[typing.List[PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem]], labels: typing.List[str]) -> int: ...
        def array(self) -> typing.List[typing.List[PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem]]: ...
        def columnLabels(self) -> typing.List[str]: ...
        @typing.overload
        def insertRow(self, rowIndex: int, row: list): ...
        @typing.overload
        def insertRow(self, rowIndex: int, row: list, label: str): ...
        @typing.overload
        def insertRows(self, rowIndex: int, rows: typing.List[typing.List[PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem]]): ...
        @typing.overload
        def insertRows(self, rowIndex: int, rows: typing.List[typing.List[PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem]], labels: typing.List[str]): ...
        @typing.overload
        def itemAt(self, position: PySide2.QtCore.QPoint) -> PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem: ...
        @typing.overload
        def itemAt(self, rowIndex: int, columnIndex: int) -> PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem: ...
        def removeRows(self, rowIndex: int, removeCount: int, removeLabels: bool = ...): ...
        @typing.overload
        def resetArray(self): ...
        @typing.overload
        def resetArray(self, newArray: typing.List[typing.List[PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem]]): ...
        @typing.overload
        def resetArray(self, newArray: typing.List[typing.List[PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem]], rowLabels: typing.List[str], columnLabels: typing.List[str]): ...
        def rowAt(self, rowIndex: int) -> PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem: ...
        def rowCount(self) -> int: ...
        def rowLabels(self) -> typing.List[str]: ...
        def series(self) -> PySide2.QtDataVisualization.QtDataVisualization.QBar3DSeries: ...
        def setColumnLabels(self, labels: typing.List[str]): ...
        @typing.overload
        def setItem(self, position: PySide2.QtCore.QPoint, item: PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem): ...
        @typing.overload
        def setItem(self, rowIndex: int, columnIndex: int, item: PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem): ...
        @typing.overload
        def setRow(self, rowIndex: int, row: list): ...
        @typing.overload
        def setRow(self, rowIndex: int, row: list, label: str): ...
        def setRowLabels(self, labels: typing.List[str]): ...
        @typing.overload
        def setRows(self, rowIndex: int, rows: typing.List[typing.List[PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem]]): ...
        @typing.overload
        def setRows(self, rowIndex: int, rows: typing.List[typing.List[PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem]], labels: typing.List[str]): ...

    class QCategory3DAxis(PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def labels(self) -> typing.List[str]: ...
        def setLabels(self, labels: typing.List[str]): ...

    class QCustom3DItem(PySide2.QtCore.QObject):

        @typing.overload
        def __init__(self, meshFile: str, position: PySide2.QtGui.QVector3D, scaling: PySide2.QtGui.QVector3D, rotation: PySide2.QtGui.QQuaternion, texture: PySide2.QtGui.QImage, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def isPositionAbsolute(self) -> bool: ...
        def isScalingAbsolute(self) -> bool: ...
        def isShadowCasting(self) -> bool: ...
        def isVisible(self) -> bool: ...
        def meshFile(self) -> str: ...
        def position(self) -> PySide2.QtGui.QVector3D: ...
        def rotation(self) -> PySide2.QtGui.QQuaternion: ...
        def scaling(self) -> PySide2.QtGui.QVector3D: ...
        def setMeshFile(self, meshFile: str): ...
        def setPosition(self, position: PySide2.QtGui.QVector3D): ...
        def setPositionAbsolute(self, positionAbsolute: bool): ...
        def setRotation(self, rotation: PySide2.QtGui.QQuaternion): ...
        def setRotationAxisAndAngle(self, axis: PySide2.QtGui.QVector3D, angle: float): ...
        def setScaling(self, scaling: PySide2.QtGui.QVector3D): ...
        def setScalingAbsolute(self, scalingAbsolute: bool): ...
        def setShadowCasting(self, enabled: bool): ...
        def setTextureFile(self, textureFile: str): ...
        def setTextureImage(self, textureImage: PySide2.QtGui.QImage): ...
        def setVisible(self, visible: bool): ...
        def textureFile(self) -> str: ...

    class QCustom3DLabel(PySide2.QtDataVisualization.QtDataVisualization.QCustom3DItem):

        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, text: str, font: PySide2.QtGui.QFont, position: PySide2.QtGui.QVector3D, scaling: PySide2.QtGui.QVector3D, rotation: PySide2.QtGui.QQuaternion, parent: PySide2.QtCore.QObject = ...): ...
        def backgroundColor(self) -> PySide2.QtGui.QColor: ...
        def font(self) -> PySide2.QtGui.QFont: ...
        def isBackgroundEnabled(self) -> bool: ...
        def isBorderEnabled(self) -> bool: ...
        def isFacingCamera(self) -> bool: ...
        def setBackgroundColor(self, color: PySide2.QtGui.QColor): ...
        def setBackgroundEnabled(self, enabled: bool): ...
        def setBorderEnabled(self, enabled: bool): ...
        def setFacingCamera(self, enabled: bool): ...
        def setFont(self, font: PySide2.QtGui.QFont): ...
        def setText(self, text: str): ...
        def setTextColor(self, color: PySide2.QtGui.QColor): ...
        def text(self) -> str: ...
        def textColor(self) -> PySide2.QtGui.QColor: ...

    class QCustom3DVolume(PySide2.QtDataVisualization.QtDataVisualization.QCustom3DItem):

        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, position: PySide2.QtGui.QVector3D, scaling: PySide2.QtGui.QVector3D, rotation: PySide2.QtGui.QQuaternion, textureWidth: int, textureHeight: int, textureDepth: int, textureData: list, textureFormat: PySide2.QtGui.QImage.Format, colorTable: list, parent: PySide2.QtCore.QObject = ...): ...
        def alphaMultiplier(self) -> float: ...
        def colorTable(self) -> int: ...
        def createTextureData(self, images: list) -> typing.Union[str, int]: ...
        def drawSliceFrames(self) -> bool: ...
        def drawSlices(self) -> bool: ...
        def preserveOpacity(self) -> bool: ...
        def renderSlice(self, axis: PySide2.QtCore.Qt.Axis, index: int) -> PySide2.QtGui.QImage: ...
        def setAlphaMultiplier(self, mult: float): ...
        def setColorTable(self, colors: list): ...
        def setDrawSliceFrames(self, enable: bool): ...
        def setDrawSlices(self, enable: bool): ...
        def setPreserveOpacity(self, enable: bool): ...
        def setSliceFrameColor(self, color: PySide2.QtGui.QColor): ...
        def setSliceFrameGaps(self, values: PySide2.QtGui.QVector3D): ...
        def setSliceFrameThicknesses(self, values: PySide2.QtGui.QVector3D): ...
        def setSliceFrameWidths(self, values: PySide2.QtGui.QVector3D): ...
        def setSliceIndexX(self, value: int): ...
        def setSliceIndexY(self, value: int): ...
        def setSliceIndexZ(self, value: int): ...
        def setSliceIndices(self, x: int, y: int, z: int): ...
        @typing.overload
        def setSubTextureData(self, axis: PySide2.QtCore.Qt.Axis, index: int, data: typing.Union[str, int]): ...
        @typing.overload
        def setSubTextureData(self, axis: PySide2.QtCore.Qt.Axis, index: int, image: PySide2.QtGui.QImage): ...
        def setTextureData(self, data: list): ...
        def setTextureDepth(self, value: int): ...
        def setTextureDimensions(self, width: int, height: int, depth: int): ...
        def setTextureFormat(self, format: PySide2.QtGui.QImage.Format): ...
        def setTextureHeight(self, value: int): ...
        def setTextureWidth(self, value: int): ...
        def setUseHighDefShader(self, enable: bool): ...
        def sliceFrameColor(self) -> PySide2.QtGui.QColor: ...
        def sliceFrameGaps(self) -> PySide2.QtGui.QVector3D: ...
        def sliceFrameThicknesses(self) -> PySide2.QtGui.QVector3D: ...
        def sliceFrameWidths(self) -> PySide2.QtGui.QVector3D: ...
        def sliceIndexX(self) -> int: ...
        def sliceIndexY(self) -> int: ...
        def sliceIndexZ(self) -> int: ...
        def textureData(self) -> typing.Union[str, int]: ...
        def textureDataWidth(self) -> int: ...
        def textureDepth(self) -> int: ...
        def textureFormat(self) -> PySide2.QtGui.QImage.Format: ...
        def textureHeight(self) -> int: ...
        def textureWidth(self) -> int: ...
        def useHighDefShader(self) -> bool: ...

    class QHeightMapSurfaceDataProxy(PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataProxy):

        @typing.overload
        def __init__(self, filename: str, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, image: PySide2.QtGui.QImage, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def heightMap(self) -> PySide2.QtGui.QImage: ...
        def heightMapFile(self) -> str: ...
        def maxXValue(self) -> float: ...
        def maxZValue(self) -> float: ...
        def minXValue(self) -> float: ...
        def minZValue(self) -> float: ...
        def setHeightMap(self, image: PySide2.QtGui.QImage): ...
        def setHeightMapFile(self, filename: str): ...
        def setMaxXValue(self, max: float): ...
        def setMaxZValue(self, max: float): ...
        def setMinXValue(self, min: float): ...
        def setMinZValue(self, min: float): ...
        def setValueRanges(self, minX: float, maxX: float, minZ: float, maxZ: float): ...

    class QItemModelBarDataProxy(PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy):

        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, valueRole: str, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, valueRole: str, rotationRole: str, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, valueRole: str, rotationRole: str, rowCategories: typing.List[str], columnCategories: typing.List[str], parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, valueRole: str, rowCategories: typing.List[str], columnCategories: typing.List[str], parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, valueRole: str, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def autoColumnCategories(self) -> bool: ...
        def autoRowCategories(self) -> bool: ...
        def columnCategories(self) -> typing.List[str]: ...
        def columnCategoryIndex(self, category: str) -> int: ...
        def columnRole(self) -> str: ...
        def columnRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def columnRoleReplace(self) -> str: ...
        def itemModel(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def multiMatchBehavior(self) -> PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior: ...
        def remap(self, rowRole: str, columnRole: str, valueRole: str, rotationRole: str, rowCategories: typing.List[str], columnCategories: typing.List[str]): ...
        def rotationRole(self) -> str: ...
        def rotationRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def rotationRoleReplace(self) -> str: ...
        def rowCategories(self) -> typing.List[str]: ...
        def rowCategoryIndex(self, category: str) -> int: ...
        def rowRole(self) -> str: ...
        def rowRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def rowRoleReplace(self) -> str: ...
        def setAutoColumnCategories(self, enable: bool): ...
        def setAutoRowCategories(self, enable: bool): ...
        def setColumnCategories(self, categories: typing.List[str]): ...
        def setColumnRole(self, role: str): ...
        def setColumnRolePattern(self, pattern: PySide2.QtCore.QRegExp): ...
        def setColumnRoleReplace(self, replace: str): ...
        def setItemModel(self, itemModel: PySide2.QtCore.QAbstractItemModel): ...
        def setMultiMatchBehavior(self, behavior: PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior): ...
        def setRotationRole(self, role: str): ...
        def setRotationRolePattern(self, pattern: PySide2.QtCore.QRegExp): ...
        def setRotationRoleReplace(self, replace: str): ...
        def setRowCategories(self, categories: typing.List[str]): ...
        def setRowRole(self, role: str): ...
        def setRowRolePattern(self, pattern: PySide2.QtCore.QRegExp): ...
        def setRowRoleReplace(self, replace: str): ...
        def setUseModelCategories(self, enable: bool): ...
        def setValueRole(self, role: str): ...
        def setValueRolePattern(self, pattern: PySide2.QtCore.QRegExp): ...
        def setValueRoleReplace(self, replace: str): ...
        def useModelCategories(self) -> bool: ...
        def valueRole(self) -> str: ...
        def valueRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def valueRoleReplace(self) -> str: ...

    class QItemModelScatterDataProxy(PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy):

        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, xPosRole: str, yPosRole: str, zPosRole: str, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, xPosRole: str, yPosRole: str, zPosRole: str, rotationRole: str, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def itemModel(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def remap(self, xPosRole: str, yPosRole: str, zPosRole: str, rotationRole: str): ...
        def rotationRole(self) -> str: ...
        def rotationRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def rotationRoleReplace(self) -> str: ...
        def setItemModel(self, itemModel: PySide2.QtCore.QAbstractItemModel): ...
        def setRotationRole(self, role: str): ...
        def setRotationRolePattern(self, pattern: PySide2.QtCore.QRegExp): ...
        def setRotationRoleReplace(self, replace: str): ...
        def setXPosRole(self, role: str): ...
        def setXPosRolePattern(self, pattern: PySide2.QtCore.QRegExp): ...
        def setXPosRoleReplace(self, replace: str): ...
        def setYPosRole(self, role: str): ...
        def setYPosRolePattern(self, pattern: PySide2.QtCore.QRegExp): ...
        def setYPosRoleReplace(self, replace: str): ...
        def setZPosRole(self, role: str): ...
        def setZPosRolePattern(self, pattern: PySide2.QtCore.QRegExp): ...
        def setZPosRoleReplace(self, replace: str): ...
        def xPosRole(self) -> str: ...
        def xPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def xPosRoleReplace(self) -> str: ...
        def yPosRole(self) -> str: ...
        def yPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def yPosRoleReplace(self) -> str: ...
        def zPosRole(self) -> str: ...
        def zPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def zPosRoleReplace(self) -> str: ...

    class QItemModelSurfaceDataProxy(PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataProxy):

        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, xPosRole: str, yPosRole: str, zPosRole: str, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, xPosRole: str, yPosRole: str, zPosRole: str, rowCategories: typing.List[str], columnCategories: typing.List[str], parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, yPosRole: str, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, rowRole: str, columnRole: str, yPosRole: str, rowCategories: typing.List[str], columnCategories: typing.List[str], parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, itemModel: PySide2.QtCore.QAbstractItemModel, yPosRole: str, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def autoColumnCategories(self) -> bool: ...
        def autoRowCategories(self) -> bool: ...
        def columnCategories(self) -> typing.List[str]: ...
        def columnCategoryIndex(self, category: str) -> int: ...
        def columnRole(self) -> str: ...
        def columnRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def columnRoleReplace(self) -> str: ...
        def itemModel(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def multiMatchBehavior(self) -> PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior: ...
        def remap(self, rowRole: str, columnRole: str, xPosRole: str, yPosRole: str, zPosRole: str, rowCategories: typing.List[str], columnCategories: typing.List[str]): ...
        def rowCategories(self) -> typing.List[str]: ...
        def rowCategoryIndex(self, category: str) -> int: ...
        def rowRole(self) -> str: ...
        def rowRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def rowRoleReplace(self) -> str: ...
        def setAutoColumnCategories(self, enable: bool): ...
        def setAutoRowCategories(self, enable: bool): ...
        def setColumnCategories(self, categories: typing.List[str]): ...
        def setColumnRole(self, role: str): ...
        def setColumnRolePattern(self, pattern: PySide2.QtCore.QRegExp): ...
        def setColumnRoleReplace(self, replace: str): ...
        def setItemModel(self, itemModel: PySide2.QtCore.QAbstractItemModel): ...
        def setMultiMatchBehavior(self, behavior: PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior): ...
        def setRowCategories(self, categories: typing.List[str]): ...
        def setRowRole(self, role: str): ...
        def setRowRolePattern(self, pattern: PySide2.QtCore.QRegExp): ...
        def setRowRoleReplace(self, replace: str): ...
        def setUseModelCategories(self, enable: bool): ...
        def setXPosRole(self, role: str): ...
        def setXPosRolePattern(self, pattern: PySide2.QtCore.QRegExp): ...
        def setXPosRoleReplace(self, replace: str): ...
        def setYPosRole(self, role: str): ...
        def setYPosRolePattern(self, pattern: PySide2.QtCore.QRegExp): ...
        def setYPosRoleReplace(self, replace: str): ...
        def setZPosRole(self, role: str): ...
        def setZPosRolePattern(self, pattern: PySide2.QtCore.QRegExp): ...
        def setZPosRoleReplace(self, replace: str): ...
        def useModelCategories(self) -> bool: ...
        def xPosRole(self) -> str: ...
        def xPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def xPosRoleReplace(self) -> str: ...
        def yPosRole(self) -> str: ...
        def yPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def yPosRoleReplace(self) -> str: ...
        def zPosRole(self) -> str: ...
        def zPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def zPosRoleReplace(self) -> str: ...

    class QLogValue3DAxisFormatter(PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxisFormatter):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def autoSubGrid(self) -> bool: ...
        def base(self) -> float: ...
        def createNewInstance(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxisFormatter: ...
        def populateCopy(self, copy: PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxisFormatter): ...
        def positionAt(self, value: float) -> float: ...
        def recalculate(self): ...
        def setAutoSubGrid(self, enabled: bool): ...
        def setBase(self, base: float): ...
        def setShowEdgeLabels(self, enabled: bool): ...
        def showEdgeLabels(self) -> bool: ...
        def valueAt(self, position: float) -> float: ...

    class QScatter3DSeries(PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries):

        @typing.overload
        def __init__(self, dataProxy: PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def dataProxy(self) -> PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy: ...
        @staticmethod
        def invalidSelectionIndex() -> int: ...
        def itemSize(self) -> float: ...
        def selectedItem(self) -> int: ...
        def setDataProxy(self, proxy: PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy): ...
        def setItemSize(self, size: float): ...
        def setSelectedItem(self, index: int): ...

    class QScatterDataItem(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, other: PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem): ...
        @typing.overload
        def __init__(self, position: PySide2.QtGui.QVector3D): ...
        @typing.overload
        def __init__(self, position: PySide2.QtGui.QVector3D, rotation: PySide2.QtGui.QQuaternion): ...
        def __copy__(self): ...
        def createExtraData(self): ...
        def position(self) -> PySide2.QtGui.QVector3D: ...
        def rotation(self) -> PySide2.QtGui.QQuaternion: ...
        def setPosition(self, pos: PySide2.QtGui.QVector3D): ...
        def setRotation(self, rot: PySide2.QtGui.QQuaternion): ...
        def setX(self, value: float): ...
        def setY(self, value: float): ...
        def setZ(self, value: float): ...
        def x(self) -> float: ...
        def y(self) -> float: ...
        def z(self) -> float: ...

    class QScatterDataProxy(PySide2.QtDataVisualization.QtDataVisualization.QAbstractDataProxy):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def addItem(self, item: PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem) -> int: ...
        def addItems(self, items: list) -> int: ...
        def array(self) -> PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem: ...
        def insertItem(self, index: int, item: PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem): ...
        def insertItems(self, index: int, items: list): ...
        def itemAt(self, index: int) -> PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem: ...
        def itemCount(self) -> int: ...
        def removeItems(self, index: int, removeCount: int): ...
        def resetArray(self, newArray: list): ...
        def series(self) -> PySide2.QtDataVisualization.QtDataVisualization.QScatter3DSeries: ...
        def setItem(self, index: int, item: PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem): ...
        def setItems(self, index: int, items: list): ...

    class QSurface3DSeries(PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries):

        @typing.overload
        def __init__(self, dataProxy: PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataProxy, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def dataProxy(self) -> PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataProxy: ...
        def drawMode(self) -> PySide2.QtDataVisualization.QtDataVisualization.QSurface3DSeries.DrawFlags: ...
        @staticmethod
        def invalidSelectionPosition() -> PySide2.QtCore.QPoint: ...
        def isFlatShadingEnabled(self) -> bool: ...
        def isFlatShadingSupported(self) -> bool: ...
        def selectedPoint(self) -> PySide2.QtCore.QPoint: ...
        def setDataProxy(self, proxy: PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataProxy): ...
        def setDrawMode(self, mode: PySide2.QtDataVisualization.QtDataVisualization.QSurface3DSeries.DrawFlags): ...
        def setFlatShadingEnabled(self, enabled: bool): ...
        def setSelectedPoint(self, position: PySide2.QtCore.QPoint): ...
        def setTexture(self, texture: PySide2.QtGui.QImage): ...
        def setTextureFile(self, filename: str): ...
        def texture(self) -> PySide2.QtGui.QImage: ...
        def textureFile(self) -> str: ...

    class QSurfaceDataItem(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, other: PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataItem): ...
        @typing.overload
        def __init__(self, position: PySide2.QtGui.QVector3D): ...
        def __copy__(self): ...
        def createExtraData(self): ...
        def position(self) -> PySide2.QtGui.QVector3D: ...
        def setPosition(self, pos: PySide2.QtGui.QVector3D): ...
        def setX(self, value: float): ...
        def setY(self, value: float): ...
        def setZ(self, value: float): ...
        def x(self) -> float: ...
        def y(self) -> float: ...
        def z(self) -> float: ...

    class QSurfaceDataProxy(PySide2.QtDataVisualization.QtDataVisualization.QAbstractDataProxy):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def addRow(self, row: list) -> int: ...
        def addRows(self, rows: typing.List[typing.List[PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataItem]]) -> int: ...
        def array(self) -> typing.List[typing.List[PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataItem]]: ...
        def columnCount(self) -> int: ...
        def insertRow(self, rowIndex: int, row: list): ...
        def insertRows(self, rowIndex: int, rows: typing.List[typing.List[PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataItem]]): ...
        @typing.overload
        def itemAt(self, position: PySide2.QtCore.QPoint) -> PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataItem: ...
        @typing.overload
        def itemAt(self, rowIndex: int, columnIndex: int) -> PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataItem: ...
        def removeRows(self, rowIndex: int, removeCount: int): ...
        def resetArray(self, newArray: typing.List[typing.List[PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataItem]]): ...
        def rowCount(self) -> int: ...
        def series(self) -> PySide2.QtDataVisualization.QtDataVisualization.QSurface3DSeries: ...
        @typing.overload
        def setItem(self, position: PySide2.QtCore.QPoint, item: PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataItem): ...
        @typing.overload
        def setItem(self, rowIndex: int, columnIndex: int, item: PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataItem): ...
        def setRow(self, rowIndex: int, row: list): ...
        def setRows(self, rowIndex: int, rows: typing.List[typing.List[PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataItem]]): ...

    class QTouch3DInputHandler(PySide2.QtDataVisualization.QtDataVisualization.Q3DInputHandler):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def touchEvent(self, event: PySide2.QtGui.QTouchEvent): ...

    class QValue3DAxis(PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def formatter(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxisFormatter: ...
        def labelFormat(self) -> str: ...
        def reversed(self) -> bool: ...
        def segmentCount(self) -> int: ...
        def setFormatter(self, formatter: PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxisFormatter): ...
        def setLabelFormat(self, format: str): ...
        def setReversed(self, enable: bool): ...
        def setSegmentCount(self, count: int): ...
        def setSubSegmentCount(self, count: int): ...
        def subSegmentCount(self) -> int: ...

    class QValue3DAxisFormatter(PySide2.QtCore.QObject):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def allowNegatives(self) -> bool: ...
        def allowZero(self) -> bool: ...
        def axis(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...
        def createNewInstance(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxisFormatter: ...
        def gridPositions(self) -> float: ...
        def labelPositions(self) -> float: ...
        def labelStrings(self) -> typing.List[str]: ...
        def locale(self) -> PySide2.QtCore.QLocale: ...
        def markDirty(self, labelsChange: bool = ...): ...
        def populateCopy(self, copy: PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxisFormatter): ...
        def positionAt(self, value: float) -> float: ...
        def recalculate(self): ...
        def setAllowNegatives(self, allow: bool): ...
        def setAllowZero(self, allow: bool): ...
        def setLocale(self, locale: PySide2.QtCore.QLocale): ...
        def stringForValue(self, value: float, format: str) -> str: ...
        def subGridPositions(self) -> float: ...
        def valueAt(self, position: float) -> float: ...

# eof
