/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.multitouch.sparshui;

import com.sparshui.common.Event;
import com.sparshui.common.Location;
import com.sparshui.common.messages.events.DragEvent;
import com.sparshui.common.messages.events.RotateEvent;
import com.sparshui.common.messages.events.ZoomEvent;
import com.sparshui.gestures.Gesture;
import com.sparshui.server.TouchPoint;
import java.util.ArrayList;
import java.util.List;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.util.Logger;

public class TwoPointGesture
implements Gesture {
    private int _myType = 9;
    protected Location _offset = null;
    protected Location _offsetCentroid = null;
    private List<Location> _traces1 = new ArrayList<Location>();
    private List<Location> _traces2 = new ArrayList<Location>();
    private int _id1 = -1;
    private int _id2 = -1;
    private int _nTraces = 0;
    private float _scale;
    private float _rotation;
    private long time;

    @Override
    public String getName() {
        return "TwoPointGesture";
    }

    @Override
    public int getGestureType() {
        return this._myType;
    }

    @Override
    public List<Event> processChange(List<TouchPoint> touchPoints, TouchPoint changedPoint) {
        return this.processChangeSync(changedPoint);
    }

    private synchronized List<Event> processChangeSync(TouchPoint changedPoint) {
        ArrayList events = null;
        this.time = changedPoint.getTime();
        switch (changedPoint.getState()) {
            case 0: {
                events = this.processBirth(changedPoint);
                break;
            }
            case 2: {
                events = this.processMove(changedPoint);
                break;
            }
            case 1: {
                events = this.processDeath(changedPoint);
            }
        }
        return events != null ? events : new ArrayList();
    }

    protected List<Event> processBirth(TouchPoint touchPoint) {
        Location location = touchPoint.getLocation();
        int id = touchPoint.getID();
        switch (this._nTraces) {
            case 0: {
                this._traces1.clear();
                this._traces1.add(Location.pixelLocation(location));
                this._id1 = id;
                this._nTraces = 1;
                break;
            }
            case 1: {
                this._traces2.clear();
                this._traces2.add(Location.pixelLocation(location));
                this._id2 = id;
                Location o = this._traces1.get(this._traces1.size() - 1);
                this._traces1.clear();
                this._traces1.add(o);
                this._nTraces = 2;
                break;
            }
            default: {
                Logger.error((String)"TwoPointGesture birth ignored!");
            }
        }
        return null;
    }

    protected List<Event> processDeath(TouchPoint touchPoint) {
        int id = touchPoint.getID();
        switch (this._nTraces) {
            case 0: {
                Logger.error((String)("TwoPointGesture death -- no traces! " + id));
                break;
            }
            case 1: {
                this._nTraces = 0;
                break;
            }
            case 2: {
                if (id == this._id1) {
                    this._id1 = this._id2;
                    List<Location> v = this._traces1;
                    this._traces1 = this._traces2;
                    this._traces2 = v;
                    this._traces2.clear();
                    this._id2 = -1;
                    this._nTraces = 1;
                    break;
                }
                if (id == this._id2) {
                    this._traces2.clear();
                    this._id2 = -1;
                    this._nTraces = 1;
                    break;
                }
                this._nTraces = 0;
            }
        }
        if (this._nTraces == 0) {
            this._traces1.clear();
            this._traces2.clear();
            this._id2 = -1;
            this._id1 = -1;
        }
        this._offsetCentroid = null;
        this._myType = 9;
        return null;
    }

    protected List<Event> processMove(TouchPoint touchPoint) {
        ArrayList<Event> events = new ArrayList<Event>();
        if (!this.updateLocations(touchPoint)) {
            return events;
        }
        if (this._myType == 9) {
            this.checkType();
        }
        Location locationLast = Location.screenLocation(this._offsetCentroid);
        if (this._myType == 9 || !this.updateParameters()) {
            return events;
        }
        Location location = Location.screenLocation(this._offsetCentroid);
        Event event = null;
        switch (this._myType) {
            case 5: {
                event = new ZoomEvent(this._scale, location, this.time);
                break;
            }
            case 2: {
                event = new RotateEvent(this._rotation, location, this.time);
                break;
            }
            case 1: {
                if (locationLast == null) break;
                V3 dxy = locationLast.getVector(location);
                event = new DragEvent(dxy.x, dxy.y, 2, this.time);
            }
        }
        if (event != null) {
            events.add(event);
        }
        return events;
    }

    private boolean updateLocations(TouchPoint touchPoint) {
        Location location = Location.pixelLocation(touchPoint.getLocation());
        int id = touchPoint.getID();
        if (id == this._id1) {
            if (this._traces1.size() > 2) {
                while (this._traces1.size() > 2) {
                    this._traces1.remove(0);
                }
            }
            this._traces1.add(location);
        } else if (id == this._id2) {
            if (this._traces2.size() > 2) {
                while (this._traces2.size() > 2) {
                    this._traces2.remove(0);
                }
            }
            this._traces2.add(location);
        } else {
            Logger.error((String)("TwoPointGesture updateLocation error: no trace with id " + id));
            return false;
        }
        return this._nTraces == 2 && this._traces1.size() == 3 && this._traces2.size() == 3;
    }

    private void checkType() {
        Location loc10 = this._traces1.get(0);
        Location loc11 = this._traces1.get(this._traces1.size() - 1);
        V3 v1 = loc10.getVector(loc11);
        float d1 = v1.length();
        Location loc20 = this._traces2.get(0);
        Location loc21 = this._traces2.get(this._traces2.size() - 1);
        V3 v2 = loc20.getVector(loc21);
        float d2 = v2.length();
        if (d1 < 3.0f || d2 < 3.0f) {
            return;
        }
        v1.normalize();
        v2.normalize();
        float cos12 = v1.dot((T3)v2);
        if ((double)cos12 > 0.8) {
            this._myType = 1;
        } else if ((double)cos12 < -0.8) {
            this._myType = 5;
        }
    }

    private boolean updateParameters() {
        Location loc10 = this._traces1.get(0);
        Location loc20 = this._traces2.get(0);
        Location loc11 = this._traces1.get(this._traces1.size() - 1);
        Location loc21 = this._traces2.get(this._traces2.size() - 1);
        float d1 = loc10.getDistance(loc11);
        float d2 = loc20.getDistance(loc21);
        float d12 = loc11.getDistance(loc21);
        if (d1 < 2.0f && d2 < 2.0f) {
            return false;
        }
        V3 v00 = loc10.getVector(loc20);
        float d00 = v00.length();
        v00.normalize();
        switch (this._myType) {
            case 2: {
                V3 v2;
                V3 v1;
                this._offsetCentroid = Location.getCenter(loc10, loc20);
                if (d2 < 2.0f) {
                    v1 = loc20.getVector(loc10);
                    v2 = loc20.getVector(loc11);
                } else {
                    v1 = loc10.getVector(loc20);
                    v2 = loc10.getVector(loc21);
                }
                v1.cross((T3)v1, (T3)v2);
                this._rotation = v1.z < 0.0f ? 1 : -1;
                return true;
            }
            case 5: {
                if (Math.abs(d12 - d00) < 2.0f) {
                    return false;
                }
                this._scale = d12 < d00 ? -1 : 1;
                this._offsetCentroid = Location.getCentroid(loc10, loc20, d1 / (d1 + d2));
                return true;
            }
            case 1: {
                this._offsetCentroid = Location.getCenter(loc11, loc21);
                return true;
            }
        }
        return false;
    }
}

