/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.lookup;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.elasticsearch.painless.lookup.PainlessClassBinding;
import org.elasticsearch.painless.lookup.PainlessClassBuilder;
import org.elasticsearch.painless.lookup.PainlessConstructor;
import org.elasticsearch.painless.lookup.PainlessField;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.spi.Whitelist;
import org.elasticsearch.painless.spi.WhitelistClass;
import org.elasticsearch.painless.spi.WhitelistClassBinding;
import org.elasticsearch.painless.spi.WhitelistConstructor;
import org.elasticsearch.painless.spi.WhitelistField;
import org.elasticsearch.painless.spi.WhitelistMethod;

public final class PainlessLookupBuilder {
    private static final Map<PainlessConstructor, PainlessConstructor> painlessConstructorCache = new HashMap<PainlessConstructor, PainlessConstructor>();
    private static final Map<PainlessMethod, PainlessMethod> painlessMethodCache = new HashMap<PainlessMethod, PainlessMethod>();
    private static final Map<PainlessField, PainlessField> painlessFieldCache = new HashMap<PainlessField, PainlessField>();
    private static final Map<PainlessClassBinding, PainlessClassBinding> painlessClassBindingCache = new HashMap<PainlessClassBinding, PainlessClassBinding>();
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("^[_a-zA-Z][._a-zA-Z0-9]*$");
    private static final Pattern METHOD_NAME_PATTERN = Pattern.compile("^[_a-zA-Z][_a-zA-Z0-9]*$");
    private static final Pattern FIELD_NAME_PATTERN = Pattern.compile("^[_a-zA-Z][_a-zA-Z0-9]*$");
    private final Map<String, Class<?>> javaClassNamesToClasses = new HashMap();
    private final Map<String, Class<?>> canonicalClassNamesToClasses = new HashMap();
    private final Map<Class<?>, PainlessClassBuilder> classesToPainlessClassBuilders = new HashMap();
    private final Map<String, PainlessMethod> painlessMethodKeysToImportedPainlessMethods = new HashMap<String, PainlessMethod>();
    private final Map<String, PainlessClassBinding> painlessMethodKeysToPainlessClassBindings = new HashMap<String, PainlessClassBinding>();

    public static PainlessLookup buildFromWhitelists(List<Whitelist> whitelists) {
        PainlessLookupBuilder painlessLookupBuilder = new PainlessLookupBuilder();
        String origin = "internal error";
        try {
            for (Whitelist whitelist : whitelists) {
                for (WhitelistClass whitelistClass : whitelist.whitelistClasses) {
                    origin = whitelistClass.origin;
                    painlessLookupBuilder.addPainlessClass(whitelist.classLoader, whitelistClass.javaClassName, !whitelistClass.noImport);
                }
            }
            for (Whitelist whitelist : whitelists) {
                for (WhitelistClass whitelistClass : whitelist.whitelistClasses) {
                    String targetCanonicalClassName = whitelistClass.javaClassName.replace('$', '.');
                    for (WhitelistConstructor whitelistConstructor : whitelistClass.whitelistConstructors) {
                        origin = whitelistConstructor.origin;
                        painlessLookupBuilder.addPainlessConstructor(targetCanonicalClassName, whitelistConstructor.canonicalTypeNameParameters);
                    }
                    for (WhitelistMethod whitelistMethod : whitelistClass.whitelistMethods) {
                        origin = whitelistMethod.origin;
                        painlessLookupBuilder.addPainlessMethod(whitelist.classLoader, targetCanonicalClassName, whitelistMethod.augmentedCanonicalClassName, whitelistMethod.methodName, whitelistMethod.returnCanonicalTypeName, whitelistMethod.canonicalTypeNameParameters);
                    }
                    for (WhitelistField whitelistField : whitelistClass.whitelistFields) {
                        origin = whitelistField.origin;
                        painlessLookupBuilder.addPainlessField(targetCanonicalClassName, whitelistField.fieldName, whitelistField.canonicalTypeNameParameter);
                    }
                }
                for (WhitelistMethod whitelistStatic : whitelist.whitelistImportedMethods) {
                    origin = whitelistStatic.origin;
                    painlessLookupBuilder.addImportedPainlessMethod(whitelist.classLoader, whitelistStatic.augmentedCanonicalClassName, whitelistStatic.methodName, whitelistStatic.returnCanonicalTypeName, whitelistStatic.canonicalTypeNameParameters);
                }
                for (WhitelistClassBinding whitelistClassBinding : whitelist.whitelistClassBindings) {
                    origin = whitelistClassBinding.origin;
                    painlessLookupBuilder.addPainlessClassBinding(whitelist.classLoader, whitelistClassBinding.targetJavaClassName, whitelistClassBinding.methodName, whitelistClassBinding.returnCanonicalTypeName, whitelistClassBinding.canonicalTypeNameParameters);
                }
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("error loading whitelist(s) " + origin, exception);
        }
        return painlessLookupBuilder.build();
    }

    private Class<?> canonicalTypeNameToType(String canonicalTypeName) {
        return PainlessLookupUtility.canonicalTypeNameToType(canonicalTypeName, this.canonicalClassNamesToClasses);
    }

    private boolean isValidType(Class<?> type) {
        while (type.getComponentType() != null) {
            type = type.getComponentType();
        }
        return type == def.class || this.classesToPainlessClassBuilders.containsKey(type);
    }

    public void addPainlessClass(ClassLoader classLoader, String javaClassName, boolean importClassName) {
        Class<Object> clazz;
        Objects.requireNonNull(classLoader);
        Objects.requireNonNull(javaClassName);
        if ("void".equals(javaClassName)) {
            clazz = Void.TYPE;
        } else if ("boolean".equals(javaClassName)) {
            clazz = Boolean.TYPE;
        } else if ("byte".equals(javaClassName)) {
            clazz = Byte.TYPE;
        } else if ("short".equals(javaClassName)) {
            clazz = Short.TYPE;
        } else if ("char".equals(javaClassName)) {
            clazz = Character.TYPE;
        } else if ("int".equals(javaClassName)) {
            clazz = Integer.TYPE;
        } else if ("long".equals(javaClassName)) {
            clazz = Long.TYPE;
        } else if ("float".equals(javaClassName)) {
            clazz = Float.TYPE;
        } else if ("double".equals(javaClassName)) {
            clazz = Double.TYPE;
        } else {
            try {
                clazz = Class.forName(javaClassName, true, classLoader);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("class [" + javaClassName + "] not found", cnfe);
            }
        }
        this.addPainlessClass(clazz, importClassName);
    }

    public void addPainlessClass(Class<?> clazz, boolean importClassName) {
        String javaClassName;
        String importedCanonicalClassName;
        Objects.requireNonNull(clazz);
        if (clazz == def.class) {
            throw new IllegalArgumentException("cannot add reserved class [def]");
        }
        String canonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(clazz);
        if (clazz.isArray()) {
            throw new IllegalArgumentException("cannot add array type [" + canonicalClassName + "] as a class");
        }
        if (!CLASS_NAME_PATTERN.matcher(canonicalClassName).matches()) {
            throw new IllegalArgumentException("invalid class name [" + canonicalClassName + "]");
        }
        Class<?> existingClass = this.javaClassNamesToClasses.get(clazz.getName());
        if (existingClass == null) {
            this.javaClassNamesToClasses.put(clazz.getName(), clazz);
        } else if (existingClass != clazz) {
            throw new IllegalArgumentException("class [" + canonicalClassName + "] cannot represent multiple java classes with the same name from different class loaders");
        }
        existingClass = this.canonicalClassNamesToClasses.get(canonicalClassName);
        if (existingClass != null && existingClass != clazz) {
            throw new IllegalArgumentException("class [" + canonicalClassName + "] cannot represent multiple java classes with the same name from different class loaders");
        }
        PainlessClassBuilder existingPainlessClassBuilder = this.classesToPainlessClassBuilders.get(clazz);
        if (existingPainlessClassBuilder == null) {
            PainlessClassBuilder painlessClassBuilder = new PainlessClassBuilder();
            this.canonicalClassNamesToClasses.put(canonicalClassName, clazz);
            this.classesToPainlessClassBuilders.put(clazz, painlessClassBuilder);
        }
        if (canonicalClassName.equals(importedCanonicalClassName = (javaClassName = clazz.getName()).substring(javaClassName.lastIndexOf(46) + 1).replace('$', '.'))) {
            if (importClassName) {
                throw new IllegalArgumentException("must use no_import parameter on class [" + canonicalClassName + "] with no package");
            }
        } else {
            Class<?> importedClass = this.canonicalClassNamesToClasses.get(importedCanonicalClassName);
            if (importedClass == null) {
                if (importClassName) {
                    if (existingPainlessClassBuilder != null) {
                        throw new IllegalArgumentException("inconsistent no_import parameter found for class [" + canonicalClassName + "]");
                    }
                    this.canonicalClassNamesToClasses.put(importedCanonicalClassName, clazz);
                }
            } else {
                if (importedClass != clazz) {
                    throw new IllegalArgumentException("imported class [" + importedCanonicalClassName + "] cannot represent multiple classes [" + canonicalClassName + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(importedClass) + "]");
                }
                if (!importClassName) {
                    throw new IllegalArgumentException("inconsistent no_import parameter found for class [" + canonicalClassName + "]");
                }
            }
        }
    }

    public void addPainlessConstructor(String targetCanonicalClassName, List<String> canonicalTypeNameParameters) {
        Objects.requireNonNull(targetCanonicalClassName);
        Objects.requireNonNull(canonicalTypeNameParameters);
        Class<?> targetClass = this.canonicalClassNamesToClasses.get(targetCanonicalClassName);
        if (targetClass == null) {
            throw new IllegalArgumentException("target class [" + targetCanonicalClassName + "] not foundfor constructor [[" + targetCanonicalClassName + "], " + canonicalTypeNameParameters + "]");
        }
        ArrayList typeParameters = new ArrayList(canonicalTypeNameParameters.size());
        for (String canonicalTypeNameParameter : canonicalTypeNameParameters) {
            Class<?> typeParameter = this.canonicalTypeNameToType(canonicalTypeNameParameter);
            if (typeParameter == null) {
                throw new IllegalArgumentException("type parameter [" + canonicalTypeNameParameter + "] not found for constructor [[" + targetCanonicalClassName + "], " + canonicalTypeNameParameters + "]");
            }
            typeParameters.add(typeParameter);
        }
        this.addPainlessConstructor(targetClass, typeParameters);
    }

    public void addPainlessConstructor(Class<?> targetClass, List<Class<?>> typeParameters) {
        MethodHandle methodHandle;
        Constructor<?> javaConstructor;
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(typeParameters);
        if (targetClass == def.class) {
            throw new IllegalArgumentException("cannot add constructor to reserved class [def]");
        }
        String targetCanonicalClassName = targetClass.getCanonicalName();
        PainlessClassBuilder painlessClassBuilder = this.classesToPainlessClassBuilders.get(targetClass);
        if (painlessClassBuilder == null) {
            throw new IllegalArgumentException("target class [" + targetCanonicalClassName + "] not foundfor constructor [[" + targetCanonicalClassName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
        }
        int typeParametersSize = typeParameters.size();
        ArrayList javaTypeParameters = new ArrayList(typeParametersSize);
        for (Class<?> typeParameter : typeParameters) {
            if (!this.isValidType(typeParameter)) {
                throw new IllegalArgumentException("type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] not found for constructor [[" + targetCanonicalClassName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
            }
            javaTypeParameters.add(PainlessLookupUtility.typeToJavaType(typeParameter));
        }
        try {
            javaConstructor = targetClass.getConstructor(javaTypeParameters.toArray(new Class[typeParametersSize]));
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("reflection object not found for constructor [[" + targetCanonicalClassName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]", nsme);
        }
        try {
            methodHandle = MethodHandles.publicLookup().in(targetClass).unreflectConstructor(javaConstructor);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("method handle not found for constructor [[" + targetCanonicalClassName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]", iae);
        }
        MethodType methodType = methodHandle.type();
        String painlessConstructorKey = PainlessLookupUtility.buildPainlessConstructorKey(typeParametersSize);
        PainlessConstructor existingPainlessConstructor = painlessClassBuilder.constructors.get(painlessConstructorKey);
        PainlessConstructor newPainlessConstructor = new PainlessConstructor(javaConstructor, typeParameters, methodHandle, methodType);
        if (existingPainlessConstructor == null) {
            newPainlessConstructor = painlessConstructorCache.computeIfAbsent(newPainlessConstructor, key -> key);
            painlessClassBuilder.constructors.put(painlessConstructorKey, newPainlessConstructor);
        } else if (!newPainlessConstructor.equals(existingPainlessConstructor)) {
            throw new IllegalArgumentException("cannot add constructors with the same arity but are not equivalent for constructors [[" + targetCanonicalClassName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] and [[" + targetCanonicalClassName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(existingPainlessConstructor.typeParameters) + "]");
        }
    }

    public void addPainlessMethod(ClassLoader classLoader, String targetCanonicalClassName, String augmentedCanonicalClassName, String methodName, String returnCanonicalTypeName, List<String> canonicalTypeNameParameters) {
        Objects.requireNonNull(classLoader);
        Objects.requireNonNull(targetCanonicalClassName);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnCanonicalTypeName);
        Objects.requireNonNull(canonicalTypeNameParameters);
        Class<?> targetClass = this.canonicalClassNamesToClasses.get(targetCanonicalClassName);
        if (targetClass == null) {
            throw new IllegalArgumentException("target class [" + targetCanonicalClassName + "] not found for method [[" + targetCanonicalClassName + "], [" + methodName + "], " + canonicalTypeNameParameters + "]");
        }
        Class<?> augmentedClass = null;
        if (augmentedCanonicalClassName != null) {
            try {
                augmentedClass = Class.forName(augmentedCanonicalClassName, true, classLoader);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("augmented class [" + augmentedCanonicalClassName + "] not found for method [[" + targetCanonicalClassName + "], [" + methodName + "], " + canonicalTypeNameParameters + "]", cnfe);
            }
        }
        ArrayList typeParameters = new ArrayList(canonicalTypeNameParameters.size());
        for (String canonicalTypeNameParameter : canonicalTypeNameParameters) {
            Class<?> typeParameter = this.canonicalTypeNameToType(canonicalTypeNameParameter);
            if (typeParameter == null) {
                throw new IllegalArgumentException("type parameter [" + canonicalTypeNameParameter + "] not found for method [[" + targetCanonicalClassName + "], [" + methodName + "], " + canonicalTypeNameParameters + "]");
            }
            typeParameters.add(typeParameter);
        }
        Class<?> returnType = this.canonicalTypeNameToType(returnCanonicalTypeName);
        if (returnType == null) {
            throw new IllegalArgumentException("return type [" + returnCanonicalTypeName + "] not found for method [[" + targetCanonicalClassName + "], [" + methodName + "], " + canonicalTypeNameParameters + "]");
        }
        this.addPainlessMethod(targetClass, augmentedClass, methodName, returnType, typeParameters);
    }

    public void addPainlessMethod(Class<?> targetClass, Class<?> augmentedClass, String methodName, Class<?> returnType, List<Class<?>> typeParameters) {
        MethodHandle methodHandle;
        Method javaMethod;
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnType);
        Objects.requireNonNull(typeParameters);
        if (targetClass == def.class) {
            throw new IllegalArgumentException("cannot add method to reserved class [def]");
        }
        String targetCanonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(targetClass);
        if (!METHOD_NAME_PATTERN.matcher(methodName).matches()) {
            throw new IllegalArgumentException("invalid method name [" + methodName + "] for target class [" + targetCanonicalClassName + "].");
        }
        PainlessClassBuilder painlessClassBuilder = this.classesToPainlessClassBuilders.get(targetClass);
        if (painlessClassBuilder == null) {
            throw new IllegalArgumentException("target class [" + targetCanonicalClassName + "] not found for method [[" + targetCanonicalClassName + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
        }
        int typeParametersSize = typeParameters.size();
        int augmentedParameterOffset = augmentedClass == null ? 0 : 1;
        ArrayList javaTypeParameters = new ArrayList(typeParametersSize + augmentedParameterOffset);
        if (augmentedClass != null) {
            javaTypeParameters.add(targetClass);
        }
        for (Class<?> typeParameter : typeParameters) {
            if (!this.isValidType(typeParameter)) {
                throw new IllegalArgumentException("type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] not found for method [[" + targetCanonicalClassName + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
            }
            javaTypeParameters.add(PainlessLookupUtility.typeToJavaType(typeParameter));
        }
        if (!this.isValidType(returnType)) {
            throw new IllegalArgumentException("return type [" + PainlessLookupUtility.typeToCanonicalTypeName(returnType) + "] not found for method [[" + targetCanonicalClassName + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
        }
        if (augmentedClass == null) {
            try {
                javaMethod = targetClass.getMethod(methodName, javaTypeParameters.toArray(new Class[typeParametersSize]));
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalArgumentException("reflection object not found for method [[" + targetCanonicalClassName + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]", nsme);
            }
        }
        try {
            javaMethod = augmentedClass.getMethod(methodName, javaTypeParameters.toArray(new Class[typeParametersSize]));
            if (!Modifier.isStatic(javaMethod.getModifiers())) {
                throw new IllegalArgumentException("method [[" + targetCanonicalClassName + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] with augmented class [" + PainlessLookupUtility.typeToCanonicalTypeName(augmentedClass) + "] must be static");
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("reflection object not found for method [[" + targetCanonicalClassName + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] with augmented class [" + PainlessLookupUtility.typeToCanonicalTypeName(augmentedClass) + "]", nsme);
        }
        if (javaMethod.getReturnType() != PainlessLookupUtility.typeToJavaType(returnType)) {
            throw new IllegalArgumentException("return type [" + PainlessLookupUtility.typeToCanonicalTypeName(javaMethod.getReturnType()) + "] does not match the specified returned type [" + PainlessLookupUtility.typeToCanonicalTypeName(returnType) + "] for method [[" + targetClass.getCanonicalName() + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
        }
        if (augmentedClass == null) {
            try {
                methodHandle = MethodHandles.publicLookup().in(targetClass).unreflect(javaMethod);
            }
            catch (IllegalAccessException iae) {
                throw new IllegalArgumentException("method handle not found for method [[" + targetClass.getCanonicalName() + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]", iae);
            }
        }
        try {
            methodHandle = MethodHandles.publicLookup().in(augmentedClass).unreflect(javaMethod);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("method handle not found for method [[" + targetClass.getCanonicalName() + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]with augmented class [" + PainlessLookupUtility.typeToCanonicalTypeName(augmentedClass) + "]", iae);
        }
        MethodType methodType = methodHandle.type();
        boolean isStatic = augmentedClass == null && Modifier.isStatic(javaMethod.getModifiers());
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, typeParametersSize);
        PainlessMethod existingPainlessMethod = isStatic ? painlessClassBuilder.staticMethods.get(painlessMethodKey) : painlessClassBuilder.methods.get(painlessMethodKey);
        PainlessMethod newPainlessMethod = new PainlessMethod(javaMethod, targetClass, returnType, typeParameters, methodHandle, methodType);
        if (existingPainlessMethod == null) {
            newPainlessMethod = painlessMethodCache.computeIfAbsent(newPainlessMethod, key -> key);
            if (isStatic) {
                painlessClassBuilder.staticMethods.put(painlessMethodKey, newPainlessMethod);
            } else {
                painlessClassBuilder.methods.put(painlessMethodKey, newPainlessMethod);
            }
        } else if (!newPainlessMethod.equals(existingPainlessMethod)) {
            throw new IllegalArgumentException("cannot add methods with the same name and arity but are not equivalent for methods [[" + targetCanonicalClassName + "], [" + methodName + "], [" + PainlessLookupUtility.typeToCanonicalTypeName(returnType) + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] and [[" + targetCanonicalClassName + "], [" + methodName + "], [" + PainlessLookupUtility.typeToCanonicalTypeName(existingPainlessMethod.returnType) + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(existingPainlessMethod.typeParameters) + "]");
        }
    }

    public void addPainlessField(String targetCanonicalClassName, String fieldName, String canonicalTypeNameParameter) {
        Objects.requireNonNull(targetCanonicalClassName);
        Objects.requireNonNull(fieldName);
        Objects.requireNonNull(canonicalTypeNameParameter);
        Class<?> targetClass = this.canonicalClassNamesToClasses.get(targetCanonicalClassName);
        if (targetClass == null) {
            throw new IllegalArgumentException("target class [" + targetCanonicalClassName + "] not found for field [[" + targetCanonicalClassName + "], [" + fieldName + "], [" + canonicalTypeNameParameter + "]]");
        }
        Class<?> typeParameter = this.canonicalTypeNameToType(canonicalTypeNameParameter);
        if (typeParameter == null) {
            throw new IllegalArgumentException("type parameter [" + canonicalTypeNameParameter + "] not found for field [[" + targetCanonicalClassName + "], [" + fieldName + "]");
        }
        this.addPainlessField(targetClass, fieldName, typeParameter);
    }

    public void addPainlessField(Class<?> targetClass, String fieldName, Class<?> typeParameter) {
        MethodHandle methodHandleGetter;
        Field javaField;
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(fieldName);
        Objects.requireNonNull(typeParameter);
        if (targetClass == def.class) {
            throw new IllegalArgumentException("cannot add field to reserved class [def]");
        }
        String targetCanonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(targetClass);
        if (!FIELD_NAME_PATTERN.matcher(fieldName).matches()) {
            throw new IllegalArgumentException("invalid field name [" + fieldName + "] for target class [" + targetCanonicalClassName + "].");
        }
        PainlessClassBuilder painlessClassBuilder = this.classesToPainlessClassBuilders.get(targetClass);
        if (painlessClassBuilder == null) {
            throw new IllegalArgumentException("target class [" + targetCanonicalClassName + "] not found for field [[" + targetCanonicalClassName + "], [" + fieldName + "], [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "]]");
        }
        if (!this.isValidType(typeParameter)) {
            throw new IllegalArgumentException("type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] not found for field [[" + targetCanonicalClassName + "], [" + fieldName + "]");
        }
        try {
            javaField = targetClass.getField(fieldName);
        }
        catch (NoSuchFieldException nsme) {
            throw new IllegalArgumentException("reflection object not found for field [[" + targetCanonicalClassName + "], [" + fieldName + "]", nsme);
        }
        if (javaField.getType() != PainlessLookupUtility.typeToJavaType(typeParameter)) {
            throw new IllegalArgumentException("type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(javaField.getType()) + "] does not match the specified type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] for field [[" + targetCanonicalClassName + "], [" + fieldName + "]");
        }
        try {
            methodHandleGetter = MethodHandles.publicLookup().unreflectGetter(javaField);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("getter method handle not found for field [[" + targetCanonicalClassName + "], [" + fieldName + "]]");
        }
        String painlessFieldKey = PainlessLookupUtility.buildPainlessFieldKey(fieldName);
        if (Modifier.isStatic(javaField.getModifiers())) {
            if (!Modifier.isFinal(javaField.getModifiers())) {
                throw new IllegalArgumentException("static field [[" + targetCanonicalClassName + "], [" + fieldName + "]] must be final");
            }
            PainlessField existingPainlessField = painlessClassBuilder.staticFields.get(painlessFieldKey);
            PainlessField newPainlessField = new PainlessField(javaField, typeParameter, methodHandleGetter, null);
            if (existingPainlessField == null) {
                newPainlessField = painlessFieldCache.computeIfAbsent(newPainlessField, key -> key);
                painlessClassBuilder.staticFields.put(painlessFieldKey, newPainlessField);
            } else if (!newPainlessField.equals(existingPainlessField)) {
                throw new IllegalArgumentException("cannot add fields with the same name but are not equivalent for fields [[" + targetCanonicalClassName + "], [" + fieldName + "], [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] and [[" + targetCanonicalClassName + "], [" + existingPainlessField.javaField.getName() + "], " + PainlessLookupUtility.typeToCanonicalTypeName(existingPainlessField.typeParameter) + "] with the same name and different type parameters");
            }
        } else {
            MethodHandle methodHandleSetter;
            try {
                methodHandleSetter = MethodHandles.publicLookup().unreflectSetter(javaField);
            }
            catch (IllegalAccessException iae) {
                throw new IllegalArgumentException("setter method handle not found for field [[" + targetCanonicalClassName + "], [" + fieldName + "]]");
            }
            PainlessField existingPainlessField = painlessClassBuilder.fields.get(painlessFieldKey);
            PainlessField newPainlessField = new PainlessField(javaField, typeParameter, methodHandleGetter, methodHandleSetter);
            if (existingPainlessField == null) {
                newPainlessField = painlessFieldCache.computeIfAbsent(newPainlessField, key -> key);
                painlessClassBuilder.fields.put(painlessFieldKey, newPainlessField);
            } else if (!newPainlessField.equals(existingPainlessField)) {
                throw new IllegalArgumentException("cannot add fields with the same name but are not equivalent for fields [[" + targetCanonicalClassName + "], [" + fieldName + "], [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] and [[" + targetCanonicalClassName + "], [" + existingPainlessField.javaField.getName() + "], " + PainlessLookupUtility.typeToCanonicalTypeName(existingPainlessField.typeParameter) + "] with the same name and different type parameters");
            }
        }
    }

    public void addImportedPainlessMethod(ClassLoader classLoader, String targetJavaClassName, String methodName, String returnCanonicalTypeName, List<String> canonicalTypeNameParameters) {
        Class<?> targetClass;
        Objects.requireNonNull(classLoader);
        Objects.requireNonNull(targetJavaClassName);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnCanonicalTypeName);
        Objects.requireNonNull(canonicalTypeNameParameters);
        try {
            targetClass = Class.forName(targetJavaClassName, true, classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("class [" + targetJavaClassName + "] not found", cnfe);
        }
        String targetCanonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(targetClass);
        if (targetClass == null) {
            throw new IllegalArgumentException("target class [" + targetCanonicalClassName + "] not found for imported method [[" + targetCanonicalClassName + "], [" + methodName + "], " + canonicalTypeNameParameters + "]");
        }
        ArrayList typeParameters = new ArrayList(canonicalTypeNameParameters.size());
        for (String canonicalTypeNameParameter : canonicalTypeNameParameters) {
            Class<?> typeParameter = this.canonicalTypeNameToType(canonicalTypeNameParameter);
            if (typeParameter == null) {
                throw new IllegalArgumentException("type parameter [" + canonicalTypeNameParameter + "] not found for imported method [[" + targetCanonicalClassName + "], [" + methodName + "], " + canonicalTypeNameParameters + "]");
            }
            typeParameters.add(typeParameter);
        }
        Class<?> returnType = this.canonicalTypeNameToType(returnCanonicalTypeName);
        if (returnType == null) {
            throw new IllegalArgumentException("return type [" + returnCanonicalTypeName + "] not found for imported method [[" + targetCanonicalClassName + "], [" + methodName + "], " + canonicalTypeNameParameters + "]");
        }
        this.addImportedPainlessMethod(targetClass, methodName, returnType, typeParameters);
    }

    public void addImportedPainlessMethod(Class<?> targetClass, String methodName, Class<?> returnType, List<Class<?>> typeParameters) {
        MethodHandle methodHandle;
        Method javaMethod;
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnType);
        Objects.requireNonNull(typeParameters);
        if (targetClass == def.class) {
            throw new IllegalArgumentException("cannot add imported method from reserved class [def]");
        }
        String targetCanonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(targetClass);
        Class<?> existingTargetClass = this.javaClassNamesToClasses.get(targetClass.getName());
        if (existingTargetClass == null) {
            this.javaClassNamesToClasses.put(targetClass.getName(), targetClass);
        } else if (existingTargetClass != targetClass) {
            throw new IllegalArgumentException("class [" + targetCanonicalClassName + "] cannot represent multiple java classes with the same name from different class loaders");
        }
        if (!METHOD_NAME_PATTERN.matcher(methodName).matches()) {
            throw new IllegalArgumentException("invalid imported method name [" + methodName + "] for target class [" + targetCanonicalClassName + "].");
        }
        int typeParametersSize = typeParameters.size();
        ArrayList javaTypeParameters = new ArrayList(typeParametersSize);
        for (Class<?> typeParameter : typeParameters) {
            if (!this.isValidType(typeParameter)) {
                throw new IllegalArgumentException("type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] not found for imported method [[" + targetCanonicalClassName + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
            }
            javaTypeParameters.add(PainlessLookupUtility.typeToJavaType(typeParameter));
        }
        if (!this.isValidType(returnType)) {
            throw new IllegalArgumentException("return type [" + PainlessLookupUtility.typeToCanonicalTypeName(returnType) + "] not found for imported method [[" + targetCanonicalClassName + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
        }
        try {
            javaMethod = targetClass.getMethod(methodName, javaTypeParameters.toArray(new Class[typeParametersSize]));
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("imported method reflection object [[" + targetCanonicalClassName + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] not found", nsme);
        }
        if (javaMethod.getReturnType() != PainlessLookupUtility.typeToJavaType(returnType)) {
            throw new IllegalArgumentException("return type [" + PainlessLookupUtility.typeToCanonicalTypeName(javaMethod.getReturnType()) + "] does not match the specified returned type [" + PainlessLookupUtility.typeToCanonicalTypeName(returnType) + "] for imported method [[" + targetClass.getCanonicalName() + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
        }
        if (!Modifier.isStatic(javaMethod.getModifiers())) {
            throw new IllegalArgumentException("imported method [[" + targetClass.getCanonicalName() + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] must be static");
        }
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, typeParametersSize);
        if (this.painlessMethodKeysToPainlessClassBindings.containsKey(painlessMethodKey)) {
            throw new IllegalArgumentException("imported method and class binding cannot have the same name [" + methodName + "]");
        }
        try {
            methodHandle = MethodHandles.publicLookup().in(targetClass).unreflect(javaMethod);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("imported method handle [[" + targetClass.getCanonicalName() + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] not found", iae);
        }
        MethodType methodType = methodHandle.type();
        PainlessMethod existingImportedPainlessMethod = this.painlessMethodKeysToImportedPainlessMethods.get(painlessMethodKey);
        PainlessMethod newImportedPainlessMethod = new PainlessMethod(javaMethod, targetClass, returnType, typeParameters, methodHandle, methodType);
        if (existingImportedPainlessMethod == null) {
            newImportedPainlessMethod = painlessMethodCache.computeIfAbsent(newImportedPainlessMethod, key -> key);
            this.painlessMethodKeysToImportedPainlessMethods.put(painlessMethodKey, newImportedPainlessMethod);
        } else if (!newImportedPainlessMethod.equals(existingImportedPainlessMethod)) {
            throw new IllegalArgumentException("cannot add imported methods with the same name and arity but are not equivalent for methods [[" + targetCanonicalClassName + "], [" + methodName + "], [" + PainlessLookupUtility.typeToCanonicalTypeName(returnType) + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] and [[" + targetCanonicalClassName + "], [" + methodName + "], [" + PainlessLookupUtility.typeToCanonicalTypeName(existingImportedPainlessMethod.returnType) + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(existingImportedPainlessMethod.typeParameters) + "]");
        }
    }

    public void addPainlessClassBinding(ClassLoader classLoader, String targetJavaClassName, String methodName, String returnCanonicalTypeName, List<String> canonicalTypeNameParameters) {
        Class<?> targetClass;
        Objects.requireNonNull(classLoader);
        Objects.requireNonNull(targetJavaClassName);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnCanonicalTypeName);
        Objects.requireNonNull(canonicalTypeNameParameters);
        try {
            targetClass = Class.forName(targetJavaClassName, true, classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("class [" + targetJavaClassName + "] not found", cnfe);
        }
        String targetCanonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(targetClass);
        ArrayList typeParameters = new ArrayList(canonicalTypeNameParameters.size());
        for (String canonicalTypeNameParameter : canonicalTypeNameParameters) {
            Class<?> typeParameter = this.canonicalTypeNameToType(canonicalTypeNameParameter);
            if (typeParameter == null) {
                throw new IllegalArgumentException("type parameter [" + canonicalTypeNameParameter + "] not found for class binding [[" + targetCanonicalClassName + "], [" + methodName + "], " + canonicalTypeNameParameters + "]");
            }
            typeParameters.add(typeParameter);
        }
        Class<?> returnType = this.canonicalTypeNameToType(returnCanonicalTypeName);
        if (returnType == null) {
            throw new IllegalArgumentException("return type [" + returnCanonicalTypeName + "] not found for class binding [[" + targetCanonicalClassName + "], [" + methodName + "], " + canonicalTypeNameParameters + "]");
        }
        this.addPainlessClassBinding(targetClass, methodName, returnType, typeParameters);
    }

    public void addPainlessClassBinding(Class<?> targetClass, String methodName, Class<?> returnType, List<Class<?>> typeParameters) {
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnType);
        Objects.requireNonNull(typeParameters);
        if (targetClass == def.class) {
            throw new IllegalArgumentException("cannot add class binding as reserved class [def]");
        }
        String targetCanonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(targetClass);
        Class<?> existingTargetClass = this.javaClassNamesToClasses.get(targetClass.getName());
        if (existingTargetClass == null) {
            this.javaClassNamesToClasses.put(targetClass.getName(), targetClass);
        } else if (existingTargetClass != targetClass) {
            throw new IllegalArgumentException("class [" + targetCanonicalClassName + "] cannot represent multiple java classes with the same name from different class loaders");
        }
        Constructor<?>[] javaConstructors = targetClass.getConstructors();
        Constructor<?> javaConstructor = null;
        for (Constructor<?> constructor : javaConstructors) {
            if (constructor.getDeclaringClass() != targetClass) continue;
            if (javaConstructor != null) {
                throw new IllegalArgumentException("class binding [" + targetCanonicalClassName + "] cannot have multiple constructors");
            }
            javaConstructor = constructor;
        }
        if (javaConstructor == null) {
            throw new IllegalArgumentException("class binding [" + targetCanonicalClassName + "] must have exactly one constructor");
        }
        int constructorTypeParametersSize = javaConstructor.getParameterCount();
        for (int typeParameterIndex = 0; typeParameterIndex < constructorTypeParametersSize; ++typeParameterIndex) {
            Class<?> typeParameter = typeParameters.get(typeParameterIndex);
            if (!this.isValidType(typeParameter)) {
                throw new IllegalArgumentException("type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] not found for class binding [[" + targetCanonicalClassName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
            }
            Class<?> clazz = javaConstructor.getParameterTypes()[typeParameterIndex];
            if (!this.isValidType(clazz)) {
                throw new IllegalArgumentException("type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] not found for class binding [[" + targetCanonicalClassName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
            }
            if (clazz == PainlessLookupUtility.typeToJavaType(typeParameter)) continue;
            throw new IllegalArgumentException("type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(clazz) + "] does not match the specified type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] for class binding [[" + targetClass.getCanonicalName() + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
        }
        if (!METHOD_NAME_PATTERN.matcher(methodName).matches()) {
            throw new IllegalArgumentException("invalid method name [" + methodName + "] for class binding [" + targetCanonicalClassName + "].");
        }
        Method[] javaMethods = targetClass.getMethods();
        Method javaMethod = null;
        for (Method eachJavaMethod : javaMethods) {
            if (eachJavaMethod.getDeclaringClass() != targetClass) continue;
            if (javaMethod != null) {
                throw new IllegalArgumentException("class binding [" + targetCanonicalClassName + "] cannot have multiple methods");
            }
            javaMethod = eachJavaMethod;
        }
        if (javaMethod == null) {
            throw new IllegalArgumentException("class binding [" + targetCanonicalClassName + "] must have exactly one method");
        }
        int n = javaMethod.getParameterCount();
        for (int typeParameterIndex = 0; typeParameterIndex < n; ++typeParameterIndex) {
            Class<?> typeParameter = typeParameters.get(constructorTypeParametersSize + typeParameterIndex);
            if (!this.isValidType(typeParameter)) {
                throw new IllegalArgumentException("type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] not found for class binding [[" + targetCanonicalClassName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
            }
            Class<?> javaTypeParameter = javaMethod.getParameterTypes()[typeParameterIndex];
            if (!this.isValidType(javaTypeParameter)) {
                throw new IllegalArgumentException("type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] not found for class binding [[" + targetCanonicalClassName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
            }
            if (javaTypeParameter == PainlessLookupUtility.typeToJavaType(typeParameter)) continue;
            throw new IllegalArgumentException("type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(javaTypeParameter) + "] does not match the specified type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] for class binding [[" + targetClass.getCanonicalName() + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
        }
        if (javaMethod.getReturnType() != PainlessLookupUtility.typeToJavaType(returnType)) {
            throw new IllegalArgumentException("return type [" + PainlessLookupUtility.typeToCanonicalTypeName(javaMethod.getReturnType()) + "] does not match the specified returned type [" + PainlessLookupUtility.typeToCanonicalTypeName(returnType) + "] for class binding [[" + targetClass.getCanonicalName() + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
        }
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, constructorTypeParametersSize + n);
        if (this.painlessMethodKeysToImportedPainlessMethods.containsKey(painlessMethodKey)) {
            throw new IllegalArgumentException("class binding and imported method cannot have the same name [" + methodName + "]");
        }
        PainlessClassBinding existingPainlessClassBinding = this.painlessMethodKeysToPainlessClassBindings.get(painlessMethodKey);
        PainlessClassBinding newPainlessClassBinding = new PainlessClassBinding(javaConstructor, javaMethod, returnType, typeParameters);
        if (existingPainlessClassBinding == null) {
            newPainlessClassBinding = painlessClassBindingCache.computeIfAbsent(newPainlessClassBinding, key -> key);
            this.painlessMethodKeysToPainlessClassBindings.put(painlessMethodKey, newPainlessClassBinding);
        } else if (newPainlessClassBinding.equals(existingPainlessClassBinding)) {
            throw new IllegalArgumentException("cannot add class bindings with the same name and arity but are not equivalent for methods [[" + targetCanonicalClassName + "], [" + methodName + "], [" + PainlessLookupUtility.typeToCanonicalTypeName(returnType) + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] and [[" + targetCanonicalClassName + "], [" + methodName + "], [" + PainlessLookupUtility.typeToCanonicalTypeName(existingPainlessClassBinding.returnType) + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(existingPainlessClassBinding.typeParameters) + "]");
        }
    }

    public PainlessLookup build() {
        this.copyPainlessClassMembers();
        this.cacheRuntimeHandles();
        this.setFunctionalInterfaceMethods();
        HashMap classesToPainlessClasses = new HashMap(this.classesToPainlessClassBuilders.size());
        for (Map.Entry<Class<?>, PainlessClassBuilder> painlessClassBuilderEntry : this.classesToPainlessClassBuilders.entrySet()) {
            classesToPainlessClasses.put(painlessClassBuilderEntry.getKey(), painlessClassBuilderEntry.getValue().build());
        }
        if (!this.javaClassNamesToClasses.values().containsAll(this.canonicalClassNamesToClasses.values())) {
            throw new IllegalArgumentException("the values of java class names to classes must be a superset of the values of canonical class names to classes");
        }
        if (!this.javaClassNamesToClasses.values().containsAll(classesToPainlessClasses.keySet())) {
            throw new IllegalArgumentException("the values of java class names to classes must be a superset of the keys of classes to painless classes");
        }
        if (!this.canonicalClassNamesToClasses.values().containsAll(classesToPainlessClasses.keySet()) || !classesToPainlessClasses.keySet().containsAll(this.canonicalClassNamesToClasses.values())) {
            throw new IllegalArgumentException("the values of canonical class names to classes must have the same classes as the keys of classes to painless classes");
        }
        return new PainlessLookup(this.javaClassNamesToClasses, this.canonicalClassNamesToClasses, classesToPainlessClasses, this.painlessMethodKeysToImportedPainlessMethods, this.painlessMethodKeysToPainlessClassBindings);
    }

    private void copyPainlessClassMembers() {
        for (Class<?> parentClass : this.classesToPainlessClassBuilders.keySet()) {
            this.copyPainlessInterfaceMembers(parentClass, parentClass);
            for (Class<?> childClass = parentClass.getSuperclass(); childClass != null; childClass = childClass.getSuperclass()) {
                if (this.classesToPainlessClassBuilders.containsKey(childClass)) {
                    this.copyPainlessClassMembers(childClass, parentClass);
                }
                this.copyPainlessInterfaceMembers(childClass, parentClass);
            }
        }
        for (Class<?> javaClass : this.classesToPainlessClassBuilders.keySet()) {
            if (!javaClass.isInterface()) continue;
            this.copyPainlessClassMembers(Object.class, javaClass);
        }
    }

    private void copyPainlessInterfaceMembers(Class<?> parentClass, Class<?> targetClass) {
        for (Class<?> childClass : parentClass.getInterfaces()) {
            if (this.classesToPainlessClassBuilders.containsKey(childClass)) {
                this.copyPainlessClassMembers(childClass, targetClass);
            }
            this.copyPainlessInterfaceMembers(childClass, targetClass);
        }
    }

    private void copyPainlessClassMembers(Class<?> originalClass, Class<?> targetClass) {
        PainlessClassBuilder originalPainlessClassBuilder = this.classesToPainlessClassBuilders.get(originalClass);
        PainlessClassBuilder targetPainlessClassBuilder = this.classesToPainlessClassBuilders.get(targetClass);
        Objects.requireNonNull(originalPainlessClassBuilder);
        Objects.requireNonNull(targetPainlessClassBuilder);
        for (Map.Entry<String, PainlessMethod> entry : originalPainlessClassBuilder.methods.entrySet()) {
            String painlessMethodKey = entry.getKey();
            PainlessMethod newPainlessMethod = entry.getValue();
            PainlessMethod existingPainlessMethod = targetPainlessClassBuilder.methods.get(painlessMethodKey);
            if (existingPainlessMethod != null && (existingPainlessMethod.targetClass == newPainlessMethod.targetClass || !existingPainlessMethod.targetClass.isAssignableFrom(newPainlessMethod.targetClass))) continue;
            targetPainlessClassBuilder.methods.put(painlessMethodKey, newPainlessMethod);
        }
        for (Map.Entry<String, Object> entry : originalPainlessClassBuilder.fields.entrySet()) {
            String painlessFieldKey = entry.getKey();
            PainlessField newPainlessField = (PainlessField)entry.getValue();
            PainlessField existingPainlessField = targetPainlessClassBuilder.fields.get(painlessFieldKey);
            if (existingPainlessField != null && (existingPainlessField.javaField.getDeclaringClass() == newPainlessField.javaField.getDeclaringClass() || !existingPainlessField.javaField.getDeclaringClass().isAssignableFrom(newPainlessField.javaField.getDeclaringClass()))) continue;
            targetPainlessClassBuilder.fields.put(painlessFieldKey, newPainlessField);
        }
    }

    private void cacheRuntimeHandles() {
        for (PainlessClassBuilder painlessClassBuilder : this.classesToPainlessClassBuilders.values()) {
            this.cacheRuntimeHandles(painlessClassBuilder);
        }
    }

    private void cacheRuntimeHandles(PainlessClassBuilder painlessClassBuilder) {
        for (PainlessMethod painlessMethod : painlessClassBuilder.methods.values()) {
            String methodName = painlessMethod.javaMethod.getName();
            int typeParametersSize = painlessMethod.typeParameters.size();
            if (typeParametersSize == 0 && methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3))) {
                painlessClassBuilder.getterMethodHandles.putIfAbsent(Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4), painlessMethod.methodHandle);
                continue;
            }
            if (typeParametersSize == 0 && methodName.startsWith("is") && methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2))) {
                painlessClassBuilder.getterMethodHandles.putIfAbsent(Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3), painlessMethod.methodHandle);
                continue;
            }
            if (typeParametersSize != 1 || !methodName.startsWith("set") || methodName.length() <= 3 || !Character.isUpperCase(methodName.charAt(3))) continue;
            painlessClassBuilder.setterMethodHandles.putIfAbsent(Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4), painlessMethod.methodHandle);
        }
        for (PainlessField painlessField : painlessClassBuilder.fields.values()) {
            painlessClassBuilder.getterMethodHandles.put(painlessField.javaField.getName(), painlessField.getterMethodHandle);
            painlessClassBuilder.setterMethodHandles.put(painlessField.javaField.getName(), painlessField.setterMethodHandle);
        }
    }

    private void setFunctionalInterfaceMethods() {
        for (Map.Entry<Class<?>, PainlessClassBuilder> painlessClassBuilderEntry : this.classesToPainlessClassBuilders.entrySet()) {
            this.setFunctionalInterfaceMethod(painlessClassBuilderEntry.getKey(), painlessClassBuilderEntry.getValue());
        }
    }

    private void setFunctionalInterfaceMethod(Class<?> targetClass, PainlessClassBuilder painlessClassBuilder) {
        if (targetClass.isInterface()) {
            ArrayList<Method> javaMethods = new ArrayList<Method>();
            for (Method javaMethod : targetClass.getMethods()) {
                if (javaMethod.isDefault() || Modifier.isStatic(javaMethod.getModifiers())) continue;
                try {
                    Object.class.getMethod(javaMethod.getName(), javaMethod.getParameterTypes());
                }
                catch (ReflectiveOperationException roe) {
                    javaMethods.add(javaMethod);
                }
            }
            if (javaMethods.size() != 1 && targetClass.isAnnotationPresent(FunctionalInterface.class)) {
                throw new IllegalArgumentException("class [" + PainlessLookupUtility.typeToCanonicalTypeName(targetClass) + "] is illegally marked as a FunctionalInterface with java methods " + javaMethods);
            }
            if (javaMethods.size() == 1) {
                Method javaMethod = (Method)javaMethods.get(0);
                String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(javaMethod.getName(), javaMethod.getParameterCount());
                painlessClassBuilder.functionalInterfaceMethod = painlessClassBuilder.methods.get(painlessMethodKey);
            }
        }
    }
}

