/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.data.Contact;
import esmska.data.Contacts;
import esmska.data.Gateways;
import esmska.data.Icons;
import esmska.data.Log;
import esmska.data.event.AbstractListDataListener;
import esmska.persistence.ContactParser;
import esmska.utils.L10N;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingWorker;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.openide.awt.Mnemonics;

public class ImportFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(ImportFrame.class.getName());
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final Gateways gateways = Gateways.getInstance();
    private static final String infoEsmska = l10n.getString("ImportFrame.infoEsmska");
    private static final String infoKubik = l10n.getString("ImportFrame.infoKubik");
    private static final String infoDreamComSE = l10n.getString("ImportFrame.infoDreamComSE");
    private static final String infoVcard = l10n.getString("ImportFrame.infoVcard");
    private static final String encodingUTF8 = l10n.getString("ImportFrame.encodingUTF8");
    private static final String encodingWin1250 = l10n.getString("ImportFrame.encodingWin1250");
    private static final JFileChooser chooser = new JFileChooser();
    private CardLayout cardLayout;
    private SwingWorker<ArrayList<Contact>, Void> worker;
    private String actualCard = "applicationPanel";
    private JPanel applicationPanel;
    private JButton backButton;
    private JButton browseButton;
    private JPanel browsePanel;
    private JPanel cardPanel;
    private JList contactList;
    private JLabel doImportLabel;
    private JRadioButton dreamcomSERadioButton;
    private JLabel encodingLabel;
    private JRadioButton esmskaRadioButton;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JButton forwardButton;
    private JLabel foundContactsLabel;
    private ButtonGroup importButtonGroup;
    private JLabel infoLabel;
    private JLabel jLabel2;
    private JLabel jLabel22;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JRadioButton kubikRadioButton;
    private JLabel problemLabel;
    private JProgressBar progressBar;
    private JPanel resultsPanel;
    private JRadioButton vcardRadioButton;

    public ImportFrame() {
        this.initComponents();
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(Icons.get("contact-16.png").getImage());
        images.add(Icons.get("contact-22.png").getImage());
        images.add(Icons.get("contact-32.png").getImage());
        images.add(Icons.get("contact-48.png").getImage());
        this.setIconImages(images);
        String command = "close";
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), command);
        this.getRootPane().getActionMap().put(command, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportFrame.this.setVisible(false);
                ImportFrame.this.dispose();
            }
        });
        this.cardLayout = (CardLayout)this.cardPanel.getLayout();
        this.progressBar.setVisible(false);
        this.backButton.setVisible(false);
        chooser.setApproveButtonText(l10n.getString("ImportFrame.Select"));
        chooser.setDialogTitle(l10n.getString("ImportFrame.choose_export_file"));
        chooser.setMultiSelectionEnabled(false);
        chooser.resetChoosableFileFilters();
        chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (ImportFrame.this.vcardRadioButton.isSelected()) {
                    return f.getName().toLowerCase().endsWith(".vcard") || f.getName().toLowerCase().endsWith(".vcf") || f.isDirectory();
                }
                return f.getName().toLowerCase().endsWith(".csv") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                if (ImportFrame.this.vcardRadioButton.isSelected()) {
                    return l10n.getString("ImportFrame.vCard_filter");
                }
                return l10n.getString("ImportFrame.CSV_filter");
            }
        });
        this.contactList.getModel().addListDataListener(new AbstractListDataListener(){

            @Override
            public void onUpdate(ListDataEvent e) {
                int size = ImportFrame.this.contactList.getModel().getSize();
                ImportFrame.this.foundContactsLabel.setText(size > 0 ? MessageFormat.format(l10n.getString("ImportFrame.foundContacts"), size) : l10n.getString("ImportFrame.foundContactsLabel.text"));
                if (ImportFrame.this.actualCard.equals("resultsPanel")) {
                    ImportFrame.this.forwardButton.setEnabled(size > 0);
                }
            }
        });
    }

    public void importVCardFile(String fileName) {
        Validate.notNull(fileName);
        this.vcardRadioButton.setSelected(true);
        this.updateBrowsePanel();
        this.cardLayout.show(this.cardPanel, "browsePanel");
        this.actualCard = "browsePanel";
        this.fileTextField.setText(fileName);
        this.forwardButtonActionPerformed(null);
    }

    private String doBrowseButton() {
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    private void removeExistingContacts() {
        DefaultListModel contactListModel = (DefaultListModel)this.contactList.getModel();
        Object[] imported = contactListModel.toArray();
        ArrayList<Contact> skipped = new ArrayList<Contact>();
        block0: for (Object impor : imported) {
            for (Contact exist : Contacts.getInstance().getAll()) {
                Contact imp = (Contact)impor;
                if (!ObjectUtils.equals(exist.getName(), imp.getName()) || !ObjectUtils.equals(exist.getNumber(), imp.getNumber())) continue;
                skipped.add(imp);
                continue block0;
            }
        }
        for (Contact skip : skipped) {
            contactListModel.removeElement(skip);
        }
    }

    private void removeInvalidGateways() {
        DefaultListModel contactListModel = (DefaultListModel)this.contactList.getModel();
        Object[] imported = contactListModel.toArray();
        ArrayList<Contact> skipped = new ArrayList<Contact>();
        for (Object impor : imported) {
            Contact c = (Contact)impor;
            if (gateways.get(c.getGateway()) != null) continue;
            skipped.add(c);
        }
        for (Object e : skipped) {
            contactListModel.removeElement(e);
        }
    }

    private void updateBrowsePanel() {
        if (this.esmskaRadioButton.isSelected()) {
            this.infoLabel.setText(infoEsmska);
            this.encodingLabel.setText(encodingUTF8);
            this.problemLabel.setVisible(false);
        } else if (this.kubikRadioButton.isSelected()) {
            this.infoLabel.setText(infoDreamComSE);
            this.encodingLabel.setText(encodingWin1250);
            this.problemLabel.setVisible(true);
        } else if (this.dreamcomSERadioButton.isSelected()) {
            this.infoLabel.setText(infoKubik);
            this.encodingLabel.setText(encodingWin1250);
            this.problemLabel.setVisible(true);
        } else if (this.vcardRadioButton.isSelected()) {
            this.infoLabel.setText(infoVcard);
            this.encodingLabel.setText(encodingUTF8);
            this.problemLabel.setVisible(true);
        }
    }

    private void initComponents() {
        this.importButtonGroup = new ButtonGroup();
        this.cardPanel = new JPanel();
        this.applicationPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.kubikRadioButton = new JRadioButton();
        this.dreamcomSERadioButton = new JRadioButton();
        this.esmskaRadioButton = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.vcardRadioButton = new JRadioButton();
        this.browsePanel = new JPanel();
        this.fileTextField = new JTextField();
        this.browseButton = new JButton();
        this.infoLabel = new JLabel();
        this.fileLabel = new JLabel();
        this.jLabel22 = new JLabel();
        this.encodingLabel = new JLabel();
        this.problemLabel = new JLabel();
        this.resultsPanel = new JPanel();
        this.foundContactsLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.contactList = new JList();
        this.doImportLabel = new JLabel();
        this.forwardButton = new JButton();
        this.progressBar = new JProgressBar();
        this.backButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(l10n.getString("ImportFrame.title"));
        this.cardPanel.setLayout(new CardLayout());
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/contact-48.png")));
        Mnemonics.setLocalizedText(this.jLabel2, l10n.getString("ImportFrame.jLabel2.text"));
        Mnemonics.setLocalizedText(this.jLabel3, l10n.getString("ImportFrame.jLabel3.text"));
        this.importButtonGroup.add(this.kubikRadioButton);
        Mnemonics.setLocalizedText(this.kubikRadioButton, "&Kub\u00edk SMS DreamCom");
        this.importButtonGroup.add(this.dreamcomSERadioButton);
        Mnemonics.setLocalizedText(this.dreamcomSERadioButton, "&DreamCom SE");
        this.importButtonGroup.add(this.esmskaRadioButton);
        Mnemonics.setLocalizedText(this.esmskaRadioButton, "&Esmska");
        Mnemonics.setLocalizedText(this.jLabel4, l10n.getString("ImportFrame.jLabel4.text"));
        this.importButtonGroup.add(this.vcardRadioButton);
        this.vcardRadioButton.setSelected(true);
        Mnemonics.setLocalizedText(this.vcardRadioButton, "&vCard (*.vcard, *.vcf)");
        GroupLayout applicationPanelLayout = new GroupLayout(this.applicationPanel);
        this.applicationPanel.setLayout(applicationPanelLayout);
        applicationPanelLayout.setHorizontalGroup(applicationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(applicationPanelLayout.createSequentialGroup().addContainerGap().addGroup(applicationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING, -1, 526, Short.MAX_VALUE).addGroup(applicationPanelLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.vcardRadioButton)).addComponent(this.jLabel4).addComponent(this.jLabel3).addGroup(applicationPanelLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(applicationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.esmskaRadioButton).addComponent(this.kubikRadioButton).addComponent(this.dreamcomSERadioButton)).addGap(206, 206, 206))).addContainerGap()));
        applicationPanelLayout.setVerticalGroup(applicationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(applicationPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.vcardRadioButton).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.esmskaRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.kubikRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dreamcomSERadioButton).addContainerGap(145, Short.MAX_VALUE)));
        this.cardPanel.add((Component)this.applicationPanel, "applicationPanel");
        this.fileTextField.setToolTipText(l10n.getString("ImportFrame.fileTextField.toolTipText"));
        this.browseButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/browse-22.png")));
        Mnemonics.setLocalizedText(this.browseButton, l10n.getString("ImportFrame.browseButton.text"));
        this.browseButton.setToolTipText(l10n.getString("ImportFrame.browseButton.toolTipText"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportFrame.this.browseButtonActionPerformed(evt);
            }
        });
        this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/contact-48.png")));
        Mnemonics.setLocalizedText(this.infoLabel, "<<info text>>");
        Mnemonics.setLocalizedText(this.fileLabel, l10n.getString("ImportFrame.fileLabel.text"));
        Mnemonics.setLocalizedText(this.jLabel22, l10n.getString("ImportFrame.jLabel22.text"));
        this.encodingLabel.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/info-32.png")));
        Mnemonics.setLocalizedText(this.encodingLabel, "<<encoding hint>>");
        this.problemLabel.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/info-32.png")));
        Mnemonics.setLocalizedText(this.problemLabel, l10n.getString("ImportFrame.problemLabel.text"));
        GroupLayout browsePanelLayout = new GroupLayout(this.browsePanel);
        this.browsePanel.setLayout(browsePanelLayout);
        browsePanelLayout.setHorizontalGroup(browsePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(browsePanelLayout.createSequentialGroup().addContainerGap().addGroup(browsePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel22, -1, 526, Short.MAX_VALUE).addComponent(this.infoLabel, -1, 526, Short.MAX_VALUE).addComponent(this.fileLabel).addGroup(GroupLayout.Alignment.TRAILING, browsePanelLayout.createSequentialGroup().addComponent(this.fileTextField, -1, 409, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addComponent(this.encodingLabel, GroupLayout.Alignment.TRAILING, -1, 526, Short.MAX_VALUE).addComponent(this.problemLabel, GroupLayout.Alignment.TRAILING, -1, 526, Short.MAX_VALUE)).addContainerGap()));
        browsePanelLayout.setVerticalGroup(browsePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(browsePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.infoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(browsePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browseButton).addComponent(this.fileTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel22, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.encodingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.problemLabel, -2, -1, -2).addContainerGap(134, Short.MAX_VALUE)));
        this.cardPanel.add((Component)this.browsePanel, "browsePanel");
        Mnemonics.setLocalizedText(this.foundContactsLabel, l10n.getString("ImportFrame.foundContactsLabel.text"));
        this.contactList.setModel(new DefaultListModel());
        this.contactList.setCellRenderer(new ContactsListRenderer());
        this.jScrollPane1.setViewportView(this.contactList);
        this.doImportLabel.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/contact-48.png")));
        Mnemonics.setLocalizedText(this.doImportLabel, l10n.getString("ImportFrame.doImportLabel.text"));
        GroupLayout resultsPanelLayout = new GroupLayout(this.resultsPanel);
        this.resultsPanel.setLayout(resultsPanelLayout);
        resultsPanelLayout.setHorizontalGroup(resultsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, resultsPanelLayout.createSequentialGroup().addContainerGap().addGroup(resultsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 526, Short.MAX_VALUE).addComponent(this.foundContactsLabel, GroupLayout.Alignment.LEADING, -1, 526, Short.MAX_VALUE).addComponent(this.doImportLabel, GroupLayout.Alignment.LEADING)).addContainerGap()));
        resultsPanelLayout.setVerticalGroup(resultsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(resultsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.foundContactsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 274, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.doImportLabel).addContainerGap()));
        this.cardPanel.add((Component)this.resultsPanel, "resultsPanel");
        this.forwardButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/next-22.png")));
        Mnemonics.setLocalizedText(this.forwardButton, l10n.getString("ImportFrame.forwardButton.text"));
        this.forwardButton.setHorizontalTextPosition(10);
        this.forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportFrame.this.forwardButtonActionPerformed(evt);
            }
        });
        this.progressBar.setIndeterminate(true);
        this.progressBar.setString(l10n.getString("ImportFrame.progressBar.string"));
        this.progressBar.setStringPainted(true);
        this.backButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/previous-22.png")));
        Mnemonics.setLocalizedText(this.backButton, l10n.getString("ImportFrame.backButton.text"));
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportFrame.this.backButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.progressBar, -1, 306, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.backButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.forwardButton).addContainerGap()).addComponent(this.cardPanel, -1, 538, Short.MAX_VALUE));
        layout.linkSize(0, this.backButton, this.forwardButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.cardPanel, -1, 361, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.forwardButton).addComponent(this.backButton)).addComponent(this.progressBar, -2, -1, -2)).addContainerGap()));
        layout.linkSize(1, this.backButton, this.forwardButton, this.progressBar);
        this.pack();
    }

    private void backButtonActionPerformed(ActionEvent evt) {
        if (this.actualCard.equals("browsePanel")) {
            this.backButton.setVisible(false);
            this.cardLayout.show(this.cardPanel, "applicationPanel");
            this.actualCard = "applicationPanel";
            return;
        }
        if (this.actualCard.equals("resultsPanel")) {
            String nextCard = "browsePanel";
            Mnemonics.setLocalizedText(this.forwardButton, l10n.getString("ImportFrame.forwardButton.text"));
            this.forwardButton.setIcon(Icons.get("next-22.png"));
            this.forwardButton.setHorizontalTextPosition(10);
            this.forwardButton.setEnabled(true);
            this.updateBrowsePanel();
            this.cardLayout.show(this.cardPanel, nextCard);
            this.actualCard = nextCard;
        }
    }

    private void forwardButtonActionPerformed(ActionEvent evt) {
        if (this.actualCard.equals("applicationPanel")) {
            String nextCard = "browsePanel";
            this.updateBrowsePanel();
            this.cardLayout.show(this.cardPanel, nextCard);
            this.actualCard = nextCard;
            this.backButton.setVisible(true);
            return;
        }
        if (this.actualCard.equals("browsePanel")) {
            ContactParser.ContactType type = null;
            String filename = this.fileTextField.getText();
            if (this.esmskaRadioButton.isSelected()) {
                type = ContactParser.ContactType.ESMSKA_FILE;
            } else if (this.kubikRadioButton.isSelected()) {
                type = ContactParser.ContactType.KUBIK_DREAMCOM_FILE;
            } else if (this.dreamcomSERadioButton.isSelected()) {
                type = ContactParser.ContactType.DREAMCOM_SE_FILE;
            } else if (this.vcardRadioButton.isSelected()) {
                type = ContactParser.ContactType.VCARD_FILE;
            }
            File file = new File(filename);
            if (!file.isFile() || !file.canRead()) {
                logger.info("File can't be read: " + file.getAbsolutePath());
                JOptionPane.showMessageDialog(this, MessageFormat.format(l10n.getString("ImportFrame.file_cant_be_read"), file.getAbsolutePath()), null, 0);
                return;
            }
            this.progressBar.setVisible(true);
            this.forwardButton.setEnabled(false);
            this.backButton.setEnabled(false);
            this.worker = new ContactParser(file, type);
            this.worker.addPropertyChangeListener(new ParseContactsFinishedListener());
            this.worker.execute();
            return;
        }
        if (this.actualCard.equals("resultsPanel")) {
            DefaultListModel contactListModel = (DefaultListModel)this.contactList.getModel();
            ArrayList<Contact> importedContacts = new ArrayList<Contact>();
            for (Object o : contactListModel.toArray()) {
                importedContacts.add((Contact)o);
            }
            logger.fine("Imported " + importedContacts.size() + " new contacts: " + importedContacts);
            Contacts.getInstance().addAll(importedContacts);
            Log.getInstance().addRecord(new Log.Record(l10n.getString("MainFrame.import_complete"), null, Icons.STATUS_INFO));
            this.setVisible(false);
            this.dispose();
            return;
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String file = this.doBrowseButton();
        if (file != null) {
            this.fileTextField.setText(file);
        }
    }

    private class ContactsListRenderer
    extends DefaultListCellRenderer {
        private final ListCellRenderer lafRenderer = new JList().getCellRenderer();

        private ContactsListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = this.lafRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            JLabel label = (JLabel)comp;
            Contact c = (Contact)value;
            String number = c.getNumber() != null ? c.getNumber() : "";
            String gateway = c.getGateway() != null ? c.getGateway() : "";
            label.setText(c.getName() + " (" + number + ", " + gateway + ")");
            return label;
        }
    }

    private class ParseContactsFinishedListener
    implements PropertyChangeListener {
        private ParseContactsFinishedListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"state".equals(evt.getPropertyName())) {
                return;
            }
            if (!SwingWorker.StateValue.DONE.equals(evt.getNewValue())) {
                return;
            }
            try {
                DefaultListModel contactListModel = (DefaultListModel)ImportFrame.this.contactList.getModel();
                contactListModel.clear();
                ArrayList contacts = (ArrayList)ImportFrame.this.worker.get();
                Collections.sort(contacts);
                for (Contact c : contacts) {
                    contactListModel.addElement(c);
                }
                ImportFrame.this.removeExistingContacts();
                Mnemonics.setLocalizedText(ImportFrame.this.forwardButton, l10n.getString("Import_"));
                ImportFrame.this.forwardButton.setIcon(Icons.get("contact-22.png"));
                ImportFrame.this.forwardButton.setHorizontalTextPosition(11);
                ImportFrame.this.forwardButton.setEnabled(ImportFrame.this.contactList.getModel().getSize() > 0);
                ImportFrame.this.cardLayout.show(ImportFrame.this.cardPanel, "resultsPanel");
                ImportFrame.this.actualCard = "resultsPanel";
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Error while parsing file", ex);
                JOptionPane.showMessageDialog(ImportFrame.this, l10n.getString("ImportFrame.invalid_file"), null, 0);
                ImportFrame.this.forwardButton.setEnabled(true);
            }
            finally {
                ImportFrame.this.progressBar.setVisible(false);
                ImportFrame.this.backButton.setEnabled(true);
            }
        }
    }
}

