/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.MenuItemSelectedListener;
import freemind.controller.actions.generated.instance.UnderlinedNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.NodeActorXml;
import freemind.modes.mindmapmode.actions.NodeGeneralAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import javax.swing.Action;
import javax.swing.JMenuItem;

public class UnderlinedAction
extends NodeGeneralAction
implements NodeActorXml,
MenuItemSelectedListener {
    private final MindMapController modeController;

    public UnderlinedAction(MindMapController modeController) {
        super(modeController, "underlined", "images/Underline24.gif");
        this.modeController = modeController;
        this.addActor(this);
    }

    @Override
    public void act(XmlAction action) {
        UnderlinedNodeAction underlinedact = (UnderlinedNodeAction)action;
        NodeAdapter node = this.getNodeFromID(underlinedact.getNode());
        if (node.isUnderlined() != underlinedact.getUnderlined()) {
            node.setUnderlined(underlinedact.getUnderlined());
            this.modeController.nodeChanged(node);
        }
    }

    @Override
    public Class getDoActionClass() {
        return UnderlinedNodeAction.class;
    }

    @Override
    public ActionPair apply(MindMap model, MindMapNode selected) {
        boolean underlined = this.modeController.getSelected().isUnderlined();
        return this.getActionPair(selected, underlined);
    }

    private ActionPair getActionPair(MindMapNode selected, boolean underlined) {
        UnderlinedNodeAction underlinedAction = this.toggleUnderlined(selected, !underlined);
        UnderlinedNodeAction undoUnderlinedAction = this.toggleUnderlined(selected, underlined);
        return new ActionPair((XmlAction)underlinedAction, (XmlAction)undoUnderlinedAction);
    }

    private UnderlinedNodeAction toggleUnderlined(MindMapNode selected, boolean underlined) {
        UnderlinedNodeAction underlinedAction = new UnderlinedNodeAction();
        underlinedAction.setNode(this.getNodeID(selected));
        underlinedAction.setUnderlined(underlined);
        return underlinedAction;
    }

    public void setUnderlined(MindMapNode node, boolean underlined) {
        this.execute(this.getActionPair(node, underlined));
    }

    @Override
    public boolean isSelected(JMenuItem item, Action action) {
        return this.modeController.getSelected().isUnderlined();
    }
}

