/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.lib.gleem.linalg;

import org.gephi.lib.gleem.linalg.Matf;
import org.gephi.lib.gleem.linalg.Vec3f;

public class Mat3f {
    private float[] data = new float[9];

    public void makeIdent() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (i == j) {
                    this.set(i, j, 1.0f);
                    continue;
                }
                this.set(i, j, 0.0f);
            }
        }
    }

    public float get(int i, int j) {
        return this.data[3 * i + j];
    }

    public void set(int i, int j, float val) {
        this.data[3 * i + j] = val;
    }

    public void setCol(int i, Vec3f v) {
        this.set(0, i, v.x());
        this.set(1, i, v.y());
        this.set(2, i, v.z());
    }

    public void setRow(int i, Vec3f v) {
        this.set(i, 0, v.x());
        this.set(i, 1, v.y());
        this.set(i, 2, v.z());
    }

    public void transpose() {
        float t = this.get(0, 1);
        this.set(0, 1, this.get(1, 0));
        this.set(1, 0, t);
        t = this.get(0, 2);
        this.set(0, 2, this.get(2, 0));
        this.set(2, 0, t);
        t = this.get(1, 2);
        this.set(1, 2, this.get(2, 1));
        this.set(2, 1, t);
    }

    public float determinant() {
        return this.get(0, 0) * (this.get(1, 1) * this.get(2, 2) - this.get(2, 1) * this.get(1, 2)) + this.get(0, 1) * (this.get(2, 0) * this.get(1, 2) - this.get(1, 0) * this.get(2, 2)) + this.get(0, 2) * (this.get(1, 0) * this.get(2, 1) - this.get(2, 0) * this.get(1, 1));
    }

    public boolean invert() {
        float det = this.determinant();
        if (det == 0.0f) {
            return false;
        }
        Mat3f cf = new Mat3f();
        cf.set(0, 0, this.get(1, 1) * this.get(2, 2) - this.get(2, 1) * this.get(1, 2));
        cf.set(0, 1, this.get(2, 0) * this.get(1, 2) - this.get(1, 0) * this.get(2, 2));
        cf.set(0, 2, this.get(1, 0) * this.get(2, 1) - this.get(2, 0) * this.get(1, 1));
        cf.set(1, 0, this.get(2, 1) * this.get(0, 2) - this.get(0, 1) * this.get(2, 2));
        cf.set(1, 1, this.get(0, 0) * this.get(2, 2) - this.get(2, 0) * this.get(0, 2));
        cf.set(1, 2, this.get(2, 0) * this.get(0, 1) - this.get(0, 0) * this.get(2, 1));
        cf.set(2, 0, this.get(0, 1) * this.get(1, 2) - this.get(1, 1) * this.get(0, 2));
        cf.set(2, 1, this.get(1, 0) * this.get(0, 2) - this.get(0, 0) * this.get(1, 2));
        cf.set(2, 2, this.get(0, 0) * this.get(1, 1) - this.get(1, 0) * this.get(0, 1));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.set(i, j, cf.get(j, i) / det);
            }
        }
        return true;
    }

    public void xformVec(Vec3f src, Vec3f dest) {
        dest.set(this.get(0, 0) * src.x() + this.get(0, 1) * src.y() + this.get(0, 2) * src.z(), this.get(1, 0) * src.x() + this.get(1, 1) * src.y() + this.get(1, 2) * src.z(), this.get(2, 0) * src.x() + this.get(2, 1) * src.y() + this.get(2, 2) * src.z());
    }

    public Mat3f mul(Mat3f b) {
        Mat3f tmp = new Mat3f();
        tmp.mul(this, b);
        return tmp;
    }

    public void mul(Mat3f a, Mat3f b) {
        for (int rc = 0; rc < 3; ++rc) {
            for (int cc = 0; cc < 3; ++cc) {
                float tmp = 0.0f;
                for (int i = 0; i < 3; ++i) {
                    tmp += a.get(rc, i) * b.get(i, cc);
                }
                this.set(rc, cc, tmp);
            }
        }
    }

    public Matf toMatf() {
        Matf out = new Matf(3, 3);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                out.set(i, j, this.get(i, j));
            }
        }
        return out;
    }

    public String toString() {
        String endl = System.getProperty("line.separator");
        return "(" + this.get(0, 0) + ", " + this.get(0, 1) + ", " + this.get(0, 2) + endl + this.get(1, 0) + ", " + this.get(1, 1) + ", " + this.get(1, 2) + endl + this.get(2, 0) + ", " + this.get(2, 1) + ", " + this.get(2, 2) + ")";
    }
}

