/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.statistics.plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.gephi.graph.api.GraphController;
import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.JXLabel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PageRankPanel
extends JPanel {
    private ButtonGroup directedButtonGroup;
    protected JRadioButton directedRadioButton;
    private JCheckBox edgeWeightCheckbox;
    protected JTextField epsilonTextField;
    private JXHeader jXHeader1;
    private JXLabel jXLabel1;
    private JXLabel jXLabel2;
    private JLabel labelE;
    private JLabel labelP;
    protected JTextField probTextField;
    protected JRadioButton undirectedRadioButton;

    public PageRankPanel() {
        this.initComponents();
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController.getGraphModel().isUndirected()) {
            this.directedRadioButton.setEnabled(false);
        }
    }

    public boolean isDirected() {
        return this.directedRadioButton.isSelected();
    }

    public double getEpsilon() {
        try {
            return Double.parseDouble(this.epsilonTextField.getText());
        }
        catch (Exception exception) {
            return 0.001;
        }
    }

    public double getProbability() {
        try {
            return Double.parseDouble(this.probTextField.getText());
        }
        catch (Exception exception) {
            return 0.85;
        }
    }

    public boolean isEdgeWeight() {
        return this.edgeWeightCheckbox.isSelected();
    }

    public void setEdgeWeight(boolean edgeWeight) {
        this.edgeWeightCheckbox.setSelected(edgeWeight);
    }

    public void setDirected(boolean directed) {
        this.directedButtonGroup.setSelected(directed ? this.directedRadioButton.getModel() : this.undirectedRadioButton.getModel(), true);
        if (!directed) {
            this.directedRadioButton.setEnabled(false);
        }
    }

    public void setEpsilon(double epsilon) {
        this.epsilonTextField.setText(Double.toString(epsilon));
    }

    public void setProbability(double probability) {
        this.probTextField.setText(Double.toString(probability));
    }

    private void initComponents() {
        this.directedButtonGroup = new ButtonGroup();
        this.labelP = new JLabel();
        this.labelE = new JLabel();
        this.probTextField = new JTextField();
        this.epsilonTextField = new JTextField();
        this.undirectedRadioButton = new JRadioButton();
        this.directedRadioButton = new JRadioButton();
        this.jXHeader1 = new JXHeader();
        this.jXLabel1 = new JXLabel();
        this.jXLabel2 = new JXLabel();
        this.edgeWeightCheckbox = new JCheckBox();
        this.labelP.setText(NbBundle.getMessage(PageRankPanel.class, (String)"PageRankPanel.labelP.text"));
        this.labelE.setText(NbBundle.getMessage(PageRankPanel.class, (String)"PageRankPanel.labelE.text"));
        this.probTextField.setText(NbBundle.getMessage(PageRankPanel.class, (String)"PageRankPanel.probTextField.text"));
        this.probTextField.setMinimumSize(new Dimension(59, 25));
        this.probTextField.setPreferredSize(new Dimension(59, 25));
        this.epsilonTextField.setText(NbBundle.getMessage(PageRankPanel.class, (String)"PageRankPanel.epsilonTextField.text"));
        this.epsilonTextField.setMinimumSize(new Dimension(59, 25));
        this.epsilonTextField.setPreferredSize(new Dimension(59, 25));
        this.directedButtonGroup.add(this.undirectedRadioButton);
        this.undirectedRadioButton.setText(NbBundle.getMessage(PageRankPanel.class, (String)"PageRankPanel.undirectedRadioButton.text"));
        this.directedButtonGroup.add(this.directedRadioButton);
        this.directedRadioButton.setText(NbBundle.getMessage(PageRankPanel.class, (String)"PageRankPanel.directedRadioButton.text"));
        this.jXHeader1.setDescription(NbBundle.getMessage(PageRankPanel.class, (String)"PageRankPanel.jXHeader1.description"));
        this.jXHeader1.setTitle(NbBundle.getMessage(PageRankPanel.class, (String)"PageRankPanel.jXHeader1.title"));
        this.jXLabel1.setForeground(new Color(102, 102, 102));
        this.jXLabel1.setLineWrap(true);
        this.jXLabel1.setText(NbBundle.getMessage(PageRankPanel.class, (String)"PageRankPanel.jXLabel1.text"));
        this.jXLabel1.setFont(this.jXLabel1.getFont().deriveFont((float)this.jXLabel1.getFont().getSize() - 1.0f));
        this.jXLabel2.setForeground(new Color(102, 102, 102));
        this.jXLabel2.setLineWrap(true);
        this.jXLabel2.setText(NbBundle.getMessage(PageRankPanel.class, (String)"PageRankPanel.jXLabel2.text"));
        this.jXLabel2.setFont(this.jXLabel2.getFont().deriveFont((float)this.jXLabel2.getFont().getSize() - 1.0f));
        this.edgeWeightCheckbox.setText(NbBundle.getMessage(PageRankPanel.class, (String)"PageRankPanel.edgeWeightCheckbox.text"));
        this.edgeWeightCheckbox.setHorizontalTextPosition(10);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jXHeader1, -1, 605, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.directedRadioButton).addComponent(this.undirectedRadioButton)).addGap(45, 45, 45).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.edgeWeightCheckbox).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelP).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.probTextField, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.labelE).addGap(45, 45, 45).addComponent(this.epsilonTextField, -2, -1, -2)).addComponent((Component)this.jXLabel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jXLabel2, -1, -1, Short.MAX_VALUE)).addGap(10, 10, 10)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.jXHeader1, -2, 73, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.directedRadioButton).addComponent(this.labelP).addComponent(this.probTextField, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.undirectedRadioButton).addComponent((Component)this.jXLabel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelE).addComponent(this.epsilonTextField, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jXLabel2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.edgeWeightCheckbox).addContainerGap(36, Short.MAX_VALUE)));
    }
}

