/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.lang.reflect.Method;
import org.gradle.api.Task;
import org.gradle.api.internal.project.taskfactory.StandardTaskAction;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.reflect.JavaReflectionUtil;

class IncrementalTaskAction
extends StandardTaskAction
implements ContextAwareTaskAction {
    private TaskExecutionContext context;

    public IncrementalTaskAction(Class<? extends Task> type, Method method) {
        super(type, method);
    }

    @Override
    public void contextualise(TaskExecutionContext context) {
        this.context = context;
    }

    @Override
    public void releaseContext() {
        this.context = null;
    }

    @Override
    protected void doExecute(Task task, String methodName) {
        IncrementalTaskInputs inputChanges = this.context.getTaskArtifactState().getInputChanges();
        this.context.setTaskExecutedIncrementally(inputChanges.isIncremental());
        JavaReflectionUtil.method((Object)task, Object.class, (String)methodName, (Class[])new Class[]{IncrementalTaskInputs.class}).invoke((Object)task, new Object[]{inputChanges});
    }
}

