/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.gradle.cache.AsyncCacheAccess;
import org.gradle.cache.CacheAccess;
import org.gradle.cache.internal.HeapProportionalCacheSizer;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorPolicy;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.time.CountdownTimer;
import org.gradle.internal.time.Time;

class CacheAccessWorker
implements Runnable,
Stoppable,
AsyncCacheAccess {
    private final BlockingQueue<Runnable> workQueue;
    private final String displayName;
    private final CacheAccess cacheAccess;
    private final long batchWindowMillis;
    private final long maximumLockingTimeMillis;
    private boolean closed;
    private boolean workerCompleted;
    private boolean stopSeen;
    private final CountDownLatch doneSignal = new CountDownLatch(1);
    private final ExecutorPolicy.CatchAndRecordFailures failureHandler = new ExecutorPolicy.CatchAndRecordFailures();

    CacheAccessWorker(String displayName, CacheAccess cacheAccess) {
        this.displayName = displayName;
        this.cacheAccess = cacheAccess;
        this.batchWindowMillis = 200L;
        this.maximumLockingTimeMillis = 5000L;
        HeapProportionalCacheSizer heapProportionalCacheSizer = new HeapProportionalCacheSizer();
        int queueCapacity = Math.min(4000, heapProportionalCacheSizer.scaleCacheSize(40000));
        this.workQueue = new ArrayBlockingQueue<Runnable>(queueCapacity, true);
    }

    @Override
    public void enqueue(Runnable task) {
        this.addToQueue(task);
    }

    private void addToQueue(Runnable task) {
        if (this.closed) {
            throw new IllegalStateException("The worker has already been closed. Cannot add more work to queue.");
        }
        try {
            this.workQueue.put(task);
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public <T> T read(final Factory<T> task) {
        FutureTask futureTask = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return task.create();
            }
        });
        this.addToQueue(futureTask);
        try {
            return (T)futureTask.get();
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public synchronized void flush() {
        if (!this.workerCompleted && !this.closed) {
            FlushOperationsCommand flushOperationsCommand = new FlushOperationsCommand();
            this.addToQueue(flushOperationsCommand);
            flushOperationsCommand.await();
        }
        this.rethrowFailure();
    }

    private void rethrowFailure() {
        this.failureHandler.onStop();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[WHILELOOP], 1[TRYBLOCK]], but top level block is 10[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Runnable takeFromQueue() throws InterruptedException {
        return this.workQueue.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushOperations(final Runnable updateOperation) {
        final ArrayList flushOperations = new ArrayList();
        try {
            this.cacheAccess.useCache(new Runnable(){

                @Override
                public void run() {
                    CountdownTimer timer = Time.startCountdownTimer((long)CacheAccessWorker.this.maximumLockingTimeMillis, (TimeUnit)TimeUnit.MILLISECONDS);
                    if (updateOperation != null) {
                        CacheAccessWorker.this.failureHandler.onExecute(updateOperation);
                    }
                    try {
                        Runnable otherOperation;
                        while ((otherOperation = (Runnable)CacheAccessWorker.this.workQueue.poll(CacheAccessWorker.this.batchWindowMillis, TimeUnit.MILLISECONDS)) != null) {
                            CacheAccessWorker.this.failureHandler.onExecute(otherOperation);
                            Class<?> runnableClass = otherOperation.getClass();
                            if (runnableClass == FlushOperationsCommand.class) {
                                flushOperations.add((FlushOperationsCommand)otherOperation);
                            }
                            if (runnableClass == ShutdownOperationsCommand.class) {
                                CacheAccessWorker.this.stopSeen = true;
                            }
                            if (runnableClass != ShutdownOperationsCommand.class && runnableClass != FlushOperationsCommand.class && !timer.hasExpired()) continue;
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
            });
        }
        finally {
            for (FlushOperationsCommand flushOperation : flushOperations) {
                flushOperation.completed();
            }
        }
    }

    public synchronized void stop() {
        if (!this.closed && !this.workerCompleted) {
            this.closed = true;
            try {
                this.workQueue.put(new ShutdownOperationsCommand());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                this.doneSignal.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.rethrowFailure();
    }

    private static class ShutdownOperationsCommand
    implements Runnable {
        private ShutdownOperationsCommand() {
        }

        @Override
        public void run() {
        }
    }

    private static class FlushOperationsCommand
    implements Runnable {
        private CountDownLatch latch = new CountDownLatch(1);

        private FlushOperationsCommand() {
        }

        @Override
        public void run() {
        }

        public void await() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        public void completed() {
            this.latch.countDown();
        }
    }
}

