/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Map;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationOperation;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

class TransformingAsyncArtifactListener
implements ResolvedArtifactSet.AsyncArtifactListener {
    private final Map<ComponentArtifactIdentifier, TransformationOperation> artifactResults;
    private final Map<File, TransformationOperation> fileResults;
    private final ExecutionGraphDependenciesResolver dependenciesResolver;
    private final BuildOperationQueue<RunnableBuildOperation> actions;
    private final ResolvedArtifactSet.AsyncArtifactListener delegate;
    private final Transformation transformation;

    TransformingAsyncArtifactListener(Transformation transformation, ResolvedArtifactSet.AsyncArtifactListener delegate, BuildOperationQueue<RunnableBuildOperation> actions, Map<ComponentArtifactIdentifier, TransformationOperation> artifactResults, Map<File, TransformationOperation> fileResults, ExecutionGraphDependenciesResolver dependenciesResolver) {
        this.artifactResults = artifactResults;
        this.actions = actions;
        this.transformation = transformation;
        this.delegate = delegate;
        this.fileResults = fileResults;
        this.dependenciesResolver = dependenciesResolver;
    }

    @Override
    public void artifactAvailable(ResolvableArtifact artifact) {
        ComponentArtifactIdentifier artifactId = artifact.getId();
        File file = artifact.getFile();
        TransformationSubject initialSubject = TransformationSubject.initial(artifactId, file);
        TransformationOperation operation = new TransformationOperation(this.transformation, initialSubject, this.dependenciesResolver);
        this.artifactResults.put(artifactId, operation);
        operation.run(null);
    }

    @Override
    public boolean requireArtifactFiles() {
        return true;
    }

    @Override
    public boolean includeFileDependencies() {
        return this.delegate.includeFileDependencies();
    }

    @Override
    public void fileAvailable(File file) {
        TransformationSubject initialSubject = TransformationSubject.initial(file);
        TransformationOperation operation = new TransformationOperation(this.transformation, initialSubject, this.dependenciesResolver);
        this.fileResults.put(file, operation);
        this.actions.add((BuildOperation)operation);
    }
}

