/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.groovy.builder.factory;

import groovy.util.FactoryBuilderSupport;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.sonatype.maven.polyglot.groovy.builder.factory.NamedFactory;

public class DependencyFactory
extends NamedFactory {
    public DependencyFactory() {
        super("dependency");
    }

    public Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map attrs) throws InstantiationException, IllegalAccessException {
        Dependency node;
        if (value != null) {
            node = DependencyFactory.parse(value);
            if (node == null) {
                throw new NamedFactory.NodeValueParseException(this, value);
            }
        } else {
            node = new Dependency();
        }
        return node;
    }

    public static Dependency parse(Object value) {
        assert (value != null);
        if (value instanceof String) {
            Dependency node = new Dependency();
            String[] items = ((String)value).split(":");
            switch (items.length) {
                case 4: {
                    node.setGroupId(items[0]);
                    node.setArtifactId(items[1]);
                    node.setVersion(items[2]);
                    node.setScope(items[3]);
                    return node;
                }
                case 3: {
                    node.setGroupId(items[0]);
                    node.setArtifactId(items[1]);
                    node.setVersion(items[2]);
                    return node;
                }
                case 2: {
                    node.setGroupId(items[0]);
                    node.setArtifactId(items[1]);
                    return node;
                }
            }
        }
        return null;
    }
}

