/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom.input;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.kotlin.org.jdom.DefaultJDOMFactory;
import org.jetbrains.kotlin.org.jdom.Document;
import org.jetbrains.kotlin.org.jdom.JDOMException;
import org.jetbrains.kotlin.org.jdom.JDOMFactory;
import org.jetbrains.kotlin.org.jdom.input.sax.BuilderErrorHandler;
import org.jetbrains.kotlin.org.jdom.input.sax.DefaultSAXHandlerFactory;
import org.jetbrains.kotlin.org.jdom.input.sax.SAXBuilderEngine;
import org.jetbrains.kotlin.org.jdom.input.sax.SAXEngine;
import org.jetbrains.kotlin.org.jdom.input.sax.SAXHandler;
import org.jetbrains.kotlin.org.jdom.input.sax.SAXHandlerFactory;
import org.jetbrains.kotlin.org.jdom.input.sax.XMLReaderJDOMFactory;
import org.jetbrains.kotlin.org.jdom.input.sax.XMLReaders;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class SAXBuilder
implements SAXEngine {
    private static final SAXHandlerFactory DEFAULTSAXHANDLERFAC = new DefaultSAXHandlerFactory();
    private static final JDOMFactory DEFAULTJDOMFAC = new DefaultJDOMFactory();
    private XMLReaderJDOMFactory readerfac = null;
    private SAXHandlerFactory handlerfac = null;
    private JDOMFactory jdomfac = null;
    private final HashMap<String, Boolean> features = new HashMap(5);
    private final HashMap<String, Object> properties = new HashMap(5);
    private ErrorHandler saxErrorHandler = null;
    private EntityResolver saxEntityResolver = null;
    private DTDHandler saxDTDHandler = null;
    private XMLFilter saxXMLFilter = null;
    private boolean expand = true;
    private boolean ignoringWhite = false;
    private boolean ignoringBoundaryWhite = false;
    private boolean reuseParser = true;
    private SAXEngine engine = null;

    public SAXBuilder() {
        this(null, null, null);
    }

    public SAXBuilder(XMLReaderJDOMFactory xmlreaderfactory, SAXHandlerFactory handlerfactory, JDOMFactory jdomfactory) {
        this.readerfac = xmlreaderfactory == null ? XMLReaders.NONVALIDATING : xmlreaderfactory;
        this.handlerfac = handlerfactory == null ? DEFAULTSAXHANDLERFAC : handlerfactory;
        this.jdomfac = jdomfactory == null ? DEFAULTJDOMFAC : jdomfactory;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.saxEntityResolver = entityResolver;
        this.engine = null;
    }

    public SAXEngine buildEngine() throws JDOMException {
        SAXHandler contentHandler = this.handlerfac.createSAXHandler(this.jdomfac);
        contentHandler.setExpandEntities(this.expand);
        contentHandler.setIgnoringElementContentWhitespace(this.ignoringWhite);
        contentHandler.setIgnoringBoundaryWhitespace(this.ignoringBoundaryWhite);
        XMLReader parser = this.createParser();
        this.configureParser(parser, contentHandler);
        boolean valid = this.readerfac.isValidating();
        return new SAXBuilderEngine(parser, contentHandler, valid);
    }

    protected XMLReader createParser() throws JDOMException {
        XMLReader parser = this.readerfac.createXMLReader();
        if (this.saxXMLFilter != null) {
            XMLFilter root2 = this.saxXMLFilter;
            while (root2.getParent() instanceof XMLFilter) {
                root2 = (XMLFilter)root2.getParent();
            }
            root2.setParent(parser);
            parser = this.saxXMLFilter;
        }
        return parser;
    }

    private SAXEngine getEngine() throws JDOMException {
        if (this.engine != null) {
            return this.engine;
        }
        this.engine = this.buildEngine();
        return this.engine;
    }

    protected void configureParser(XMLReader parser, SAXHandler contentHandler) throws JDOMException {
        parser.setContentHandler(contentHandler);
        if (this.saxEntityResolver != null) {
            parser.setEntityResolver(this.saxEntityResolver);
        }
        if (this.saxDTDHandler != null) {
            parser.setDTDHandler(this.saxDTDHandler);
        } else {
            parser.setDTDHandler(contentHandler);
        }
        if (this.saxErrorHandler != null) {
            parser.setErrorHandler(this.saxErrorHandler);
        } else {
            parser.setErrorHandler(new BuilderErrorHandler());
        }
        boolean success = false;
        try {
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
            success = true;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        if (!success) {
            try {
                parser.setProperty("http://xml.org/sax/handlers/LexicalHandler", contentHandler);
                success = true;
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
        }
        for (Map.Entry<String, Boolean> entry : this.features.entrySet()) {
            this.internalSetFeature(parser, entry.getKey(), entry.getValue(), entry.getKey());
        }
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            this.internalSetProperty(parser, entry.getKey(), entry.getValue(), entry.getKey());
        }
        try {
            if (parser.getFeature("http://xml.org/sax/features/external-general-entities") != this.expand) {
                parser.setFeature("http://xml.org/sax/features/external-general-entities", this.expand);
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        if (!this.expand) {
            try {
                parser.setProperty("http://xml.org/sax/properties/declaration-handler", contentHandler);
                success = true;
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
        }
    }

    private void internalSetFeature(XMLReader parser, String feature, boolean value, String displayName) throws JDOMException {
        try {
            parser.setFeature(feature, value);
        }
        catch (SAXNotSupportedException e) {
            throw new JDOMException(displayName + " feature not supported for SAX driver " + parser.getClass().getName());
        }
        catch (SAXNotRecognizedException e) {
            throw new JDOMException(displayName + " feature not recognized for SAX driver " + parser.getClass().getName());
        }
    }

    private void internalSetProperty(XMLReader parser, String property, Object value, String displayName) throws JDOMException {
        try {
            parser.setProperty(property, value);
        }
        catch (SAXNotSupportedException e) {
            throw new JDOMException(displayName + " property not supported for SAX driver " + parser.getClass().getName());
        }
        catch (SAXNotRecognizedException e) {
            throw new JDOMException(displayName + " property not recognized for SAX driver " + parser.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document build(Reader characterStream) throws JDOMException, IOException {
        try {
            Document document = this.getEngine().build(characterStream);
            return document;
        }
        finally {
            if (!this.reuseParser) {
                this.engine = null;
            }
        }
    }
}

