/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;

public class AddModeDialog
extends EnhancedDialog {
    private JTextField modeName;
    private JTextField modeFile;
    private JButton browse;
    private JTextField filenameGlob;
    private JTextField firstLineGlob;
    private final JButton ok;
    private final JButton cancel;
    private boolean canceled = false;

    public AddModeDialog(View view) {
        super(view, jEdit.getProperty("options.editing.addMode.dialog.title"), true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setContentPane(jPanel);
        AbstractOptionPane abstractOptionPane = new AbstractOptionPane("addmode");
        abstractOptionPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.modeName = new JTextField(16);
        abstractOptionPane.addComponent(jEdit.getProperty("options.editing.addMode.dialog.modeName"), (Component)this.modeName);
        this.modeFile = new JTextField();
        this.browse = new JButton("...");
        this.browse.addActionListener(new ActionHandler());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.modeFile, "Center");
        jPanel2.add((Component)this.browse, "East");
        abstractOptionPane.addComponent(jEdit.getProperty("options.editing.addMode.dialog.modeFile"), (Component)jPanel2);
        this.filenameGlob = new JTextField(16);
        abstractOptionPane.addComponent(jEdit.getProperty("options.editing.addMode.dialog.filenameGlob"), (Component)this.filenameGlob);
        this.firstLineGlob = new JTextField();
        abstractOptionPane.addComponent(jEdit.getProperty("options.editing.addMode.dialog.firstLineGlob"), (Component)this.firstLineGlob);
        jPanel.add(abstractOptionPane);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(17, 0, 0, 6));
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(new ActionHandler());
        this.getRootPane().setDefaultButton(this.ok);
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(new ActionHandler());
        GenericGUIUtilities.makeSameSize(this.ok, this.cancel);
        jPanel3.add(Box.createGlue());
        jPanel3.add(this.ok);
        jPanel3.add(Box.createHorizontalStrut(6));
        jPanel3.add(this.cancel);
        jPanel.add("South", jPanel3);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    public String getModeName() {
        return this.modeName.getText();
    }

    public String getModeFile() {
        return this.modeFile.getText();
    }

    public String getFilenameGlob() {
        return this.filenameGlob.getText();
    }

    public String getFirstLineGlob() {
        return this.firstLineGlob.getText();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void ok() {
        String string = this.getModeName();
        if (string == null || string.isEmpty()) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), jEdit.getProperty("options.editing.addMode.dialog.Mode_name_may_not_be_empty.", "Mode name may not be empty."), jEdit.getProperty("options.editing.addMode.dialog.errorTitle", "Error"), 0);
            return;
        }
        String string2 = this.getModeFile();
        if (string2 == null || string2.isEmpty()) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), jEdit.getProperty("options.editing.addMode.dialog.Mode_file_may_not_be_empty.", "Mode file may not be empty."), jEdit.getProperty("options.editing.addMode.dialog.errorTitle", "Error"), 0);
            return;
        }
        String string3 = this.getFilenameGlob();
        String string4 = this.getFirstLineGlob();
        if ((string3 == null || string3.isEmpty()) && (string4 == null || string4.isEmpty())) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), jEdit.getProperty("options.editing.addMode.dialog.Either_file_name_glob_or_first_line_glob_or_both_must_be_filled_in.", "Either file name glob or first line glob or both must be filled in."), jEdit.getProperty("options.editing.addMode.dialog.errorTitle", "Error"), 0);
            return;
        }
        this.canceled = false;
        this.dispose();
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.dispose();
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == AddModeDialog.this.browse) {
                boolean bl;
                int n;
                String string;
                View view = jEdit.getActiveView();
                String[] stringArray = GUIUtilities.showVFSFileDialog(view, string = jEdit.getSettingsDirectory(), n = 0, bl = false);
                if (stringArray != null && stringArray.length > 0) {
                    AddModeDialog.this.modeFile.setText(stringArray[0]);
                } else {
                    AddModeDialog.this.modeFile.setText("");
                }
            } else if (object == AddModeDialog.this.ok) {
                AddModeDialog.this.ok();
            } else if (object == AddModeDialog.this.cancel) {
                AddModeDialog.this.cancel();
            }
        }
    }
}

