/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gjt.sp.jedit.help.HelpHistoryModelListener;
import org.gjt.sp.jedit.help.HelpViewer;

public class HelpHistoryModel {
    private int historyPos;
    private HistoryEntry[] history;
    private List<HelpHistoryModelListener> listeners;

    public HelpHistoryModel(int n) {
        this.history = new HistoryEntry[n];
        this.listeners = new ArrayList<HelpHistoryModelListener>();
    }

    HistoryEntry forward(HelpViewer helpViewer) {
        if (this.history.length - this.historyPos <= 1) {
            return null;
        }
        if (this.history[this.historyPos] == null) {
            return null;
        }
        this.setCurrentScrollPosition(helpViewer.getCurrentPage(), helpViewer.getCurrentScrollPosition());
        HistoryEntry historyEntry = new HistoryEntry(this.history[this.historyPos]);
        ++this.historyPos;
        this.fireUpdate();
        return historyEntry;
    }

    public boolean hasNext() {
        return this.history.length - this.historyPos > 1 && this.history[this.historyPos] != null;
    }

    HistoryEntry back(HelpViewer helpViewer) {
        if (this.historyPos <= 1) {
            return null;
        }
        this.setCurrentScrollPosition(helpViewer.getCurrentPage(), helpViewer.getCurrentScrollPosition());
        HistoryEntry historyEntry = new HistoryEntry(this.history[--this.historyPos - 1]);
        this.fireUpdate();
        return historyEntry;
    }

    public boolean hasPrevious() {
        return this.historyPos > 1;
    }

    public void addToHistory(String string) {
        this.history[this.historyPos] = new HistoryEntry(string, string, 0);
        if (this.historyPos + 1 == this.history.length) {
            System.arraycopy(this.history, 1, this.history, 0, this.history.length - 1);
            this.history[this.historyPos] = null;
        } else {
            ++this.historyPos;
            for (int i = this.historyPos; i < this.history.length; ++i) {
                this.history[i] = null;
            }
        }
        this.fireUpdate();
    }

    public void setCurrentScrollPosition(URL uRL, int n) {
        if (null != uRL && this.historyPos >= 1 && uRL.toString().equals(this.history[this.historyPos - 1].url)) {
            this.history[this.historyPos - 1].scrollPosition = n;
        }
    }

    public void setCurrentEntry(HistoryEntry historyEntry) {
        for (int i = 0; i < this.history.length; ++i) {
            if (this.history[i] == null || !this.history[i].equals(historyEntry)) continue;
            this.historyPos = i + 1;
            this.fireUpdate();
            break;
        }
    }

    public void updateTitle(String string, String string2) {
        for (HistoryEntry historyEntry : this.history) {
            if (historyEntry == null || !historyEntry.url.equals(string)) continue;
            historyEntry.title = string2;
        }
        this.fireUpdate();
    }

    HistoryEntry[] getPreviousURLs() {
        if (this.historyPos <= 1) {
            return new HistoryEntry[0];
        }
        HistoryEntry[] historyEntryArray = new HistoryEntry[this.historyPos - 1];
        System.arraycopy(this.history, 0, historyEntryArray, 0, this.historyPos - 1);
        return historyEntryArray;
    }

    HistoryEntry[] getNextURLs() {
        if (this.history.length - this.historyPos <= 1) {
            return new HistoryEntry[0];
        }
        if (this.history[this.historyPos] == null) {
            return new HistoryEntry[0];
        }
        HistoryEntry[] historyEntryArray = new HistoryEntry[this.history.length - this.historyPos];
        System.arraycopy(this.history, this.historyPos, historyEntryArray, 0, this.history.length - this.historyPos);
        return historyEntryArray;
    }

    public void addHelpHistoryModelListener(HelpHistoryModelListener helpHistoryModelListener) {
        this.listeners.add(helpHistoryModelListener);
    }

    public void removeHelpHistoryModelListener(HelpHistoryModelListener helpHistoryModelListener) {
        this.listeners.remove(helpHistoryModelListener);
    }

    public void fireUpdate() {
        for (HelpHistoryModelListener helpHistoryModelListener : this.listeners) {
            helpHistoryModelListener.historyUpdated();
        }
    }

    static class HistoryEntry {
        String url;
        String title;
        int scrollPosition;

        HistoryEntry(String string, String string2) {
            this(string, string2, 0);
        }

        HistoryEntry(HistoryEntry historyEntry) {
            this(historyEntry.url, historyEntry.title, historyEntry.scrollPosition);
        }

        HistoryEntry(String string, String string2, int n) {
            this.url = string;
            this.title = string2;
            this.scrollPosition = n;
        }

        public boolean equals(HistoryEntry historyEntry) {
            return historyEntry.url.equals(this.url) && historyEntry.title.equals(this.title) && historyEntry.scrollPosition == this.scrollPosition;
        }

        public String toString() {
            return this.getClass().getName() + "[url=" + this.url + ",title=" + this.title + ",scrollPosition=" + this.scrollPosition + ']';
        }
    }
}

