/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Encoding;
import javajs.util.JSJSONParser;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import jspecview.api.JSVZipInterface;
import jspecview.common.JSVersion;
import jspecview.common.JSViewer;
import jspecview.exception.JSVException;
import org.jmol.util.Logger;

public class JSVFileManager {
    public static final String SIMULATION_PROTOCOL = "http://SIMULATION/";
    public static URL appletDocumentBase;
    private static JSViewer viewer;
    public static String jsDocumentBase;
    private static final String[] urlPrefixes;
    public static final int URL_LOCAL = 4;
    private static Map<String, String> htCorrelationCache;
    private static String nciResolver;
    private static String nmrdbServerH1;
    private static String nmrdbServerC13;
    private static int stringCount;

    static {
        jsDocumentBase = "";
        urlPrefixes = new String[]{"http:", "https:", "ftp:", SIMULATION_PROTOCOL, "file:"};
        htCorrelationCache = new Hashtable<String, String>();
        nciResolver = "https://cactus.nci.nih.gov/chemical/structure/%FILE/file?format=sdf&get3d=True";
        nmrdbServerH1 = "http://www.nmrdb.org/tools/jmol/predict.php?POST?molfile=";
        nmrdbServerC13 = "http://www.nmrdb.org/service/jsmol13c?POST?molfile=";
    }

    public boolean isApplet() {
        return appletDocumentBase != null;
    }

    public static String getFileAsString(String string) {
        if (string == null) {
            return null;
        }
        SB sB = new SB();
        try {
            String string2;
            BufferedReader bufferedReader = JSVFileManager.getBufferedReaderFromName(string, null);
            while ((string2 = bufferedReader.readLine()) != null) {
                sB.append(string2);
                sB.appendC('\n');
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            return null;
        }
        return sB.toString();
    }

    public static BufferedReader getBufferedReaderForInputStream(InputStream inputStream) {
        try {
            return new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static BufferedReader getBufferedReaderForData(Object object) {
        return object == null ? null : new BufferedReader(new StringReader(object instanceof String ? (String)object : new String((byte[])object)));
    }

    public static BufferedReader getBufferedReaderFromName(String string, String string2) throws JSVException {
        if (string == null) {
            throw new JSVException("Cannot find " + string);
        }
        Logger.info("JSVFileManager getBufferedReaderFromName " + string);
        String string3 = JSVFileManager.getFullPathName(string);
        if (!string3.equals(string)) {
            Logger.info("JSVFileManager getBufferedReaderFromName " + string3);
        }
        return JSVFileManager.getUnzippedBufferedReaderFromName(string3, string2);
    }

    public static String getFullPathName(String string) throws JSVException {
        try {
            if (appletDocumentBase == null) {
                if (JSVFileManager.isURL(string)) {
                    URL uRL = new URL(null, string, null);
                    return uRL.toString();
                }
                return JSVFileManager.viewer.apiPlatform.newFile(string).getFullPath();
            }
            if (string.indexOf(":\\") == 1 || string.indexOf(":/") == 1) {
                string = "file:///" + string;
            } else if (string.startsWith("cache://")) {
                return string;
            }
            URL uRL = new URL(appletDocumentBase, string, null);
            return uRL.toString();
        }
        catch (Exception exception) {
            throw new JSVException("Cannot create path for " + string);
        }
    }

    public static boolean isURL(String string) {
        int n = urlPrefixes.length;
        while (--n >= 0) {
            if (!string.startsWith(urlPrefixes[n])) continue;
            return true;
        }
        return false;
    }

    public static int urlTypeIndex(String string) {
        int n = 0;
        while (n < urlPrefixes.length) {
            if (string.startsWith(urlPrefixes[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static boolean isLocal(String string) {
        if (string == null) {
            return false;
        }
        int n = JSVFileManager.urlTypeIndex(string);
        return n < 0 || n == 4;
    }

    private static BufferedReader getUnzippedBufferedReaderFromName(String string, String string2) throws JSVException {
        String[] stringArray = null;
        if (string.indexOf("|") >= 0 && (stringArray = PT.split(string, "|")) != null && stringArray.length > 0) {
            string = stringArray[0];
        }
        if (string.startsWith(SIMULATION_PROTOCOL)) {
            return JSVFileManager.getSimulationReader(string);
        }
        try {
            BufferedInputStream bufferedInputStream;
            InputStream inputStream = JSVFileManager.getInputStream(string, true, null);
            if (inputStream instanceof SB || inputStream instanceof String) {
                return new BufferedReader(new StringReader(inputStream.toString()));
            }
            if (JSVFileManager.isAB(inputStream)) {
                return new BufferedReader(new StringReader(new String((byte[])inputStream)));
            }
            InputStream inputStream2 = bufferedInputStream = new BufferedInputStream(inputStream);
            if (JSVFileManager.isZipFile(bufferedInputStream)) {
                return ((JSVZipInterface)JSViewer.getInterface("jspecview.common.JSVZipUtil")).newJSVZipFileSequentialReader(inputStream2, stringArray, string2);
            }
            if (JSVFileManager.isGzip(bufferedInputStream)) {
                inputStream2 = ((JSVZipInterface)JSViewer.getInterface("jspecview.common.JSVZipUtil")).newGZIPInputStream(inputStream2);
            }
            return new BufferedReader(new InputStreamReader(inputStream2, "UTF-8"));
        }
        catch (Exception exception) {
            throw new JSVException("Cannot read file " + string + " " + exception);
        }
    }

    public static String getAbbrSimulationFileName(String string) {
        String string2 = JSVFileManager.getSimulationType(string);
        String string3 = JSVFileManager.getAbbreviatedSimulationName(string, string2, true);
        return string3;
    }

    static String getAbbreviatedSimulationName(String string, String string2, boolean bl) {
        return string.indexOf("MOL=") >= 0 ? String.valueOf(bl ? SIMULATION_PROTOCOL : "") + "MOL=" + JSVFileManager.getSimulationHash(string, string2) : string;
    }

    private static String getSimulationHash(String string, String string2) {
        String string3 = String.valueOf(string2) + Math.abs(string.substring(string.indexOf("V2000") + 1).hashCode());
        if (Logger.debugging) {
            System.out.println("JSVFileManager hash for " + string + " = " + string3);
        }
        return string3;
    }

    public static String getSimulationFileData(String string, String string2) {
        return JSVFileManager.cacheGet(string.startsWith("MOL=") ? string.substring(4) : JSVFileManager.getAbbreviatedSimulationName(string, string2, false));
    }

    public static void cachePut(String string, String string2) {
        if (Logger.debugging) {
            Logger.debug("JSVFileManager cachePut " + string2 + " for " + string);
        }
        if (string2 != null) {
            htCorrelationCache.put(string, string2);
        }
    }

    public static String cacheGet(String string) {
        String string2 = htCorrelationCache.get(string);
        if (Logger.debugging) {
            Logger.info("JSVFileManager cacheGet " + string2 + " for " + string);
        }
        return string2;
    }

    private static BufferedReader getSimulationReader(String string) {
        String string2 = JSVFileManager.cacheGet(string);
        if (string2 == null) {
            string2 = JSVFileManager.getNMRSimulationJCampDX(string.substring(SIMULATION_PROTOCOL.length()));
            JSVFileManager.cachePut(string, string2);
        }
        return JSVFileManager.getBufferedReaderForData(string2);
    }

    public static boolean isAB(Object object) {
        return object instanceof byte[];
    }

    public static boolean isZipFile(InputStream inputStream) throws JSVException {
        try {
            byte[] byArray = new byte[4];
            inputStream.mark(5);
            int n = inputStream.read(byArray, 0, 4);
            inputStream.reset();
            return n == 4 && byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4;
        }
        catch (Exception exception) {
            throw new JSVException(exception.toString());
        }
    }

    private static boolean isGzip(InputStream inputStream) throws JSVException {
        try {
            byte[] byArray = new byte[4];
            inputStream.mark(5);
            int n = inputStream.read(byArray, 0, 4);
            inputStream.reset();
            return n == 4 && byArray[0] == 31 && byArray[1] == -117;
        }
        catch (Exception exception) {
            throw new JSVException(exception.toString());
        }
    }

    public static Object getStreamAsBytes(BufferedInputStream bufferedInputStream, OC oC) throws JSVException {
        try {
            byte[] byArray = new byte[1024];
            byte[] byArray2 = oC == null ? new byte[4096] : null;
            int n = 0;
            int n2 = 0;
            while ((n = bufferedInputStream.read(byArray, 0, 1024)) > 0) {
                n2 += n;
                if (oC == null) {
                    if (n2 >= byArray2.length) {
                        byArray2 = AU.ensureLengthByte(byArray2, n2 * 2);
                    }
                    System.arraycopy(byArray, 0, byArray2, n2 - n, n);
                    continue;
                }
                oC.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            if (oC == null) {
                return AU.arrayCopyByte(byArray2, n2);
            }
            return String.valueOf(n2) + " bytes";
        }
        catch (Exception exception) {
            throw new JSVException(exception.toString());
        }
    }

    public static String postByteArray(String string, byte[] byArray) {
        Object object = null;
        try {
            object = JSVFileManager.getInputStream(string, false, byArray);
        }
        catch (Exception exception) {
            object = exception.toString();
        }
        if (object instanceof String) {
            return (String)object;
        }
        try {
            object = JSVFileManager.getStreamAsBytes((BufferedInputStream)object, null);
        }
        catch (JSVException jSVException) {
            try {
                ((BufferedInputStream)object).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object == null ? "" : JSVFileManager.fixUTF((byte[])object);
    }

    private static Encoding getUTFEncoding(byte[] byArray) {
        if (byArray.length >= 3 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            return Encoding.UTF8;
        }
        if (byArray.length >= 4 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
            return Encoding.UTF_32BE;
        }
        if (byArray.length >= 4 && byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
            return Encoding.UTF_32LE;
        }
        if (byArray.length >= 2 && byArray[0] == -1 && byArray[1] == -2) {
            return Encoding.UTF_16LE;
        }
        if (byArray.length >= 2 && byArray[0] == -2 && byArray[1] == -1) {
            return Encoding.UTF_16BE;
        }
        return Encoding.NONE;
    }

    public static String fixUTF(byte[] byArray) {
        Encoding encoding = JSVFileManager.getUTFEncoding(byArray);
        if (encoding != Encoding.NONE) {
            try {
                String string = new String(byArray, encoding.name().replace('_', '-'));
                switch (encoding) {
                    case UTF8: 
                    case UTF_16BE: 
                    case UTF_16LE: {
                        string = string.substring(1);
                        break;
                    }
                }
                return string;
            }
            catch (IOException iOException) {
                Logger.error("fixUTF error " + iOException);
            }
        }
        return new String(byArray);
    }

    public static InputStream getInputStream(String string, boolean bl, byte[] byArray) throws JSVException {
        int n;
        boolean bl2 = JSVFileManager.isURL(string);
        boolean bl3 = appletDocumentBase != null;
        Object object = null;
        String string2 = null;
        if (bl2 && (n = string.indexOf("?POST?")) >= 0) {
            string2 = string.substring(n + 6);
            string = string.substring(0, n);
        }
        if (bl3 || bl2) {
            URL uRL;
            try {
                uRL = new URL(appletDocumentBase, string, null);
            }
            catch (Exception exception) {
                throw new JSVException("Cannot read " + string);
            }
            Logger.info("JSVFileManager opening URL " + uRL + (string2 == null ? "" : " with POST of " + string2.length() + " bytes"));
            object = JSVFileManager.viewer.apiPlatform.getURLContents(uRL, byArray, string2, false);
        } else {
            if (bl) {
                Logger.info("JSVFileManager opening file " + string);
            }
            object = JSVFileManager.viewer.apiPlatform.getBufferedFileInputStream(string);
        }
        if (object instanceof String) {
            throw new JSVException((String)object);
        }
        return (InputStream)object;
    }

    private static String getNMRSimulationJCampDX(String string) {
        String[] stringArray;
        Object object;
        String string2;
        String string3;
        String string4;
        boolean bl;
        int n = 0;
        String string5 = null;
        String string6 = JSVFileManager.getSimulationType(string);
        if (string.startsWith(string6)) {
            string = string.substring(string6.length() + 1);
        }
        if (bl = string.startsWith("MOL=")) {
            n = (string = string.substring(4)).indexOf("/n__Jmol");
            if (n > 0) {
                string = String.valueOf(string.substring(0, n)) + PT.rep(string.substring(n), "/n", "\n");
            }
            string5 = string = PT.rep(string, "\\n", "\n");
        }
        String string7 = JSVFileManager.getSimulationHash(string, string6);
        if (Logger.debugging) {
            Logger.info("JSVFileManager type=" + string6 + " key=" + string7 + " name=" + string);
        }
        if ((string4 = JSVFileManager.cacheGet(string7)) != null) {
            return string4;
        }
        String string8 = string3 = bl ? null : PT.rep(nciResolver, "%FILE", PT.escapeUrl(string));
        if (!bl && (string5 = JSVFileManager.getFileAsString(string3)) == null || string5.indexOf("<html") >= 0) {
            Logger.error("no MOL data returned by NCI");
            return null;
        }
        boolean bl2 = string6.equals("C13");
        String string9 = bl2 ? nmrdbServerC13 : nmrdbServerH1;
        String string10 = JSVFileManager.getFileAsString(String.valueOf(string9) + string5);
        Map map = new JSJSONParser().parseMap(string10, true);
        JSVFileManager.cachePut("json", string10);
        if (bl2) {
            map = (Map)map.get("result");
        }
        if ((string2 = (String)map.get("molfile")) == null) {
            System.out.println("JSVFileManager: no MOL file returned from EPFL");
            string2 = string5;
        } else {
            System.out.println("JSVFileManager: MOL file hash=" + string2.hashCode());
        }
        int[] nArray = JSVFileManager.getAtomMap(string2, string5);
        JSVFileManager.cachePut("mol", string5);
        System.out.println("type/name: " + string6 + "/" + string);
        System.out.println("jsonMolFile is \n" + string2);
        viewer.syncScript("JSVSTR:" + string5);
        String string11 = "<Signals src=" + PT.esc(PT.rep(bl2 ? nmrdbServerC13 : nmrdbServerH1, "?POST?molfile=", "")) + ">\n";
        if (bl2) {
            object = (Map)map.get("spectrum13C");
            string4 = (String)((Map)object.get("jcamp")).get("value");
            stringArray = (String[])object.get("predCSNuc");
            SB sB = new SB();
            int n2 = stringArray.size();
            while (--n2 >= 0) {
                map = (Map)stringArray.get(n2);
                sB.append("<Signal ");
                JSVFileManager.setAttr(sB, "type", "nucleus", map);
                if (nArray == null) {
                    JSVFileManager.setAttr(sB, "atoms", "assignment", map);
                } else {
                    sB.append("atoms=\"").appendI(nArray[PT.parseInt((String)map.get("assignment"))]).append("\" ");
                }
                JSVFileManager.setAttr(sB, "multiplicity", "multiplicity", map);
                map = (Map)map.get("integralData");
                JSVFileManager.setAttr(sB, "xMin", "from", map);
                JSVFileManager.setAttr(sB, "xMax", "to", map);
                JSVFileManager.setAttr(sB, "integral", "value", map);
                sB.append("></Signal>\n");
            }
            sB.append("</Signals>");
            string11 = String.valueOf(string11) + sB.toString();
        } else {
            string11 = PT.rep((String)map.get("xml"), "<Signals>", string11);
            if (nArray != null) {
                object = new SB();
                stringArray = PT.split(string11, " atoms=\"");
                ((SB)object).append(stringArray[0]);
                int n3 = 1;
                while (n3 < stringArray.length) {
                    String string12 = stringArray[n3];
                    int n4 = PT.parseInt(string12);
                    ((SB)object).append(" atoms=\"").appendI(nArray[n4]).append(string12.substring(string12.indexOf("\"")));
                    ++n3;
                }
                string11 = ((SB)object).toString();
            }
            string11 = PT.rep(string11, "</", "\n</");
            string11 = PT.rep(string11, "><", ">\n<");
            string11 = PT.rep(string11, "\\\"", "\"");
            string4 = (String)map.get("jcamp");
        }
        if (Logger.debugging) {
            Logger.info(string11);
        }
        JSVFileManager.cachePut("xml", string11);
        string4 = "##TITLE=" + (bl ? "JMOL SIMULATION/" + string6 : string) + "\n" + string4.substring(string4.indexOf("\n##") + 1);
        n = string5.indexOf("\n");
        n = string5.indexOf("\n", n + 1);
        if (n > 0 && n == string5.indexOf("\n \n")) {
            string5 = String.valueOf(string5.substring(0, n + 1)) + "Created " + JSVFileManager.viewer.apiPlatform.getDateFormat("8824") + " by JSpecView " + JSVersion.VERSION + string5.substring(n + 1);
        }
        n = 0;
        n = string4.indexOf("##.");
        object = JSVFileManager.getAbbreviatedSimulationName(string, string6, false);
        int n5 = ((String)object).indexOf("id='");
        if (bl && n5 > 0) {
            object = ((String)object).substring(n5 + 4, (String.valueOf(object) + "'").indexOf("'", n5 + 4));
        }
        string4 = String.valueOf(string4.substring(0, n)) + "##$MODELS=\n<Models>\n" + "<ModelData id=" + PT.esc((String)object) + " type=\"MOL\" src=" + PT.esc(string3) + ">\n" + string5 + "</ModelData>\n</Models>\n" + "##$SIGNALS=\n" + string11 + "\n" + string4.substring(n);
        JSVFileManager.cachePut("jcamp", string4);
        JSVFileManager.cachePut(string7, string4);
        return string4;
    }

    private static int[] getAtomMap(String string, String string2) {
        P3[] p3Array;
        P3[] p3Array2 = JSVFileManager.getCoord(string);
        int n = p3Array2.length;
        if (n != (p3Array = JSVFileManager.getCoord(string2)).length) {
            return null;
        }
        int[] nArray = new int[n];
        BS bS = new BS();
        bS.setBits(0, n);
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            P3 p3 = p3Array2[n2];
            int n3 = bS.nextSetBit(0);
            while (n3 >= 0) {
                if (p3.distanceSquared(p3Array[n3]) < 0.1f) {
                    bS.clear(n3);
                    nArray[n2] = n3;
                    if (n2 == n3) break;
                    bl = true;
                    break;
                }
                n3 = bS.nextSetBit(n3 + 1);
            }
            ++n2;
        }
        return (int[])(bl ? nArray : null);
    }

    private static P3[] getCoord(String string) {
        String[] stringArray = PT.split(string, "\n");
        float[] fArray = new float[3];
        int n = Integer.parseInt(stringArray[3].substring(0, 3).trim());
        P3[] p3Array = new P3[n];
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[4 + n2];
            PT.parseFloatArrayInfested(PT.getTokens(string2.substring(0, 31)), fArray);
            p3Array[n2] = P3.new3(fArray[0], fArray[1], fArray[2]);
            ++n2;
        }
        return p3Array;
    }

    private static void setAttr(SB sB, String string, String string2, Map<String, Object> map) {
        sB.append(String.valueOf(string) + "=\"").appendO(map.get(string2)).append("\" ");
    }

    private static URL getResource(Object object, String string, String[] stringArray) {
        URL uRL = null;
        try {
            uRL = object.getClass().getResource(string);
            if (uRL == null) {
                stringArray[0] = "Couldn't find file: " + string;
            }
        }
        catch (Exception exception) {
            stringArray[0] = "Exception " + exception + " in getResource " + string;
        }
        return uRL;
    }

    public static String getResourceString(Object object, String string, String[] stringArray) {
        URL uRL = JSVFileManager.getResource(object, string, stringArray);
        if (uRL == null) {
            stringArray[0] = "Error loading resource " + string;
            return null;
        }
        if (uRL instanceof String) {
            return JSVFileManager.getFileAsString((String)((Object)uRL));
        }
        SB sB = new SB();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)uRL.getContent(), "UTF-8"));
            while ((string2 = bufferedReader.readLine()) != null) {
                sB.append(string2).append("\n");
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            stringArray[0] = exception.toString();
        }
        return sB.toString();
    }

    public static String getJmolFilePath(String string) {
        try {
            string = JSVFileManager.getFullPathName(string);
        }
        catch (JSVException jSVException) {
            return null;
        }
        return appletDocumentBase == null ? string.replace('\\', '/') : string;
    }

    public static String getTagName(String string) {
        if (string == null) {
            return "String" + ++stringCount;
        }
        if (JSVFileManager.isURL(string)) {
            try {
                if (string.startsWith(SIMULATION_PROTOCOL)) {
                    return JSVFileManager.getAbbrSimulationFileName(string);
                }
                String string2 = new URL(null, string, null).getFile();
                return string2.substring(string2.lastIndexOf(47) + 1);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return JSVFileManager.viewer.apiPlatform.newFile(string).getName();
    }

    public static void setDocumentBase(JSViewer jSViewer, URL uRL) {
        viewer = jSViewer;
        appletDocumentBase = uRL;
    }

    public static String getSimulationType(String string) {
        return string.indexOf("C13/") >= 0 ? "C13" : "H1";
    }
}

