/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javajs.api.GenericColor;
import javajs.api.GenericFileInterface;
import javajs.awt.Font;
import javajs.awt.GenericMouseInterface;
import javajs.awt.GenericPlatform;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import javax.imageio.ImageIO;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import jspecview.api.JSVPanel;
import jspecview.api.JSVPdfWriter;
import jspecview.common.ColorParameters;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PrintLayout;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import org.jmol.util.Logger;

public class AwtPanel
extends JPanel
implements JSVPanel,
Printable {
    private static final long serialVersionUID = 1L;
    private GenericPlatform apiPlatform;
    private PanelData pd;
    private JSViewer vwr;
    private GenericMouseInterface mouse;
    private GenericColor bgcolor;

    public void finalize() {
        Logger.info("JSVPanel " + this + " finalized");
    }

    @Override
    public GenericPlatform getApiPlatform() {
        return this.apiPlatform;
    }

    @Override
    public PanelData getPanelData() {
        return this.pd;
    }

    public static AwtPanel getEmptyPanel(JSViewer jSViewer) {
        return new AwtPanel(jSViewer, false);
    }

    public static AwtPanel getPanelOne(JSViewer jSViewer, Spectrum spectrum) {
        ToolTipManager.sharedInstance().setInitialDelay(0);
        AwtPanel awtPanel = new AwtPanel(jSViewer, true);
        awtPanel.pd.initOne(spectrum);
        return awtPanel;
    }

    public static AwtPanel getPanelMany(JSViewer jSViewer, Lst<Spectrum> lst) {
        AwtPanel awtPanel = new AwtPanel(jSViewer, true);
        awtPanel.pd.initMany(lst, jSViewer.initialStartIndex, jSViewer.initialEndIndex);
        return awtPanel;
    }

    private AwtPanel(JSViewer jSViewer, boolean bl) {
        this.vwr = jSViewer;
        this.pd = bl ? new PanelData(this, jSViewer) : null;
        this.apiPlatform = jSViewer.apiPlatform;
        this.mouse = this.apiPlatform.getMouseManager(0.0, this);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
    }

    @Override
    public String getTitle() {
        return this.pd.getTitle();
    }

    @Override
    public void dispose() {
        if (this.pd != null) {
            this.pd.dispose();
        }
        this.pd = null;
        this.mouse.dispose();
    }

    @Override
    public void setTitle(String string) {
        this.pd.title = string;
        this.setName(string);
    }

    public void setColorOrFont(ColorParameters colorParameters, ScriptToken scriptToken) {
        this.pd.setColorOrFont(colorParameters, scriptToken);
    }

    @Override
    public void setBackgroundColor(GenericColor genericColor) {
        this.bgcolor = genericColor;
        this.setBackground((Color)((Object)this.bgcolor));
    }

    public GenericColor getBackgroundColor() {
        return this.bgcolor;
    }

    @Override
    public void doRepaint(boolean bl) {
        if (bl) {
            this.pd.setTaintedAll();
        }
        if (!this.pd.isPrinting) {
            this.vwr.requestRepaint();
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.vwr == null || this.pd == null || this.pd.graphSets == null || this.pd.isPrinting) {
            return;
        }
        super.paintComponent(graphics);
        try {
            this.pd.g2d = this.pd.g2d0;
            this.pd.drawGraph(graphics, graphics, graphics, this.getWidth(), this.getHeight(), false);
        }
        catch (Exception exception) {
            System.out.println("Exception while painting " + exception);
            exception.printStackTrace();
        }
        this.vwr.repaintDone();
    }

    @Override
    public String getInput(String string, String string2, String string3) {
        String string4 = (String)JOptionPane.showInputDialog(this, string, string2, 3, null, null, string3);
        this.getFocusNow(true);
        return string4;
    }

    @Override
    public void showMessage(String string, String string2) {
        Logger.info(string);
        if (string2 != null) {
            JOptionPane.showMessageDialog(this, string, string2, string.startsWith("<html>") ? 1 : -1);
        }
        this.getFocusNow(true);
    }

    @Override
    public void printPanel(PrintLayout printLayout, OutputStream outputStream, String string) {
        block13: {
            printLayout.title = string;
            printLayout.date = this.apiPlatform.getDateFormat("8824");
            this.pd.setPrint(printLayout, outputStream == null ? printLayout.font : "Helvetica");
            try {
                PrinterJob printerJob;
                PrinterJob printerJob2 = printerJob = outputStream == null ? PrinterJob.getPrinterJob() : null;
                if (printerJob != null) {
                    if (string.length() > 30) {
                        string = string.substring(0, 30);
                    }
                    printerJob.setJobName(string);
                    printerJob.setPrintable(this);
                }
                if (printerJob != null && !printerJob.printDialog()) break block13;
                try {
                    if (printerJob == null) {
                        Dimension dimension = this.getDimension((MediaSizeName)printLayout.paper);
                        printLayout.paperWidth = dimension.width;
                        printLayout.paperHeight = dimension.height;
                        ((JSVPdfWriter)JSViewer.getInterface("jspecview.common.PDFWriter")).createPdfDocument(this, printLayout, outputStream);
                    } else {
                        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
                        hashPrintRequestAttributeSet.add(printLayout.layout.equals("landscape") ? OrientationRequested.LANDSCAPE : OrientationRequested.PORTRAIT);
                        hashPrintRequestAttributeSet.add((Attribute)printLayout.paper);
                        printerJob.print(hashPrintRequestAttributeSet);
                    }
                }
                catch (PrinterException printerException) {
                    String string2 = printerException.getMessage();
                    if (string2 == null) {
                        this.pd.setPrint(null, null);
                        return;
                    }
                    try {
                        string2 = PT.rep(string2, "not accepting job.", "not accepting jobs.");
                        this.showMessage(string2, "Printer Error");
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                }
            }
            finally {
                this.pd.setPrint(null, null);
            }
        }
    }

    private Dimension getDimension(MediaSizeName mediaSizeName) {
        if (mediaSizeName == MediaSizeName.NA_LETTER) {
            return new Dimension(612, 792);
        }
        if (mediaSizeName == MediaSizeName.NA_LEGAL) {
            return new Dimension(612, 1008);
        }
        if (mediaSizeName == MediaSizeName.ISO_A4) {
            return new Dimension(595, 841);
        }
        return new Dimension(708, 1000);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        return this.pd.print(graphics, pageFormat.getImageableHeight(), pageFormat.getImageableWidth(), pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getPaper().getHeight(), pageFormat.getPaper().getWidth(), pageFormat.getOrientation() == 1, n);
    }

    @Override
    public int getFontFaceID(String string) {
        return Font.getFontFaceID("SansSerif");
    }

    @Override
    public String saveImage(String string, GenericFileInterface genericFileInterface, OC oC) {
        String string2 = "OK";
        try {
            Image image = this.createImage(this.getWidth(), this.getHeight());
            this.paint(image.getGraphics());
            ImageIO.write((RenderedImage)((Object)image), string, (File)((Object)genericFileInterface));
        }
        catch (IOException iOException) {
            string2 = iOException.toString();
            this.showMessage(string2, "Error Saving Image");
        }
        return null;
    }

    @Override
    public void getFocusNow(boolean bl) {
        if (bl) {
            SwingUtilities.invokeLater(new RequestThread());
        } else {
            this.requestFocusInWindow();
        }
        if (this.pd != null) {
            this.pd.dialogsToFront(null);
        }
    }

    @Override
    public String toString() {
        return this.pd.getSpectrumAt(0).toString();
    }

    @Override
    public boolean processMouseEvent(int n, int n2, int n3, int n4, long l) {
        return this.mouse.processEvent(n, n2, n3, n4, l);
    }

    @Override
    public void processTwoPointGesture(float[][][] fArray) {
    }

    @Override
    public void showMenu(int n, int n2) {
        this.vwr.showMenu(n, n2);
    }

    @Override
    public void paintComponent(Object object) {
        super.paintComponent((Graphics)object);
    }

    public class RequestThread
    implements Runnable {
        @Override
        public void run() {
            AwtPanel.this.requestFocusInWindow();
        }
    }
}

