/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericCifDataParser;
import javajs.util.BS;
import javajs.util.CifDataParser;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.V3;
import org.jmol.adapter.readers.cif.MSCifParser;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.Logger;
import org.jmol.util.Vibration;

public class CifReader
extends AtomSetCollectionReader {
    private static final String titleRecords = "__citation_title__publ_section_title__active_magnetic_irreps_details__";
    private MSCifParser modr;
    GenericCifDataParser parser;
    private boolean isAFLOW;
    private boolean filterAssembly;
    private boolean allowRotations = true;
    private boolean readIdeal = true;
    private int configurationPtr = Integer.MIN_VALUE;
    protected boolean useAuthorChainID = true;
    protected String thisDataSetName = "";
    protected String lastDataSetName;
    private String chemicalName = "";
    private String thisStructuralFormula = "";
    private String thisFormula = "";
    protected boolean iHaveDesiredModel;
    protected boolean isMMCIF;
    protected boolean isLigand;
    protected boolean isMagCIF;
    boolean haveHAtoms;
    private String molecularType = "GEOM_BOND default";
    private char lastAltLoc = '\u0000';
    private boolean haveAromatic;
    private int conformationIndex;
    private int nMolecular = 0;
    private String appendedData;
    protected boolean skipping;
    protected int nAtoms;
    protected int ac;
    private String auditBlockCode;
    private String lastSpaceGroupName;
    private boolean modulated;
    protected boolean isCourseGrained;
    boolean haveCellWaveVector;
    private String latticeType = null;
    protected Map<String, String> htGroup1;
    protected int nAtoms0;
    private int titleAtomSet = 1;
    private int intTableNo;
    private Map<String, String> htCellTypes;
    public Map<String, Integer> modelMap;
    private Hashtable<String, Object> htAudit;
    private Lst<String> symops;
    protected String pdbID;
    private static final String[] TransformFields = new String[]{"x[1][1]", "x[1][2]", "x[1][3]", "r[1]", "x[2][1]", "x[2][2]", "x[2][3]", "r[2]", "x[3][1]", "x[3][2]", "x[3][3]", "r[3]"};
    String key;
    String key0;
    String data;
    private boolean isLoop;
    int[] col2key = new int[100];
    int[] key2col = new int[100];
    String field;
    protected char firstChar = '\u0000';
    private Map<String, Float> htOxStates;
    private Lst<Object[]> bondTypes = new Lst();
    private String disorderAssembly = ".";
    private String lastDisorderAssembly;
    private Lst<float[]> lattvecs;
    private Lst<String> magCenterings;
    protected int maxSerial;
    private static final byte ATOM_TYPE_SYMBOL = 0;
    private static final byte ATOM_TYPE_OXIDATION_NUMBER = 1;
    private static final String[] atomTypeFields = new String[]{"_atom_type_symbol", "_atom_type_oxidation_number"};
    protected static final byte NONE = -1;
    private static final byte TYPE_SYMBOL = 0;
    private static final byte LABEL = 1;
    private static final byte AUTH_ATOM = 2;
    private static final byte FRACT_X = 3;
    private static final byte FRACT_Y = 4;
    private static final byte FRACT_Z = 5;
    private static final byte CARTN_X = 6;
    private static final byte CARTN_Y = 7;
    private static final byte CARTN_Z = 8;
    private static final byte OCCUPANCY = 9;
    private static final byte B_ISO = 10;
    private static final byte COMP_ID = 11;
    private static final byte AUTH_ASYM_ID = 12;
    private static final byte AUTH_SEQ_ID = 13;
    private static final byte INS_CODE = 14;
    private static final byte ALT_ID = 15;
    private static final byte GROUP_PDB = 16;
    private static final byte MODEL_NO = 17;
    private static final byte DUMMY_ATOM = 18;
    private static final byte DISORDER_GROUP = 19;
    private static final byte ANISO_LABEL = 20;
    private static final byte ANISO_MMCIF_ID = 21;
    private static final byte ANISO_U11 = 22;
    private static final byte ANISO_U22 = 23;
    private static final byte ANISO_U33 = 24;
    private static final byte ANISO_U12 = 25;
    private static final byte ANISO_U13 = 26;
    private static final byte ANISO_U23 = 27;
    private static final byte ANISO_MMCIF_U11 = 28;
    private static final byte ANISO_MMCIF_U22 = 29;
    private static final byte ANISO_MMCIF_U33 = 30;
    private static final byte ANISO_MMCIF_U12 = 31;
    private static final byte ANISO_MMCIF_U13 = 32;
    private static final byte ANISO_MMCIF_U23 = 33;
    private static final byte U_ISO_OR_EQUIV = 34;
    private static final byte ANISO_B11 = 35;
    private static final byte ANISO_B22 = 36;
    private static final byte ANISO_B33 = 37;
    private static final byte ANISO_B12 = 38;
    private static final byte ANISO_B13 = 39;
    private static final byte ANISO_B23 = 40;
    private static final byte ANISO_BETA_11 = 41;
    private static final byte ANISO_BETA_22 = 42;
    private static final byte ANISO_BETA_33 = 43;
    private static final byte ANISO_BETA_12 = 44;
    private static final byte ANISO_BETA_13 = 45;
    private static final byte ANISO_BETA_23 = 46;
    private static final byte ADP_TYPE = 47;
    private static final byte CC_COMP_ID = 48;
    private static final byte CC_ATOM_ID = 49;
    private static final byte CC_ATOM_SYM = 50;
    private static final byte CC_ATOM_CHARGE = 51;
    private static final byte CC_ATOM_X = 52;
    private static final byte CC_ATOM_Y = 53;
    private static final byte CC_ATOM_Z = 54;
    private static final byte CC_ATOM_X_IDEAL = 55;
    private static final byte CC_ATOM_Y_IDEAL = 56;
    private static final byte CC_ATOM_Z_IDEAL = 57;
    private static final byte DISORDER_ASSEMBLY = 58;
    private static final byte ASYM_ID = 59;
    private static final byte SUBSYS_ID = 60;
    private static final byte SITE_MULT = 61;
    private static final byte THERMAL_TYPE = 62;
    private static final byte MOMENT_LABEL = 63;
    private static final byte MOMENT_PRELIM_X = 64;
    private static final byte MOMENT_PRELIM_Y = 65;
    private static final byte MOMENT_PRELIM_Z = 66;
    private static final byte MOMENT_X = 67;
    private static final byte MOMENT_Y = 68;
    private static final byte MOMENT_Z = 69;
    private static final byte ATOM_ID = 70;
    private static final byte SEQ_ID = 71;
    protected static final String FAMILY_ATOM = "_atom_site";
    private static final String[] atomFields = new String[]{"*_type_symbol", "*_label", "*_auth_atom_id", "*_fract_x", "*_fract_y", "*_fract_z", "*_cartn_x", "*_cartn_y", "*_cartn_z", "*_occupancy", "*_b_iso_or_equiv", "*_auth_comp_id", "*_auth_asym_id", "*_auth_seq_id", "*_pdbx_pdb_ins_code", "*_label_alt_id", "*_group_pdb", "*_pdbx_pdb_model_num", "*_calc_flag", "*_disorder_group", "*_aniso_label", "*_anisotrop_id", "*_aniso_u_11", "*_aniso_u_22", "*_aniso_u_33", "*_aniso_u_12", "*_aniso_u_13", "*_aniso_u_23", "*_anisotrop_u[1][1]", "*_anisotrop_u[2][2]", "*_anisotrop_u[3][3]", "*_anisotrop_u[1][2]", "*_anisotrop_u[1][3]", "*_anisotrop_u[2][3]", "*_u_iso_or_equiv", "*_aniso_b_11", "*_aniso_b_22", "*_aniso_b_33", "*_aniso_b_12", "*_aniso_b_13", "*_aniso_b_23", "*_aniso_beta_11", "*_aniso_beta_22", "*_aniso_beta_33", "*_aniso_beta_12", "*_aniso_beta_13", "*_aniso_beta_23", "*_adp_type", "_chem_comp_atom_comp_id", "_chem_comp_atom_atom_id", "_chem_comp_atom_type_symbol", "_chem_comp_atom_charge", "_chem_comp_atom_model_cartn_x", "_chem_comp_atom_model_cartn_y", "_chem_comp_atom_model_cartn_z", "_chem_comp_atom_pdbx_model_cartn_x_ideal", "_chem_comp_atom_pdbx_model_cartn_y_ideal", "_chem_comp_atom_pdbx_model_cartn_z_ideal", "*_disorder_assembly", "*_label_asym_id", "*_subsystem_code", "*_symmetry_multiplicity", "*_thermal_displace_type", "*_moment_label", "*_moment_crystalaxis_mx", "*_moment_crystalaxis_my", "*_moment_crystalaxis_mz", "*_moment_crystalaxis_x", "*_moment_crystalaxis_y", "*_moment_crystalaxis_z", "*_id", "*_label_seq_id"};
    private static final String singleAtomID = atomFields[48];
    private static final byte CITATION_TITLE = 0;
    private static final String[] citationFields = new String[]{"_citation_title"};
    private static final byte SYM_XYZ = 0;
    private static final byte SYM_MAGN_XYZ = 1;
    private static final byte SYM_SSG_ALG = 2;
    private static final byte SYM_MAGN_SSG_ALG = 3;
    private static final byte SYM_EQ_XYZ = 4;
    private static final byte SYM_SSG_EQ_XYZ = 5;
    private static final byte SYM_MAGN_REV = 7;
    private static final byte SYM_MAGN_SSG_REV = 8;
    private static final byte SYM_MAGN_REV_PRELIM = 6;
    private static final byte SYM_MAGN_CENTERING = 9;
    private static final byte SYM_MAGN_SSG_CENTERING = 10;
    private static final byte SYM_MAGN_SSG_CENT_XYZ = 11;
    private static final String FAMILY_SGOP = "_space_group_symop";
    private static final String[] symmetryOperationsFields = new String[]{"*_operation_xyz", "*_magn_operation_xyz", "*_ssg_operation_algebraic", "*_magn_ssg_operation_algebraic", "_symmetry_equiv_pos_as_xyz", "_symmetry_ssg_equiv_pos_as_xyz", "*_magn_operation_timereversal", "*_magn_ssg_operation_timereversal", "*_operation_timereversal", "*_magn_centering_xyz", "*_magn_ssg_centering_algebraic", "*_magn_ssg_centering_xyz"};
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_1 = 0;
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_2 = 1;
    private static final byte GEOM_BOND_DISTANCE = 2;
    private static final byte CCDC_GEOM_BOND_TYPE = 3;
    private static final String[] geomBondFields = new String[]{"_geom_bond_atom_site_label_1", "_geom_bond_atom_site_label_2", "_geom_bond_distance", "_ccdc_geom_bond_type"};
    private float[] atomRadius;
    private BS[] bsConnected;
    private BS[] bsSets;
    private final P3 ptOffset = new P3();
    private BS bsMolecule;
    private BS bsExclude;
    private int firstAtom;
    private Atom[] atoms;
    private BS bsBondDuplicates;

    @Override
    public void initializeReader() throws Exception {
        this.initSubclass();
        this.allowPDBFilter = true;
        this.appendedData = (String)this.htParams.get("appendedData");
        String string = this.getFilter("CONF ");
        if (string != null) {
            this.configurationPtr = this.parseIntStr(string);
        }
        this.isMolecular = this.checkFilterKey("MOLECUL") && !this.checkFilterKey("BIOMOLECULE");
        this.isPrimitive = this.checkFilterKey("PRIMITIVE");
        this.readIdeal = !this.checkFilterKey("NOIDEAL");
        this.filterAssembly = this.checkFilterKey("$");
        boolean bl = this.useAuthorChainID = !this.checkFilterKey("NOAUTHORCHAINS");
        if (this.isMolecular) {
            this.forceSymmetry(false);
            this.molecularType = "filter \"MOLECULAR\"";
        }
        this.asc.checkSpecial = !this.checkFilterKey("NOSPECIAL");
        boolean bl2 = this.allowRotations = !this.checkFilterKey("NOSYM");
        if (this.strSupercell != null && this.strSupercell.indexOf(",") >= 0) {
            this.addCellType("conventional", this.strSupercell, true);
        }
        if (this.binaryDoc != null) {
            return;
        }
        this.readCifData();
        this.continuing = false;
    }

    protected void initSubclass() {
    }

    private void readCifData() throws Exception {
        this.parser = this.getCifDataParser();
        this.line = "";
        while ((this.key = (String)this.parser.peekToken()) != null) {
            if (!this.readAllData()) break;
        }
        if (this.appendedData != null) {
            this.parser = ((GenericCifDataParser)this.getInterface("javajs.util.CifDataParser")).set(null, Rdr.getBR(this.appendedData), this.debugging);
            while ((this.key = (String)this.parser.peekToken()) != null) {
                if (!this.readAllData()) break;
            }
        }
    }

    protected GenericCifDataParser getCifDataParser() {
        return new CifDataParser().set(this, null, this.debugging);
    }

    private boolean readAllData() throws Exception {
        if (this.key.startsWith("data_")) {
            this.isLigand = false;
            if (this.asc.atomSetCount == 0) {
                this.iHaveDesiredModel = false;
            }
            if (this.iHaveDesiredModel) {
                return false;
            }
            if (this.desiredModelNumber != Integer.MIN_VALUE) {
                this.appendLoadNote(null);
            }
            this.newModel(++this.modelNumber);
            this.haveCellWaveVector = false;
            if (this.auditBlockCode == null) {
                this.modulated = false;
            }
            if (!this.skipping) {
                this.nAtoms0 = this.asc.ac;
                this.processDataParameter();
                this.nAtoms = this.asc.ac;
            }
            return true;
        }
        if (this.skipping && this.key.equals("_audit_block_code")) {
            this.iHaveDesiredModel = false;
            this.skipping = false;
        }
        this.isLoop = this.key.startsWith("loop_");
        if (this.isLoop) {
            if (this.skipping && !this.isMMCIF) {
                this.parser.getTokenPeeked();
                this.parser.skipLoop(false);
            } else {
                this.processLoopBlock();
            }
            return true;
        }
        if (this.key.indexOf("_") != 0) {
            Logger.warn(this.key.startsWith("save_") ? "CIF reader ignoring save_" : "CIF ERROR ? should be an underscore: " + this.key);
            this.parser.getTokenPeeked();
        } else if (!this.getData()) {
            return true;
        }
        if (!this.skipping) {
            this.key0 = this.key;
            this.key = this.parser.fixKey(this.key0);
            if (this.key.startsWith("_chemical_name") || this.key.equals("_chem_comp_name")) {
                this.processChemicalInfo("name");
            } else if (this.key.startsWith("_chemical_formula_structural")) {
                this.processChemicalInfo("structuralFormula");
            } else if (this.key.startsWith("_chemical_formula_sum") || this.key.equals("_chem_comp_formula")) {
                this.processChemicalInfo("formula");
            } else if (this.key.equals("_cell_modulation_dimension")) {
                this.modDim = this.parseIntStr(this.data);
            } else if (this.key.startsWith("_cell_") && this.key.indexOf("_commen_") < 0) {
                this.processCellParameter();
            } else if (this.key.startsWith("_atom_sites_fract_tran")) {
                this.processUnitCellTransformMatrix();
            } else if (this.key.startsWith("_audit")) {
                if (this.key.equals("_audit_block_code")) {
                    this.auditBlockCode = this.parser.fullTrim(this.data).toUpperCase();
                    this.appendLoadNote(this.auditBlockCode);
                    if (this.htAudit != null && this.auditBlockCode.contains("_MOD_")) {
                        String string = PT.rep(this.auditBlockCode, "_MOD_", "_REFRNCE_");
                        if (this.asc.setSymmetry((SymmetryInterface)this.htAudit.get(string)) != null) {
                            this.unitCellParams = this.asc.getSymmetry().getUnitCellParams();
                            this.iHaveUnitCell = true;
                        }
                    } else if (this.htAudit != null && this.symops != null) {
                        int n = 0;
                        while (n < this.symops.size()) {
                            this.setSymmetryOperator((String)this.symops.get(n));
                            ++n;
                        }
                    }
                    if (this.lastSpaceGroupName != null) {
                        this.setSpaceGroupName(this.lastSpaceGroupName);
                    }
                } else if (this.key.equals("_audit_creation_date")) {
                    this.symmetry = null;
                }
            } else if (this.key.equals(singleAtomID)) {
                this.readSingleAtom();
            } else if (this.key.startsWith("_symmetry_space_group_name_h-m") || this.key.startsWith("_symmetry_space_group_name_hall") || this.key.startsWith("_space_group_name") || this.key.contains("_ssg_name") || this.key.contains("_magn_name") || this.key.contains("_bns_name")) {
                this.processSymmetrySpaceGroupName();
            } else if (this.key.startsWith("_space_group_transform") || this.key.startsWith("_parent_space_group") || this.key.startsWith("_space_group_magn_transform")) {
                this.processUnitCellTransform();
            } else if (this.key.contains("_database_code")) {
                this.addModelTitle("ID");
            } else if (titleRecords.contains("_" + this.key + "__")) {
                this.addModelTitle("TITLE");
            } else if (this.key.startsWith("_aflow_")) {
                this.isAFLOW = true;
            } else if (this.key.equals("_symmetry_int_tables_number")) {
                this.intTableNo = this.parseIntStr(this.data);
                this.rotateHexCell = this.isAFLOW && this.intTableNo >= 143 && this.intTableNo <= 194;
            } else if (this.key.equals("_entry_id")) {
                this.pdbID = this.data;
            } else {
                this.processSubclassEntry();
            }
        }
        return true;
    }

    private void addModelTitle(String string) {
        if (this.asc.atomSetCount > this.titleAtomSet) {
            this.titleAtomSet = this.asc.atomSetCount;
            this.appendLoadNote("\nMODEL: " + this.titleAtomSet);
        }
        this.appendLoadNote(String.valueOf(string) + ": " + this.parser.fullTrim(this.data));
    }

    protected void processSubclassEntry() throws Exception {
        if (this.modDim > 0) {
            this.getModulationReader().processEntry();
        }
    }

    private void processUnitCellTransform() {
        this.data = PT.replaceAllCharacters(this.data, " ", "");
        if (this.key.contains("_from_parent") || this.key.contains("child_transform")) {
            this.addCellType("parent", this.data, true);
        } else if (this.key.contains("_to_standard") || this.key.contains("transform_bns_pp_abc")) {
            this.addCellType("standard", this.data, false);
        }
        this.appendLoadNote(String.valueOf(this.key) + ": " + this.data);
    }

    private void addCellType(String string, String string2, boolean bl) {
        if (this.htCellTypes == null) {
            this.htCellTypes = new Hashtable<String, String>();
        }
        if (string2.startsWith("!")) {
            string2 = string2.substring(1);
            bl = !bl;
        }
        String string3 = String.valueOf(bl ? "!" : "") + string2;
        this.htCellTypes.put(string, string3);
        if (string.equalsIgnoreCase(this.strSupercell)) {
            this.strSupercell = string3;
            this.htCellTypes.put("conventional", String.valueOf(bl ? "" : "!") + string2);
        }
    }

    private void readSingleAtom() {
        Atom atom = new Atom();
        atom.set(0.0f, 0.0f, 0.0f);
        atom.atomName = this.parser.fullTrim(this.data);
        atom.getElementSymbol();
        this.asc.addAtom(atom);
    }

    private MSCifParser getModulationReader() throws Exception {
        return this.modr == null ? this.initializeMSCIF() : this.modr;
    }

    private MSCifParser initializeMSCIF() throws Exception {
        if (this.modr == null) {
            this.modr = (MSCifParser)this.getInterface("org.jmol.adapter.readers.cif.MSCifParser");
            this.ms = this.modr;
        }
        this.modulated = this.modr.initialize(this, this.modDim) > 0;
        return this.modr;
    }

    protected void newModel(int n) throws Exception {
        this.modelNumber = n;
        boolean bl = this.skipping = !this.doGetModel(this.modelNumber, null);
        if (this.skipping) {
            if (!this.isMMCIF) {
                this.parser.getTokenPeeked();
            }
            return;
        }
        this.chemicalName = "";
        this.thisStructuralFormula = "";
        this.thisFormula = "";
        this.iHaveDesiredModel = this.isLastModel(this.modelNumber);
        if (this.isCourseGrained) {
            this.asc.setCurrentModelInfo("courseGrained", Boolean.TRUE);
        }
        if (this.nAtoms0 == this.asc.ac) {
            --this.modelNumber;
            this.haveModel = false;
            this.asc.removeCurrentAtomSet();
        } else {
            this.applySymmetryAndSetTrajectory();
        }
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        if (this.asc.iSet > 0 && this.asc.getAtomSetAtomCount(this.asc.iSet) == 0) {
            --this.asc.atomSetCount;
        } else if (!this.isMMCIF || !this.finalizeSubclass()) {
            this.applySymmetryAndSetTrajectory();
        }
        int n = this.asc.atomSetCount;
        if (n > 1) {
            this.asc.setCollectionName("<collection of " + n + " models>");
        }
        if (this.pdbID != null) {
            this.asc.setCurrentModelInfo("pdbID", this.pdbID);
        }
        this.finalizeReaderASCR();
        this.addHeader();
        if (this.haveAromatic) {
            this.addJmolScript("calculate aromatic");
        }
    }

    protected void addHeader() {
        String string = this.parser.getFileHeader();
        if (string.length() > 0) {
            String string2 = this.setLoadNote();
            this.appendLoadNote(null);
            this.appendLoadNote(string);
            this.appendLoadNote(string2);
            this.setLoadNote();
            this.asc.setInfo("fileHeader", string);
        }
    }

    protected boolean finalizeSubclass() throws Exception {
        return false;
    }

    @Override
    public void doPreSymmetry() throws Exception {
        if (this.magCenterings != null) {
            this.addLatticeVectors();
        }
        if (this.modDim > 0) {
            this.getModulationReader().setModulation(false, null);
        }
        if (this.isMagCIF) {
            this.asc.getXSymmetry().scaleFractionalVibs();
            this.vibsFractional = true;
        }
    }

    @Override
    public void applySymmetryAndSetTrajectory() throws Exception {
        boolean bl;
        if (this.isMMCIF) {
            this.asc.checkSpecial = false;
        }
        boolean bl2 = bl = this.doCheckUnitCell && !this.isMMCIF;
        if (this.isMMCIF) {
            int n = this.asc.iSet;
            this.asc.setCurrentModelInfo("PDB_CONECT_firstAtom_count_max", new int[]{this.asc.getAtomSetAtomIndex(n), this.asc.getAtomSetAtomCount(n), this.maxSerial});
        }
        if (this.htCellTypes != null) {
            for (Map.Entry<String, String> entry : this.htCellTypes.entrySet()) {
                this.asc.setCurrentModelInfo("unitcell_" + entry.getKey(), entry.getValue());
            }
            this.htCellTypes = null;
        }
        if (!this.haveCellWaveVector) {
            this.modDim = 0;
        }
        if (this.doApplySymmetry && !this.iHaveFractionalCoordinates) {
            this.fractionalizeCoordinates(true);
        }
        this.applySymTrajASCR();
        if (bl && (this.bondTypes.size() > 0 || this.isMolecular)) {
            this.setBondingAndMolecules();
        }
        this.asc.setCurrentModelInfo("fileHasUnitCell", Boolean.TRUE);
        this.asc.xtalSymmetry = null;
    }

    @Override
    protected void finalizeSubclassSymmetry(boolean bl) throws Exception {
        SymmetryInterface symmetryInterface;
        SymmetryInterface symmetryInterface2 = symmetryInterface = bl ? this.asc.getXSymmetry().getBaseSymmetry() : null;
        if (symmetryInterface != null && symmetryInterface.getSpaceGroup() == null) {
            this.appendLoadNote("Invalid or missing space group operations!");
            symmetryInterface = null;
        }
        if (this.modDim > 0 && symmetryInterface != null) {
            this.addLatticeVectors();
            this.asc.setTensors();
            this.getModulationReader().setModulation(true, symmetryInterface);
            this.modr.finalizeModulation();
        }
        if (this.isMagCIF) {
            this.asc.setNoAutoBond();
            if (symmetryInterface != null) {
                this.addJmolScript("vectors on;vectors 0.15;");
                int n = this.asc.getXSymmetry().setSpinVectors();
                this.appendLoadNote(String.valueOf(n) + " magnetic moments - use VECTORS ON/OFF or VECTOR MAX x.x or SELECT VXYZ>0");
            }
        }
        if (symmetryInterface != null && this.auditBlockCode != null && this.auditBlockCode.contains("REFRNCE")) {
            if (this.htAudit == null) {
                this.htAudit = new Hashtable();
            }
            this.htAudit.put(this.auditBlockCode, symmetryInterface);
        }
    }

    private void processDataParameter() {
        this.bondTypes.clear();
        this.parser.getTokenPeeked();
        String string = this.thisDataSetName = this.key.length() < 6 ? "" : this.key.substring(5);
        if (this.thisDataSetName.length() > 0) {
            this.nextAtomSet();
        }
        if (this.debugging) {
            Logger.debug(this.key);
        }
    }

    protected void nextAtomSet() {
        this.asc.setCurrentModelInfo("isCIF", Boolean.TRUE);
        if (this.asc.iSet >= 0) {
            if (this.isMMCIF) {
                this.setModelPDB(true);
                if (this.pdbID != null) {
                    this.asc.setCurrentModelInfo("pdbID", this.pdbID);
                }
            }
            this.asc.newAtomSet();
            if (this.isMMCIF) {
                this.setModelPDB(true);
                if (this.pdbID != null) {
                    this.asc.setCurrentModelInfo("pdbID", this.pdbID);
                }
            }
        } else {
            this.asc.setCollectionName(this.thisDataSetName);
        }
    }

    private String processChemicalInfo(String string) throws Exception {
        if (string.equals("name")) {
            this.chemicalName = this.data = this.parser.fullTrim(this.data);
            this.appendLoadNote(this.chemicalName);
            if (!this.data.equals("?")) {
                this.asc.setInfo("modelLoadNote", this.data);
            }
        } else if (string.equals("structuralFormula")) {
            this.thisStructuralFormula = this.data = this.parser.fullTrim(this.data);
        } else if (string.equals("formula")) {
            this.thisFormula = this.data = this.parser.fullTrim(this.data);
            if (this.thisFormula.length() > 1) {
                this.appendLoadNote(this.thisFormula);
            }
        }
        if (this.debugging) {
            Logger.debug(String.valueOf(string) + " = " + this.data);
        }
        return this.data;
    }

    private void processSymmetrySpaceGroupName() throws Exception {
        if (this.key.indexOf("_ssg_name") >= 0) {
            this.modulated = true;
            this.latticeType = this.data.substring(0, 1);
        } else if (this.modulated) {
            return;
        }
        this.data = this.parser.toUnicode(this.data);
        this.lastSpaceGroupName = String.valueOf(this.key.indexOf("h-m") > 0 ? "HM:" : (this.modulated ? "SSG:" : (this.key.indexOf("bns") >= 0 ? "BNS:" : (this.key.indexOf("hall") >= 0 ? "Hall:" : "")))) + this.data;
        this.setSpaceGroupName(this.lastSpaceGroupName);
    }

    private void addLatticeVectors() {
        this.lattvecs = null;
        if (this.magCenterings != null) {
            this.latticeType = "Magnetic";
            this.lattvecs = new Lst();
            int n = 0;
            while (n < this.magCenterings.size()) {
                String string = (String)this.magCenterings.get(n);
                float[] fArray = new float[this.modDim + 4];
                if (string.indexOf("x1") >= 0) {
                    int n2 = 1;
                    while (n2 <= this.modDim + 3) {
                        string = PT.rep(string, "x" + n2, "");
                        ++n2;
                    }
                }
                String[] stringArray = PT.split(PT.replaceAllCharacters(string, "xyz+", ""), ",");
                int n3 = 0;
                int n4 = 0;
                while (n4 < stringArray.length) {
                    string = stringArray[n4].trim();
                    if (string.length() != 0 && (fArray[n4] = PT.parseFloatFraction(string)) != 0.0f) {
                        ++n3;
                    }
                    ++n4;
                }
                if (n3 >= 2) {
                    this.lattvecs.addLast(fArray);
                }
                ++n;
            }
            this.magCenterings = null;
        } else if (this.latticeType != null && "ABCFI".indexOf(this.latticeType) >= 0) {
            this.lattvecs = new Lst();
            try {
                this.ms.addLatticeVector(this.lattvecs, this.latticeType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.lattvecs != null && this.lattvecs.size() > 0 && this.asc.getSymmetry().addLatticeVectors(this.lattvecs)) {
            this.appendLoadNote("Note! " + this.lattvecs.size() + " symmetry operators added for lattice centering " + this.latticeType);
            int n = 0;
            while (n < this.lattvecs.size()) {
                this.appendLoadNote(PT.toJSON(null, this.lattvecs.get(n)));
                ++n;
            }
        }
        this.latticeType = null;
    }

    private void processCellParameter() throws Exception {
        int n = JmolAdapter.cellParamNames.length;
        while (--n >= 0) {
            if (!this.key.equals(JmolAdapter.cellParamNames[n])) continue;
            float f = this.parseFloatStr(this.data);
            if (this.rotateHexCell && n == 5 && f == 120.0f) {
                f = -1.0f;
            }
            this.setUnitCellItem(n, f);
            return;
        }
    }

    private void processUnitCellTransformMatrix() throws Exception {
        float f = this.parseFloatStr(this.data);
        if (Float.isNaN(f)) {
            return;
        }
        int n = 0;
        while (n < TransformFields.length) {
            if (this.key.indexOf(TransformFields[n]) >= 0) {
                this.setUnitCellItem(6 + n, f);
                return;
            }
            ++n;
        }
    }

    private boolean getData() throws Exception {
        this.key = (String)this.parser.getTokenPeeked();
        this.data = this.parser.getNextToken();
        if (this.debugging && this.data != null && this.data.length() > 0 && this.data.charAt(0) != '\u0000') {
            Logger.debug(">> " + this.key + " " + this.data);
        }
        if (this.data == null) {
            Logger.warn("CIF ERROR ? end of file; data missing: " + this.key);
            return false;
        }
        return this.data.length() == 0 || this.data.charAt(0) != '\u0000';
    }

    protected void processLoopBlock() throws Exception {
        this.parser.getTokenPeeked();
        this.key = (String)this.parser.peekToken();
        if (this.key == null) {
            return;
        }
        this.key0 = this.key;
        this.key = this.parser.fixKey(this.key0);
        if (this.modDim > 0) {
            switch (this.getModulationReader().processLoopBlock()) {
                case 0: {
                    break;
                }
                case -1: {
                    this.parser.skipLoop(false);
                }
                case 1: {
                    return;
                }
            }
        }
        boolean bl = false;
        if (this.key.startsWith(FAMILY_ATOM) || (bl = this.key.equals("_chem_comp_atom_comp_id"))) {
            if (!this.processAtomSiteLoopBlock(bl)) {
                return;
            }
            if (this.thisDataSetName.equals("global")) {
                this.thisDataSetName = this.chemicalName;
                this.asc.setCollectionName(this.thisDataSetName);
            }
            if (!this.thisDataSetName.equals(this.lastDataSetName)) {
                this.asc.setAtomSetName(this.thisDataSetName);
                this.lastDataSetName = this.thisDataSetName;
            }
            this.asc.setCurrentModelInfo("chemicalName", this.chemicalName);
            this.asc.setCurrentModelInfo("structuralFormula", this.thisStructuralFormula);
            this.asc.setCurrentModelInfo("formula", this.thisFormula);
            return;
        }
        if (this.key.startsWith(FAMILY_SGOP) || this.key.startsWith("_symmetry_equiv_pos") || this.key.startsWith("_symmetry_ssg_equiv")) {
            if (this.ignoreFileSymmetryOperators) {
                Logger.warn("ignoring file-based symmetry operators");
                this.parser.skipLoop(false);
            } else {
                this.processSymmetryOperationsLoopBlock();
            }
            return;
        }
        if (this.key.startsWith("_citation")) {
            this.processCitationListBlock();
            return;
        }
        if (this.key.startsWith("_atom_type")) {
            this.processAtomTypeLoopBlock();
            return;
        }
        if ((this.isMolecular || !this.doApplySymmetry) && this.key.startsWith("_geom_bond")) {
            this.processGeomBondLoopBlock();
            return;
        }
        if (this.processSubclassLoopBlock()) {
            return;
        }
        if (this.key.equals("_propagation_vector_seq_id")) {
            this.addMore();
            return;
        }
        this.parser.skipLoop(false);
    }

    protected boolean processSubclassLoopBlock() throws Exception {
        return false;
    }

    private void addMore() {
        int n = 0;
        try {
            String string;
            while ((string = (String)this.parser.peekToken()) != null && string.charAt(0) == '_') {
                this.parser.getTokenPeeked();
                ++n;
            }
            int n2 = 0;
            String string2 = "";
            while ((string = (String)this.parser.getNextDataToken()) != null) {
                string2 = String.valueOf(string2) + string + (n2 % n == 0 ? "=" : " ");
                if (++n2 % n != 0) continue;
                this.appendUunitCellInfo(string2.trim());
                string2 = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int fieldProperty(int n) {
        return n >= 0 && (this.field = (String)this.parser.getColumnData(n)).length() > 0 && (this.firstChar = this.field.charAt(0)) != '\u0000' ? this.col2key[n] : -1;
    }

    void parseLoopParameters(String[] stringArray) throws Exception {
        this.parser.parseDataBlockParameters(stringArray, this.isLoop ? null : this.key0, this.data, this.key2col, this.col2key);
    }

    void parseLoopParametersFor(String string, String[] stringArray) throws Exception {
        if (stringArray[0].charAt(0) == '*') {
            int n = stringArray.length;
            while (--n >= 0) {
                if (stringArray[n].charAt(0) != '*') continue;
                stringArray[n] = String.valueOf(string) + stringArray[n].substring(1);
            }
        }
        this.parseLoopParameters(stringArray);
    }

    private void disableField(int n) {
        int n2 = this.key2col[n];
        if (n2 != -1) {
            this.col2key[n2] = -1;
        }
    }

    private void processAtomTypeLoopBlock() throws Exception {
        this.parseLoopParameters(atomTypeFields);
        if (!this.checkAllFieldsPresent(atomTypeFields, -1, false)) {
            this.parser.skipLoop(false);
            return;
        }
        float f = 0.0f;
        while (this.parser.getData()) {
            String string = this.getField((byte)0);
            if (this.isNull(string) || Float.isNaN(f = this.parseFloatStr(this.getField((byte)1)))) continue;
            if (this.htOxStates == null) {
                this.htOxStates = new Hashtable<String, Float>();
            }
            this.htOxStates.put(string, Float.valueOf(f));
        }
    }

    boolean processAtomSiteLoopBlock(boolean bl) throws Exception {
        this.isLigand = bl;
        int n = -1;
        boolean bl2 = true;
        this.parseLoopParametersFor(FAMILY_ATOM, atomFields);
        if (this.key2col[55] != -1) {
            this.setFractionalCoordinates(false);
        } else if (this.key2col[6] != -1 || this.key2col[52] != -1) {
            this.setFractionalCoordinates(false);
            this.disableField(3);
            this.disableField(4);
            this.disableField(5);
            if (this.key2col[16] != -1 && !this.isMMCIF) {
                this.setIsPDB();
                this.isMMCIF = true;
            }
        } else if (this.key2col[3] != -1) {
            this.setFractionalCoordinates(true);
            this.disableField(6);
            this.disableField(7);
            this.disableField(8);
        } else if (this.key2col[20] != -1 || this.key2col[21] != -1 || this.key2col[63] != -1) {
            bl2 = false;
        } else {
            this.parser.skipLoop(false);
            return false;
        }
        int n2 = this.key2col[17];
        int n3 = 0;
        while (this.parser.getData()) {
            if (n2 >= 0) {
                if ((n = this.checkPDBModelField(n2, n)) < 0) break;
                if (this.skipping) continue;
            }
            Atom atom = null;
            if (bl2) {
                atom = new Atom();
            } else if (this.fieldProperty(this.key2col[20]) == -1 && this.fieldProperty(this.key2col[21]) == -1 && this.fieldProperty(this.key2col[63]) == -1 || (atom = this.asc.getAtomFromName(this.field)) == null) continue;
            String string = null;
            String string2 = null;
            String string3 = null;
            int n4 = 0;
            int n5 = this.parser.getColumnCount();
            int n6 = 0;
            while (n6 < n5) {
                int n7 = this.fieldProperty(n6);
                block0 : switch (n7) {
                    case -1: {
                        break;
                    }
                    case 71: {
                        n4 = this.parseIntStr(this.field);
                        break;
                    }
                    case 70: {
                        string3 = this.field;
                        break;
                    }
                    case 0: 
                    case 50: {
                        String string4;
                        if (this.field.length() < 2) {
                            string4 = this.field;
                        } else {
                            char c = Character.toLowerCase(this.field.charAt(1));
                            if (Atom.isValidSym2(this.firstChar, c)) {
                                string4 = "" + this.firstChar + c;
                            } else {
                                string4 = "" + this.firstChar;
                                if (!this.haveHAtoms && this.firstChar == 'H') {
                                    this.haveHAtoms = true;
                                }
                            }
                        }
                        atom.elementSymbol = string4;
                        if (this.htOxStates == null || !this.htOxStates.containsKey(this.field)) break;
                        float f = this.htOxStates.get(this.field).floatValue();
                        atom.formalCharge = Math.round(f);
                        if (!((double)Math.abs((float)atom.formalCharge - f) > 0.1) || !this.debugging) break;
                        Logger.debug("CIF charge on " + this.field + " was " + f + "; rounded to " + atom.formalCharge);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 49: {
                        atom.atomName = this.field;
                        break;
                    }
                    case 55: {
                        float f = this.parseFloatStr(this.field);
                        if (!this.readIdeal || Float.isNaN(f)) break;
                        atom.x = f;
                        break;
                    }
                    case 56: {
                        float f = this.parseFloatStr(this.field);
                        if (!this.readIdeal || Float.isNaN(f)) break;
                        atom.y = f;
                        break;
                    }
                    case 57: {
                        float f = this.parseFloatStr(this.field);
                        if (!this.readIdeal || Float.isNaN(f)) break;
                        atom.z = f;
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 52: {
                        atom.x = this.parseFloatStr(this.field);
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 53: {
                        atom.y = this.parseFloatStr(this.field);
                        break;
                    }
                    case 5: 
                    case 8: 
                    case 54: {
                        atom.z = this.parseFloatStr(this.field);
                        break;
                    }
                    case 51: {
                        atom.formalCharge = this.parseIntStr(this.field);
                        break;
                    }
                    case 9: {
                        float f = this.parseFloatStr(this.field);
                        if (Float.isNaN(f)) break;
                        atom.foccupancy = f;
                        break;
                    }
                    case 10: {
                        atom.bfactor = this.parseFloatStr(this.field) * (this.isMMCIF ? 1.0f : 100.0f);
                        break;
                    }
                    case 11: 
                    case 48: {
                        atom.group3 = this.field;
                        break;
                    }
                    case 59: {
                        string = this.field;
                        if (this.useAuthorChainID) break;
                        string2 = this.field;
                        this.setChainID(atom, string2);
                        break;
                    }
                    case 12: {
                        if (!this.useAuthorChainID) break;
                        string2 = this.field;
                        this.setChainID(atom, string2);
                        break;
                    }
                    case 13: {
                        atom.sequenceNumber = this.parseIntStr(this.field);
                        this.maxSerial = Math.max(this.maxSerial, atom.sequenceNumber);
                        break;
                    }
                    case 14: {
                        atom.insertionCode = this.firstChar;
                        break;
                    }
                    case 15: 
                    case 60: {
                        atom.altLoc = this.firstChar;
                        break;
                    }
                    case 58: {
                        this.disorderAssembly = this.field;
                        break;
                    }
                    case 19: {
                        if (this.firstChar == '-' && this.field.length() > 1) {
                            atom.altLoc = this.field.charAt(1);
                            atom.ignoreSymmetry = true;
                            break;
                        }
                        atom.altLoc = this.firstChar;
                        break;
                    }
                    case 16: {
                        if (!"HETATM".equals(this.field)) break;
                        atom.isHetero = true;
                        break;
                    }
                    case 18: {
                        if (!"dum".equals(this.field)) break;
                        atom.x = Float.NaN;
                        break;
                    }
                    case 61: {
                        if (!this.modulated) break;
                        n3 = this.parseIntStr(this.field);
                        break;
                    }
                    case 47: 
                    case 62: {
                        int n8;
                        if (!this.field.equalsIgnoreCase("Uiso") || (n8 = this.key2col[34]) == -1) break;
                        this.asc.setU(atom, 7, this.parseFloatStr((String)this.parser.getColumnData(n8)));
                        break;
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        this.asc.setU(atom, (this.col2key[n6] - 22) % 6, this.parseFloatStr(this.field));
                        break;
                    }
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        this.asc.setU(atom, 6, 4.0f);
                        this.asc.setU(atom, (this.col2key[n6] - 35) % 6, this.parseFloatStr(this.field));
                        break;
                    }
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: {
                        this.asc.setU(atom, 6, 0.0f);
                        this.asc.setU(atom, (this.col2key[n6] - 41) % 6, this.parseFloatStr(this.field));
                        break;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: {
                        this.isMagCIF = true;
                        V3 v3 = atom.vib;
                        if (v3 == null) {
                            atom.vib = v3 = new Vibration().setType(-2);
                        }
                        float f = this.parseFloatStr(this.field);
                        switch (n7) {
                            case 64: 
                            case 67: {
                                v3.x = f;
                                this.appendLoadNote("magnetic moment: " + this.line);
                                break block0;
                            }
                            case 65: 
                            case 68: {
                                v3.y = f;
                                break block0;
                            }
                            case 66: 
                            case 69: {
                                v3.z = f;
                            }
                        }
                    }
                }
                ++n6;
            }
            if (!bl2) continue;
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("atom " + atom.atomName + " has invalid/unknown coordinates");
                continue;
            }
            if (atom.elementSymbol == null && atom.atomName != null) {
                atom.getElementSymbol();
            }
            if (!this.filterCIFAtom(atom, string)) continue;
            this.setAtomCoord(atom);
            if (this.isMMCIF && !this.processSubclassAtom(atom, string, string2)) continue;
            if (this.asc.iSet < 0) {
                this.nextAtomSet();
            }
            this.asc.addAtomWithMappedName(atom);
            if (string3 != null) {
                this.asc.atomSymbolicMap.put(string3, atom);
                if (n4 > 0) {
                    V3 v3 = atom.vib;
                    if (v3 == null) {
                        v3 = this.asc.addVibrationVector(atom.index, 0.0f, Float.NaN, 1.0947133E9f);
                    }
                    v3.x = n4;
                }
            }
            ++this.ac;
            if (this.modDim <= 0 || n3 == 0) continue;
            atom.vib = V3.new3(n3, 0.0f, Float.NaN);
        }
        this.asc.setCurrentModelInfo("isCIF", Boolean.TRUE);
        if (this.isMMCIF) {
            this.setModelPDB(true);
        }
        if (this.isMMCIF && this.skipping) {
            this.skipping = false;
        }
        return true;
    }

    protected int checkPDBModelField(int n, int n2) throws Exception {
        return 0;
    }

    protected boolean processSubclassAtom(Atom atom, String string, String string2) {
        return true;
    }

    protected boolean filterCIFAtom(Atom atom, String string) {
        if (!this.filterAtom(atom, -1)) {
            return false;
        }
        if (this.filterAssembly && this.filterReject(this.filter, "$", string)) {
            return false;
        }
        if (this.configurationPtr > 0) {
            if (!this.disorderAssembly.equals(this.lastDisorderAssembly)) {
                this.lastDisorderAssembly = this.disorderAssembly;
                this.lastAltLoc = '\u0000';
                this.conformationIndex = this.configurationPtr;
            }
            if (atom.altLoc != '\u0000') {
                if (this.conformationIndex >= 0 && atom.altLoc != this.lastAltLoc) {
                    this.lastAltLoc = atom.altLoc;
                    --this.conformationIndex;
                }
                if (this.conformationIndex != 0) {
                    Logger.info("ignoring " + atom.atomName);
                    return false;
                }
            }
        }
        return true;
    }

    private void processCitationListBlock() throws Exception {
        this.parseLoopParameters(citationFields);
        while (this.parser.getData()) {
            String string = this.getField((byte)0);
            if (this.isNull(string)) continue;
            this.appendLoadNote("TITLE: " + this.parser.toUnicode(string));
        }
    }

    private void processSymmetryOperationsLoopBlock() throws Exception {
        this.parseLoopParametersFor(FAMILY_SGOP, symmetryOperationsFields);
        this.symops = new Lst();
        int n = symmetryOperationsFields.length;
        while (--n >= 0) {
            if (this.key2col[n] != -1) break;
        }
        if (n < 0) {
            Logger.warn("required _space_group_symop key not found");
            this.parser.skipLoop(false);
            return;
        }
        n = 0;
        boolean bl = false;
        while (this.parser.getData()) {
            boolean bl2 = false;
            int n2 = this.parser.getColumnCount();
            int n3 = this.fieldProperty(this.key2col[7]) == -1 && this.fieldProperty(this.key2col[8]) == -1 && this.fieldProperty(this.key2col[6]) == -1 ? 0 : (this.field.equals("-1") ? -1 : 1);
            int n4 = 0;
            while (n4 < n2) {
                int n5 = this.fieldProperty(n4);
                switch (n5) {
                    case 5: {
                        if (this.field.indexOf(126) >= 0) {
                            this.field = PT.rep(this.field, "~", "");
                        }
                    }
                    case 2: 
                    case 3: {
                        this.modulated = true;
                        bl2 = true;
                    }
                    case 0: 
                    case 1: 
                    case 4: {
                        if (!this.allowRotations && n3 == 0 && ++n != 1 || this.modulated && !bl2) break;
                        if (n5 == 1 || n5 == 3) {
                            bl = true;
                            int n6 = this.field.endsWith(",+1") || this.field.endsWith(",1") ? 1 : (n3 = this.field.endsWith(",-1") ? -1 : 0);
                            if (n3 != 0) {
                                this.field = this.field.substring(0, this.field.lastIndexOf(44));
                            }
                        }
                        if (n3 != 0) {
                            this.field = String.valueOf(this.field) + "," + (n3 == 1 ? "m" : "-m");
                        }
                        this.field = this.field.replace(';', ' ');
                        this.symops.addLast(this.field);
                        this.setSymmetryOperator(this.field);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        bl = true;
                        if (this.magCenterings == null) {
                            this.magCenterings = new Lst();
                        }
                        this.magCenterings.addLast(this.field);
                    }
                }
                ++n4;
            }
        }
        if (this.ms != null && !bl) {
            this.addLatticeVectors();
        }
    }

    public int getBondOrder(String string) {
        switch (string.toUpperCase().charAt(0)) {
            default: {
                Logger.warn("unknown CIF bond order: " + string);
            }
            case '\u0000': 
            case 'S': {
                return 1;
            }
            case 'D': {
                return 2;
            }
            case 'T': {
                return 3;
            }
            case 'Q': {
                return 4;
            }
            case 'A': 
        }
        this.haveAromatic = true;
        return 515;
    }

    private void processGeomBondLoopBlock() throws Exception {
        boolean bl = this.stateScriptVersionInt >= 130304 && this.stateScriptVersionInt < 140403 || this.stateScriptVersionInt >= 150000 && this.stateScriptVersionInt < 150403;
        this.parseLoopParameters(geomBondFields);
        if (bl || !this.checkAllFieldsPresent(geomBondFields, 2, true)) {
            this.parser.skipLoop(false);
            return;
        }
        int n = 0;
        String string = null;
        while (this.parser.getData()) {
            string = null;
            String string2 = this.getField((byte)0);
            if ((this.asc.getAtomIndex(string2) < 0 || this.asc.getAtomIndex(string = this.getField((byte)1)) < 0) && (string == null && this.asc.getAtomIndex(string2 = string2.toUpperCase()) < 0 || this.asc.getAtomIndex(string = string.toUpperCase()) < 0)) continue;
            int n2 = this.getBondOrder(this.getField((byte)3));
            String string3 = this.getField((byte)2);
            float f = this.parseFloatStr(string3);
            if (f == 0.0f || Float.isNaN(f)) {
                if (this.iHaveFractionalCoordinates) continue;
                Atom atom = this.asc.getAtomFromName(string2);
                Atom atom2 = this.asc.getAtomFromName(string);
                if (atom == null || atom2 == null) continue;
                this.asc.addNewBondWithOrder(atom.index, atom2.index, n2);
                continue;
            }
            float f2 = 0.0f;
            int n3 = string3.indexOf(40);
            if (n3 >= 0) {
                char[] cArray = string3.toCharArray();
                String string4 = string3.substring(n3 + 1, string3.length() - 1);
                int n4 = string4.length();
                int n5 = n3;
                while (--n5 >= 0) {
                    if (cArray[n5] == '.' && --n5 < 0) break;
                    int n6 = cArray[n5] = --n4 < 0 ? 48 : (int)string4.charAt(n4);
                }
                if (Float.isNaN(f2 = this.parseFloatStr(String.valueOf(cArray)))) {
                    Logger.info("error reading uncertainty for " + this.line);
                    f2 = 0.015f;
                }
            } else {
                f2 = 0.015f;
            }
            ++n;
            this.bondTypes.addLast(new Object[]{string2, string, Float.valueOf(f), Float.valueOf(f2), n2});
        }
        if (n > 0) {
            Logger.info(String.valueOf(n) + " bonds read");
            if (!this.doApplySymmetry) {
                this.isMolecular = true;
                this.forceSymmetry(false);
            }
        }
    }

    private void setBondingAndMolecules() {
        int n;
        this.atoms = this.asc.atoms;
        this.firstAtom = this.asc.getLastAtomSetAtomIndex();
        int n2 = this.asc.getLastAtomSetAtomCount();
        this.ac = this.firstAtom + n2;
        Logger.info("CIF creating molecule for " + n2 + " atoms " + (this.bondTypes.size() > 0 ? " using GEOM_BOND records" : ""));
        this.bsSets = new BS[n2];
        this.symmetry = this.asc.getSymmetry();
        int n3 = this.firstAtom;
        while (n3 < this.ac) {
            n = this.asc.getAtomFromName((String)this.atoms[n3].atomName).index - this.firstAtom;
            if (this.bsSets[n] == null) {
                this.bsSets[n] = new BS();
            }
            this.bsSets[n].set(n3 - this.firstAtom);
            ++n3;
        }
        if (this.isMolecular) {
            this.atomRadius = new float[this.ac];
            n3 = this.firstAtom;
            while (n3 < this.ac) {
                int n4;
                n = JmolAdapter.getElementNumber(this.atoms[n3].getElementSymbol());
                this.atoms[n3].elementNumber = (short)n;
                int n5 = n4 = this.atoms[n3].formalCharge == Integer.MIN_VALUE ? 0 : this.atoms[n3].formalCharge;
                if (n > 0) {
                    this.atomRadius[n3] = JmolAdapter.getBondingRadius(n, n4);
                }
                ++n3;
            }
            this.bsConnected = new BS[this.ac];
            n3 = this.firstAtom;
            while (n3 < this.ac) {
                this.bsConnected[n3] = new BS();
                ++n3;
            }
            this.bsMolecule = new BS();
            this.bsExclude = new BS();
        }
        n3 = 1;
        this.bsBondDuplicates = new BS();
        while (this.createBonds(n3 != 0)) {
            n3 = 0;
        }
        if (this.isMolecular && this.iHaveFractionalCoordinates && !this.bsMolecule.isEmpty()) {
            if (this.asc.bsAtoms == null) {
                this.asc.bsAtoms = new BS();
            }
            this.asc.bsAtoms.clearBits(this.firstAtom, this.ac);
            this.asc.bsAtoms.or(this.bsMolecule);
            this.asc.bsAtoms.andNot(this.bsExclude);
            n = this.firstAtom;
            while (n < this.ac) {
                if (this.asc.bsAtoms.get(n)) {
                    this.symmetry.toCartesian(this.atoms[n], true);
                } else if (this.debugging) {
                    Logger.debug(String.valueOf(this.molecularType) + " removing " + n + " " + this.atoms[n].atomName + " " + this.atoms[n]);
                }
                ++n;
            }
            this.asc.setCurrentModelInfo("unitCellParams", null);
            if (this.nMolecular++ == this.asc.iSet) {
                this.asc.clearGlobalBoolean(0);
                this.asc.clearGlobalBoolean(1);
                this.asc.clearGlobalBoolean(2);
            }
        }
        if (this.bondTypes.size() > 0) {
            this.asc.setCurrentModelInfo("hasBonds", Boolean.TRUE);
        }
        this.bondTypes.clear();
        this.atomRadius = null;
        this.bsSets = null;
        this.bsConnected = null;
        this.bsMolecule = null;
        this.bsExclude = null;
    }

    private void fixAtomForBonding(P3 p3, int n) {
        p3.setT(this.atoms[n]);
        if (this.iHaveFractionalCoordinates) {
            this.symmetry.toCartesian(p3, true);
        }
    }

    private boolean createBonds(boolean bl) {
        int n;
        BS bS;
        int n2;
        int n3;
        int n4;
        Object object;
        String string = "";
        boolean bl2 = false;
        int n5 = this.bondTypes.size();
        while (--n5 >= 0) {
            Object object2;
            if (this.bsBondDuplicates.get(n5)) continue;
            object = (Object[])this.bondTypes.get(n5);
            float f = ((Float)object[2]).floatValue();
            float f2 = ((Float)object[3]).floatValue();
            n4 = (Integer)object[4];
            n3 = this.asc.getAtomIndex((String)object[0]);
            n2 = this.asc.getAtomIndex((String)object[1]);
            if (bl) {
                object2 = ";" + n3 + ";" + n2 + ";" + f;
                if (string.indexOf((String)object2) >= 0) {
                    this.bsBondDuplicates.set(n5);
                    continue;
                }
                string = String.valueOf(string) + (String)object2;
            }
            object2 = this.bsSets[n3 - this.firstAtom];
            bS = this.bsSets[n2 - this.firstAtom];
            if (object2 == null || bS == null) continue;
            if (this.atoms[n3].elementNumber == 1 || this.atoms[n2].elementNumber == 1) {
                bl2 = true;
            }
            n = ((BS)object2).nextSetBit(0);
            while (n >= 0) {
                int n6 = bS.nextSetBit(0);
                while (n6 >= 0) {
                    if (!(this.isMolecular && this.bsConnected[n + this.firstAtom].get(n6) || !this.checkBondDistance(this.atoms[n + this.firstAtom], this.atoms[n6 + this.firstAtom], f, f2))) {
                        this.addNewBond(n + this.firstAtom, n6 + this.firstAtom, n4);
                    }
                    n6 = bS.nextSetBit(n6 + 1);
                }
                n = ((BS)object2).nextSetBit(n + 1);
            }
        }
        if (!this.iHaveFractionalCoordinates) {
            return false;
        }
        if (this.bondTypes.size() > 0 && !bl2) {
            n5 = this.firstAtom;
            while (n5 < this.ac) {
                if (this.atoms[n5].elementNumber == 1) {
                    boolean bl3 = this.atoms[n5].altLoc != '\u0000';
                    int n7 = this.firstAtom;
                    while (n7 < this.ac) {
                        if (!(n7 == n5 || this.atoms[n7].elementNumber == 1 || bl3 && this.atoms[n7].altLoc != '\u0000' && this.atoms[n7].altLoc != this.atoms[n5].altLoc || this.bsConnected[n5].get(n7) || !this.checkBondDistance(this.atoms[n5], this.atoms[n7], 1.1f, 0.0f))) {
                            this.addNewBond(n5, n7, 1);
                        }
                        ++n7;
                    }
                }
                ++n5;
            }
        }
        if (!this.isMolecular) {
            return false;
        }
        if (bl) {
            n5 = this.firstAtom;
            while (n5 < this.ac) {
                if (this.atoms[n5].atomSite + this.firstAtom == n5 && !this.bsMolecule.get(n5)) {
                    this.setBs(this.atoms, n5, this.bsConnected, this.bsMolecule);
                }
                ++n5;
            }
        }
        float f = this.vwr.getFloat(0x22000004);
        object = new BS();
        P3 p3 = new P3();
        P3 p32 = new P3();
        n4 = 2;
        n3 = this.firstAtom;
        while (n3 < this.ac) {
            if (!this.bsMolecule.get(n3) && !this.bsExclude.get(n3)) {
                n2 = this.bsMolecule.nextSetBit(0);
                while (n2 >= 0) {
                    if (this.symmetry.checkDistance(this.atoms[n2], this.atoms[n3], this.atomRadius[n3] + this.atomRadius[n2] + f, 0.0f, n4, n4, n4, this.ptOffset)) {
                        this.setBs(this.atoms, n3, this.bsConnected, (BS)object);
                        int n8 = ((BS)object).nextSetBit(0);
                        while (n8 >= 0) {
                            this.atoms[n8].add(this.ptOffset);
                            this.fixAtomForBonding(p3, n8);
                            bS = this.bsSets[this.asc.getAtomIndex(this.atoms[n8].atomName) - this.firstAtom];
                            if (bS != null) {
                                n = bS.nextSetBit(0);
                                while (n >= 0) {
                                    if (n + this.firstAtom != n8) {
                                        this.fixAtomForBonding(p32, n + this.firstAtom);
                                        if (p32.distance(p3) < 0.1f) {
                                            this.bsExclude.set(n8);
                                            break;
                                        }
                                    }
                                    n = bS.nextSetBit(n + 1);
                                }
                            }
                            this.bsMolecule.set(n8);
                            n8 = ((BS)object).nextSetBit(n8 + 1);
                        }
                        return true;
                    }
                    n2 = this.bsMolecule.nextSetBit(n2 + 1);
                }
            }
            ++n3;
        }
        return false;
    }

    private boolean checkBondDistance(Atom atom, Atom atom2, float f, float f2) {
        if (this.iHaveFractionalCoordinates) {
            return this.symmetry.checkDistance(atom, atom2, f, f2, 0, 0, 0, this.ptOffset);
        }
        float f3 = atom.distance(atom2);
        return f2 > 0.0f ? Math.abs(f3 - f) <= f2 : f3 <= f && f3 > 0.1f;
    }

    private void addNewBond(int n, int n2, int n3) {
        this.asc.addNewBondWithOrder(n, n2, n3);
        if (!this.isMolecular) {
            return;
        }
        this.bsConnected[n].set(n2);
        this.bsConnected[n2].set(n);
    }

    private void setBs(Atom[] atomArray, int n, BS[] bSArray, BS bS) {
        BS bS2 = bSArray[n];
        bS.set(n);
        int n2 = bS2.nextSetBit(0);
        while (n2 >= 0) {
            if (!bS.get(n2)) {
                this.setBs(atomArray, n2, bSArray, bS);
            }
            n2 = bS2.nextSetBit(n2 + 1);
        }
    }

    protected boolean checkSubclassSymmetry() {
        return this.doCheckUnitCell;
    }

    protected boolean checkAllFieldsPresent(String[] stringArray, int n, boolean bl) {
        int n2 = n < 0 ? stringArray.length : n;
        while (--n2 >= 0) {
            if (this.key2col[n2] != -1) continue;
            if (bl) {
                Logger.warn("CIF reader missing property: " + stringArray[n2]);
            }
            return false;
        }
        return true;
    }

    protected String getField(byte by) {
        int n = this.key2col[by];
        return n == -1 ? "\u0000" : (String)this.parser.getColumnData(n);
    }

    protected boolean isNull(String string) {
        return string.equals("\u0000");
    }
}

