/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javajs.util.P3;
import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public class JSONReader
extends AtomSetCollectionReader {
    private P3 scale;

    @Override
    public void initializeReader() throws Exception {
        this.asc.setCollectionName("JSON");
        this.asc.newAtomSet();
        String string = "";
        while (this.rd() != null) {
            string = String.valueOf(string) + this.line;
        }
        if ((string = PT.replaceAllCharacters(string, "\" ", "").replace(',', ':')).contains("_is2D:true")) {
            this.set2D();
        }
        if (string.contains("_scale:")) {
            this.getScaling(this.getSection(string, "_scale", false));
        }
        string = PT.replaceAllCharacters(string, "}", "").replace(',', ':');
        this.readAtoms(this.getSection(string, "a", true));
        this.readBonds(this.getSection(string, "b", true));
        this.continuing = false;
    }

    private void getScaling(String[] stringArray) {
        String[] stringArray2 = PT.split(stringArray[0], ":");
        this.scale = P3.new3(1.0f, 1.0f, 1.0f);
        int n = 0;
        while (n < stringArray2.length) {
            if (stringArray2[n].length() == 1) {
                switch (stringArray2[n].charAt(0)) {
                    case 'x': {
                        this.scale.x = this.parseFloatStr(stringArray2[n + 1]);
                        break;
                    }
                    case 'y': {
                        this.scale.y = this.parseFloatStr(stringArray2[n + 1]);
                        break;
                    }
                    case 'z': {
                        this.scale.z = this.parseFloatStr(stringArray2[n + 1]);
                    }
                }
            }
            n += 2;
        }
        Logger.info("scale set to " + this.scale);
    }

    private String[] getSection(String string, String string2, boolean bl) {
        String[] stringArray = PT.split(string, String.valueOf(string2) + ":" + (bl ? "[" : "") + "{");
        if (stringArray.length < 2) {
            return stringArray;
        }
        String string3 = stringArray[1];
        string3 = String.valueOf(string3.substring(0, string3.indexOf(bl ? "]" : "}"))) + ":";
        return PT.split(string3, "{");
    }

    private void readAtoms(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = PT.split(stringArray[n], ":");
            Atom atom = this.asc.addNewAtom();
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            String string = "C";
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (stringArray2[n2].length() == 1) {
                    switch (stringArray2[n2].charAt(0)) {
                        case 'x': {
                            f = this.parseFloatStr(stringArray2[n2 + 1]);
                            break;
                        }
                        case 'y': {
                            f2 = this.parseFloatStr(stringArray2[n2 + 1]);
                            break;
                        }
                        case 'z': {
                            f3 = this.parseFloatStr(stringArray2[n2 + 1]);
                            break;
                        }
                        case 'l': {
                            string = stringArray2[n2 + 1];
                        }
                    }
                }
                n2 += 2;
            }
            if (this.scale != null) {
                f /= this.scale.x;
                f2 /= this.scale.y;
                f3 /= this.scale.z;
            }
            this.setAtomCoordXYZ(atom, f, f2, f3);
            atom.elementSymbol = string;
            ++n;
        }
    }

    private void readBonds(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = PT.split(stringArray[n], ":");
            int n2 = 0;
            int n3 = 0;
            int n4 = 1;
            int n5 = 0;
            while (n5 < stringArray2.length) {
                if (stringArray2[n5].length() == 1) {
                    block0 : switch (stringArray2[n5].charAt(0)) {
                        case 'b': {
                            n2 = this.parseIntStr(stringArray2[n5 + 1]);
                            break;
                        }
                        case 'e': {
                            n3 = this.parseIntStr(stringArray2[n5 + 1]);
                            break;
                        }
                        case 'o': {
                            int n6 = (int)(this.parseFloatStr(stringArray2[n5 + 1]) * 2.0f);
                            switch (n6) {
                                case 0: {
                                    break block0;
                                }
                                case 2: 
                                case 4: 
                                case 6: 
                                case 8: {
                                    n4 = n6 / 2;
                                    break block0;
                                }
                                case 1: {
                                    n4 = 33;
                                    break block0;
                                }
                                case 3: {
                                    n4 = 66;
                                    break block0;
                                }
                                case 5: {
                                    n4 = 97;
                                    break block0;
                                }
                            }
                            n4 = 1;
                        }
                    }
                }
                n5 += 2;
            }
            this.asc.addBond(new Bond(n2, n3, n4));
            ++n;
        }
    }
}

