/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import javajs.util.BS;
import javajs.util.PT;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;

public class XmlXsdReader
extends XmlReader {
    private BS bsBackbone = new BS();
    private int iChain = -1;
    private int iGroup = 0;
    private int iAtom = 0;

    @Override
    protected void processXml(XmlReader xmlReader, Object object) throws Exception {
        xmlReader.htParams.put("backboneAtoms", this.bsBackbone);
        this.processXml2(xmlReader, object);
        this.asc.atomSymbolicMap.clear();
    }

    @Override
    public void processStartElement(String string, String string2) {
        if ("molecule".equals(string)) {
            this.asc.newAtomSet();
            this.asc.setAtomSetName((String)this.atts.get("name"));
            return;
        }
        if ("linearchain".equals(string)) {
            this.iGroup = 0;
            ++this.iChain;
        }
        if ("repeatunit".equals(string)) {
            ++this.iGroup;
        }
        if ("atom3d".equals(string)) {
            boolean bl;
            this.atom = new Atom();
            this.atom.elementSymbol = (String)this.atts.get("components");
            this.atom.atomName = (String)this.atts.get("id");
            this.atom.atomSerial = ++this.iAtom;
            if (this.iChain >= 0) {
                this.parent.setChainID(this.atom, "" + (char)((this.iChain - 1) % 26 + 65));
            }
            this.atom.group3 = "UNK";
            if (this.iGroup == 0) {
                this.iGroup = 1;
            }
            this.atom.sequenceNumber = this.iGroup;
            String string3 = (String)this.atts.get("xyz");
            if (string3 != null) {
                String[] stringArray = PT.getTokens(string3.replace(',', ' '));
                this.atom.set(this.parseFloatStr(stringArray[0]), this.parseFloatStr(stringArray[1]), this.parseFloatStr(stringArray[2]));
            }
            if (bl = "1".equals(this.atts.get("isbackboneatom"))) {
                this.bsBackbone.set(this.iAtom);
            }
            return;
        }
        if ("bond".equals(string)) {
            String[] stringArray = PT.split((String)this.atts.get("connects"), ",");
            int n = 1;
            if (this.atts.containsKey("type")) {
                String string4 = (String)this.atts.get("type");
                if (string4.equals("Double")) {
                    n = 2;
                } else if (string4.equals("Triple")) {
                    n = 3;
                }
            }
            this.asc.addNewBondFromNames(stringArray[0], stringArray[1], n);
            return;
        }
    }

    @Override
    void processEndElement(String string) {
        if ("atom3d".equalsIgnoreCase(string)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.parent.setAtomCoord(this.atom);
                this.asc.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        this.setKeepChars(false);
    }
}

