/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JFrame;
import junit.framework.TestCase;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolViewer;
import org.jmol.util.JUnitLogger;
import org.jmol.util.Profiling;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.Jmol;

class TestScriptsImpl
extends TestCase {
    private File file;
    private boolean checkOnly;
    private boolean performance;
    private final int nbExecutions;

    public TestScriptsImpl(File file, boolean bl, boolean bl2) {
        super("testFile");
        this.file = file;
        this.checkOnly = bl;
        this.performance = bl2;
        int n = 1;
        try {
            n = Integer.parseInt(System.getProperty("test.nbExecutions", "1"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.nbExecutions = n;
    }

    public void runTest() throws Throwable {
        this.testScript();
    }

    public void testScript() {
        JUnitLogger.setInformation(this.file.getPath());
        if (this.performance) {
            this.runPerformanceTest();
            return;
        }
        this.runSimpleTest();
    }

    public void runPerformanceTest() {
        JFrame jFrame = new JFrame();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this.checkOnly) {
            hashtable.put("check", Boolean.TRUE);
        }
        Jmol jmol = Jmol.getJmol(jFrame, 500, 500, hashtable);
        Viewer viewer = jmol.vwr;
        long l = Profiling.getTime();
        int n = 0;
        while (n < this.nbExecutions) {
            block26: {
                ((JmolViewer)viewer).scriptWaitStatus("set defaultDirectory \"" + this.file.getParent().replace('\\', '/') + "\"", "");
                int n2 = 0;
                BufferedReader bufferedReader = null;
                try {
                    long l2;
                    bufferedReader = new BufferedReader(new FileReader(this.file));
                    Object object = null;
                    long l3 = Profiling.getTime();
                    while ((object = bufferedReader.readLine()) != null) {
                        Object object2;
                        ++n2;
                        l2 = Profiling.getTime();
                        if (((String)object).indexOf("TESTBLOCKSTART") >= 0) {
                            object2 = "";
                            while ((object = bufferedReader.readLine()) != null && ((String)object).indexOf("TESTBLOCKEND") < 0) {
                                object2 = String.valueOf(object2) + (String)object + "\n";
                                ++n2;
                            }
                            object = object2;
                        }
                        object2 = (List)((JmolViewer)viewer).scriptWaitStatus((String)object, "scriptTerminated");
                        long l4 = Profiling.getTime();
                        if (object2 != null && object2.size() > 0) {
                            List list;
                            String string = object2.get(0).toString();
                            if (object2.get(0) instanceof List && (list = (List)object2.get(0)).size() > 0 && list.get(0) instanceof List) {
                                list = (List)list.get(0);
                                string = list.get(list.size() - 1).toString();
                            }
                            if (!string.equalsIgnoreCase("Jmol script terminated successfully")) {
                                TestScriptsImpl.fail((String)("Error in script [" + this.file.getPath() + "] " + "at line " + n2 + " (" + (String)object + "):\n" + string));
                            }
                        }
                        if (l4 - l2 <= 0L) continue;
                        this.outputPerformanceMessage(l4 - l2, "execute [" + (String)object + "]");
                    }
                    l2 = Profiling.getTime();
                    this.outputPerformanceMessage(l2 - l3, "execute script [" + this.file.getPath() + "]");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    TestScriptsImpl.fail((String)("File " + this.file.getPath() + " not found"));
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block26;
                }
                catch (IOException iOException) {
                    try {
                        TestScriptsImpl.fail((String)("Error reading line " + n2 + " of " + this.file.getPath()));
                        break block26;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException2) {}
                        }
                    }
                }
                if (bufferedReader == null) break block26;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n;
        }
        long l5 = Profiling.getTime();
        if (this.nbExecutions > 1) {
            this.outputPerformanceMessage(l5 - l, String.valueOf(this.nbExecutions) + " of script");
        }
    }

    public void runSimpleTest() {
        JUnitLogger.setInformation(this.file.getPath());
        JmolViewer jmolViewer = JmolViewer.allocateViewer(new JFrame(), new SmarterJmolAdapter(), null, null, null, this.checkOnly ? "-n -c -l " : "-n -l ", null);
        String string = jmolViewer.evalFile(String.valueOf(this.file.getPath()) + " -noqueue");
        TestScriptsImpl.assertNull((String)("Error in script [" + this.file.getPath() + ":\n" + string), (Object)string);
    }

    private void outputPerformanceMessage(long l, String string) {
        String string2 = "            " + l;
        string2 = string2.substring(Math.min(12, string2.length() - 12));
        System.err.println(String.valueOf(string2) + Profiling.getUnit() + ": " + string);
    }

    public String getName() {
        if (this.file != null) {
            return String.valueOf(super.getName()) + " [" + this.file.getPath() + "]";
        }
        return super.getName();
    }

    protected void setUp() throws Exception {
        super.setUp();
        JUnitLogger.activateLogger();
        JUnitLogger.setInformation(null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        JUnitLogger.setInformation(null);
        this.file = null;
    }
}

