/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BC;
import javajs.util.MessagePackReader;
import javajs.util.P3;
import javajs.util.SB;
import org.jmol.jvxl.readers.MapFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class BCifDensityReader
extends MapFileReader {
    private int pt;
    float checkSum;
    protected float[] values;
    public Map<String, Object> cifData;
    public Map<String, Object> thisData;
    private boolean isDiff;

    BCifDensityReader() {
    }

    protected void getCifData(String string, Object object) {
        this.binarydoc = this.newBinaryDocument();
        if (AU.isAB(object)) {
            this.binarydoc.setStream(new BufferedInputStream(new ByteArrayInputStream((byte[])object)), true);
        } else {
            this.setStream(string, true);
        }
        this.nSurfaces = 1;
    }

    protected P3 readCifP3(String string, P3 p3) {
        float f;
        if (p3 == null) {
            p3 = new P3();
        }
        if (Float.isNaN(f = this.getCifFloat(String.valueOf(string) + "[0]"))) {
            p3.x = Float.NaN;
        } else {
            p3.x = f;
            p3.y = this.getCifFloat(String.valueOf(string) + "[1]");
            p3.z = this.getCifFloat(String.valueOf(string) + "[2]");
        }
        return p3;
    }

    protected Map<String, Object> getCifMap(String string) {
        if (this.cifData == null) {
            try {
                this.cifData = new MessagePackReader(this.binarydoc, true).readMap();
                System.out.println("BCifDensityReader BCIF encoder " + this.cifData.get("encoder") + " BCIF version " + this.cifData.get("version"));
            }
            catch (Exception exception) {
                System.out.println("BCifDensityReader error " + exception);
            }
        }
        Object[] objectArray = (Object[])this.cifData.get("dataBlocks");
        int n = objectArray.length;
        while (--n >= 0) {
            Map map = (Map)objectArray[n];
            if (!string.equalsIgnoreCase(map.get("header").toString())) continue;
            Object[] objectArray2 = (Object[])map.get("categories");
            int n2 = objectArray2.length;
            while (--n2 >= 0) {
                Map map2 = (Map)objectArray2[n2];
                String string2 = (String)map2.get("name");
                Object[] objectArray3 = (Object[])map2.get("columns");
                int n3 = objectArray3.length;
                while (--n3 >= 0) {
                    Map map3 = (Map)objectArray3[n3];
                    map.put(String.valueOf(string2) + "_" + map3.get("name"), map3.get("data"));
                }
            }
            map.remove("categories");
            this.thisData = map;
            return this.thisData;
        }
        return null;
    }

    protected String getCifString(String string) {
        Map map = (Map)this.thisData.get(string);
        byte[] byArray = (byte[])map.get("data");
        Map map2 = (Map)((Object[])map.get("encoding"))[0];
        Object v = map2.get("offsetEncoding");
        return null;
    }

    protected float getCifFloat(String string) {
        Map map = (Map)this.thisData.get(string);
        byte[] byArray = (byte[])map.get("data");
        int n = (Integer)((Map)((Object[])map.get("encoding"))[0]).get("type");
        float f = Float.NaN;
        try {
            switch (n) {
                case 3: {
                    f = BC.bytesToInt(byArray, 0, false);
                    break;
                }
                case 33: {
                    f = BC.bytesToDoubleToFloat(byArray, 0, false);
                    break;
                }
                default: {
                    System.out.println("BCDensityReader: Number encoding not recognized: " + n);
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return f;
    }

    protected float[] readCifFloats(String string, float[] fArray) {
        Map map = (Map)this.thisData.get(string);
        byte[] byArray = (byte[])map.get("data");
        Map map2 = (Map)((Object[])map.get("encoding"))[0];
        float f = ((Float)map2.get("min")).floatValue();
        float f2 = ((Float)map2.get("max")).floatValue();
        int n = (Integer)map2.get("numSteps");
        String string2 = (String)map2.get("kind");
        if ("IntervalQuantization".equals(string2)) {
            float f3 = (f2 - f) / (float)(n - 1);
            int n2 = byArray.length;
            while (--n2 >= 0) {
                fArray[n2] = f + f3 * (float)((byArray[n2] + 256) % 256);
            }
        } else {
            System.out.println("BCifDensityReader: value encoding type? " + string2);
        }
        return fArray;
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.allowSigma = true;
        this.init2MFR(surfaceGenerator, bufferedReader);
        Object[] objectArray = (Object[])surfaceGenerator.getReaderData();
        String string = (String)objectArray[0];
        Object object = objectArray[1];
        this.isDiff = string != null && string.indexOf("&diff=1") >= 0 || object instanceof String && ((String)object).indexOf("#diff=1") >= 0;
        this.getCifData(string, object);
        this.nSurfaces = 1;
    }

    @Override
    protected void readParameters() throws Exception {
        this.getCifMap(this.isDiff ? "FO-FC" : "2FO-FC");
        String string = this.getCifString("_volume_data_3d_info_name");
        this.readCifP3("_volume_data_3d_info_axis_order", this.p3);
        P3 p3 = this.readCifP3("_volume_data_3d_info_axis_order", null);
        P3 p32 = this.readCifP3("_volume_data_3d_info_origin", null);
        P3 p33 = this.readCifP3("_volume_data_3d_info_dimensions", null);
        P3 p34 = this.readCifP3("_volume_data_3d_info_sample_count", this.p3);
        this.mapc = (int)p3.x + 1;
        this.mapr = (int)p3.y + 1;
        this.maps = (int)p3.z + 1;
        int[] nArray = new int[3];
        nArray[this.mapc - 1] = 0;
        nArray[this.mapr - 1] = 1;
        nArray[this.maps - 1] = 2;
        this.n0 = (int)p34.x;
        this.n1 = (int)p34.y;
        this.n2 = (int)p34.z;
        this.na = (int)this.getXYZ(p34, nArray[0]);
        this.nb = (int)this.getXYZ(p34, nArray[1]);
        this.nc = (int)this.getXYZ(p34, nArray[2]);
        this.readCifP3("_volume_data_3d_info_spacegroup_cell_size", this.p3);
        this.a = this.p3.x;
        this.b = this.p3.y;
        this.c = this.p3.z;
        float f = this.getXYZ(p33, nArray[0]);
        float f2 = this.getXYZ(p33, nArray[1]);
        float f3 = this.getXYZ(p33, nArray[2]);
        this.xIndex = 0;
        this.xyzStart[0] = this.getXYZ(p32, nArray[0]) * (float)this.na / f;
        this.yIndex = 1;
        this.xyzStart[1] = this.getXYZ(p32, nArray[1]) * (float)this.nb / f2;
        this.zIndex = 2;
        this.xyzStart[2] = this.getXYZ(p32, nArray[2]) * (float)this.nc / f3;
        this.a *= f;
        this.b *= f2;
        this.c *= f3;
        this.readCifP3("_volume_data_3d_info_spacegroup_cell_angles", this.p3);
        this.alpha = this.p3.x;
        this.beta = this.p3.y;
        this.gamma = this.p3.z;
        this.values = this.readCifFloats("_volume_data_3d_values", new float[this.na * this.nb * this.nc]);
        this.getVectorsAndOrigin();
        if (this.params.thePlane == null && (this.params.cutoffAutomatic || !Float.isNaN(this.params.sigma))) {
            float f4 = this.params.sigma < 0.0f || Float.isNaN(this.params.sigma) ? 1.0f : this.params.sigma;
            this.dmean = this.getCifFloat("_volume_data_3d_info_mean_sampled");
            float f5 = this.getCifFloat("_volume_data_3d_info_sigma_sampled");
            this.params.cutoff = f5 * f4 + this.dmean;
            Logger.info("Cutoff set to (mean + rmsDeviation*" + f4 + " = " + this.params.cutoff + ")\n");
        }
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("CifDensity reader\n");
        this.jvxlFileHeaderBuffer.append("see http://www.ebi.ac.uk/pdbe/densities/x-ray/1cbs/dbox/\n");
    }

    private float getXYZ(P3 p3, float f) {
        switch ((int)f) {
            case 0: {
                return p3.x;
            }
            case 1: {
                return p3.y;
            }
        }
        return p3.z;
    }

    @Override
    protected float nextVoxel() throws Exception {
        float f = this.values[this.pt++];
        this.checkSum += f;
        return f;
    }

    @Override
    protected void skipData(int n) throws Exception {
        this.pt += n;
    }

    @Override
    protected void closeReader() {
        if (this.readerClosed) {
            return;
        }
        System.out.println("CifDensityReader checkSum=" + this.checkSum);
        super.closeReader();
    }
}

