/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.Hashtable;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.jvxl.readers.XmlReader;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class JvxlXmlReader
extends VolumeFileReader {
    protected String JVXL_VERSION = "2.3";
    protected int surfaceDataCount;
    protected int edgeDataCount;
    protected int colorDataCount;
    private int excludedTriangleCount;
    private int excludedVertexCount;
    private int invalidatedVertexCount;
    protected boolean haveContourData;
    private XmlReader xr;
    protected boolean isXmlFile = true;
    protected boolean thisInside;
    String tempDataXml;
    protected BS bsVoxelBitSet;
    private boolean includeValueNaN = true;
    private int valueCount;
    private float valueMin = Float.NaN;
    private float valueRange = Float.NaN;
    private int fractionPtr;
    private int colorPtr;
    private String strFractionTemp = "";
    boolean haveReadColorData;
    private String jvxlColorEncodingRead;

    JvxlXmlReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2JXR(surfaceGenerator, bufferedReader);
    }

    void init2JXR(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2VFR(surfaceGenerator, bufferedReader);
        this.isJvxl = true;
        this.jvxlData.wasJvxl = true;
        this.canDownsample = false;
        this.isXLowToHigh = false;
        this.xr = new XmlReader(bufferedReader);
    }

    @Override
    protected boolean readVolumeData(boolean bl) {
        if (!this.readVolumeDataVFR(bl)) {
            return false;
        }
        this.strFractionTemp = this.jvxlEdgeDataRead;
        this.fractionPtr = 0;
        return true;
    }

    @Override
    protected boolean gotoAndReadVoxelData(boolean bl) {
        block13: {
            this.initializeVolumetricData();
            if (this.nPointsX < 0 || this.nPointsY < 0 || this.nPointsZ < 0) {
                return true;
            }
            this.gotoData(this.params.fileIndex - 1, this.nPointsX * this.nPointsY * this.nPointsZ);
            if (!this.vertexDataOnly) break block13;
            return true;
        }
        try {
            this.volumeData.setMappingPlane(this.params.thePlane);
            this.readSurfaceData(bl);
            this.volumeData.setMappingPlane(null);
            if (this.edgeDataCount > 0) {
                this.jvxlEdgeDataRead = this.jvxlReadFractionData("edge", this.edgeDataCount);
            }
            this.jvxlData.jvxlExcluded = new BS[4];
            this.params.bsExcluded = this.jvxlData.jvxlExcluded;
            boolean bl2 = this.hasColorData = this.colorDataCount > 0;
            if (this.hasColorData) {
                this.jvxlColorDataRead = this.jvxlReadFractionData("color", this.colorDataCount);
            }
            if (this.excludedVertexCount > 0) {
                this.jvxlData.jvxlExcluded[0] = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlExcludedVertexData", null, false, false));
                if (this.xr.isNext("jvxlExcludedPlaneData")) {
                    this.jvxlData.jvxlExcluded[2] = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlExcludedPlaneData", null, false, false));
                }
            }
            if (this.excludedTriangleCount > 0) {
                this.jvxlData.jvxlExcluded[3] = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlExcludedTriangleData", null, false, false));
            }
            if (this.invalidatedVertexCount > 0) {
                this.jvxlData.jvxlExcluded[1] = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlInvalidatedVertexData", null, false, false));
            }
            if (this.haveContourData) {
                this.jvxlDecodeContourData(this.jvxlData, this.xr.getXmlData("jvxlContourData", null, false, false));
            }
            if (this.jvxlDataIsColorMapped && this.jvxlData.nVertexColors > 0) {
                this.jvxlData.vertexColorMap = new Hashtable<String, BS>();
                String string = this.xr.getXmlData("jvxlVertexColorData", null, true, false);
                String string2 = XmlReader.getXmlAttrib(string, "baseColor");
                this.jvxlData.baseColor = string2.length() > 0 ? string2 : null;
                int n = 0;
                while (n < this.jvxlData.nVertexColors) {
                    String string3 = this.xr.getXmlData("jvxlColorMap", string, true, false);
                    String string4 = XmlReader.getXmlAttrib(string3, "color");
                    BS bS = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlColorMap", string3, false, false));
                    this.jvxlData.vertexColorMap.put(string4, bS);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            Logger.error(exception.toString());
            return false;
        }
        return true;
    }

    @Override
    protected void readParameters() throws Exception {
        String string = this.xr.getXmlData("jvxlFileTitle", null, false, false);
        this.jvxlFileHeaderBuffer = SB.newS(string == null ? "" : string);
        this.xr.toTag("jvxlVolumeData");
        String string2 = this.tempDataXml = this.xr.getXmlData("jvxlVolumeData", null, true, false);
        this.volumetricOrigin.setT(this.xr.getXmlPoint(string2, "origin"));
        this.isAngstroms = true;
        this.readVector(0);
        this.readVector(1);
        this.readVector(2);
        this.line = this.xr.toTag("jvxlSurfaceSet");
        this.nSurfaces = this.parseIntStr(XmlReader.getXmlAttrib(this.line, "count"));
        Logger.info("jvxl file surfaces: " + this.nSurfaces);
        Logger.info("using default edge fraction base and range");
        Logger.info("using default color fraction base and range");
        this.cJvxlEdgeNaN = (char)(this.edgeFractionBase + this.edgeFractionRange);
    }

    protected void readVector(int n) throws Exception {
        String string = this.xr.getXmlData("jvxlVolumeVector", this.tempDataXml, true, true);
        this.tempDataXml = this.tempDataXml.substring(this.tempDataXml.indexOf(string) + string.length());
        int n2 = this.parseIntStr(XmlReader.getXmlAttrib(string, "count"));
        if (n2 == Integer.MIN_VALUE) {
            this.vertexDataOnly = true;
        }
        this.voxelCounts[n] = n2 < 0 ? 0 : n2;
        this.volumetricVectors[n].setT(this.xr.getXmlPoint(string, "vector"));
        if (this.isAnisotropic) {
            this.setVectorAnisotropy(this.volumetricVectors[n]);
        }
    }

    @Override
    protected void gotoData(int n, int n2) throws Exception {
        if (n > 0) {
            Logger.info("skipping " + n + " data sets, " + n2 + " points each");
        }
        this.jvxlData.vertexDataOnly = n2 == 0;
        this.vertexDataOnly = this.jvxlData.vertexDataOnly;
        int n3 = 0;
        while (n3 < n) {
            this.jvxlSkipData(n2, true);
            ++n3;
        }
        this.xr.toTag("jvxlSurface");
        this.jvxlReadSurfaceInfo();
    }

    protected void jvxlSkipData(int n, boolean bl) throws Exception {
        this.rd();
        this.xr.skipTag("jvxlSurface");
    }

    protected void jvxlReadSurfaceInfo() throws Exception {
        int n;
        String string;
        int n2;
        String string2 = this.xr.getXmlData("jvxlSurfaceInfo", null, true, true);
        this.isXLowToHigh = XmlReader.getXmlAttrib(string2, "isXLowToHigh").equals("true");
        this.jvxlCutoff = this.parseFloatStr(XmlReader.getXmlAttrib(string2, "cutoff"));
        if (!Float.isNaN(this.jvxlCutoff)) {
            Logger.info("JVXL read: cutoff " + this.jvxlCutoff);
        }
        this.haveContourData = (n2 = this.parseIntStr(XmlReader.getXmlAttrib(string2, "nContourData"))) > 0;
        this.params.isContoured = this.jvxlData.isModelConnected = XmlReader.getXmlAttrib(string2, "contoured").equals("true");
        this.params.isModelConnected = XmlReader.getXmlAttrib(string2, "isModelConnected").equals("true");
        if (this.params.isContoured) {
            int n3 = this.parseIntStr(XmlReader.getXmlAttrib(string2, "nContours"));
            if (n3 <= 0) {
                n3 = 0;
            } else {
                if (this.params.thisContour < 0) {
                    this.params.thisContour = this.parseIntStr(XmlReader.getXmlAttrib(string2, "thisContour"));
                }
                if ((string = XmlReader.getXmlAttrib(string2, "contourValues")).length() > 0) {
                    string = string.replace('[', ' ').replace(']', ' ');
                    this.params.contoursDiscrete = this.parseFloatArrayStr(string);
                    this.jvxlData.contourValues = this.params.contoursDiscrete;
                    Logger.info("JVXL read: contourValues " + Escape.eAF(this.jvxlData.contourValues));
                }
                if ((string = XmlReader.getXmlAttrib(string2, "contourColors")).length() > 0) {
                    this.params.contourColixes = C.getColixArray(string);
                    this.jvxlData.contourColixes = this.params.contourColixes;
                    this.jvxlData.contourColors = C.getHexCodes(this.jvxlData.contourColixes);
                    Logger.info("JVXL read: contourColixes " + C.getHexCodes(this.jvxlData.contourColixes));
                }
                this.params.contourFromZero = XmlReader.getXmlAttrib(string2, "contourFromZero").equals("true");
            }
            this.params.nContours = this.haveContourData ? n2 : n3;
        }
        this.jvxlData.nVertexColors = this.parseIntStr(XmlReader.getXmlAttrib(string2, "nVertexColors"));
        this.params.isBicolorMap = XmlReader.getXmlAttrib(string2, "bicolorMap").equals("true");
        if (this.params.isBicolorMap) {
            string = XmlReader.getXmlAttrib(string2, "colorPositive");
            if (string.length() > 0 && this.params.colorRgb == Integer.MIN_VALUE && this.params.colorPos == -16776961) {
                this.params.colorPos = CU.getArgbFromString(string);
            }
            if ((string = XmlReader.getXmlAttrib(string2, "colorNegative")).length() > 0 && this.params.colorRgb == Integer.MIN_VALUE && this.params.colorNeg == -65536) {
                this.params.colorNeg = CU.getArgbFromString(string);
            }
        }
        if (this.params.isBicolorMap || this.params.colorBySign) {
            this.jvxlCutoff = 0.0f;
        }
        this.jvxlDataIsColorMapped = !(this.params.colorRgb != Integer.MIN_VALUE && this.params.colorRgb != Integer.MAX_VALUE || !this.params.isBicolorMap && !XmlReader.getXmlAttrib(string2, "colorMapped").equals("true"));
        this.jvxlData.isJvxlPrecisionColor = XmlReader.getXmlAttrib(string2, "precisionColor").equals("true");
        this.params.colorDensity = this.params.colorRgb == Integer.MIN_VALUE && XmlReader.getXmlAttrib(string2, "colorDensity").equals("true");
        this.jvxlData.jvxlDataIsColorDensity = this.params.colorDensity;
        if (this.jvxlData.jvxlDataIsColorDensity && Float.isNaN(this.params.pointSize) && (string = XmlReader.getXmlAttrib(string2, "pointSize")).length() > 0) {
            this.jvxlData.pointSize = this.params.pointSize = this.parseFloatStr(string);
        }
        this.params.allowVolumeRender = (string = XmlReader.getXmlAttrib(string2, "allowVolumeRender")).length() == 0 || string.equalsIgnoreCase("true");
        this.jvxlData.allowVolumeRender = this.params.allowVolumeRender;
        string = XmlReader.getXmlAttrib(string2, "plane");
        if (string.indexOf("{") >= 0) {
            this.params.thePlane = null;
            this.params.mapLattice = null;
            try {
                this.params.thePlane = (P4)Escape.uP(string);
                string = XmlReader.getXmlAttrib(string2, "maplattice");
                Logger.info("JVXL read: plane " + this.params.thePlane);
                if (string.indexOf("{") >= 0) {
                    this.params.mapLattice = (P3)Escape.uP(string);
                    Logger.info("JVXL read: mapLattice " + this.params.mapLattice);
                }
                if (this.params.scale3d == 0.0f) {
                    this.params.scale3d = this.parseFloatStr(XmlReader.getXmlAttrib(string2, "scale3d"));
                }
                if (Float.isNaN(this.params.scale3d)) {
                    this.params.scale3d = 0.0f;
                }
            }
            catch (Exception exception) {
                if (this.params.thePlane == null) {
                    Logger.error("JVXL Error reading plane definition -- setting to 0 0 1 0  (z=0)");
                    this.params.thePlane = P4.new4(0.0f, 0.0f, 1.0f, 0.0f);
                }
                Logger.error("JVXL Error reading mapLattice definition -- ignored");
            }
            this.surfaceDataCount = 0;
            this.edgeDataCount = 0;
        } else {
            this.params.thePlane = null;
            this.surfaceDataCount = this.parseIntStr(XmlReader.getXmlAttrib(string2, "nSurfaceInts"));
            this.edgeDataCount = this.parseIntStr(XmlReader.getXmlAttrib(string2, "nBytesUncompressedEdgeData"));
            string = XmlReader.getXmlAttrib(string2, "fixedLattice");
            if (string.indexOf("{") >= 0) {
                this.jvxlData.fixedLattice = (P3)Escape.uP(string);
            }
        }
        this.excludedVertexCount = this.parseIntStr(XmlReader.getXmlAttrib(string2, "nExcludedVertexes"));
        this.excludedTriangleCount = this.parseIntStr(XmlReader.getXmlAttrib(string2, "nExcludedTriangles"));
        this.invalidatedVertexCount = this.parseIntStr(XmlReader.getXmlAttrib(string2, "nInvalidatedVertexes"));
        string = XmlReader.getXmlAttrib(string2, "slabInfo");
        if (string.length() > 0) {
            this.jvxlData.slabInfo = string;
        }
        this.colorDataCount = Math.max(0, this.parseIntStr(XmlReader.getXmlAttrib(string2, "nBytesUncompressedColorData")));
        this.jvxlDataIs2dContour = this.params.thePlane != null && this.jvxlDataIsColorMapped;
        this.jvxlData.color = XmlReader.getXmlAttrib(string2, "color");
        if (this.jvxlData.color.length() == 0 || this.jvxlData.color.indexOf("null") >= 0) {
            this.jvxlData.color = "orange";
        }
        this.jvxlData.translucency = this.parseFloatStr(XmlReader.getXmlAttrib(string2, "translucency"));
        if (Float.isNaN(this.jvxlData.translucency)) {
            this.jvxlData.translucency = 0.0f;
        }
        if ((string = XmlReader.getXmlAttrib(string2, "meshColor")).length() > 0) {
            this.jvxlData.meshColor = string;
        }
        if ((string = XmlReader.getXmlAttrib(string2, "rendering")).length() > 0) {
            this.jvxlData.rendering = string;
        }
        this.jvxlData.colorScheme = XmlReader.getXmlAttrib(string2, "colorScheme");
        if (this.jvxlData.colorScheme.length() == 0) {
            String string3 = this.jvxlData.colorScheme = this.jvxlDataIsColorMapped ? "roygb" : null;
        }
        if (this.jvxlData.thisSet < 0 && (n = this.parseIntStr(XmlReader.getXmlAttrib(string2, "set"))) > 0) {
            this.jvxlData.thisSet = n - 1;
        }
        this.jvxlData.slabValue = this.parseIntStr(XmlReader.getXmlAttrib(string2, "slabValue"));
        this.jvxlData.isSlabbable = XmlReader.getXmlAttrib(string2, "slabbable").equalsIgnoreCase("true");
        this.jvxlData.diameter = this.parseIntStr(XmlReader.getXmlAttrib(string2, "diameter"));
        if (this.jvxlData.diameter == Integer.MIN_VALUE) {
            this.jvxlData.diameter = 0;
        }
        if (this.jvxlDataIs2dContour) {
            this.params.isContoured = true;
        }
        if (this.params.colorBySign) {
            this.params.isBicolorMap = true;
        }
        boolean bl = XmlReader.getXmlAttrib(string2, "insideOut").equals("true");
        float f = Float.NaN;
        float f2 = Float.NaN;
        float f3 = Float.NaN;
        float f4 = Float.NaN;
        if (this.jvxlDataIsColorMapped) {
            f = this.parseFloatStr(XmlReader.getXmlAttrib(string2, "dataMinimum"));
            f2 = this.parseFloatStr(XmlReader.getXmlAttrib(string2, "dataMaximum"));
            f3 = this.parseFloatStr(XmlReader.getXmlAttrib(string2, "valueMappedToRed"));
            f4 = this.parseFloatStr(XmlReader.getXmlAttrib(string2, "valueMappedToBlue"));
            if (Float.isNaN(f)) {
                f3 = -1.0f;
                f = -1.0f;
                f4 = 1.0f;
                f2 = 1.0f;
            }
        }
        this.jvxlSetColorRanges(f, f2, f3, f4, bl);
    }

    protected void jvxlSetColorRanges(float f, float f2, float f3, float f4, boolean bl) {
        if (this.jvxlDataIsColorMapped) {
            if (!Float.isNaN(f) && !Float.isNaN(f2)) {
                if (f2 == 0.0f && f == 0.0f) {
                    f = -1.0f;
                    f2 = 1.0f;
                }
                this.params.mappedDataMin = f;
                this.params.mappedDataMax = f2;
                Logger.info("JVXL read: data_min/max " + this.params.mappedDataMin + "/" + this.params.mappedDataMax);
            }
            if (!this.params.rangeDefined) {
                if (!Float.isNaN(f3) && !Float.isNaN(f4)) {
                    if (f3 == 0.0f && f4 == 0.0f) {
                        f3 = -1.0f;
                        f4 = 1.0f;
                    }
                    this.params.valueMappedToRed = Math.min(f3, f4);
                    this.params.valueMappedToBlue = Math.max(f3, f4);
                    this.params.isColorReversed = f3 > f4;
                    this.params.rangeDefined = true;
                } else {
                    this.params.valueMappedToRed = 0.0f;
                    this.params.valueMappedToBlue = 1.0f;
                    this.params.rangeDefined = true;
                }
            }
            Logger.info("JVXL read: color red/blue: " + this.params.valueMappedToRed + "/" + this.params.valueMappedToBlue);
        }
        this.jvxlData.valueMappedToRed = this.params.valueMappedToRed;
        this.jvxlData.valueMappedToBlue = this.params.valueMappedToBlue;
        this.jvxlData.mappedDataMin = this.params.mappedDataMin;
        this.jvxlData.mappedDataMax = this.params.mappedDataMax;
        this.jvxlData.isColorReversed = this.params.isColorReversed;
        if (this.params.insideOut) {
            bl = !bl;
        }
        this.params.insideOut = this.jvxlData.insideOut = bl;
    }

    @Override
    protected void readSurfaceData(boolean bl) throws Exception {
        boolean bl2 = this.thisInside = !this.params.isContoured;
        if (this.readSurfaceDataXML()) {
            return;
        }
        this.tempDataXml = this.xr.getXmlData("jvxlEdgeData", null, true, false);
        this.bsVoxelBitSet = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlEdgeData", this.tempDataXml, false, false));
        this.readSurfaceDataJXR();
    }

    protected boolean readSurfaceDataXML() throws Exception {
        if (this.vertexDataOnly) {
            this.getEncodedVertexData();
            return true;
        }
        if (this.params.thePlane != null) {
            this.volumeData.setDataDistanceToPlane(this.params.thePlane);
            this.setVolumeDataV(this.volumeData);
            this.params.cutoff = 0.0f;
            this.jvxlData.setSurfaceInfo(this.params.thePlane, this.params.mapLattice, 0, "");
            this.jvxlData.scale3d = this.params.scale3d;
            return true;
        }
        return false;
    }

    protected void readSurfaceDataJXR() throws Exception {
        this.readSurfaceDataVFR(false);
        this.volumeData.setMappingPlane(null);
    }

    protected String jvxlReadFractionData(String string, int n) {
        String string2;
        try {
            if (string.equals("edge")) {
                string2 = JvxlCoder.jvxlDecompressString(XmlReader.getXmlAttrib(this.tempDataXml, "data"));
            } else {
                String string3 = this.xr.getXmlData("jvxlColorData", null, true, false);
                this.jvxlData.isJvxlPrecisionColor = JvxlXmlReader.getEncoding(string3).endsWith("2");
                string2 = JvxlCoder.jvxlDecompressString(XmlReader.getXmlAttrib(string3, "data"));
            }
        }
        catch (Exception exception) {
            Logger.error("Error reading " + string + " data " + exception);
            throw new NullPointerException();
        }
        return string2;
    }

    @Override
    protected BS getVoxelBitSet(int n) throws Exception {
        if (this.bsVoxelBitSet != null) {
            return this.bsVoxelBitSet;
        }
        BS bS = new BS();
        int n2 = 0;
        if (this.surfaceDataCount <= 0) {
            return bS;
        }
        int n3 = 0;
        while (n2 < n) {
            n3 = this.parseInt();
            if (n3 == Integer.MIN_VALUE) {
                this.rd();
                if (this.line == null || (n3 = this.parseIntStr(this.line)) == Integer.MIN_VALUE) {
                    if (!this.endOfData) {
                        Logger.error("end of file in JvxlReader? line=" + this.line);
                    }
                    this.endOfData = true;
                    n3 = 10000;
                }
            }
            this.thisInside = !this.thisInside;
            ++this.jvxlNSurfaceInts;
            if (this.thisInside) {
                bS.setBits(n2, n2 + n3);
            }
            n2 += n3;
        }
        return bS;
    }

    @Override
    protected float getSurfacePointAndFraction(float f, boolean bl, float f2, float f3, T3 t3, V3 v3, int n, int n2, int n3, int n4, int n5, float[] fArray, T3 t32) {
        if (this.edgeDataCount <= 0) {
            return this.getSPFv(f, bl, f2, f3, t3, v3, n, n2, n3, n4, n5, fArray, t32);
        }
        fArray[0] = this.jvxlGetNextFraction(this.edgeFractionBase, this.edgeFractionRange, 0.5f);
        t32.scaleAdd2(fArray[0], v3, t3);
        if (Float.isNaN(this.valueMin)) {
            this.setValueMinMax();
        }
        return this.valueCount == 0 || this.includeValueNaN && Float.isNaN(fArray[0]) ? fArray[0] : this.getNextValue();
    }

    private float getNextValue() {
        float f = Float.NaN;
        if (this.colorPtr < this.valueCount && Float.isNaN(f)) {
            f = this.jvxlData.isJvxlPrecisionColor ? JvxlCoder.jvxlFractionFromCharacter2(this.jvxlColorDataRead.charAt(this.colorPtr), this.jvxlColorDataRead.charAt(this.colorPtr++ + this.valueCount), this.colorFractionBase, this.colorFractionRange) : JvxlCoder.jvxlFractionFromCharacter(this.jvxlColorDataRead.charAt(this.colorPtr++), this.colorFractionBase, this.colorFractionRange, 0.5f);
        }
        return this.valueMin + f * this.valueRange;
    }

    private void setValueMinMax() {
        this.valueCount = this.jvxlColorDataRead.length();
        if (this.jvxlData.isJvxlPrecisionColor) {
            this.valueCount /= 2;
        }
        boolean bl = this.includeValueNaN = this.valueCount != this.jvxlEdgeDataRead.length();
        float f = !this.jvxlData.isJvxlPrecisionColor ? this.params.valueMappedToRed : (this.valueMin = this.params.mappedDataMin == Float.MAX_VALUE ? 0.0f : this.params.mappedDataMin);
        this.valueRange = (!this.jvxlData.isJvxlPrecisionColor ? this.params.valueMappedToBlue : (this.params.mappedDataMin == Float.MAX_VALUE ? 1.0f : this.params.mappedDataMax)) - this.valueMin;
        this.haveReadColorData = true;
    }

    private float jvxlGetNextFraction(int n, int n2, float f) {
        if (this.fractionPtr >= this.strFractionTemp.length()) {
            if (!this.endOfData) {
                Logger.error("end of file reading compressed fraction data");
            }
            this.endOfData = true;
            this.strFractionTemp = "" + (char)n;
            this.fractionPtr = 0;
        }
        return JvxlCoder.jvxlFractionFromCharacter(this.strFractionTemp.charAt(this.fractionPtr++), n, n2, f);
    }

    @Override
    protected String readColorData() {
        if (!this.jvxlDataIsColorMapped) {
            return "";
        }
        int n = this.jvxlData.vertexCount = this.meshData.vc;
        short[] sArray = this.meshData.vcs;
        float[] fArray = this.meshData.vvs;
        if ("none".equals(this.jvxlColorEncodingRead)) {
            this.jvxlData.vertexColors = new int[n];
            int[] nArray = new int[1];
            int n2 = PT.parseIntNext(this.jvxlColorDataRead, nArray);
            n2 = Math.min(n2, n);
            String[] stringArray = PT.getTokens(this.jvxlColorDataRead.substring(nArray[0]));
            boolean bl = false;
            float f = this.jvxlData.translucency;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                try {
                    int n5 = JvxlXmlReader.getColor(stringArray[n4]);
                    if (n5 == 0) {
                        n5 = n3;
                    } else {
                        n3 = n5;
                    }
                    this.jvxlData.vertexColors[n4] = n5;
                    sArray[n4] = C.getColixTranslucent(this.jvxlData.vertexColors[n4]);
                    if (C.isColixTranslucent(sArray[n4])) {
                        bl = true;
                    } else if (f != 0.0f) {
                        sArray[n4] = C.getColixTranslucent3(sArray[n4], true, f);
                    }
                }
                catch (Exception exception) {
                    Logger.info("JvxlXmlReader: Cannot interpret color code: " + stringArray[n4]);
                }
                ++n4;
            }
            if (bl && f == 0.0f) {
                this.jvxlData.translucency = 0.5f;
            }
            return "-";
        }
        if (this.params.colorEncoder == null) {
            this.params.colorEncoder = new ColorEncoder(null, null);
        }
        this.params.colorEncoder.setColorScheme(null, false);
        this.params.colorEncoder.setRange(this.params.valueMappedToRed, this.params.valueMappedToBlue, this.params.isColorReversed);
        Logger.info("JVXL reading color data mapped min/max: " + this.params.mappedDataMin + "/" + this.params.mappedDataMax + " for " + n + " vertices." + " using encoding keys " + this.colorFractionBase + " " + this.colorFractionRange);
        Logger.info("mapping red-->blue for " + this.params.valueMappedToRed + " to " + this.params.valueMappedToBlue + " colorPrecision:" + this.jvxlData.isJvxlPrecisionColor);
        boolean bl = Float.isNaN(this.valueMin);
        if (bl) {
            this.setValueMinMax();
        }
        float f = Float.MAX_VALUE;
        float f2 = -3.4028235E38f;
        if (sArray == null || sArray.length < n) {
            this.meshData.vcs = sArray = new short[n];
        }
        short s = 0;
        short s2 = 0;
        if (this.params.colorBySign) {
            s2 = C.getColix(this.params.isColorReversed ? this.params.colorNeg : this.params.colorPos);
            s = C.getColix(this.params.isColorReversed ? this.params.colorPos : this.params.colorNeg);
        }
        int n6 = this.meshData.vertexIncrement;
        boolean bl2 = this.params.mappedDataMin == Float.MAX_VALUE;
        int n7 = 0;
        while (n7 < n) {
            float f3 = bl ? (fArray[n7] = this.getNextValue()) : fArray[n7];
            if (bl2) {
                if (f3 < f) {
                    f = f3;
                }
                if (f3 > f2) {
                    f2 = f3;
                }
            }
            n7 += n6;
        }
        if (bl2) {
            this.params.mappedDataMin = f;
            this.params.mappedDataMax = f2;
        }
        if (this.jvxlData.colorScheme != null) {
            n7 = this.marchingSquares != null && this.params.isContoured ? 1 : 0;
            int n8 = 0;
            while (n8 < n) {
                float f4 = fArray[n8];
                if (n7 != 0) {
                    this.marchingSquares.setContourData(n8, f4);
                } else {
                    short s3 = !this.params.colorBySign ? this.params.colorEncoder.getColorIndex(f4) : ((this.params.isColorReversed ? f4 > 0.0f : f4 <= 0.0f) ? s : s2);
                    sArray[n8] = C.getColixTranslucent3(s3, true, this.jvxlData.translucency);
                }
                n8 += n6;
            }
        }
        return String.valueOf(this.jvxlColorDataRead) + "\n";
    }

    private static int getColor(String string) {
        int n = 0;
        try {
            switch (string.charAt(0)) {
                case '[': {
                    n = CU.getArgbFromString(string);
                    break;
                }
                case '0': {
                    n = PT.parseIntRadix(string.substring(2), 16);
                    break;
                }
                default: {
                    n = PT.parseIntRadix(string, 10);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    protected void getEncodedVertexData() throws Exception {
        String string = this.xr.getXmlData("jvxlSurfaceData", null, true, false);
        this.jvxlDecodeVertexData(this.xr.getXmlData("jvxlVertexData", string, true, false), false);
        String string2 = this.xr.getXmlData("jvxlTriangleData", string, true, false);
        String string3 = this.xr.getXmlData("jvxlTriangleEdgeData", string, true, false);
        String string4 = this.xr.getXmlData("jvxlPolygonColorData", string, false, false);
        this.jvxlDecodeTriangleData(string2, string3, string4);
        String string5 = this.xr.getXmlData("jvxlColorData", string, true, false);
        this.jvxlColorEncodingRead = JvxlXmlReader.getEncoding(string5);
        this.jvxlData.isJvxlPrecisionColor = this.jvxlColorEncodingRead.endsWith("2");
        string5 = this.getData(string5, "jvxlColorData");
        this.jvxlColorDataRead = this.jvxlColorEncodingRead.equals("none") ? string5 : JvxlCoder.jvxlDecompressString(string5);
        boolean bl = this.jvxlDataIsColorMapped = (this.params.colorRgb == Integer.MIN_VALUE || this.params.colorRgb == Integer.MAX_VALUE) && this.jvxlColorDataRead.length() > 0;
        if (this.haveContourData) {
            this.jvxlDecodeContourData(this.jvxlData, this.xr.getXmlData("jvxlContourData", null, false, false));
        }
    }

    private String getData(String string, String string2) throws Exception {
        String string3 = XmlReader.getXmlAttrib(string, "data");
        if (string3.length() == 0) {
            string3 = this.xr.getXmlData(string2, string, false, false);
        }
        return string3;
    }

    private static String getEncoding(String string) {
        if (XmlReader.getXmlAttrib(string, "len").length() > 0) {
            return "";
        }
        String string2 = XmlReader.getXmlAttrib(string, "encoding");
        return string2.length() == 0 ? "none" : string2;
    }

    public P3[] jvxlDecodeVertexData(String string, boolean bl) throws Exception {
        int n = this.parseIntStr(XmlReader.getXmlAttrib(string, "count"));
        if (!bl) {
            Logger.info("Reading " + n + " vertices");
        }
        int n2 = n * 3;
        P3[] p3Array = bl ? new P3[n] : null;
        String string2 = XmlReader.getXmlAttrib(string, "data");
        String string3 = JvxlXmlReader.getEncoding(string);
        if ("none".equals(string3)) {
            float[] fArray;
            if (string2.length() == 0) {
                string2 = this.xr.getXmlData("jvxlVertexData", string, false, false);
            }
            if ((fArray = PT.parseFloatArray(string2))[0] != (float)(n * 3)) {
                Logger.info("JvxlXmlReader: vertexData count=" + (int)fArray[0] + "; expected " + n * 3);
            }
            int n3 = 0;
            int n4 = 1;
            while (n3 < n) {
                P3 p3 = P3.new3(fArray[n4++], fArray[n4++], fArray[n4++]);
                if (bl) {
                    p3Array[n3] = p3;
                } else {
                    this.addVertexCopy(p3, 0.0f, n3, false);
                }
                ++n3;
            }
        } else {
            P3 p3 = this.xr.getXmlPoint(string, "min");
            P3 p32 = this.xr.getXmlPoint(string, "max");
            p32.sub(p3);
            int n5 = this.jvxlData.colorFractionBase;
            int n6 = this.jvxlData.colorFractionRange;
            String string4 = JvxlCoder.jvxlDecompressString(string2);
            if (string4.length() == 0) {
                string4 = this.xr.getXmlData("jvxlVertexData", string, false, false);
            }
            int n7 = 0;
            int n8 = -1;
            while (n7 < n) {
                P3 p33 = new P3();
                float f = JvxlCoder.jvxlFractionFromCharacter2(string4.charAt(++n8), string4.charAt(n8 + n2), n5, n6);
                p33.x = p3.x + f * p32.x;
                f = JvxlCoder.jvxlFractionFromCharacter2(string4.charAt(++n8), string4.charAt(n8 + n2), n5, n6);
                p33.y = p3.y + f * p32.y;
                f = JvxlCoder.jvxlFractionFromCharacter2(string4.charAt(++n8), string4.charAt(n8 + n2), n5, n6);
                p33.z = p3.z + f * p32.z;
                if (bl) {
                    p3Array[n7] = p33;
                } else {
                    this.addVertexCopy(p33, 0.0f, n7, false);
                }
                ++n7;
            }
        }
        return p3Array;
    }

    void jvxlDecodeTriangleData(String string, String string2, String string3) throws Exception {
        int n;
        boolean bl;
        boolean bl2;
        int n2 = this.parseIntStr(XmlReader.getXmlAttrib(string, "count"));
        if (n2 < 0) {
            return;
        }
        int[] nArray = new int[1];
        int n3 = string3 == null ? -1 : 1;
        int n4 = 0;
        Logger.info("Reading " + n2 + " triangles");
        String string4 = JvxlXmlReader.getEncoding(string);
        string = this.getData(string, "jvxlTriangleData");
        String string5 = this.getData(string2, "jvxlTriangleEdgeData");
        int[] nArray2 = new int[3];
        int[] nArray3 = new int[1];
        int[] nArray4 = null;
        int n5 = 7;
        boolean bl3 = bl2 = !"none".equals(string4);
        if (bl2) {
            string = JvxlCoder.jvxlDecompressString(string);
            bl = (string5 = JvxlCoder.jvxlDecompressString(string5).trim()).length() == n2;
        } else {
            n = PT.parseIntNext(string, nArray3);
            boolean bl4 = bl = string5.length() > 0;
            if (bl) {
                nArray4 = new int[1];
                PT.parseIntNext(string5, nArray4);
            } else if (n > 0) {
                Logger.info("JvxlXmlReader: jvxlTriangleEdgeData count=" + n + "; expected " + n2);
            }
        }
        n = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        block5: while (n < n2) {
            int n9;
            if (bl2) {
                int n10;
                n9 = string.charAt(++n8);
                switch (n9) {
                    case 33: {
                        n10 = 0;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: 
                    case 43: 
                    case 44: 
                    case 46: {
                        continue block5;
                    }
                    case 45: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        nArray3[0] = n8;
                        n10 = PT.parseIntNext(string, nArray3);
                        n8 = nArray3[0] - 1;
                        break;
                    }
                    default: {
                        n10 = n9 - 92;
                    }
                }
                n6 += n10;
            } else {
                n6 = PT.parseIntNext(string, nArray3) - 1;
            }
            nArray2[n7] = n6;
            if (++n7 != 3) continue;
            n7 = 0;
            if (bl) {
                int n11 = n5 = nArray4 == null ? string5.charAt(n) - 48 : PT.parseIntNext(string5, nArray4);
                if (n5 < 0 || n5 > 7) {
                    n5 = 7;
                }
            }
            if (--n3 == 0) {
                n3 = PT.parseIntNext(string3, nArray);
                n9 = PT.parseIntNext(string3, nArray);
                if (n9 == Integer.MIN_VALUE) {
                    n3 = 0;
                } else {
                    n4 = n9 | 0xFF000000;
                }
            }
            this.addTriangleCheck(nArray2[0], nArray2[1], nArray2[2], n5, n4, false, n4);
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void jvxlDecodeContourData(JvxlData var1_1, String var2_2) throws Exception {
        var3_3 = new Lst<Lst<Object>>();
        var4_4 = new SB();
        var5_5 = new SB();
        var6_6 = -1;
        var1_1.vContours = null;
        if (var2_2 != null) ** GOTO lbl23
        return;
lbl-1000:
        // 1 sources

        {
            var7_7 = new Lst<Object>();
            var8_9 = this.xr.getXmlData("jvxlContour", var2_2.substring(var6_6), true, false);
            var9_11 = this.parseFloatStr(XmlReader.getXmlAttrib(var8_9, "value"));
            var4_4.append(" ").appendF(var9_11);
            var10_12 = JvxlXmlReader.getColor(XmlReader.getXmlAttrib(var8_9, "color"));
            var11_13 = C.getColix(var10_12);
            var5_5.append(" ").append(Escape.escapeColor(var10_12));
            var12_14 = JvxlCoder.jvxlDecompressString(XmlReader.getXmlAttrib(var8_9, "data"));
            var13_15 = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlContour", var8_9, false, false));
            var14_16 = var13_15.length();
            IsosurfaceMesh.setContourVector(var7_7, var14_16, var13_15, var9_11, var11_13, var10_12, SB.newS(var12_14));
            var3_3.addLast(var7_7);
lbl23:
            // 2 sources

            ** while ((var6_6 = var2_2.indexOf((String)"<jvxlContour", (int)(var6_6 + 1))) >= 0)
        }
lbl24:
        // 1 sources

        var7_8 = var3_3.size();
        if (var7_8 > 0) {
            var1_1.vContours = AU.createArrayOfArrayList(var7_8);
            this.params.contourColixes = new short[var7_8];
            var1_1.contourColixes = this.params.contourColixes;
            this.params.contoursDiscrete = new float[var7_8];
            var1_1.contourValues = this.params.contoursDiscrete;
            var8_10 = 0;
            while (var8_10 < var7_8) {
                var1_1.vContours[var8_10] = (Lst)var3_3.get(var8_10);
                var1_1.contourValues[var8_10] = ((Float)var1_1.vContours[var8_10].get(2)).floatValue();
                var1_1.contourColixes[var8_10] = ((short[])var1_1.vContours[var8_10].get(3))[0];
                ++var8_10;
            }
            var1_1.contourColors = C.getHexCodes(var1_1.contourColixes);
            Logger.info("JVXL read: " + var7_8 + " discrete contours");
            Logger.info("JVXL read: contour values: " + var4_4);
            Logger.info("JVXL read: contour colors: " + var5_5);
        }
    }

    @Override
    protected void postProcessVertices() {
        BS bS = this.params.bsExcluded[1];
        if (bS != null) {
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 1, null);
            }
            this.meshData.invalidateVertices(bS);
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 4, null);
                this.meshData = new MeshData();
            }
            this.updateTriangles();
        }
    }
}

