/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.api.JmolAnnotationParser;
import org.jmol.c.STR;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Structure;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.BioExt;
import org.jmol.modelsetbio.BioModel;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.BioResolver;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class BioModelSet {
    private Viewer vwr;
    private ModelSet ms;
    private BioExt ext;
    private Map<String, BS>[] unitIdSets;

    BioExt getBioExt() {
        BioExt bioExt;
        if (this.ext == null) {
            this.ext = (BioExt)Interface.getInterface("org.jmol.modelsetbio.BioExt", this.vwr, "script");
            bioExt = this.ext.set(this.vwr, this.vwr.ms);
        } else {
            bioExt = this.ext;
        }
        return bioExt;
    }

    public BioModelSet set(Viewer viewer, ModelSet modelSet) {
        this.vwr = viewer;
        this.ms = modelSet;
        this.unitIdSets = null;
        if (this.ext != null) {
            this.ext.set(viewer, modelSet);
        }
        return this;
    }

    public void calcAllRasmolHydrogenBonds(BS bS, BS bS2, Lst<Bond> lst, boolean bl, int n, boolean bl2, BS bS3, int n2) {
        Model[] modelArray = this.ms.am;
        if (lst == null) {
            BS bS4 = bS;
            if (bS2 != null && !bS.equals(bS2)) {
                bS4 = BSUtil.copy(bS);
                bS4.or(bS2);
            }
            BS bS5 = new BS();
            BS bS6 = new BS();
            Model[] modelArray2 = this.ms.am;
            Bond[] bondArray = this.ms.bo;
            int n3 = this.ms.bondCount;
            while (--n3 >= 0) {
                Bond bond = bondArray[n3];
                if ((bond.order & 0x7000) == 0) continue;
                if (bS4.get(bond.atom1.i)) {
                    bS5.set(n3);
                    continue;
                }
                bS6.set(modelArray2[bond.atom1.mi].trajectoryBaseIndex);
            }
            n3 = this.ms.mc;
            while (--n3 >= 0) {
                if (!modelArray2[n3].isBioModel) continue;
                modelArray2[n3].hasRasmolHBonds = bS6.get(n3);
            }
            if (bS5.nextSetBit(0) >= 0) {
                this.ms.deleteBonds(bS5, false);
            }
        }
        int n4 = this.ms.mc;
        while (--n4 >= 0) {
            if (!modelArray[n4].isBioModel || this.ms.isTrajectorySubFrame(n4)) continue;
            ((BioModel)modelArray[n4]).getRasmolHydrogenBonds(bS, bS2, lst, bl, n, bl2, bS3, n2);
        }
    }

    public void calcSelectedMonomersCount() {
        BS bS = this.vwr.bsA();
        int n = this.ms.mc;
        while (--n >= 0) {
            if (!this.ms.am[n].isBioModel) continue;
            BioModel bioModel = (BioModel)this.ms.am[n];
            int n2 = bioModel.bioPolymerCount;
            while (--n2 >= 0) {
                bioModel.bioPolymers[n2].calcSelectedMonomersCount(bS);
            }
        }
    }

    public void calculateAllPolymers(Group[] groupArray, int n, int n2, BS bS) {
        int n3;
        boolean bl;
        boolean bl2 = bl = !this.vwr.getBoolean(603979896);
        if (n < 0) {
            n = groupArray.length;
        }
        if (bS != null) {
            n3 = 0;
            while (n3 < n) {
                Group group = groupArray[n3];
                if (group instanceof Monomer && ((Monomer)group).bioPolymer != null && !bS.get(group.chain.model.modelIndex)) {
                    ((Monomer)group).setBioPolymer(null, -1);
                }
                ++n3;
            }
        }
        n3 = 0;
        int n4 = this.ms.mc;
        while (n3 < n4) {
            if ((bS == null || !bS.get(n3)) && this.ms.am[n3].isBioModel) {
                int n5 = 0;
                int n6 = n2;
                while (n6 < n) {
                    Group group = groupArray[n6];
                    Model model = group.getModel();
                    if (model.isBioModel && group instanceof Monomer) {
                        BioPolymer bioPolymer;
                        boolean bl3 = bl && !this.ms.isJmolDataFrameForModel(this.ms.at[group.firstAtomIndex].mi);
                        BioPolymer bioPolymer2 = bioPolymer = ((Monomer)group).bioPolymer == null ? BioResolver.allocateBioPolymer(groupArray, n6, bl3, n5) : null;
                        if (bioPolymer != null && bioPolymer.monomerCount != 0) {
                            int n7 = ((BioModel)model).addBioPolymer(bioPolymer);
                            n6 += n7 - 1;
                            n5 += n7 - 1;
                        }
                    }
                    ++n6;
                    ++n5;
                }
            }
            ++n3;
        }
    }

    public String calculateAllStructuresExcept(BS bS, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n) {
        String string = "";
        BS bS2 = BSUtil.copyInvert(bS, this.ms.mc);
        if (bl4) {
            this.setAllDefaultStructure(bS2);
        }
        int n2 = bS2.nextSetBit(0);
        while (n2 >= 0) {
            if (this.ms.am[n2].isBioModel) {
                string = String.valueOf(string) + ((BioModel)this.ms.am[n2]).calculateStructures(bl, bl2, bl3, bl4, bl5, n);
            }
            n2 = bS2.nextSetBit(n2 + 1);
        }
        if (bl4) {
            this.ms.setStructureIndexes();
        }
        return string;
    }

    public String calculateAllStuctures(BS bS, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        BS bS2 = new BS();
        BS bS3 = BSUtil.copyInvert(this.modelsOf(bS, bS2), this.ms.mc);
        if (!bl4) {
            return this.ms.calculateStructuresAllExcept(bS3, bl, bl2, bl3, false, false, n);
        }
        this.ms.recalculatePolymers(bS3);
        String string = this.ms.calculateStructuresAllExcept(bS3, bl, bl2, bl3, true, false, n);
        this.vwr.shm.resetBioshapes(bS2);
        this.ms.setStructureIndexes();
        return string;
    }

    public void calculateStraightnessAll() {
        this.getBioExt().calculateStraightnessAll();
    }

    public int calculateStruts(BS bS, BS bS2) {
        return this.getBioExt().calculateAllstruts(this.vwr, this.ms, bS, bS2);
    }

    public String getAllDefaultStructures(BS bS, BS bS2) {
        BS bS3 = this.modelsOf(bS, bS2);
        SB sB = new SB();
        int n = bS3.nextSetBit(0);
        while (n >= 0) {
            if (this.ms.am[n].isBioModel && ((BioModel)this.ms.am[n]).defaultStructure != null) {
                sB.append(((BioModel)this.ms.am[n]).defaultStructure);
            }
            n = bS3.nextSetBit(n + 1);
        }
        return sB.toString();
    }

    public Map<String, String> getAllHeteroList(int n) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = false;
        int n2 = this.ms.mc;
        while (--n2 >= 0) {
            Map map;
            if (n >= 0 && n2 != n || (map = (Map)this.ms.getInfo(n2, "hetNames")) == null) continue;
            bl = true;
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                hashtable.put(string, (String)entry.getValue());
            }
        }
        return bl ? hashtable : null;
    }

    public void getAllPolymerInfo(BS bS, Map<String, Lst<Map<String, Object>>> map) {
        this.getBioExt().getAllPolymerInfo(bS, map);
    }

    public void getAllPolymerPointsAndVectors(BS bS, Lst<P3[]> lst, boolean bl, float f) {
        int n = 0;
        while (n < this.ms.mc) {
            if (this.ms.am[n].isBioModel) {
                BioModel bioModel = (BioModel)this.ms.am[n];
                int n2 = 0x7FFFFFFE;
                int n3 = 0;
                while (n3 < bioModel.bioPolymerCount) {
                    n2 = bioModel.bioPolymers[n3].getPolymerPointsAndVectors(n2, bS, lst, bl, f);
                    ++n3;
                }
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public BS getAllSequenceBits(String var1_1, BS var2_2, BS var3_3) {
        block5: {
            if (var1_1.length() <= 0) break block5;
            if (var2_2 == null) {
                var2_2 = this.vwr.getAllAtoms();
            }
            if (var1_1.indexOf(124) < var1_1.lastIndexOf(124)) {
                return this.getAllUnitIds(var1_1, var2_2, var3_3);
            }
            var4_4 = this.ms.am;
            var5_5 = this.ms.mc;
            while (--var5_5 >= 0) {
                if (!var4_4[var5_5].isBioModel) continue;
                var6_6 = (BioModel)var4_4[var5_5];
                var7_7 = var1_1.length();
                var8_8 = 0;
                while (var8_8 < var6_6.bioPolymerCount) {
                    var9_9 = var6_6.bioPolymers[var8_8].getSequence();
                    var10_10 = -1;
                    if (true) ** GOTO lbl19
                    do {
                        var6_6.bioPolymers[var8_8].getPolymerSequenceAtoms(var10_10, var7_7, var2_2, var3_3);
lbl19:
                        // 2 sources

                        ++var10_10;
                    } while ((var10_10 = var9_9.indexOf(var1_1, var10_10)) >= 0);
                    ++var8_8;
                }
            }
        }
        return var3_3;
    }

    public BS getAtomBitsBS(int n, BS bS, BS bS2) {
        Atom[] atomArray = this.ms.at;
        int n2 = this.ms.ac;
        int n3 = 0;
        switch (n) {
            case 0x200020: 
            case 136314895: {
                Group group;
                STR sTR = n == 136314895 ? STR.HELIX : STR.SHEET;
                n3 = n2;
                while (--n3 >= 0) {
                    group = atomArray[n3].group;
                    if (group.isWithinStructure(sTR)) {
                        group.setAtomBits(bS2);
                    }
                    n3 = group.firstAtomIndex;
                }
                break;
            }
            case 0x200024: {
                Group group;
                n3 = n2;
                while (--n3 >= 0) {
                    group = atomArray[n3].group;
                    if (group.isCarbohydrate()) {
                        group.setAtomBits(bS2);
                    }
                    n3 = group.firstAtomIndex;
                }
                break;
            }
            case 0x200004: {
                Group group;
                n3 = n2;
                while (--n3 >= 0) {
                    group = atomArray[n3].group;
                    if (group.isDna()) {
                        group.setAtomBits(bS2);
                    }
                    n3 = group.firstAtomIndex;
                }
                break;
            }
            case 0x20000E: {
                Group group;
                n3 = n2;
                while (--n3 >= 0) {
                    group = atomArray[n3].group;
                    if (group.isNucleic()) {
                        group.setAtomBits(bS2);
                    }
                    n3 = group.firstAtomIndex;
                }
                break;
            }
            case 0x200010: {
                Group group;
                n3 = n2;
                while (--n3 >= 0) {
                    group = atomArray[n3].group;
                    if (group.isProtein()) {
                        group.setAtomBits(bS2);
                    }
                    n3 = group.firstAtomIndex;
                }
                break;
            }
            case 0x200012: {
                Group group;
                n3 = n2;
                while (--n3 >= 0) {
                    group = atomArray[n3].group;
                    if (group.isPurine()) {
                        group.setAtomBits(bS2);
                    }
                    n3 = group.firstAtomIndex;
                }
                break;
            }
            case 2097172: {
                Group group;
                n3 = n2;
                while (--n3 >= 0) {
                    group = atomArray[n3].group;
                    if (group.isPyrimidine()) {
                        group.setAtomBits(bS2);
                    }
                    n3 = group.firstAtomIndex;
                }
                break;
            }
            case 2097174: {
                Group group;
                n3 = n2;
                while (--n3 >= 0) {
                    group = atomArray[n3].group;
                    if (group.isRna()) {
                        group.setAtomBits(bS2);
                    }
                    n3 = group.firstAtomIndex;
                }
                break;
            }
        }
        if (n3 < 0) {
            return bS2;
        }
        int n4 = bS.nextSetBit(0);
        if (n4 < 0) {
            return bS2;
        }
        n3 = 0;
        switch (n) {
            case 1094713362: {
                n3 = n4;
                while (n3 >= 0) {
                    int n5 = atomArray[n3].group.getBioPolymerIndexInModel();
                    if (n5 >= 0) {
                        ((Monomer)atomArray[n3].group).bioPolymer.setAtomBitsAndClear(bS2, bS);
                    }
                    n3 = bS.nextSetBit(n3 + 1);
                }
                break;
            }
            case 1639976963: {
                n3 = n4;
                while (n3 >= 0) {
                    Structure structure = atomArray[n3].group.getStructure();
                    if (structure != null) {
                        structure.setAtomBitsAndClear(bS2, bS);
                    }
                    n3 = bS.nextSetBit(n3 + 1);
                }
                break;
            }
        }
        if (n3 == 0) {
            Logger.error("MISSING getAtomBits entry for " + T.nameOf(n));
        }
        return bS2;
    }

    public BS getAtomBitsStr(int n, String string, BS bS) {
        switch (n) {
            default: {
                return new BS();
            }
            case 1073741925: {
                return this.getAnnotationBits("domains", 1073741925, string);
            }
            case 1073742189: {
                return this.getAnnotationBits("validation", 1073742189, string);
            }
            case 1073742128: {
                return this.getAnnotationBits("rna3d", 1073742128, string);
            }
            case 1073741863: {
                String string2 = string;
                bS = new BS();
                return string2.length() % 2 != 0 ? bS : this.ms.getAtomBitsMDa(1086324742, this.getAllBasePairBits(string2), bS);
            }
            case 1111490587: {
                return this.getAnnotationBits("dssr", 1111490587, string);
            }
            case 1086324744: 
        }
        return this.getAllSequenceBits(string, null, bS);
    }

    public int getBioPolymerCountInModel(int n) {
        if (n < 0) {
            int n2 = 0;
            int n3 = this.ms.mc;
            while (--n3 >= 0) {
                if (this.ms.isTrajectorySubFrame(n3) || !this.ms.am[n3].isBioModel) continue;
                n2 += ((BioModel)this.ms.am[n3]).getBioPolymerCount();
            }
            return n2;
        }
        return this.ms.isTrajectorySubFrame(n) || !this.ms.am[n].isBioModel ? 0 : ((BioModel)this.ms.am[n]).getBioPolymerCount();
    }

    public String getFullProteinStructureState(BS bS, int n) {
        int n2;
        int n3;
        boolean bl;
        boolean bl2 = bl = n == 1073742327;
        if (bl && !this.ms.proteinStructureTainted) {
            return "";
        }
        boolean bl3 = n == 1073742158 || n == 1073742327;
        Atom[] atomArray = this.ms.at;
        int n4 = n3 = bS == null ? 0 : bS.nextSetBit(0);
        if (n3 < 0) {
            return "";
        }
        if (bS != null && n == 4138) {
            bS = BSUtil.copy(bS);
            n2 = this.ms.ac;
            while (--n2 >= 0) {
                if (!Float.isNaN(atomArray[n2].group.getGroupParameter(1111490569)) && !Float.isNaN(atomArray[n2].group.getGroupParameter(1111490570))) continue;
                bS.clear(n2);
            }
        }
        n2 = (bS == null ? this.ms.ac : bS.length()) - 1;
        int n5 = atomArray[n3].mi;
        short s = atomArray[n2].mi;
        Lst<ProteinStructure> lst = new Lst<ProteinStructure>();
        Hashtable<ProteinStructure, Boolean> hashtable = new Hashtable<ProteinStructure, Boolean>();
        SB sB = new SB();
        int n6 = n5;
        while (n6 <= s) {
            if (this.ms.am[n6].isBioModel) {
                BioModel bioModel = (BioModel)this.ms.am[n6];
                if (!bl || bioModel.structureTainted) {
                    BS bS2 = new BS();
                    bS2.or(bioModel.bsAtoms);
                    bS2.andNot(bioModel.bsAtomsDeleted);
                    int n7 = bS2.nextSetBit(0);
                    if (n7 >= 0) {
                        if (bl3) {
                            sB.append("  structure none ").append(Escape.eBS(this.ms.getModelAtomBitSetIncludingDeleted(n6, false))).append("    \t# model=" + this.ms.getModelNumberDotted(n6)).append(";\n");
                        }
                        int n8 = n7;
                        while (n8 >= 0) {
                            ProteinStructure proteinStructure;
                            Atom atom = atomArray[n8];
                            if (atom.group instanceof AlphaMonomer && (proteinStructure = ((AlphaMonomer)atom.group).proteinStructure) != null && !hashtable.containsKey(proteinStructure)) {
                                lst.addLast(proteinStructure);
                                hashtable.put(proteinStructure, Boolean.TRUE);
                            }
                            n8 = bS2.nextSetBit(n8 + 1);
                        }
                    }
                }
            }
            ++n6;
        }
        this.getStructureLines(bS, sB, lst, STR.HELIX, bl3, n);
        this.getStructureLines(bS, sB, lst, STR.SHEET, bl3, n);
        this.getStructureLines(bS, sB, lst, STR.TURN, bl3, n);
        return sB.toString();
    }

    public BS getGroupsWithinAll(int n, BS bS) {
        BS bS2 = new BS();
        BS bS3 = this.ms.getIterativeModels(false);
        int n2 = this.ms.mc;
        while (--n2 >= 0) {
            if (!bS3.get(n2) || !this.ms.am[n2].isBioModel) continue;
            BioModel bioModel = (BioModel)this.ms.am[n2];
            int n3 = bioModel.bioPolymerCount;
            while (--n3 >= 0) {
                bioModel.bioPolymers[n3].getRangeGroups(n, bS, bS2);
            }
        }
        return bS2;
    }

    public BS getIdentifierOrNull(String string) {
        int n;
        BS bS;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2 && PT.isLetter(string.charAt(n3))) {
            ++n3;
        }
        BS bS2 = this.ms.getSpecNameOrNull(string.substring(0, n3), false);
        if (n3 == n2) {
            return bS2;
        }
        if (bS2 == null) {
            bS2 = new BS();
        }
        int n4 = n3;
        while (n3 < n2 && PT.isDigit(string.charAt(n3))) {
            ++n3;
        }
        int n5 = 0;
        try {
            n5 = Integer.parseInt(string.substring(n4, n3));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        char c = ' ';
        if (n3 < n2 && string.charAt(n3) == '^' && ++n3 < n2) {
            c = string.charAt(n3);
        }
        if ((bS = this.ms.getSeqcodeBits(n = Group.getSeqcodeFor(n5, c), false)) == null) {
            if (c != ' ') {
                bS = this.ms.getSeqcodeBits(Character.toUpperCase(string.charAt(n3)), false);
            }
            if (bS == null) {
                return null;
            }
            ++n3;
        }
        bS2.and(bS);
        if (n3 >= n2) {
            return bS2;
        }
        if (n3 != n2 - 1) {
            return null;
        }
        bS2.and(this.ms.getChainBits(string.charAt(n3)));
        return bS2;
    }

    public boolean mutate(BS bS, String string, String[] stringArray) {
        return this.getBioExt().mutate(this.vwr, bS, string, stringArray);
    }

    public void recalculateAllPolymers(BS bS, Group[] groupArray) {
        int n = 0;
        while (n < this.ms.mc) {
            if (this.ms.am[n].isBioModel && !bS.get(n)) {
                ((BioModel)this.ms.am[n]).clearBioPolymers();
            }
            ++n;
        }
        this.calculateAllPolymers(groupArray, -1, 0, bS);
    }

    public void recalculatePoints(int n) {
        if (n < 0) {
            int n2 = this.ms.mc;
            while (--n2 >= 0) {
                if (this.ms.isTrajectorySubFrame(n2) || !this.ms.am[n2].isBioModel) continue;
                ((BioModel)this.ms.am[n2]).recalculateLeadMidpointsAndWingVectors();
            }
            return;
        }
        if (!this.ms.isTrajectorySubFrame(n) && this.ms.am[n].isBioModel) {
            ((BioModel)this.ms.am[n]).recalculateLeadMidpointsAndWingVectors();
        }
    }

    public void setAllConformation(BS bS) {
        BS bS2 = this.ms.getModelBS(bS, false);
        int n = bS2.nextSetBit(0);
        while (n >= 0) {
            if (this.ms.am[n].isBioModel) {
                BioModel bioModel = (BioModel)this.ms.am[n];
                if (bioModel.altLocCount > 0) {
                    int n2 = bioModel.bioPolymerCount;
                    while (--n2 >= 0) {
                        bioModel.bioPolymers[n2].setConformation(bS);
                    }
                }
            }
            n = bS2.nextSetBit(n + 1);
        }
    }

    public void setAllProteinType(BS bS, STR sTR) {
        int n = -1;
        int n2 = -1;
        BS bS2 = this.ms.getModelBS(bS, false);
        this.setAllDefaultStructure(bS2);
        Atom[] atomArray = this.ms.at;
        Model[] modelArray = this.ms.am;
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            Atom atom = atomArray[n3];
            Group group = atom.group;
            if (!group.isAdded(n3) && group.getBioPolymerLength() != 0) {
                n = group.setProteinStructureType(sTR, n2 == n3 - 1 ? n : -1);
                short s = atom.mi;
                modelArray[s].structureTainted = true;
                this.ms.proteinStructureTainted = true;
                n2 = n3 = group.lastAtomIndex;
            }
            n3 = bS.nextSetBit(n3 + 1);
        }
        int[] nArray = new int[this.ms.mc];
        int n4 = 0;
        while (n4 < this.ms.ac) {
            short s = atomArray[n4].mi;
            if (!bS2.get(s)) {
                n4 = modelArray[s].firstAtomIndex + modelArray[s].act - 1;
            } else {
                Group group = atomArray[n4].group;
                if (!group.isAdded(n4)) {
                    n2 = group.getStrucNo();
                    if (n2 < 1000 && n2 > nArray[s]) {
                        nArray[s] = n2;
                    }
                    n4 = group.lastAtomIndex;
                }
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.ms.ac) {
            short s = atomArray[n4].mi;
            if (!bS2.get(s)) {
                n4 = modelArray[s].firstAtomIndex + modelArray[s].act - 1;
            } else {
                Group group = atomArray[n4].group;
                if (!group.isAdded(n4)) {
                    n4 = group.lastAtomIndex;
                    if (group.getStrucNo() > 1000) {
                        short s2 = s;
                        int n5 = nArray[s2] + 1;
                        nArray[s2] = n5;
                        group.setStrucNo(n5);
                    }
                }
            }
            ++n4;
        }
    }

    public void setAllStructureList(Map<STR, float[]> map) {
        int n = this.ms.mc;
        while (--n >= 0) {
            if (!this.ms.am[n].isBioModel) continue;
            BioModel bioModel = (BioModel)this.ms.am[n];
            bioModel.bioPolymers = (BioPolymer[])AU.arrayCopyObject(bioModel.bioPolymers, bioModel.bioPolymerCount);
            int n2 = bioModel.bioPolymerCount;
            while (--n2 >= 0) {
                BioPolymer bioPolymer = bioModel.bioPolymers[n2];
                if (!(bioPolymer instanceof AminoPolymer)) continue;
                ((AminoPolymer)bioPolymer).setStructureList(map);
            }
        }
    }

    private BS getAllBasePairBits(String string) {
        BS bS = null;
        BS bS2 = null;
        Lst<Bond> lst = new Lst<Bond>();
        if (string.length() == 0) {
            bS = bS2 = this.vwr.getAllAtoms();
            this.calcAllRasmolHydrogenBonds(bS, bS2, lst, true, 1, false, null, 0);
        } else {
            int n = 0;
            while (n < string.length()) {
                if ((bS = this.ms.getSequenceBits(string.substring(n++, n), null, new BS())).nextSetBit(0) < 0 || (bS2 = this.ms.getSequenceBits(string.substring(n++, n), null, new BS())).nextSetBit(0) < 0) continue;
                this.calcAllRasmolHydrogenBonds(bS, bS2, lst, true, 1, false, null, 0);
            }
        }
        BS bS3 = new BS();
        int n = lst.size();
        while (--n >= 0) {
            Bond bond = (Bond)lst.get(n);
            bS3.set(bond.atom1.i);
            bS3.set(bond.atom2.i);
        }
        return bS3;
    }

    private BS getAllUnitIds(String string, BS bS, BS bS2) {
        Object object;
        Object object2;
        Map<String, BS>[] mapArray = this.unitIdSets;
        if (mapArray == null) {
            mapArray = this.unitIdSets = new Map[7];
            int n = 0;
            while (n < 7) {
                mapArray[n] = new Hashtable<String, BS>();
                ++n;
            }
            n = this.ms.mc;
            while (--n >= 0) {
                object2 = this.ms.am[n];
                if (!((Model)object2).isBioModel) continue;
                if (this.ms.isTrajectory(n)) {
                    n = ((Model)object2).trajectoryBaseIndex;
                    object2 = this.ms.am[n];
                }
                object = "|" + this.ms.getInfo(n, "modelNumber");
                this.checkMap(mapArray[0], this.ms.getInfo(n, "modelName") + (String)object, ((Model)object2).bsAtoms);
                this.checkMap(mapArray[0], (String)object, ((Model)object2).bsAtoms);
            }
        }
        BS bS3 = null;
        object2 = null;
        object = new BS();
        String[] stringArray = PT.getTokens(PT.replaceAllCharacters(string, ", \t\n[]\"=", " "));
        int[] nArray = new int[8];
        int n = stringArray.length;
        while (--n >= 0) {
            String string2 = String.valueOf(stringArray[n]) + "|";
            if (string2.length() < 5) continue;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = string2.lastIndexOf(124) + 1;
            while (n3 < n5 && n4 < 8) {
                if (string2.charAt(n3) == '|') {
                    nArray[n4++] = n3;
                } else {
                    n2 |= 1 << n4;
                }
                ++n3;
            }
            if ((n2 & 0x16) != 22) continue;
            ((BS)object).clearAll();
            ((BS)object).or(bS);
            String string3 = string2.substring(0, nArray[2]);
            if (object2 != null && ((String)object2).equals(string3)) {
                ((BS)object).and(bS3);
            } else {
                if (!this.addUnit(1094717454, string2.substring(0, nArray[1]).toUpperCase(), (BS)object, mapArray[0]) || !this.addUnit(1073742357, string2.substring(nArray[1] + 1, nArray[2]), (BS)object, mapArray[1])) continue;
                bS3 = BSUtil.copy((BS)object);
                object2 = string3;
            }
            n4 = (n2 & 0x20) != 0 ? 1 : 0;
            int n6 = n5 = (n2 & 0x40) != 0 ? 1 : 0;
            if (!this.addUnit(1094715412, string2.substring(nArray[3] + 1, nArray[4]), (BS)object, mapArray[2]) || !this.addUnit(5, (n2 & 0x80) == 0 ? "\u0000" : string2.substring(nArray[6] + 1, nArray[7]), (BS)object, mapArray[3]) || (n4 != 0 ? !this.addUnit(1086326786, string2.substring(nArray[4] + 1, nArray[5]).toUpperCase(), (BS)object, mapArray[4]) || !this.addUnit(1073742355, string2.substring(nArray[5] + 1, nArray[6]), (BS)object, mapArray[5]) : n5 != 0 && !this.addUnit(1094717448, string2.substring(nArray[5] + 1, nArray[6]), (BS)object, mapArray[6]))) continue;
            bS2.or((BS)object);
        }
        return bS2;
    }

    private BS checkMap(Map<String, BS> map, String string, BS bS) {
        BS bS2 = BSUtil.copy(bS);
        BS bS3 = map.get(string);
        if (bS3 == null) {
            bS3 = bS2;
            map.put(string, bS3);
        } else {
            bS3.or(bS2);
        }
        return bS3;
    }

    private boolean addUnit(int n, String string, BS bS, Map<String, BS> map) {
        BS bS2 = map.get(string);
        if (bS2 == null) {
            Object object;
            switch (n) {
                default: {
                    return false;
                }
                case 1073742357: {
                    object = this.vwr.getChainID(string, false);
                    break;
                }
                case 1094715412: {
                    object = PT.parseInt(string);
                    break;
                }
                case 5: {
                    object = (int)string.charAt(0);
                    break;
                }
                case 1094717448: {
                    n = 1073742355;
                    bS2 = this.ms.getAtomBitsMDa(1073742355, null, new BS());
                }
                case 1086326786: {
                    object = string;
                    break;
                }
                case 1073742355: {
                    object = string.length() == 0 ? null : string;
                }
            }
            bS2 = this.ms.getAtomBitsMDa(n, object, bS2 == null ? new BS() : bS2);
            map.put(string, bS2);
        }
        bS.and(bS2);
        return bS.nextSetBit(0) >= 0;
    }

    private BS getAnnotationBits(String string, int n, String string2) {
        BS bS = new BS();
        JmolAnnotationParser jmolAnnotationParser = this.vwr.getAnnotationParser(string.equals("dssr"));
        int n2 = this.ms.mc;
        while (--n2 >= 0) {
            Object object = this.ms.getInfo(n2, string);
            if (object == null) continue;
            bS.or(jmolAnnotationParser.getAtomBits(this.vwr, string2, ((BioModel)this.ms.am[n2]).getCachedAnnotationMap(String.valueOf(string) + " V ", object), this.ms.am[n2].dssrCache, n, n2, this.ms.am[n2].bsAtoms));
        }
        return bS;
    }

    private int getStructureLines(BS bS, SB sB, Lst<ProteinStructure> lst, STR sTR, boolean bl, int n) {
        boolean bl2 = n == 134222350;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = null;
        BS bS2 = new BS();
        int n5 = 0;
        int n6 = 0;
        int n7 = lst.size();
        while (n6 < n7) {
            ProteinStructure proteinStructure = (ProteinStructure)lst.get(n6);
            if (proteinStructure.type == sTR) {
                Monomer monomer = proteinStructure.findMonomer(bS, true);
                Monomer monomer2 = proteinStructure.findMonomer(bS, false);
                if (monomer != null && monomer2 != null) {
                    int n8 = proteinStructure.apolymer.model.modelIndex;
                    String string2 = bl ? "    \t# model=" + this.ms.getModelNumberDotted(n8) : null;
                    int n9 = monomer.getResno();
                    int n10 = monomer2.getResno();
                    STR sTR2 = proteinStructure.subtype;
                    switch (sTR) {
                        case TURN: 
                        case SHEET: 
                        case HELIX: {
                            String string3;
                            ++n5;
                            if (bl) {
                                bS2.clearAll();
                                proteinStructure.setAtomBits(bS2);
                                string3 = sTR2.getBioStructureTypeName(false);
                                sB.append("  structure ").append(string3).append(" ").append(Escape.eBS(bS2)).append(string2).append(" & (" + n9 + " - " + n10 + ")").append(";\n");
                                break;
                            }
                            switch (sTR) {
                                case HELIX: {
                                    int n11 = ++n2;
                                    string = PT.formatStringI("%3N %3N", "N", n11);
                                    string3 = "HELIX  %ID %3GROUPA %1CA %4RESA  %3GROUPB %1CB %4RESB";
                                    String string4 = null;
                                    switch (sTR2) {
                                        case HELIX: 
                                        case HELIXALPHA: {
                                            string4 = "  1";
                                            break;
                                        }
                                        case HELIX310: {
                                            string4 = "  5";
                                            break;
                                        }
                                        case HELIXPI: {
                                            string4 = "  3";
                                        }
                                    }
                                    if (string4 == null) break;
                                    string3 = String.valueOf(string3) + string4;
                                    break;
                                }
                                case SHEET: {
                                    int n11 = ++n3;
                                    string = PT.formatStringI("%3N %3A 0", "N", n11);
                                    string = PT.formatStringS(string, "A", "S" + n11);
                                    string3 = "SHEET  %ID %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB";
                                    break;
                                }
                                default: {
                                    int n11 = ++n4;
                                    string = PT.formatStringI("%3N %3N", "N", n11);
                                    string3 = "TURN   %ID %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB";
                                }
                            }
                            string3 = PT.formatStringS(string3, "ID", string);
                            string3 = PT.formatStringS(string3, "GROUPA", monomer.getGroup3());
                            string3 = PT.formatStringS(string3, "CA", monomer.getLeadAtom().getChainIDStr());
                            string3 = PT.formatStringI(string3, "RESA", n9);
                            string3 = PT.formatStringS(string3, "GROUPB", monomer2.getGroup3());
                            string3 = PT.formatStringS(string3, "CB", monomer2.getLeadAtom().getChainIDStr());
                            string3 = PT.formatStringI(string3, "RESB", n10);
                            sB.append(string3);
                            if (bl2) {
                                sB.append(" strucno= ").appendI(proteinStructure.strucNo);
                            }
                            sB.append("\n");
                        }
                    }
                }
            }
            ++n6;
        }
        if (n5 > 0) {
            sB.append("\n");
        }
        return n5;
    }

    private BS modelsOf(BS bS, BS bS2) {
        int n;
        BS bS3 = BS.newN(this.ms.mc);
        boolean bl = bS == null;
        int n2 = n = bl ? this.ms.ac - 1 : bS.nextSetBit(0);
        while (n2 >= 0) {
            int n3 = this.ms.am[this.ms.at[n2].mi].trajectoryBaseIndex;
            if (!this.ms.isJmolDataFrameForModel(n3)) {
                bS3.set(n3);
                bS2.set(n2);
            }
            int n4 = n2 = bl ? n2 - 1 : bS.nextSetBit(n2 + 1);
        }
        return bS3;
    }

    private void setAllDefaultStructure(BS bS) {
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (this.ms.am[n].isBioModel) {
                BioModel bioModel = (BioModel)this.ms.am[n];
                if (bioModel.defaultStructure == null) {
                    bioModel.defaultStructure = this.getFullProteinStructureState(bioModel.bsAtoms, 1073742158);
                }
            }
            n = bS.nextSetBit(n + 1);
        }
    }

    public boolean getAminoAcidValenceAndCharge(String string, String string2, int[] nArray) {
        return this.getBioExt().getAminoAcidValenceAndCharge(string, string2, nArray);
    }
}

