/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import org.jmol.api.JmolRendererInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.viewer.JC;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public abstract class ShapeRenderer {
    public Viewer vwr;
    protected TransformManager tm;
    public JmolRendererInterface g3d;
    protected ModelSet ms;
    protected Shape shape;
    protected int myVisibilityFlag;
    protected int shapeID;
    public short colix;
    public short mad;
    public int exportType;
    public boolean isExport;

    protected void initRenderer() {
    }

    protected abstract boolean render();

    public final void setViewerG3dShapeID(Viewer viewer, int n) {
        this.vwr = viewer;
        this.tm = viewer.tm;
        this.shapeID = n;
        this.myVisibilityFlag = JC.getShapeVisibilityFlag(n);
        this.initRenderer();
    }

    public boolean renderShape(JmolRendererInterface jmolRendererInterface, ModelSet modelSet, Shape shape) {
        this.setup(jmolRendererInterface, modelSet, shape);
        boolean bl = this.render();
        this.exportType = 0;
        this.isExport = false;
        return bl;
    }

    public void setup(JmolRendererInterface jmolRendererInterface, ModelSet modelSet, Shape shape) {
        this.g3d = jmolRendererInterface;
        this.ms = modelSet;
        this.shape = shape;
        this.exportType = jmolRendererInterface.getExportType();
        this.isExport = this.exportType != 0;
    }

    protected boolean isVisibleForMe(Atom atom) {
        return atom.isVisible(this.myVisibilityFlag | 9);
    }
}

