/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import org.jmol.util.Node;
import org.jmol.util.SimpleEdge;

public abstract class Edge
implements SimpleEdge {
    public static final int BOND_RENDER_SINGLE = 65536;
    public static final int TYPE_ATROPISOMER = 65537;
    public static final int TYPE_ATROPISOMER_REV = 65538;
    private static final int ATROPISOMER_SHIFT = 11;
    public static final int BOND_STEREO_MASK = 1024;
    public static final int BOND_STEREO_NEAR = 1025;
    public static final int BOND_STEREO_FAR = 1041;
    public static final int BOND_AROMATIC_MASK = 512;
    public static final int BOND_AROMATIC_SINGLE = 513;
    public static final int BOND_AROMATIC_DOUBLE = 514;
    public static final int BOND_AROMATIC = 515;
    public static final int BOND_SULFUR_MASK = 256;
    public static final int BOND_PARTIAL_MASK = 224;
    public static final int BOND_PARTIAL01 = 33;
    public static final int BOND_PARTIAL12 = 66;
    public static final int BOND_PARTIAL23 = 97;
    public static final int BOND_PARTIAL32 = 100;
    public static final int BOND_COVALENT_MASK = 1023;
    public static final int BOND_COVALENT_SINGLE = 1;
    public static final int BOND_COVALENT_DOUBLE = 2;
    public static final int BOND_COVALENT_TRIPLE = 3;
    public static final int BOND_COVALENT_QUADRUPLE = 4;
    public static final int BOND_COVALENT_QUINTUPLE = 5;
    public static final int BOND_COVALENT_sextuple = 6;
    public static final int BOND_ORDER_UNSPECIFIED = 17;
    public static final int BOND_ORDER_ANY = 65535;
    public static final int BOND_ORDER_NULL = 131071;
    public static final int BOND_STRUT = 32768;
    public static final int BOND_PYMOL_NOMULT = 65536;
    public static final int BOND_PYMOL_MULT = 98304;
    public static final int BOND_NEW = 131072;
    public static final int BOND_HBOND_SHIFT = 11;
    public static final int BOND_HYDROGEN_MASK = 30720;
    public static final int BOND_H_REGULAR = 2048;
    public static final int BOND_H_CALC_MASK = 28672;
    public static final int BOND_H_CALC = 4096;
    public static final int BOND_H_PLUS_2 = 6144;
    public static final int BOND_H_PLUS_3 = 8192;
    public static final int BOND_H_PLUS_4 = 10240;
    public static final int BOND_H_PLUS_5 = 12288;
    public static final int BOND_H_MINUS_3 = 14336;
    public static final int BOND_H_MINUS_4 = 16384;
    public static final int BOND_H_NUCLEOTIDE = 18432;
    private static final int[] argbsHbondType = new int[]{-38476, -256, -256, -1, -65281, -65536, -23296, -16711681, -16711936, -32640};
    public int index = -1;
    public int order;

    public abstract int getAtomIndex1();

    public abstract int getAtomIndex2();

    @Override
    public abstract int getCovalentOrder();

    @Override
    public abstract boolean isCovalent();

    public abstract boolean isHydrogen();

    public static int getArgbHbondType(int n) {
        int n2 = (n & 0x7800) >> 11;
        return argbsHbondType[n2];
    }

    public static final String getBondOrderNumberFromOrder(int n) {
        if ((n &= 0xFFFDFFFF) == 131071 || n == 65535) {
            return "0";
        }
        if (Edge.isOrderH(n) || Edge.isAtropism(n) || (n & 0x100) != 0) {
            return EnumBondOrder.SINGLE.number;
        }
        if ((n & 0xE0) != 0) {
            return String.valueOf(n >> 5) + "." + (n & 0x1F);
        }
        return EnumBondOrder.getNumberFromCode(n);
    }

    public static final String getCmlBondOrder(int n) {
        String string = Edge.getBondOrderNameFromOrder(n);
        switch (string.charAt(0)) {
            case 'd': 
            case 's': 
            case 't': {
                return "" + string.toUpperCase().charAt(0);
            }
            case 'a': {
                if (string.indexOf("Double") >= 0) {
                    return "D";
                }
                if (string.indexOf("Single") >= 0) {
                    return "S";
                }
                return "aromatic";
            }
            case 'p': {
                if (string.indexOf(" ") >= 0) {
                    return string.substring(string.indexOf(" ") + 1);
                }
                return "partial12";
            }
        }
        return null;
    }

    public static final String getBondOrderNameFromOrder(int n) {
        switch (n &= 0xFFFDFFFF) {
            case 65535: 
            case 131071: {
                return "";
            }
            case 32768: {
                return EnumBondOrder.STRUT.name;
            }
            case 1: {
                return EnumBondOrder.SINGLE.name;
            }
            case 2: {
                return EnumBondOrder.DOUBLE.name;
            }
        }
        if ((n & 0xE0) != 0) {
            return "partial " + Edge.getBondOrderNumberFromOrder(n);
        }
        if (Edge.isOrderH(n)) {
            return EnumBondOrder.H_REGULAR.name;
        }
        if ((n & 0x10001) == 65537) {
            int n2 = Edge.getAtropismCode(n);
            return "atropisomer_" + n2 / 4 + n2 % 4;
        }
        if ((n & 0x100) != 0) {
            return EnumBondOrder.SINGLE.name;
        }
        return EnumBondOrder.getNameFromCode(n);
    }

    public static int getAtropismOrder(int n, int n2) {
        return Edge.getAtropismOrder12((n + 1 << 2) + n2 + 1);
    }

    public static int getAtropismOrder12(int n) {
        return n << 11 | 0x10001;
    }

    private static int getAtropismCode(int n) {
        return n >> 11 & 0xF;
    }

    public static Node getAtropismNode(int n, Node node, boolean bl) {
        int n2 = n >> 11 + (bl ? 2 : 0) & 3;
        return (Node)node.getEdges()[n2 - 1].getOtherNode(node);
    }

    public static boolean isAtropism(int n) {
        return (n & 0x10001) == 65537;
    }

    public static boolean isOrderH(int n) {
        return (n & 0x7800) != 0 && (n & 0x10001) == 0;
    }

    public static final int getPartialBondDotted(int n) {
        return n & 0x1F;
    }

    public static final int getPartialBondOrder(int n) {
        return (n & 0xFFFDFFFF) >> 5;
    }

    protected static final int getCovalentBondOrder(int n) {
        if ((n & 0x3FF) == 0) {
            return 0;
        }
        if (((n &= 0xFFFDFFFF) & 0xE0) != 0) {
            return Edge.getPartialBondOrder(n);
        }
        if ((n & 0x100) != 0) {
            n &= 0xFFFFFEFF;
        }
        if ((n & 0xF8) != 0) {
            n = 1;
        }
        return n & 7;
    }

    public static final int getBondOrderFromFloat(float f) {
        switch ((int)(f * 10.0f)) {
            case 10: {
                return 1;
            }
            case -10: 
            case 5: {
                return 33;
            }
            case 15: {
                return 515;
            }
            case -15: {
                return 66;
            }
            case 20: {
                return 2;
            }
            case 25: {
                return 97;
            }
            case -25: {
                return 100;
            }
            case 30: {
                return 3;
            }
            case 40: {
                return 4;
            }
        }
        return 131071;
    }

    public static int getBondOrderFromString(String string) {
        int n = EnumBondOrder.getCodeFromName(string);
        try {
            if (n == 131071 && string.length() == 14 && string.toLowerCase().startsWith("atropisomer_")) {
                n = Edge.getAtropismOrder(Integer.parseInt(string.substring(12, 13)), Integer.parseInt(string.substring(13, 14)));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public void setCIPChirality(int n) {
    }

    public String getCIPChirality(boolean bl) {
        return "";
    }

    private static enum EnumBondOrder {
        SINGLE(1, "1", "single"),
        DOUBLE(2, "2", "double"),
        TRIPLE(3, "3", "triple"),
        QUADRUPLE(4, "4", "quadruple"),
        QUINTUPLE(5, "5", "quintuple"),
        sextuple(6, "6", "sextuple"),
        AROMATIC(515, "1.5", "aromatic"),
        STRUT(32768, "1", "struts"),
        H_REGULAR(2048, "1", "hbond"),
        PARTIAL01(33, "0.5", "partial"),
        PARTIAL12(66, "1.5", "partialDouble"),
        PARTIAL23(97, "2.5", "partialTriple"),
        PARTIAL32(100, "2.5", "partialTriple2"),
        AROMATIC_SINGLE(513, "1", "aromaticSingle"),
        AROMATIC_DOUBLE(514, "2", "aromaticDouble"),
        ATROPISOMER(65537, "1", "atropisomer"),
        UNSPECIFIED(17, "1", "unspecified");

        private int code;
        protected String number;
        protected String name;

        private EnumBondOrder(int n2, String string2, String string3) {
            this.code = n2;
            this.number = string2;
            this.name = string3;
        }

        protected static int getCodeFromName(String string) {
            EnumBondOrder[] enumBondOrderArray = EnumBondOrder.values();
            int n = enumBondOrderArray.length;
            int n2 = 0;
            while (n2 < n) {
                EnumBondOrder enumBondOrder = enumBondOrderArray[n2];
                if (enumBondOrder.name.equalsIgnoreCase(string)) {
                    return enumBondOrder.code;
                }
                ++n2;
            }
            return 131071;
        }

        protected static String getNameFromCode(int n) {
            EnumBondOrder[] enumBondOrderArray = EnumBondOrder.values();
            int n2 = enumBondOrderArray.length;
            int n3 = 0;
            while (n3 < n2) {
                EnumBondOrder enumBondOrder = enumBondOrderArray[n3];
                if (enumBondOrder.code == n) {
                    return enumBondOrder.name;
                }
                ++n3;
            }
            return "?";
        }

        protected static String getNumberFromCode(int n) {
            EnumBondOrder[] enumBondOrderArray = EnumBondOrder.values();
            int n2 = enumBondOrderArray.length;
            int n3 = 0;
            while (n3 < n2) {
                EnumBondOrder enumBondOrder = enumBondOrderArray[n3];
                if (enumBondOrder.code == n) {
                    return enumBondOrder.number;
                }
                ++n3;
            }
            return "?";
        }
    }
}

